''
'' Infinite Road Racer (2018)
'' v0.1 by ssjx (http://ssjx.co.uk)
''

#include "header.bi"

randomize timer

declare sub map_init()
declare sub map_loadtheme()
declare sub map_draw()
declare sub map_reset()

declare sub segment_load()
declare sub map_build()

declare sub player_init()
declare sub player_draw()
declare sub player_controls()
declare sub player_hud()
declare sub player_reset()

declare sub traffic_init()
declare sub traffic_draw()
declare sub traffic_set()
declare sub traffic_update()
declare sub traffic_bump()

declare sub p_shot_init()
declare sub p_shot_draw()
declare sub p_shot_reset()

declare sub expo_init()
declare sub expo_draw()
declare sub expo_reset()
declare sub expo_add(x as integer, y as integer)

declare sub title_init()
declare sub title_welcome()
declare sub title_ready()
declare sub title_over()
declare sub title_stagedone()

common shared player as playerxy
common shared level as integer

common shared map_done as integer

common shared basemap() as ubyte
dim shared basemap(800*8) as ubyte	'' Basemap (8 segments each 16*50 = 800 )

dim as integer ext=0,alt=0,fc,esc

'dim as string key

sub quick_dim()
	'' 
	Dim As Integer we, he, bypp, pitch
	Dim buffer As any Ptr = ScreenPtr()

	dim as integer i,j,ps
	ScreenInfo we, he, , bypp, pitch

	Dim As Ubyte Ptr pixel = buffer

	Screenlock
		for j=0 to 480-1
			for i=0 to (640*4)-1 step 4
				ps=(j*pitch)+i
		
				pixel[ps]=pixel[ps] shr 1 
				pixel[ps+1]=pixel[ps+1] shr 1
				pixel[ps+2]=pixel[ps+2] shr 1
				
			next i
		next j
	Screenunlock	
end sub

''
''
''

windowtitle GAMETITLE+" ["+VERSION+"] "+SITEURL
screen 18,32,2 '',&h01


player_init()	

traffic_init()
map_init()
p_shot_init()
player_init()
expo_init()
title_init()

segment_load()

do
	title_welcome()

	level=1
	player.score=0
	
	do
		ext=0
		esc=0
		map_build()
		map_loadtheme()
		traffic_set()	'' Must do after map loaded
	
		expo_reset()
		p_shot_reset()

		player_reset()		
		map_reset()
		
		cls
		map_draw()
		quick_dim()
		title_ready()
		
		do
			player_controls()
			
			if alt=1 then traffic_update()
				
			fc+=1
			if fc=30 then
				fc=0
				if player.bonus>0 then player.bonus-=1
			end if
		
			Screenlock
				cls
				map_draw()
				
				p_shot_draw()
				
				player_draw()
				traffic_draw()
				expo_draw()
				player_hud()
				
			Screenunlock
			
			with player
				if .damage=5 then
					expo_add(.x,.y)
					expo_add(.x+16,.y)
					expo_add(.x,.y+16)
					expo_add(.x+16,.y+16)
					expo_add(.x+8,.y+8)
					.speed=0
					.gear=0
				 	ext=2
				else	
					if .damage=4 then
						color rgb(255,0,0)
						draw string((512-(29*8)) shr 1,4),"* Danger : Damage Critical! *"
					end if
				end if
			end with
			
			sleep 10,1
		
			'' Escape to the welcome screen
			if multikey(SC_ESCAPE) then esc=1
			if multikey(SC_ESCAPE)=0 and esc=1 then ext=1
			
			'' Quit entirely
			if inkey=Chr(255)&"k" then ext=4
			
			if map_done=1 then ext=3
			
			alt=1-alt	
		loop while ext=0
		
		select case as const ext
		case 2:
			
			'' Draw your car exploding before end...
			for i as integer=0 to 15
				Screenlock
					cls
					map_draw()
					p_shot_draw()
					player_draw()
					traffic_draw()
					expo_draw()
					player_hud()
				Screenunlock
				sleep 20,1
			next i
			
			quick_dim()		
			title_over()
			
		case 3: 
			quick_dim()
			title_stagedone()
			level+=1
			
			'' Back to Get Ready
			ext=0
		end select
		
	loop while ext=0
	
	if ext=1 then ext=0
	
	'' Game Over to Welcome
	if ext=2 then ext=0
	
loop while ext=0
