'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================
''
'' Level 2 - Squid like thing
''
'' Sort out level 3
''
#include "header.bi"
#include "mytv.bi"
#include "fmod.bi"
common shared sample() As Integer

declare sub expo_reset()
declare sub expo_add(x as integer, y as integer)
declare sub expo_draw()	 

declare sub bug_bomb(as integer, as integer)

declare sub zoom(x as integer,y as integer)

declare sub title_fail(py as integer)
declare sub title_success(py as integer)
declare sub infobar(txt as string)

declare function race_has_hitblock(x as integer,y as integer) as integer
declare sub race_update()

''
'' Simplify and get working!
''

dim shared as xy shot(40)

const as string fb="CISABeerF"

dim shared as integer nextletter=1
dim shared as integer level=0,playsnd=0

sub vshot_reset()
	for i as integer=0 to ubound(shot)
		shot(i).a=0
	next i
end sub	

'' Only used now to check if player has been hit...
function vshot_hit(tx as integer,ty as integer,owner as integer) as integer
	for s as integer=0 to ubound(shot)
		if shot(s).a=2 then
			'' invader shot (2)
			if shot(s).x+4>tx and shot(s).x+4<tx+24 then
				if shot(s).y+5>ty and shot(s).y+5<ty+24 then
					shot(s).a=0
					return 2
				end if
			end if		
		end if		
	next s	
	return 0
end function

function vshot_hitblock(tx as integer,ty as integer) as boolean
	for s as integer=0 to ubound(shot)	
		with shot(s)
			if .a=1 then
				if .x+4>tx and .x+4<tx+32 then
					if .y+5>ty and .y+5<ty+32 then
						.a=0
						return true
					end if
				end if
			end if
		end with
	next s	
	return false
end function 
 
sub vshot_addbomb(x as integer,y as integer,owner as integer)
	dim as integer s=0,e=0

	'' These are the ranges of the shots the invader and player can use
	select case as const owner
	case 1
		s=0
		e=20
	case 2
		s=21
		e=ubound(shot)
	end select

	for i as integer=s to e 
		if shot(i).a=0 then
			shot(i).a=owner
			shot(i).x=x
			shot(i).xdir=0
			if owner=1 then shot(i).ydir=-4 else shot(i).ydir=4
			shot(i).y=y
			shot(i).v=nextletter
			nextletter+=1
			if nextletter>len(fb) then nextletter=1
			return
		end if
	next i

end sub 
 
sub vshot_addside(x as integer,y as integer)
	dim as integer e=0
	
	const as integer s=21
	e=ubound(shot)
	
	for i as integer=s to e 
		if shot(i).a=0 then
			shot(i).a=2	'' enemy
			shot(i).x=x+12
			shot(i).y=y+12
			
			shot(i).xdir=-2	'' Left
			shot(i).ydir=2	'' 
			exit for
		end if
	next i
	
	for i as integer=s to e 
		if shot(i).a=0 then
			shot(i).a=2	'' enemy
			shot(i).x=x+12
			shot(i).y=y+12
			
			shot(i).xdir=2	'' Right
			shot(i).ydir=2	
			exit for
		end if
	next i	
	
	
end sub
 
sub vshot_update()

	color rgb(255,255,0)
	for i as integer=0 to ubound(shot)
		if shot(i).a>0 then
			select case as const shot(i).a
			case 1
				'' player
				draw string (shot(i).x,shot(i).y),mid(fb,shot(i).v,1)		
			case 2
				'' TV
				'put (shot(i).x,shot(i).y),spriteno(5),trans
				draw string (shot(i).x,shot(i).y),"#"
			end select	
		
			shot(i).x+=shot(i).xdir
			shot(i).y+=shot(i).ydir
			if shot(i).x<0 or shot(i).x>640 then shot(i).a=0
			if shot(i).y<0 or shot(i).y>480 then shot(i).a=0	
		end if
	next i

end sub

''
''
''

dim shared as integer hill(22),shotdelay


dim shared as mytv tv(2)
dim shared as integer tvs=1

dim shared spriteno(5) as any ptr

dim shared as integer scry=0,ofx=0

dim shared as xy player 
dim shared as xy block(10)

sub race_init()
	const path="gfx\race\"
	spriteno(0) = ImageCreate( 24, 24,rgb(0,110,0) )
	spriteno(1) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(2) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(3) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(4) = ImageCreate( 32, 32,rgb(0,110,0) )
	
	''
	bload "gfx\ship2\up.bmp",spriteno(0)
	bload path+"green.bmp",spriteno(1)
	bload path+"blue.bmp",spriteno(2)
	bload path+"invert.bmp",spriteno(3)
	bload path+"red.bmp",spriteno(4)
	
	for t as integer=0 to tvs
		tv(t).init(t)
	next t
end sub

sub race_reset(lv as integer)
	'' Set level here	
	expo_reset()
	
	'tvs=level-1
	level=lv
	if level=1 then tvs=0
	if level=2 then tvs=1
	if level=3 then tvs=1
	if level=4 then tvs=0
	if level=5 then tvs=1
	if level=6 then tvs=1
	
	player.x=320-16
	player.y=416
		
	vshot_reset()
	
	for i as integer=0 to ubound(block)
		block(i).x=int(rnd()*608)
		block(i).y=-240+int(rnd()*480)
		block(i).a=1
			
		if level>=3 then
			if int(rnd()*10)>8 then
				block(i).a=2
			end if	
		end if
	next i
	
	for t as integer=0 to tvs
		tv(t).reset(level)
	next t
	
	playsnd=0
end sub

sub race_draw()
	dim as integer i,j
	'' Background
	for j=-32 to 480 step 32
		for i=0 to 640 step 32
		put (i,j+scry),spriteno(2),pset
		next i
	next j
	
	'' Draw random barriers
	for i as integer=0 to ubound(block)
	
		with block(i)
			if .a=1 then 
				put (.x,.y),spriteno(1),trans
			else
				put (.x,.y),spriteno(4),trans
			end if
		end with
	
	next i
	
	'' Draw Bug (moving left and right)	
	for t as integer=0 to tvs
		tv(t).draw()
	next t
	
	'' Player
	put (player.x,player.y),spriteno(0),trans
	
	vshot_update()
	
	expo_draw()
end sub

sub race_fail()
	'dim as integer bary=0
	
	for i as integer=0 to 9
		screenlock
			race_draw()
			zoom(player.x-160,player.y-120)
		screenunlock
		race_update()
		sleep 10
	next i
	screenlock
		title_fail(player.y)
	screenunlock
end sub

sub race_success()
	race_draw()
	title_success(0)
end sub


sub race_update()
	'' Scroll background
	scry+=1
	if scry=32 then scry=0

	for b as integer=0 to ubound(block)
		with block(b)
			.y+=2
			
			if .y>=480 then 
				.x=int(rnd()*608)
				.y=-32
				.a=1
				if level=3 then
					if int(rnd()*10)>8 then .a=2
				end if
			end if

			'' Red shooter block
			if .a=2 then
				if .delay=0 then
					.delay=30
					if int(rnd*9)>7 then
						vshot_addside(.x,.y)
					end if
				else
					.delay-=1
				end if 
				
				'' Turn Red block green
				if vshot_hitblock(.x,.y)=true then .a=1
					
			end if
		end with
	next b
	
	
	for t as integer=0 to tvs
		tv(t).update()
			
		dim as integer bomb=tv(t).bomb()
		if bomb>-1 then
			dim as integer i,j,c
			for j=0 to 15
				for i=0 to 15
					if bomb=c then 
						vshot_addbomb(tv(t).x+(i*16)+12,tv(t).y+(i*16)+4,2)	
					end if
					c=c+1
				next i
			next j
		end if
		
		for s as integer=0 to ubound(shot)
			if shot(s).a=1 then
				if tv(t).shothit(shot(s).x+4,shot(s).y+4)=true then
					shot(s).a=0
				end if
			end if
		next s
		
	next t
	
	
end sub

function race_controls() as integer
	dim as integer ext=0
	if  MultiKey(SC_ESCAPE) then 
		expo_add(player.x+8,player.y+8)
		FSOUND_PlaySound(FSOUND_FREE, sample(1))
		ext=FAIL
		return ext
	end if
	
	if  MultiKey(SC_RIGHT) and player.x<616 then player.x+=2
	if  MultiKey(SC_LEFT) and player.x>0 then player.x-=2
	
	if  MultiKey(SC_SPACE) then
		if shotdelay=0 then
			vshot_addbomb(player.x+8,player.y,1)	
			if playsnd=0 then 
				FSOUND_PlaySound(FSOUND_FREE, sample(0))
				playsnd=1
			end if
			shotdelay=12
		end if
	end if
	
	if  MultiKey(SC_SPACE)=0 then playsnd=0
		
	#if CHEAT=1
	if  MultiKey(SC_C) then
		 tv(0).cheater()	
		'for t as integer=0 to tvs	
		'tv(t).cheater()	
		'next t
	end if
	
	if  MultiKey(SC_S) then 
	    bsave "vertical.bmp",0
	end if
		
	#endif
	
	if  MultiKey(SC_UP) and player.y>0 then player.y-=2
	if  MultiKey(SC_DOWN) and player.y<(480-32) then player.y+=2
		
	if shotdelay>0 then shotdelay-=1
	
	'' Some sort of collision with rock/barrier	
	for t as integer=0 to tvs
		if tv(t).isclean()=true then 
			ext=SUCCESS
		else
			ext=0
			exit for
		end if
	next t
	
	for t as integer=0 to tvs	
		if tv(t).hitplayer(player.x,player.y)=true then 
			'expo_add(player.x+8,player.y+8)
			ext=FAIL
		end if
	next t
	
	if race_has_hitblock(player.x,player.y)>0 then 
		'expo_add(player.x+8,player.y+8)
		ext=FAIL
	end if

	'' Player hit by shot
	if vshot_hit(player.x,player.y,2)=2 then 
		'expo_add(player.x+8,player.y+8)
		ext=FAIL
	end if
	
	if ext=FAIL then
		expo_add(player.x+8,player.y+8)	
		FSOUND_PlaySound(FSOUND_FREE, sample(1))
	end if
	
	
	return ext
end function


function race_has_hitblock(x as integer,y as integer) as integer
	dim as integer v=0
	dim as integer x1,y1
	const as integer pw=24,ph=24
	const as integer w=32,h=32
	x=x+4

	for i as integer=0 to ubound(block)	
		x1=block(i).x
		y1=block(i).y
		
		if x>=x1 and x<=(x1+w) then
			'' top left
			if y>=y1 and y<=(y1+h) then
			v+=1
			end if
			
			'' bottom left
			if (y+ph)>=y1 and (y+ph)<=(y1+h) then
				v+=4
			end if
		end if
			
		if (x+pw)>=x1 and (x+pw)<=(x1+w) then
			'' top right
			if y>=y1 and y<=(y1+h) then
			v+=2
			end if
			
			''bottom right
			if (y+ph)>=y1 and (y+ph)<=(y1+h) then
				v+=8
			end if
		end if

	next i
	return v
end function



