'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================
''
'' + Move player back
'' + Shots
'' + Something to shoot at
'' 
''
#include "header.bi"
#include "fmod.bi"
common shared sample() As Integer

declare sub expo_reset()
declare sub expo_add(x as integer, y as integer)
declare sub expo_draw()	

declare sub title_fail(py as integer)
declare sub title_success(py as integer)

declare sub zoom(x as integer,y as integer)


dim shared sprite(10) as any ptr
dim shared as integer ofx,ofy,bfx,bfy,alt=0,cnt=0,scy=0

'dim  shared as integer basegrid(7,27)

dim  shared as integer grid_b(7,40)
dim  shared as integer grid_a(7,40)


dim shared as integer movedir=0
dim shared as boolean collide=false

type isoxy
	a as integer
	x as integer
	y as integer
	ox as integer 
	oy as integer 
	owner as integer
	h as integer
end type

dim  shared as xy player
dim  shared as isoxy shot(20)

dim shared as xy bugb(7,7) 


''
sub tunnel_shot_reset()
	for s as integer=0 to ubound(shot)
		shot(s).a=0
	next s
end sub

sub tunnel_shot_add(sx as integer,sy as integer,owner as integer)
	for s as integer=0 to ubound(shot)
		with shot(s)
			if .a=0 then
				.a=1
				.x=sx
				.y=1 'sy
				.ox=0
				.oy=0
				.h=sy
				return
			end if
		end with
	next s

end sub

sub tunnel_shot_update()
	for s as integer=0 to ubound(shot)
		with shot(s)
			if .a=1 then
				.ox+=8'2
				.oy+=4'1
				
				if .ox=32 then
				'	.x+=1
					.ox=0
				end if
				
				if .oy=16 then
					.y+=1
					.oy=0
				end if
				
				if .y>20 then .a=0
			end if
		end with
	next s
end sub

sub tunnel_shot_draw(x as integer,y as integer,sh as integer)
	const as integer offset=20
	const as integer sx=(0*64)
	const as integer sy=(8*32)
	dim as integer ax,ay

	for s as integer=0 to ubound(shot)
		with shot(s)
			if .a=1 and .h=sh then
				if .x=x and (offset-.y)=y then								
					ax=sx+(.x*32)+(.y*32)+.ox
					ay=sy+(.x*16)-(.y*16)-.oy
				
					put(ax,ay+32),sprite(6),trans			'' Shadow
					'put(px+nx,py-(32*player.y)+ny-player.oy),sprite(3),trans 	'' Ship
					put(ax,ay-(.h*32)),sprite(5),trans			'' Shot
					
					'draw string(64,64),str(.x)+" / "+str(.y)				
				end if
			end if
		end with
	next s
end sub
''

function tunnel_shot_check() as boolean
	const as integer offset=20
	dim as integer i,j,c=0
			
	for s as integer=0 to ubound(shot)
		with shot(s)
			if .a=1 then
			
			'' Hit wall
			select case as const .h
			case 0
				if grid_a(.x,(offset-.y)-1)=7 then
					grid_a(.x,(offset-.y)-1)=0
					.a=0
				end if
				
				if grid_a(.x,(offset-.y)-1)=2 then .a=0
			case 1
				if grid_b(.x,(offset-.y)-1)=7 then
					grid_b(.x,(offset-.y)-1)=0
					.a=0
				end if
				
				if grid_b(.x,(offset-.y)-1)=2 then .a=0
			end select
			''
			''
			'' Hit bug
			for i=0 to 7
				for j=6 to 13
					if bugb(i,j-6).a=1 and bugb(i,j-6).y=.h then 
						if .x=i and (offset-.y)-1=j then 
							bugb(i,j-6).a=2
							.a=0
						end if
					end if
				next j
			next i
			
			
			
			end if
			
		end with
	next s
	
	return false
end function

''
''
''

sub tunnel_init()
	const as string path="gfx\tunnel\"
	
	sprite(0) = ImageCreate( 64, 32,rgb(0,110,0) )
	sprite(1) = ImageCreate( 64, 32,rgb(0,110,0) )
	sprite(2) = ImageCreate( 64, 64,rgb(0,110,0) )
	sprite(3) = ImageCreate( 64, 64,rgb(0,110,0) )
	sprite(4) = ImageCreate( 64, 32,rgb(0,110,0) )

	sprite(5) = ImageCreate( 64, 64,rgb(255,255,0) )	'' Shot
	sprite(6) = ImageCreate( 64, 32,rgb(192,192,192) )	'' Shot shadow

	sprite(7) = ImageCreate( 64, 64,rgb(0,110,0) )
	sprite(8) = ImageCreate( 64, 64,rgb(0,110,0) )	
	sprite(9) = ImageCreate( 64, 32,rgb(0,110,0) )
	
'	sprite(6) = ImageCreate( 8, 8,rgb(0,110,0) )
'	bload path+"sml.bmp",sprite(6)
	''
	bload path+"iso.bmp",sprite(0)
	bload path+"iso2.bmp",sprite(1)
	bload path+"block.bmp",sprite(2)
	bload path+"player.bmp",sprite(3)
	bload path+"shadow.bmp",sprite(4)
	
	bload path+"shot.bmp",sprite(5)
	bload path+"shot_shadow.bmp",sprite(6)
	
	bload path+"bad.bmp",sprite(7)
	bload path+"good.bmp",sprite(8)
	bload path+"iso_shadow.bmp",sprite(9)
	
end sub

sub tunnel_reset(lev as integer)
	dim as integer i,j
	
	'' Bug
	dim bug(63) as byte=>{_
	0,0,0,1,1,0,0,0,_
	0,0,1,1,1,1,0,0,_
	0,1,1,1,1,1,1,0,_
	1,1,0,1,1,0,1,1,_
	1,1,1,1,1,1,1,1,_
	0,1,0,1,1,0,1,0,_
	1,0,0,0,0,0,0,1,_
	0,1,0,0,0,0,1,0}

	'' Skull
	dim skull(63) as byte=>{_
	0,0,1,1,1,1,0,0,_
	0,1,1,1,1,1,1,0,_
	1,1,0,1,1,0,1,1,_
	1,1,1,1,1,1,1,1,_
	0,1,1,1,1,1,1,0,_
	0,0,1,0,0,1,0,0,_
	0,0,1,0,0,1,0,0,_
	0,0,1,1,1,1,0,0}

	'' Clear track first!
	for j=0 to 40
		for i=0 to 7
			grid_a(i,j)=0
			grid_b(i,j)=0
		next i
		
		'' Edges
		grid_a(0,j)=1
		grid_a(7,j)=1			
	next j	
	
	select case as const lev
	case 1
		'' Obstacles
		for j=0 to 40	
			select case as const j
			case 0
				'' Low
				for i as integer=0 to 7
					grid_a(i,j)=2'
				next i
			case 8
				'' High
				for i as integer=0 to 7
					grid_b(i,j)=2'
				next i
			case 16
				'' Side
				grid_a(4,j)=2
				grid_a(5,j)=2
				grid_a(6,j)=2
				grid_a(7,j)=2
				
			case 24
				'' Side
				grid_b(0,j)=2
				grid_b(1,j)=2
				grid_b(2,j)=2
				grid_b(3,j)=2
	
			case 32
				'' Outer
				grid_a(0,j)=2
				grid_a(1,j)=2
				grid_a(6,j)=2
				grid_a(7,j)=2	
			end select
		next j
		

	
		dim as integer c=0
		for i=0 to 7
			for j=0 to 7
				with (bugb(j,i))
					.a=bug(c)
					.x=j
					.y=0
					.ydir=0
				end with
				c=c+1
			next j	
		next i
	case 2
		'' Obstacles
		for j=0 to 40			
			select case as const j
			case 0
					'' Side
				grid_b(0,j)=2
				grid_b(1,j)=2
				grid_b(2,j)=2
				grid_b(3,j)=2
				grid_a(4,j)=2
				grid_a(5,j)=2
				grid_a(6,j)=2
				grid_a(7,j)=2
			case 8
				grid_a(0,j)=2
				grid_a(1,j)=2
				grid_a(2,j)=2
				grid_a(3,j)=2
				grid_b(4,j)=2
				grid_b(5,j)=2
				grid_b(6,j)=2
				grid_b(7,j)=2
			case 16
				'' High
				for i as integer=0 to 7
					grid_b(i,j)=2'
				next i				
			case 24
				grid_b(0,j)=2
				grid_b(1,j)=2
				grid_b(2,j)=2
				grid_b(3,j)=2
				grid_a(4,j)=2
				grid_a(5,j)=2
				grid_a(6,j)=2
				grid_a(7,j)=2
	
			case 32
				grid_a(0,j)=2
				grid_a(1,j)=2
				grid_a(2,j)=2
				grid_a(3,j)=2
				grid_b(4,j)=2
				grid_b(5,j)=2
				grid_b(6,j)=2
				grid_b(7,j)=2	
			end select
		next j
			
		dim as integer c=0
		for i=0 to 7
			for j=0 to 7
				with (bugb(j,i))
					.a=skull(c)
					.x=j
					.y=0
					.ydir=0
				end with
				c=c+1
			next j	
		next i
		
	end select	

	'' Scroll offsets
	ofx=0
	ofy=0
	
	bfx=0
	bfy=0
	
	collide=false
	
	movedir=0
	player.x=3
	player.y=0
	player.ox=0
	player.oy=0
	
	tunnel_shot_reset()
	expo_reset()
end sub

sub scroll_grid()
	dim as integer tmp(7)

	for i as integer=0 to 7
	tmp(i)=grid_a(i,40)
	if tmp(i)=7 then tmp(i)=0
	next i	
	
	for j as integer=40 to 1 step -1
		for i as integer=0 to 7
			grid_a(i,j)=grid_a(i,j-1)	
		next i
	next j
	
	for i as integer=0 to 7
		grid_a(i,0)=tmp(i)
	next i
	
	''' Top part
	for i as integer=0 to 7
	tmp(i)=grid_b(i,40)
	next i	
	
	for j as integer=40 to 1 step -1
		for i as integer=0 to 7
			grid_b(i,j)=grid_b(i,j-1)	
		next i
	next j
	
	for i as integer=0 to 7
		grid_b(i,0)=tmp(i)
	next i	
	

end sub

sub player_draw()
	dim as integer px=(0*64)+(player.x*32) ''2
	dim as integer py=(8*32)+(player.x*16) ''6
	
	dim as integer nx=(player.ox*2)
	dim as integer ny=(player.ox)
	
	'' player
	with player
		put(px+nx,py+32+ny),sprite(4),trans				'' Shadow
		put(px+nx,py-(32*player.y)+ny-player.oy),sprite(3),trans 	'' Ship
	end with
		
end sub

sub tunnel_draw()
	const as integer sx=10*64
	const as integer sy=-(1*32)
	dim as integer i,j
	dim as boolean drawplayer=false
	
	cls 0
	for j=-1 to 15
		for i=-1 to 11
			put((i*64)-bfx,(j*32)+bfy),sprite(0),pset
		next i
	next j
	
	dim as integer ax,ay,gfx
	
	''layer 0 (Flat)
	for j=0 to 40
		gfx=-(j*32)
		for i=0 to 7
			ax=sx+(i*32)+gfx-ofx
			ay=sy+(j*16)+(i*16)+ofy
			
			if grid_a(i,j)=1 then put(ax,ay),sprite(1),trans
			
			'' Overhead block shadow
			if (grid_a(i,j)=0 or grid_a(i,j)=1) then
				if grid_b(i,j)=2 or grid_b(i,j)=7 then
					put(ax,ay),sprite(9),trans
				end if
			end if
				
			'' Bug shadow	
			if j>=6 and j<=13 then
				with bugb(i,j-6)
					if (.a>0) and (.y=1) then
						 put(ax+ofx,ay-ofy),sprite(9),trans
					end if
				end with		
			end if			
		next i
	next j
	
	
	'tunnel_shot_draw(0)	
	
	'' Layer 1 (Single block)
	dim as integer c=0
	for i=0 to 7
		for j=0 to 40
			gfx=-(j*32)

			ax=sx+(i*32)+gfx-ofx
			ay=sy+(j*16)+(i*16)+ofy
			
			if j=16 then
				if player.y=0 then
					if player.x=i then
						'' player
						player_draw()
						drawplayer=true			
					end if
				end if
			end if
			
			'' Draw Bug	
			if j>=6 and j<=13 then
				with bugb(i,j-6)
					if (.a>0) and (.y=0) then
						if .a=1 then put(ax+ofx,ay-32-ofy-.oy),sprite(7),trans	'' Red
						if .a=2 then put(ax+ofx,ay-32-ofy-.oy),sprite(8),trans	'' Yellow
						'put(ax,ay-32),sprite(7),trans
						if grid_a(i,j-2)=2 then .ydir=1
					end if
				end with
			end if
			''
			tunnel_shot_draw(i,j,0)	
													
			if grid_a(i,j)=2 then put(ax,ay-32),sprite(2),trans
			if grid_a(i,j)=7 then put(ax,ay-32),sprite(7),trans	
		next j
	next i
	
	'' Layer 2 (Second block)
	c=0
	
	for i=0 to 7
		for j=0 to 40
			gfx=-(j*32)
			
			ax=sx+(i*32)+gfx-ofx
			ay=sy+(j*16)+(i*16)+ofy

			if j=16 then
				if player.y=1 then
					if player.x=i then
						'' player
						player_draw()
						drawplayer=true			
					end if
				end if
			end if
			
			'' Draw Bug
			if j>=6 and j<=13 then
				with bugb(i,j-6)
					if (.a>0) and (.y=1) then
						if .a=1 then put(ax+ofx,ay-64-ofy-.oy),sprite(7),trans	'' Red
						if .a=2 then put(ax+ofx,ay-64-ofy-.oy),sprite(8),trans	'' Yellow
						'put(ax,ay-32),sprite(7),trans
						if grid_b(i,j-2)=2 then .ydir=-1
						
					end if
				end with
			end if
		
			
			if grid_b(i,j)=2 then put(ax,ay-64),sprite(2),trans
			if grid_b(i,j)=7 then put(ax,ay-64),sprite(7),trans
			
			tunnel_shot_draw(i,j,1)			
		next j
	next i
	

	if drawplayer=false then
		'' player
		player_draw()
	end if
	
	expo_draw()
	
	'for j=0 to 7
	'	for i=0 to 7
	'		if bugb(i,j).a=1 then 
	'			draw string ((i*16),(j*16)+64),"X"
	'		end if
	'	next i
	'next j
	
end sub

function tunnel_clean() as boolean
	dim as integer i,j
	for j=0 to 7
		for i=0 to 7
			if bugb(i,j).a=1 then return false
		next i
	next j

	return true
end function



sub tunnel_cheat()
	dim as integer i,j
	for j=0 to 7
		for i=0 to 7
			if bugb(i,j).a=1 then bugb(i,j).a=2
		next i
	next j
end sub



sub tunnel_update()
	dim as integer i,j
		
	ofx+=2
	ofy+=1
	
	bfx+=2
	bfy+=1

	'' Background
	if bfx=64 then 
		bfx=0
		bfy=0
	end if
	
	'' Track
	if ofx=32 then 
		scroll_grid()
		ofx=0
		ofy=0
		alt=1-alt
		
		if player.y=0 then
			if grid_a(player.x,19)>1 then collide=true
		end if
		
		if player.y=1 then
			if grid_b(player.x,19)>1 then collide=true
		end if
		
		'' Bug drop a bomb?
		for i=0 to 7
			for j=0 to 7
				with (bugb(i,j))	
					if .a=1 then
						if (int(rnd*1000)=1) then
							select case as const .y
							case 0
								'' Low bomb box	
								if grid_a(i,j+6)=0 then grid_a(i,j+6)=7
							case 1
								'' High bomb box
								if grid_b(i,j+6)=0 then grid_b(i,j+6)=7
							end select
						end if
					end if
				end with
			next j	
		next i
		
				
	end if
	
	'' Rise / Lower bug body
	dim as integer c=0

		for i=0 to 7
			for j=0 to 7
				with (bugb(i,j))	
					if .ydir=1 then 
						.oy+=2
						if .oy=32 then 
							.oy=0
							.y+=1
							.ydir=0
						end if
					end if
					
					if .ydir=-1 then 
						.oy-=2
						if .oy=-32 then 
							.oy=0
							.y-=1
							.ydir=0
						end if
					end if
					
				end with
			next j	
		next i
	'''
	
	select case as const movedir
	case 1
		player.oy+=2
		if player.oy=32 then
			player.oy=0
			player.y+=1
			movedir=0
		end if
	case 2
		player.ox+=2
		if player.ox=16 then
			player.ox=0
			player.x+=1
			movedir=0
		end if
	
	case 3
		player.oy-=2
		if player.oy=-32 then
			player.oy=0
			player.y-=1
			movedir=0
		end if
	
	case 4
		player.ox-=2
		if player.ox=-16 then
			player.ox=0
			player.x-=1
			movedir=0
		end if
	end select
	
	
	tunnel_shot_update()
	
	 tunnel_shot_check()
end sub



function tunnel_controls() as integer
	dim as integer ext=0
	dim as integer px=(0*64)+(player.x*32) ''2
	dim as integer py=(8*32)+(player.x*16) ''6
	
	if tunnel_clean()=true then
		ext=SUCCESS
		return ext	
	end if
	
	if collide=true then
		expo_add(px+32,py+32-(player.y*32))
		FSOUND_PlaySound(FSOUND_FREE, sample(1))
		ext=FAIL
		return ext
	end if

	if  MultiKey(SC_ESCAPE) then 
		expo_add(px+32,py+32-(player.y*32))
		FSOUND_PlaySound(FSOUND_FREE, sample(1))
		ext=FAIL
	end if
	
	if movedir=0 then
			if  MultiKey(SC_UP) then 
			if (player.y+1)<=1 then movedir=1
		end if	
			
		if  MultiKey(SC_RIGHT) then 
			if (player.x+1)<=7 then movedir=2
		end if
		
		if  MultiKey(SC_DOWN) then 	
			if (player.y-1)>=0 then movedir=3
		end if
		
		if  MultiKey(SC_LEFT) then 
			if (player.x-1)>=0 then movedir=4
		end if
	end if
	
	#if CHEAT=1
		if  MultiKey(SC_C) then
			tunnel_cheat()			
			ext=SUCCESS
			return ext
		end if	
		
		if  MultiKey(SC_S) then 
		    bsave "tunnel.bmp",0
		end if
		
	#endif
	
	
	if player.delay=0 then
		if  MultiKey(SC_SPACE) then 
			tunnel_shot_add(player.x,player.y,1)
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
			player.delay=20
		end if
	else
		player.delay-=1
	end if
	
	return ext
end function

sub tunnel_success()
	tunnel_draw()
	title_success(0)
end sub

sub tunnel_fail()
	dim as integer px=(0*64)+(player.x*32) ''2
	dim as integer py=(8*32)+(player.x*16) ''6

	for i as integer=0 to 9
		screenlock
			tunnel_draw()
			zoom(px-160,py-120)
		screenunlock
		'tunnel_update()
		sleep 10
	next i
	screenlock
		title_fail(0)
	screenunlock
end sub
