'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================

#include "header.bi"

#include "font.bi"
dim shared text as myfont

#include "fmod.bi"
common shared sample() As Integer
common shared as integer rpgmusic	'' <-- Used on title screen

declare function game_save() as boolean
declare function game_load() as boolean

common shared as integer hilevel()
common shared as myscore best()
common shared as integer music_on

dim shared levelstd(5) as integer=>{0,3,3,4,2,1}
dim shared levelmax(5) as integer=>{0,6,6,6,4,2}

dim shared as integer bg_ofy

dim shared sprite(10) as any ptr
dim shared thumb(30) as any ptr
dim shared logo as any ptr

sub title_init()
	text.load()
	
	logo = ImageCreate( 400, 100,rgb(100,255,100) )

	sprite(0) = ImageCreate( 32, 32,rgb(100,255,100) )  
	sprite(1) = ImageCreate( 32, 32,rgb(100,255,100) )  
	sprite(2) = ImageCreate( 48, 48,rgb(100,255,100) )  
	sprite(3) = ImageCreate( 32, 32,rgb(100,255,100) )  
	sprite(4) = ImageCreate( 48, 48,rgb(100,255,100) ) 
	sprite(5) = ImageCreate( 16, 16,rgb(100,255,100) )  
	sprite(6) = ImageCreate( 48, 48,rgb(100,255,100) )  
	sprite(7) = ImageCreate( 32, 32,rgb(100,255,100) )  

	''	
	dim path as string="gfx\ui\"
	bload path+"tl.bmp",sprite(0)	
	bload path+"br.bmp",sprite(1)	
	
	for t as integer=0 to ubound(thumb)
		thumb(t) = ImageCreate( 48, 48,rgb(50,50,50) )
	next t
	
	path="gfx\select\"
	bload path+"title.bmp",logo	
		
	bload path+"lock.bmp",sprite(2)		
	bload path+"gray.bmp",sprite(3)	
	bload path+"star.bmp",sprite(4)
	bload path+"tick.bmp",sprite(5)
	bload path+"movie.bmp",sprite(6)
	bload path+"back.bmp",sprite(7)
	
	bload path+"a0.bmp",thumb(0)
	bload path+"a1.bmp",thumb(1)
	bload path+"a2.bmp",thumb(2)
	bload path+"a0.bmp",thumb(3)
	bload path+"a1.bmp",thumb(4)
	bload path+"a2.bmp",thumb(5)

	bload path+"b0.bmp",thumb(6)
	bload path+"b1.bmp",thumb(7)
	bload path+"b2.bmp",thumb(8)
	bload path+"b0.bmp",thumb(9)
	bload path+"b1.bmp",thumb(10)
	bload path+"b2.bmp",thumb(11)	
	
	bload path+"c0.bmp",thumb(12)
	bload path+"c1.bmp",thumb(13)
	bload path+"c2.bmp",thumb(14)
	bload path+"c3.bmp",thumb(15)
	bload path+"c4.bmp",thumb(16)
	bload path+"c5.bmp",thumb(17)
	
	bload path+"d0.bmp",thumb(18)
	bload path+"d1.bmp",thumb(19)
	bload path+"d2.bmp",thumb(20)
	bload path+"d3.bmp",thumb(21)	
	
	bload path+"e0.bmp",thumb(24)
	bload path+"e1.bmp",thumb(25)
	
	'bload path+"a0.bmp",thumb(0)
end sub

sub title_bg(offset as integer)
	dim as integer i,j
	
	for j=-32 to 479 step 32
		for i=0 to 639 step 32
			put (i,j+offset),sprite(3),pset
		next i
	next j
end sub

''
'' Need a 32bit screen to work
''
sub fastdim(y as integer)

    Dim buffer As UByte Ptr = ScreenPtr()    
	dim as uinteger c=(640*y*2)      
        
      asm
      	mov eax, [c]		''counter
      	mov ebx, [buffer]	''screen buffer
      	
      dtop:
      	mov cx,[ebx]	''screen pos
  	
      	shr ch		''shift colour bytes
      	shr cl
      	
      	mov [ebx],cx	''put shift colour back 
      	
		add ebx,2	''move to next 2 bytes
						
		sub eax,1	'' decrease count
		jnz dtop	
	 
      end asm   

end sub


sub infobar(txt as string)

	dim as integer i,j
	dim as uinteger t,r,g,b
	
	fastdim(32)
	
	'' Slow dim
'	for j=0 to 31
'		for i=0 to 639
'			t=point(i,j)
'			r=(t and &H00ff0000) shr 16
'			g=(t and &H0000ff00) shr 8
'			b=(t and &H000000ff) 
			
'			r=r shr 1
'			g=g shr 1
'			b=b shr 1
			
'			pset(i,j),rgb(r,g,b)
			'pset(i,y+j),rgb(255,255,255)
'		next i
'	next j

	if txt<>"" then
		dim as integer cx	
		cx=(640-(len(txt)*8))/2
		draw string(cx,8),txt
	end if
end sub


function title_welcome(opt as integer) as integer
	const as integer sz=12
	const as integer oy=16
	const as integer ofy=270-8
	
	dim as integer ext=0
	dim as integer i,j,tl=0
	dim as integer esc=0,up=0,down=0,spac=0,mdown=0
	dim as string key,txt(15),tmp
	dim as integer fc
	dim as integer res,mx,my,mb
	dim as integer mouse_on,prev_mouse
	dim as boolean mouse_down=false	

	dim as integer ox=(640-(40*sz))/2	''38
		
	txt(0)="Cure the infected devices!"
	txt(1)=""
	txt(2)="Stun the escaped programs so they return to their"
	txt(3)="device, then go into the device to cure them!"
	txt(4)=""
	txt(5)="Control using the Arrow and Space keys!"
	txt(6)=""
	txt(7)="View Introduction"
	txt(8)="Watch how this all happened!"
	
	txt(9)="Play Game"
	txt(10)="Go capture and cure the rogue programs!"
	
	txt(11)="Practice / Bonus"
	txt(12)="Replay completed and attempted levels!"
	
	do
		screenlock
			title_bg(bg_ofy)
			
			put ((640-400)/2,15-8),logo,trans			
			'draw string (32,32),str(opt)

			for i=0 to 5' ubound(txt)
				tmp=txt(i)
				text.centre(96+(i*24)-8,tmp)	''300
			next i
				
			'' Buttons	
			tl=7
			for i=0 to 2
				line (128+1,ofy+(i*64)+1)-(640-128-1,ofy+(i*64)+48-1),rgb(0,0,0),bf
		
				if i=0 then put (128,ofy+(i*64)),sprite(6),pset
				if i=1 then put (128,ofy+(i*64)),thumb(0),pset
				if i=2 then put (128,ofy+(i*64)),sprite(4),pset
				
				'' Mouse over
				if mouse_on=i then
					color rgb(0,153,255)
					'line (128,ofy+(i*64))-(640-128,ofy+(i*64)+48),,b
					line (128+1,ofy+(i*64)+1)-(640-128-1,ofy+(i*64)+48-1),,b
				end if
				
				
				color rgb(0,255,128)
				
				'' Yellow outline (Keys)
				if opt=i then 
					'' Outer line (so thicker)
					color rgb(255,255,0)
					line (128-1,ofy+(i*64)-1)-(640-128+1,ofy+(i*64)+48+1),,b
				end if
					
				line (128,ofy+(i*64))-(640-128,ofy+(i*64)+48),,b
		
				text.show(192,ofy+(i*64),txt(tl))
				
				tl+=1
				color rgb(192,192,192)
				draw string(192,ofy+(i*64)+26),txt(tl)
				tl+=1
			
			next i	
							
			'' Footer
			color rgb(255,255,0)
			draw string (2,480-14),VERSION
			draw string (500,480-14),SITEURL
			
			if music_on=1 then
				draw string (500,480-28),"[M]usic - On"
			else
				draw string (500,480-28),"[M]usic - Off"
			end if
								
		screenunlock
		''	
		While Inkey <> "": Wend
		
		ext=0
		do
			FSOUND_Update
			key=inkey
			if key=Chr(255)&"k" then ext=QUIT
			if multikey(SC_ESCAPE)=0 and esc=1 then ext=QUIT
			
			if multikey(SC_ESCAPE) then esc=1
			if multikey(SC_SPACE) then spac=1
			if multikey(SC_UP) and up=0 then up=1
			if multikey(SC_DOWN) and down=0 then down=1
			if multikey(SC_M) and mdown=0 then mdown=1
		
			if multikey(SC_UP)=0 and up=1 then 
				up=0
				opt-=1
				ext=2	'' This will force a redraw
				FSOUND_PlaySound(FSOUND_FREE, sample(2))
			end if
			
			if multikey(SC_DOWN)=0 and down=1 then
				down=0
				opt+=1
				ext=2 	'' This will force a redraw
				FSOUND_PlaySound(FSOUND_FREE, sample(2))
			end if
	
			if multikey(SC_M)=0 and mdown=1 then 
				mdown=0
				music_on=1-music_on
				if music_on=0 then FMUSIC_StopAllSongs()
				if music_on=1 then FMUSIC_PlaySong(rpgmusic)
				ext=2	'' This will force a redraw
			end if
			
			if multikey(SC_SPACE)=0 and spac=1 then ext=1
			 
			if opt<0 then opt=2
			if opt>2 then opt=0
		
			sleep 10,1
			
			fc+=1
			if fc=5 then 
				fc=0
				bg_ofy+=1
				if bg_ofy=32 then bg_ofy=0
				ext=2
			end if
			
			'' Mouse
			res = GetMouse (mx,my,,mb)
			
			if res=0 then
				prev_mouse=mouse_on
				mouse_on=-1
				for i=0 to 2
					'line (128+1,ofy+(i*64)+1)-(640-128-1,ofy+(i*64)+48-1),rgb(0,0,0),bf
				
					if (mx>128) and (mx<640-128) then
						if (my>ofy+(i*64)) and (my<ofy+(i*64)+48) then
							'color rgb(0,153,255)
							'line (128,ofy+(i*64))-(640-128,ofy+(i*64)+48),,b
							mouse_on=i	
							exit for
						end if
					end if
				next i
				''
				
				'' Mouseclick (exit on up)
				select case as const mb	
				case 1
					if mouse_down=false then mouse_down=true
				case 0
					if mouse_down=true then 
						mouse_down=false
						if mouse_on>-1 then
							opt=mouse_on
							ext=1
						end if
					end if 
				end select
				
			end if
		
			if mouse_on<>prev_mouse then
				prev_mouse=mouse_on
				ext=2
			end if
			''	
		loop while ext=0
	
		if ext=QUIT then
			game_save()
			FSOUND_Close
			end
		end if
	
		While Inkey <> "": Wend
	
	loop while ext<>1

	return opt
	
end function


function bonus_unlock(game as integer) as boolean

	for i as integer=1 to levelstd(game)
		if best(game,i).completed=false then return false
	next i
	
	'' Mark the games as played otherwise we can't start them..
	for i as integer=1 to levelmax(game)
		best(game,i).played=true
	next i
	
	return true
end function

function title_practice(game as integer,level as integer) as integer
	const as integer sz=48
	const as integer ox=32
	const as integer oy=32+16
	
	dim as integer esc=0,up=0,down=0,lft=0,rght=0,spac=0
	dim as integer c,i,j,xp,yp,ext
	dim as string key,txt(5),padding
	dim as integer fc
	
	dim as integer res,mx,my,mb
	dim as integer mouse_on,prev_mouse
	dim as integer mouse_game,mouse_level
	dim as boolean mouse_down=false
	''
	dim as integer cx
	dim as string lin(1),tmp
	lin(0)="Locked levels can be played after starting them in the main game"
	lin(1)="Bonus levels can be unlocked after completing the main game levels"

	txt(0)="RPG Ignore"
	txt(1)="Laptop Levels"
	txt(2)="Smart TV Levels"
	txt(3)="Tablet Levels"
	txt(4)="Cooker Levels"
	txt(5)="Router Levels"

	''
	''Only unlock if games completed
	'''
	for j=1 to 5
		if bonus_unlock(j)=true then hilevel(j)=levelmax(j)
	next j
	''

	do
		'' Draw
		c=0
		screenlock
			title_bg(bg_ofy)
			put (0,480-32),sprite(7),trans
			text.centre(8,"Practice / Bonus Levels")	''300
			
			'if mouse_on>-1 then
		'		draw string (8,8),str(mouse_game)+" / "+str(mouse_level)+" of "+str(hilevel(mouse_game))
			'	draw string (8,24),str(mouse_on)
			'end if
			
			for j=1 to 5
				yp=oy+((j-1)*80)
				color rgb(255,255,255)
				
				draw string (32,yp-16),txt(j) '+" - Levels: "+str(hilevel(j))  '+str(besttime(game,level)) '+" / "+str(hilevel(j))+" / "+str(levelmax(j))+" / "+str(levelmax(j)/2)
				
				'if hilevel(j)=levelmax(j)/2 then hilevel(j)=levelmax(j)
				
				'' Only unlock if games completed
				'if bonus_unlock(j)=true then hilevel(j)=levelmax(j)
					
				for i=1 to 6
					xp=ox+((i-1)*((sz)+8))
						
					if i<=levelmax(j) then
						
						line (xp,yp)-(xp+sz,yp+sz),rgb(0,255,128),b
					
						if i<=hilevel(j) then
							'' Game Thumbnail	
							'if best(j,i).played=true then
							put (xp,yp),thumb(c),pset
							'end if
							
							''Show tick if complete in main game
							if best(j,i).completed=true then
								put (xp+32,yp+32),sprite(5),trans
							end if
							
						else 
							if i>(levelstd(j)) then
								'' Star
								put (xp,yp),sprite(4),pset
							else
								'' Locked
								put (xp,yp),sprite(2),pset
							end if
							
							'color rgb(255,0,0)	
							'draw string (xp+2,yp+16),"X"	
						end if
						
						''draw string (xp+2,yp+32),str(i+1)+"/"+str(hilevel(j))
						
						if j=game and i=level then
							if best(j,i).played=false then
								'' Red
								color rgb(255,0,0)
							else
								'' Yellow
								color rgb(255,255,0)
							end if
							line (xp,yp)-(xp+sz,yp+sz),,b
							line (xp+1,yp+1)-(xp+sz-1,yp+sz-1),,b
							
						else
							'' Gray
							'line (xp,yp)-(xp+sz,yp+sz),rgb(0,255,0),b
							line (xp,yp)-(xp+sz,yp+sz),rgb(128,128,128),b
						end if
						
						
						''
						if mouse_on>-1 then
							if (mouse_game=j) and (mouse_level=i) then
								'' Blue outline
								color rgb(0,153,255)
								line (xp,yp)-(xp+sz,yp+sz),,b
								line (xp+1,yp+1)-(xp+sz-1,yp+sz-1),,b
							end if
						end if
						
						
					end if
					
					c=c+1
				next i
			next j
			
			'' Highscore list
			text.show(400,48,"Best Times")	''300
			
			for j=1 to levelmax(game) ''6
				padding=""
				color rgb(255,255,255)
				if j=level then color rgb(255,255,0)
				with best(game,j)
					if len(.first)<10 then padding=string(10-len(.first),".")
					draw string (400,64+(j*24)),str(j)+". "+.first+padding+" "+str(.score)
				end with
			next j
			''
			color rgb(255,255,255)
			for i=0 to ubound(lin)
				tmp=lin(i)
				cx=(640-(len(tmp)*8)) shr 1
				draw string(cx,480-48+(i*24)),tmp
			next i
			
		screenunlock
		
		'' Keys
		
		While Inkey <> "": Wend
		ext=0
		do
			FSOUND_Update
			key=inkey
			if key=Chr(255)&"k" then end
			
			if multikey(SC_ESCAPE) then esc=1
			if multikey(SC_SPACE) then spac=1
			if multikey(SC_UP) and up=0 then up=1
			if multikey(SC_DOWN) and down=0 then down=1
			if multikey(SC_LEFT) and lft=0 then lft=1
			if multikey(SC_RIGHT) and rght=0 then rght=1	
		
			if multikey(SC_ESCAPE)=0 and esc=1 then 
				return 0
			end if
		
			if multikey(SC_UP)=0 and up=1 then 
				up=0
				game-=1
				level=1
				ext=2	'' This will force a redraw
				FSOUND_PlaySound(FSOUND_FREE, sample(2))
			end if
			
			if multikey(SC_DOWN)=0 and down=1 then
				down=0
				game+=1
				level=1
				ext=2 	'' This will force a redraw
				FSOUND_PlaySound(FSOUND_FREE, sample(2))
			end if
			
			if multikey(SC_LEFT)=0 and lft=1 then 
				lft=0
				level-=1
				ext=2	'' This will force a redraw
				FSOUND_PlaySound(FSOUND_FREE, sample(2))
			end if
			
			if multikey(SC_RIGHT)=0 and rght=1 then
				rght=0
				level+=1
				ext=2 	'' This will force a redraw
				FSOUND_PlaySound(FSOUND_FREE, sample(2))
			end if
			
			if multikey(SC_SPACE)=0 and spac=1 then 
				spac=0
				'' Check if it is unlocked!
				if best(game,level).played=true then
					ext=1
				end if
			end if 
			 
			'' Mouse
			res = GetMouse (mx,my,,mb)
			
			if res=0 then
				prev_mouse=mouse_on
				mouse_on=-1
				mouse_game=-1
				mouse_level=-1
				
				for j=1 to 5
				yp=oy+((j-1)*80)
				
					for i=1 to 6
						xp=ox+((i-1)*((sz)+8))
					
						if (mx>xp) and (mx<xp+48) then
							if (my>yp) and (my<yp+48) then
								mouse_game=j
								mouse_level=i	
								mouse_on=(mouse_game*10)+mouse_level						
								exit for
							end if
						end if
					next i
					if mouse_on>-1 then exit for
				next j
				''
				
				if mouse_on>0 then	
					if mouse_level>hilevel(mouse_game) then 
						mouse_level=-1
						mouse_on=-1
					else
				
						select case as const mb	
						case 1
							if mouse_down=false then mouse_down=true
						case 0
							if mouse_down=true then 
								mouse_down=false
								if mouse_on>-1 then
									game=mouse_game
									level=mouse_level
									ext=1
								end if
							end if 
						end select
				
				
						'if mb=1 then
						'	game=mouse_game
						'	level=mouse_level
						'	ext=1
						'end if
					end if
				end if
				
				'' Check for back button
				if mb=1 then
					if my>(480-32) and (mx<32) then
						return 0
					end if
				end if
				
				
			else
				mouse_on=-1	
			end if
			
			if mouse_on<>prev_mouse then
				prev_mouse=mouse_on
				ext=2
			end if
			''	 
			 
			if game<1 then game=5
			if game>5 then game=1
		
			if level<1 then level=hilevel(game)
			if level>hilevel(game) then level=1
		
			sleep 10,1
			
			fc+=1
			if fc=5 then 
				fc=0
				bg_ofy+=1
				if bg_ofy=32 then bg_ofy=0
				ext=2
			end if
			
			''		
		loop while ext=0
	
		While Inkey <> "": Wend
	
	loop while ext<>1

	
	return (game*10)+(level)
end function



sub title_window(y as integer,h as integer)

	'' Slow dim
	dim as integer i,j
	dim as uinteger t,r,g,b
	
	y=(480-h) shr 1
	
	for j=y to y+h
		for i=4 to 640-4
			t=point(i,j)
			r=(t and &H00ff0000) shr 16
			g=(t and &H0000ff00) shr 8
			b=(t and &H000000ff) 
			
			r=r shr 1
			g=g shr 1
			b=b shr 1
			
			pset(i,j),rgb(r,g,b)
		next i
	next j

'	put (0,y),sprite(0),trans
'	put (640-32,y+h-32),sprite(1),trans
	
end sub


sub title_instructions(gt as integer)
	const as integer height=64
	const as integer bary=240-16
	
	title_window(bary,height)
	
	dim as string txt="????"
	select case as const gt
	case 0
		txt="You gain health points by curing devices! Good luck!"
	case 1
		txt="Avoid the binary hills and cure this laptop!"
	case 2
		txt="Avoid the stream of binary blocks and convert the corrupt Java program!"
	case 3
		txt="Don't touch the the walls and guide your cure to the corrupt core program!"
	case 4
		txt="Convert the program streams to FreeBasic!"	
	case 5
		txt="Stop the evil program from reaching the internet!"
	end select
	
	dim as integer cx
	cx=(640-(len(txt)*8))/2
	
	color rgb(255,255,255)
	draw string(cx,bary+4-8),txt
	
	txt="Space / Click to start!"
	cx=(640-(len(txt)*8))/2
	'draw string(cx,bary+16+8),txt
	
	color rgb(0,0,0)
	draw string(cx+1,bary+24+1),txt

	color rgb(0,255,0)
	draw string(cx,bary+24),txt
	
	
end sub


sub title_final(no as integer)
	const as integer height=80
	const as integer bary=240-40
	
	dim as integer cx
	dim as string tmp,txt(4)
	
	title_window(bary,height)
	
	for i as integer=0 to ubound(txt)
		txt(i)=""
	next i
	
	select case as const no
	case 0
		txt(0)="Ha ha ha! You think you've won?"
		txt(1)=""
		txt(2)="Once I get on the internet,I will free all the other trapped programs!"
		txt(3)=""
		txt(4)="Find the router! Press Space to continue!"
		
		'color rgb(255,0,0)
		for j as integer=0 to ubound(txt)
			tmp=txt(j)
			cx=(640-(len(tmp)*8))/2
			
			color rgb(0,0,0)
			draw string(cx+1,bary+4+(j*14)+1),tmp
			
			color rgb(255,0,0)
			if j=4 then color rgb(0,255,0)
			draw string(cx,bary+4+(j*14)),tmp
		next j
		
	case 1
		txt(1)="Well done! You have cured all of the devices!"
		txt(3)="Space to continue..."
	
		for j as integer=0 to ubound(txt)
			tmp=txt(j)
			cx=(640-(len(tmp)*8))/2
		
			color rgb(0,0,0)
			draw string(cx+1,bary+4+(j*14)+1),tmp
		
			color rgb(255,255,255)	
			if j=3 then color rgb(0,255,0)
			draw string(cx,bary+4+(j*14)),tmp
		next j
	case 3	
		txt(0)="Game Over, your health is zero.."
		txt(1)=""
		txt(2)="Maybe some more practice would help?"
		txt(3)=""
		txt(4)="Press Space to continue"
	
		for j as integer=0 to ubound(txt)
			tmp=txt(j)
			cx=(640-(len(tmp)*8))/2
		
			color rgb(0,0,0)
			draw string(cx+1,bary+4+(j*14)+1),tmp
		
			color rgb(255,255,255)	
			if j=4 then color rgb(0,255,0)
			draw string(cx,bary+4+(j*14)),tmp
		next j
		
	end select

end sub

function title_name(no as integer) as string
	const as integer height=64
	const as integer bary=240-16
	dim as integer ext=0
	dim as string key
	dim as string nam=""
	dim as integer cx
	dim as string txt
	dim as integer fc,fcb,alt	
	
	if no=0 then txt="Please enter your name or initials, press Enter when done:"
	
	if no=1 then txt="You have a new high score! Please enter your name:"
	
	do	
		screenlock
			title_bg(bg_ofy)
			title_window(bary,height)
				
			cx=(640-(len(txt)*8))/2
			
			color rgb(255,255,255)
			draw string(cx,bary+4-8),txt
			
			cx=(640-(len(nam)*8))/2
			
			if alt=0 then
				draw string(cx,bary+16+8),nam
			else
				draw string(cx,bary+16+8),nam+"_"
			end if
		screenunlock
		
		key=inkey
		
		if key>=chr(65) and key<=chr(122) then
			if len(nam)<10 then nam+=key
		else
			'' Press enter	
			if key=chr(10) or key=chr(13) then ext=1
		
			'' Backspace
			if key=chr(8) then
				nam=left(nam,len(nam)-1)
			end if
		end if

		sleep 10,1
	
		fcb+=1
		if fcb=5 then
			fcb=0 
			bg_ofy+=1
			if bg_ofy=32 then bg_ofy=0
		end if
		
		if fc=30 then
			alt=1-alt
			fc=0
		else
			fc+=1
		end if
		
	loop while ext=0

	if len(nam)=0 then nam="Unknown"

	return nam
end function


sub title_fail(py as integer)
	const as string txt="You did not clear this device, you lose a health point..."
	infobar(txt)
end sub

sub title_success(py as integer)
	const as string txt="This device has been successfully cured of its evil programming!"
	infobar(txt)
end sub


sub title_complete()

end sub

