'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================
''
''

#include "bmp.bi"
#include "header.bi"
#include "fmod.bi"
common shared sample() As Integer

declare sub expo_reset()
declare sub expo_add(x as integer, y as integer)
declare sub expo_draw()	 

declare sub zoom(x as integer,y as integer)

declare sub smash_update()

declare sub title_fail(py as integer)
declare sub title_success(py as integer)
''
''
dim shared basemaze(20*15) as ubyte	'' Basemap
dim shared maze(20,15) as ubyte	

dim shared spriteno(12) as any ptr

dim shared as integer mapwidth,mapheight
dim shared as integer shotdelay=0

dim shared as boolean space_down=false

dim shared as xy player
dim shared as xy enemy(20)
dim shared as xy snake(5)

''
''
''

const as string fb="CISABeerF"
dim shared as xy shot(40)
dim shared as integer nextletter=1

sub s_shot_reset()
	for i as integer=0 to ubound(shot)
		shot(i).a=0
	next i
end sub	

sub s_shot_add(x as integer,y as integer,xdir as integer,ydir as integer,owner as integer)
	dim as integer s,e
	
	select case as const owner
	case 1
		s=0
		e=20
	case 2
		s=21
		e=ubound(shot)
	end select

	for i as integer=0 to ubound(shot) 
		if shot(i).a=0 then
			shot(i).a=owner
			shot(i).x=x
			shot(i).y=y
			shot(i).xdir=(xdir*4)
			shot(i).ydir=(ydir*4)
			shot(i).v=nextletter
			nextletter+=1
			if nextletter>len(fb) then nextletter=1
			return
		end if
	next i

end sub 
''
''
''
function smash_shot_hitwall(tx as integer,ty as integer) as boolean
	dim as integer i,j

	for j=0 to 14
		for i=0 to 19
			'' Wall
			if maze(i,j)=1 then	
				if tx>=(i*32) and tx<=((i*32)+32) then
					if ty>=(j*32) and ty<=((j*32)+32) then
					return true
					end if
				end if
			end if
			''
		next i
	next j
	
	return false
end function

function smash_shot_hitenemy(tx as integer,ty as integer) as boolean

	for i as integer=0 to ubound(enemy)
		with enemy(i)
			if .a>1 then
				if tx>=.x and tx<(.x+32) then
					if ty>=.y and ty<(.y+32) then
					.a-=1
					return true
					end if
				end if
			end if	
		end with
	next i
	
	return false
end function

function smash_shot_hitsnake(tx as integer,ty as integer) as boolean

	for i as integer=0 to ubound(snake)
		with snake(i)
			if .a=1 then
				if tx>=(.x*32)+.ox and tx<(.x*32)+.ox+32 then
					if ty>=(.y*32)+.oy and ty<(.y*32)+.oy+32 then
					.a=2
					return true
					end if
				end if
			end if	
		end with
	next i
	
	return false
end function




sub s_shot_update()
	color rgb(255,255,0)
	for i as integer=0 to ubound(shot)
		with shot(i)
			if .a>0 then
				if .a=1 then draw string (.x,.y),mid(fb,.v,1)
				
				if .a=2 then draw string (.x,.y),"#"
				
				.x+=.xdir
				.y+=.ydir
				
				if .x>640 or .x<-10 then shot(i).a=0
				if .y<0 or .y>490 then shot(i).a=0
				
				''	
				'' Has Shot hit the wall?	
				''
				if smash_shot_hitwall(.x+4,.y+4)=true then		
					expo_add(.x,.y)
					.a=0
				end if
				
				'' Check if player shot hit enemies
				if .a=1 then
					if smash_shot_hitenemy(.x+4,.y+4)=true then		
						expo_add(.x,.y)
						.a=0
					end if
					
					if smash_shot_hitsnake(.x+4,.y+4)=true then		
						expo_add(.x,.y)
						.a=0
					end if
				end if
		
			end if
			
				
		end with
	next i
end sub

''
''
''

sub smash_load(level as integer)
	
	const path as string="gfx\smash\"

	if  Open(path+str(level)+".bmp" For binary access read As #1)=0 then
		dim header as bmphdr

		get #1,,header	
		get #1,header.offset+1,basemaze()  
	    Close #1     
	     
	    mapwidth=header.w
		mapheight=header.h  
		'' Not flipping as identical upside down... 	              
	else
		draw string(8,128),"Could not load maze..."
		sleep 100*10 
	end if
	
end sub


sub smash_reset(lv as integer)
	dim as integer i,j,c
    '' Reset map
    
    if lv=1 or lv=3 then smash_load(1)
    if lv=2 or lv=4 then smash_load(2)
    
    s_shot_reset()
    
    '' Turn off snake
    for p as integer=0 to ubound(snake)
		snake(p).a=0
    next p
    
    c=0
	for j=0 to mapheight-1
	 	for i=0 to mapwidth-1
	 		maze(i,j)=basemaze(c)	'' 1= blue, 2=green,		
	 		if maze(i,j)=4 then
	 			maze(i,j)=0
		 			for p as integer=0 to ubound(snake)
		 				with snake(p)
		 					.a=1
		 					.x=i+p
		 					.y=j
		 					.xdir=1
		 					.ydir=0
							.ox=0
		 					.oy=0
		 				end with
		 			next p
	 		end if
			c+=1
    	next i
    next j

	expo_reset()

	player.a=1
	player.x=(9*32)+16+4
	player.y=(7*32)+16+4
		
	for i=0 to ubound(enemy)
		with enemy(i)
			if lv>2 then .a=3 else .a=2
			.x=(4+int(rnd*12))*32
			.y=-(int(rnd*15)*32)
			.ydir=1
			.xdir=0
		end with
	next i
end sub

''
''
sub smash_init()
	dim as string path="gfx\maze\"
	spriteno(0) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(1) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(2) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(3) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(4) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(5) = ImageCreate( 32, 32,rgb(0,110,0) )
	''
	bload path+"blue.bmp",spriteno(0)
	bload path+"green.bmp",spriteno(1)
	
	
	bload "gfx\common\cplus32_hard.bmp",spriteno(2)
	bload "gfx\common\cplus32.bmp",spriteno(3)
	bload "gfx\common\freebasic32.bmp",spriteno(4)
	bload "gfx\common\python32.bmp",spriteno(5)
	
	for i as integer=8 to ubound(spriteno)
	spriteno(i) = ImageCreate( 24, 24,rgb(0,110,0) )
	next i
	
	path="gfx\ship2\"
	bload path+"up.bmp",spriteno(8)
	
end sub



sub smash_draw()
	dim as integer i,j,m
	cls 
	for j=0 to 14
		for i=0 to 19
			m=maze(i,j)
			put (i*32,j*32),spriteno(m),trans
		next i
	next j

	for i=0 to ubound(enemy)
		with enemy(i)
			if .a=3 then put (.x,.y),spriteno(2),trans	'' hard c++
			if .a=2 then put (.x,.y),spriteno(3),trans	'' c++
			if .a=1 then put (.x,.y),spriteno(4),trans	'' fb
			
		end with
	next i

	for i=0 to ubound(snake)
		with snake(i)
			if .a=1 then put ((.x*32)+.ox,(.y*32)+.oy),spriteno(5),trans '' py
			if .a=2 then put ((.x*32)+.ox,(.y*32)+.oy),spriteno(4),trans '' fb
		end with
	next i

	'' Player 
	put (player.x,player.y),spriteno(8),trans
	
	s_shot_update()
	
	expo_draw()
end sub


sub smash_cheat()

	for i as integer=0 to ubound(enemy)
		with enemy(i)
		if .a>1 then .a=1
		end with
	next i
	
	'for i as integer=0 to ubound(snake)
	'	with snake(i)
	'	if .a=1 then return false
	'	end with
	'next i

	'return true
end sub


function smash_clean() as boolean

	for i as integer=0 to ubound(enemy)
		with enemy(i)
		if .a>1 then return false
		end with
	next i
	
	for i as integer=0 to ubound(snake)
		with snake(i)
		if .a=1 then return false
		end with
	next i

	return true
end function


sub smash_fail()
	for i as integer=0 to 9
		screenlock
			smash_draw()
			zoom(player.x-160,player.y-120)
		screenunlock
		smash_update()
		sleep 10
	next i

	screenlock
		title_fail(player.y)
	screenunlock
end sub

sub smash_success()
	dim as integer i,j
	 
	for j=0 to 14
		for i=0 to 19
		put (i*32,j*32),spriteno(maze(i,j)),trans
		next i
	next j
		
	'' Player 
	put (player.x,player.y),spriteno(8),trans	
		
	title_success(player.y)
end sub


sub smash_update()
	dim as boolean newdir=false
	'' update enemy
	for i as integer=0 to ubound(enemy)
		with enemy(i)
	
			if .a>0 then	
				
				'' C++ shoot
				if .a=2 or .a=3 then
					if .delay=0 then
						if (int(rnd*1000)=5) then
							.delay=60
							if .ydir=0 then s_shot_add(.x+12,.y+12,0,1,2)
							
							if .xdir=0 then s_shot_add(.x+12,.y+12,0,.ydir,2)
							
						end if
					else
						.delay-=1
					end if
				end if			
			
				.x+=(.xdir*1)
				.y+=(.ydir*1)
				
				newdir=false
				
				if .ydir=1 and .y>480 then newdir=true
				if .ydir=-1 and .y<-32 then newdir=true
				
				if .xdir=1 and .x>640 then newdir=true
				if .xdir=-1 and .x<-32 then newdir=true
				
				if newdir=true then
				
					'' If a FB block goes off screen, remove
					if .a=1 then 
						.a=0 
						continue for
					end if
					
					dim as integer d
					d=int(rnd*4)
					
					.xdir=0
					.ydir=0
					
					select case as const d
					case 0
						.x=(4+int(rnd*12))*32
						.y=-32
						.ydir=1
					
					case 1
						.x=640+32
						.y=(4+int(rnd*7))*32
						.xdir=-1
					case 2
						.x=(4+int(rnd*12))*32
						.y=480+32
						.ydir=-1
					case 3
						.x=-32
						.y=(4+int(rnd*7))*32
						.xdir=1
					end select	
				end if
				
			end if
		end with
	next i
	
	''
	''
	''
	for i as integer=0 to ubound(snake)
		with snake(i)
			.ox+=(.xdir*2)
			.oy+=(.ydir*2)
			
			if .ox=32 then 
				.x+=1
				newdir=true
			end if	
				
			if .ox=-32 then 
				.x-=1
				newdir=true
			end if
			
			if .oy=32 then 
				.y+=1
				newdir=true
			end if
			
			if .oy=-32 then 
				.y-=1
				newdir=true
			end if
			
			if newdir=true then
				.ox=0
				.oy=0
				
				'' Add a shot (Snake)
				if .a=1 then
					'if .delay=0 then
						if maze(.x-1,.y)=0 and maze(.x+1,.y)=0 then
							if maze(.x,.y-1)=0 and maze(.x,.y+1)=0 then
					
					
								if (int(rnd*20)=5) then
									'.delay=20
									'' Moving Left and Right
									if .ydir=0 then 
									
										if 	.y<=7 then 
											s_shot_add((.x*32)+12,(.y*32)+12,0,1,2)
										else
											s_shot_add((.x*32)+12,(.y*32)+12,0,-1,2)
										end if		
									end if
									
									'' Up Down
									if .xdir=0 then 
										if 	.x<=15 then
											s_shot_add((.x*32)+12,(.y*32)+12,1,0,2)
										else
											s_shot_add((.x*32)+12,(.y*32)+12,-1,0,2)
										end if
									end if		
								end if

							end if
						end if
						
					'else
					'	.delay-=1
					'end if
				end if
								
				dim as integer done=false
				if .xdir=1 and maze(.x+1,.y)=1 then
					.xdir=0
					if maze(.x,.y+1)=0 then .ydir=1
					if maze(.x,.y-1)=0 then .ydir=-1
					done=true
				end if
				
				if done=false then
					if .xdir=-1 and maze(.x-1,.y)=1 then
						.xdir=0
						if maze(.x,.y+1)=0 then .ydir=1
						if maze(.x,.y-1)=0 then .ydir=-1
						done=true
					end if
				end if
							
				if done=false then
					if .ydir=1 and maze(.x,.y+1)=1 then
						.ydir=0
						if maze(.x+1,.y)=0 then .xdir=1
						if maze(.x-1,.y)=0 then .xdir=-1
						done=true
					end if
				end if
				
				if done=false then
					if .ydir=-1 and maze(.x,.y-1)=1 then
						.ydir=0
						if maze(.x+1,.y)=0 then .xdir=1
						if maze(.x-1,.y)=0 then .xdir=-1
						done=true
					end if
				end if
				
			end if	
		end with
	next i	
end sub


function smash_collide(x1 as integer,y1 as integer) as integer
	dim as integer v=0
	const as integer pw=24,ph=24
	const as integer ww=32,wh=32
	
	dim as integer x=player.x
	dim as integer y=player.y
	
	if y>=y1 and y<=(y1+wh) then
		'' top left
		if x>=x1 and x<=(x1+ww) then
			v+=1
		end if
	
		'' top right
		if (x+pw)>=x1 and (x+pw)<=(x1+ww) then
			v+=2
		end if
	end if
	
	
	if (y+ph)>=y1 and (y+ph)<=(y1+wh) then
		'' bottom left
		if x>=x1 and x<=(x1+ww) then
			v+=4
		end if
	
		''bottom right
		if (x+pw)>=x1 and (x+pw)<=(x1+ww) then
			v+=8
		end if
	end if
	return v
end function


function smash_controls() as integer
	dim as integer ext=0,i,j
	
	if  MultiKey(SC_ESCAPE) then 
		expo_add(player.x+8,player.y+8)
		player.xdir=0
		player.ydir=0
		ext=FAIL
	end if
	
	if  MultiKey(SC_LEFT) then 
		if (player.x-2)>=0 then player.x-=2
	end if

	if  MultiKey(SC_RIGHT) then 
		if (player.x+2)<=(639-24) then player.x+=2
	end if	

	if  MultiKey(SC_UP) then 
		if (player.y-2)>=0 then player.y-=2
	end if	
	
	if  MultiKey(SC_DOWN) then 	
		if (player.y+2)<=(479-24) then player.y+=2
	end if	

	if shotdelay=0 then
		if MultiKey(SC_SPACE)=true then 	
			s_shot_add(player.x+8,player.y+8,0,-1,1)	
			shotdelay=30	'12'
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
		end if
	else
		shotdelay-=1
	end if
	
	#if CHEAT=1
		if  MultiKey(SC_C) then
			smash_cheat()			
			'ext=SUCCESS
			return ext
		end if	
		
		if  MultiKey(SC_S) then 
		    bsave "smash.bmp",0
		end if
	#endif
	
	'' Has player hit the wall?	(adapt to check blocks too!)
	for j=0 to 14
		for i=0 to 19
			'' Wall
			if maze(i,j)=1 then	
				if smash_collide(i*32,j*32)>0 then		
					ext=FAIL
				end if
			end if
			''
		next i
	next j	
		
	'' Has enemy shot hit player?
	for s as integer=0 to ubound(shot)
		with shot(s)
			if .a=2 then
				if (.x+4)>player.x and (.x+4)<(player.x+24) then
					if (.y+4)>player.y and (.y+4)<(player.y+24) then
						.xdir=0
						.ydir=0
						ext=FAIL
					end if
				end if
				
			end if
		end with
	next s
		
	'' Has player crashed into enemy/snake?
	for i as integer=0 to ubound(snake)
		with snake(i)
			if .a=1 then
				if smash_collide((.x*32)+.ox,(.y*32)+.oy)>0 then
					.xdir=0
					.ydir=0
					ext=FAIL
				end if
			end if
		end with
	next i
		
	''		
	for i as integer=0 to ubound(enemy)
		with enemy(i)
			if .a=2 or .a=3 then
				if smash_collide(.x,.y)>0 then
					ext=FAIL
				end if
			end if
		end with
	next i
			
	'' General add explosion if failed
	if ext=FAIL then
		expo_add(player.x+8,player.y+8)
		player.xdir=0
		player.ydir=0
		FSOUND_PlaySound(FSOUND_FREE, sample(1))
	end if	
				
	if smash_clean()=true then ext=SUCCESS
			
	return ext
end function





