'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================



#include "header.bi"

dim shared as xy shot(40)

const as string fb="CISABeerF"

dim shared as integer nextletter=1

sub shot_reset()
	for i as integer=0 to ubound(shot)
		shot(i).a=0
	next i
end sub	

function shot_hit(tx as integer,ty as integer,owner as integer) as integer

	for s as integer=0 to ubound(shot)
		if shot(s).a=owner then
		
			select case as const shot(s).a
			case 1
				'' player shot (1) hit invader
				if shot(s).x+4>tx and shot(s).x+4<tx+16 then
					if shot(s).y+5>ty and shot(s).y+5<ty+16 then
						shot(s).a=0
						return 1
					end if
				end if
			case 2
				'' invader shot (2) hits player
				if shot(s).x+4>tx and shot(s).x+4<tx+32 then
					if shot(s).y+5>ty and shot(s).y+5<ty+16 then
						shot(s).a=0
						return 2
					end if
				end if
			end select	
		
		end if		
	next s	
	
	return 0
end function

function shot_hitblock(tx as integer,ty as integer) as integer
dim as integer owner
	for s as integer=0 to ubound(shot)
		owner=shot(s).a
		if owner>0 then
			'' player shot (1) hit invader
			if shot(s).x+4>tx and shot(s).x+4<tx+32 then
				if shot(s).y+5>ty and shot(s).y+5<ty+32 then
					shot(s).a=0
					return owner
				end if
			end if	
		end if		
	next s	
	
	return 0
end function



sub shot_add(x as integer,y as integer,owner as integer)
	dim as integer s=0,e=0

	'' These are the ranges of the shots the invader and player can use
	select case as const owner
	case 1
		s=0
		e=20
	case 2
		s=21
		e=ubound(shot)
	end select

	for i as integer=s to e 
		if shot(i).a=0 then
			shot(i).a=owner
			shot(i).x=x
			shot(i).y=y
			shot(i).ydir=0
			
			if owner=1 then shot(i).xdir=4 else shot(i).xdir=-4
			
			shot(i).v=nextletter
			nextletter+=1
			if nextletter>len(fb) then nextletter=1
			return
		end if
	next i

end sub
 
sub shot_addbomb(x as integer,y as integer,owner as integer)
	dim as integer s=0,e=0

	'' These are the ranges of the shots the invader and player can use
	select case as const owner
	case 1
		s=0
		e=20
	case 2
		s=21
		e=ubound(shot)
	end select

	for i as integer=s to e 
		if shot(i).a=0 then
			shot(i).a=owner
			shot(i).x=x+12
			shot(i).xdir=0
			if owner=1 then shot(i).ydir=-4 else shot(i).ydir=4
			shot(i).y=y
			shot(i).v=nextletter
			nextletter+=1
			if nextletter>len(fb) then nextletter=1
			return
		end if
	next i

end sub 

'' Enemy upward rocket shot
sub shot_addrocket(x as integer,y as integer)
	dim as integer e=0
	
	const as integer s=21
	e=ubound(shot)
	
	for i as integer=s to e 
		if shot(i).a=0 then
			shot(i).a=2	'' enemy
			shot(i).x=x+12
			shot(i).y=y-6
			
			shot(i).xdir=-2
			shot(i).ydir=-4	
			return
		end if
	next i
	
end sub





sub shot_update(ofx as integer,ofy as integer)

	color rgb(255,255,0)
	for i as integer=0 to ubound(shot)
		if shot(i).a>0 then
			select case as const shot(i).a
			case 1
				'' player
				draw string (shot(i).x,shot(i).y),mid(fb,shot(i).v,1)
			case 2
				'' invader
				'put (shot(i).x,shot(i).y),spriteno(5),trans
				draw string (shot(i).x,shot(i).y),"#"		
			end select	
		
			with shot(i)
				.x=.x+.xdir-ofx
				.y+=.ydir
				if .x<0 or .x>640 then .a=0
				if .y<0 or .y>480 then .a=0
			end with
		end if
	next i
end sub

