'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================
''
'' Thanks to your efforts
'' and FreeBASIC, the programs
'' are much happier!
'' 
'' To avoid angry programs, make 
'' sure you keep using FreeBASIC!
''

#include "bmp.bi"
#include "header.bi"

declare sub wait_space()


dim shared scene_one((40*30)*6) as ubyte	'' Basemap 20*15
dim shared scene_two((40*30)*4) as ubyte	'' Basemap 20*15

dim shared sprite(12) as any ptr

dim shared mapwidth as integer
dim shared mapheight as integer

sub outro_flip(scene as integer)
	dim as integer i,j,c
	dim as ubyte tmp
	dim temp(mapwidth*mapheight) as ubyte 

	'' copy
	for i=0 to ubound(temp)
		if scene=1 then temp(i)=scene_one(i)
		if scene=2 then temp(i)=scene_two(i)
	next i
	
	'' flip row by row..
	c=0
	for j=0 to mapheight-1
		for i=0 to mapwidth-1
			tmp=temp((mapwidth*( (mapheight-1)-j))+i)  '' 32*(31-j)
			
			if scene=1 then scene_one(c+i)=tmp
			if scene=2 then scene_two(c+i)=tmp
		next i
		c+=mapwidth	''32
	next j
end sub


sub outro_load()
	dim header as bmphdr

	const path as string="gfx\outro\"

	if  Open(path+"1.bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,scene_one()  
	    Close #1     
	              
	    mapwidth=header.w
		mapheight=header.h      
	              
	    outro_flip(1)  
	else
		draw string(8,128),"Could not load intro"
		sleep 100*10 
	end if
	
	if  Open(path+"2.bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,scene_two()  
	    Close #1     
	              
	    mapwidth=header.w
		mapheight=header.h      
	              
	    outro_flip(2)  
	else
		draw string(8,128),"Could not load intro"
		sleep 100*10 
	end if	
	
end sub	        

sub outro_init()

	const path as string="gfx\intro\"
	
	for i as integer=0 to ubound(sprite)
		sprite(i) = ImageCreate( 16, 16,rgb(100,255,100) )
	next i
		
	bload path+"blue.bmp",sprite(0)	
	bload path+"green.bmp",sprite(1)	
	bload path+"yellow.bmp",sprite(2)	
	bload "gfx\common\pascal.bmp",sprite(3)	
	bload "gfx\common\c.bmp",sprite(4)	
	bload "gfx\common\basic.bmp",sprite(5)	
	
	bload "gfx\common\java.bmp",sprite(6)	
	bload "gfx\common\python.bmp",sprite(7)	
	bload "gfx\common\cplus.bmp",sprite(8)	
	bload "gfx\common\freebasic.bmp",sprite(9)	
	
end sub




sub outro_window(x as integer,y as integer,w as integer,h as integer)
	dim as integer i,j
	dim as uinteger t,r,g,b
	
	for j=y to y+h
		for i=x to x+w
			t=point(i,j)
			r=(t and &H00ff0000) shr 16
			g=(t and &H0000ff00) shr 8
			b=(t and &H000000ff) 
			
			r=r shr 1
			g=g shr 1
			b=b shr 1
			
			pset(i,j),rgb(r,g,b)
			'pset(i,y+j),rgb(255,255,255)
		next i
	next j
end sub


sub outro_part1(f as integer)
	dim as string txt(3)

	txt(0)="Thanks to your efforts"
	txt(1)="and FreeBASIC, the programs"
	txt(2)="are much happier!"
	txt(3)=""

	dim as integer i,j,c=0
	
	c=f*(40*30)
	
	for j=0 to 29
		for i=0 to 39
			put (i*16,j*16),sprite(scene_one(c)),trans
			c=c+1
		next i
	next j

	outro_window(24,24,300,80)

	color rgb(255,255,255)
	for i=0 to ubound(txt)
		if txt(i)="" then exit for
		draw string(32,32+(i*16)),txt(i)
	next i

end sub

sub outro_part2(f as integer)
	dim as string txt(3)

	txt(0)="To avoid angry programs, make"
	txt(1)="sure you and everyone you know"
	txt(2)="keeps using FreeBASIC!"

	dim as integer i,j,c=0
	
	c=f*(40*30)
	
	for j=0 to 29
		for i=0 to 39
			put (i*16,j*16),sprite(scene_two(c)),trans
			c=c+1
		next i
	next j
		
	outro_window(24,24,340,80)
	
	color rgb(255,255,255)
	for i=0 to ubound(txt)
		if txt(i)="" then exit for
		draw string(32,32+(i*16)),txt(i)
	next i

end sub



sub outro_run()
	dim as boolean spacedown=false
	dim as integer ext=0
	dim as integer frame=0,fc,maxframe
	dim as boolean showframe=true
	
	dim as integer res,mx,my,mb
	dim as boolean mouse_down=false
	
	const as string txt="< Space / Click to Continue >" 
	
	dim as integer cx
	cx=(640-(len(txt)*8))/2
	
	for scene as integer=1 to 2
		spacedown=false
		ext=0
		frame=0
		fc=0
		if scene=1 then maxframe=5
		if scene=2 then maxframe=3
	
		do
			'' Only draw if the frame has changed
			if showframe=true then
				showframe=false
				
				screenlock
					cls 0
					if scene=1 then outro_part1(frame)
					if scene=2 then outro_part2(frame)
					
					color rgb(0,0,0)
					draw string (cx+1,480-16+1),txt
					
					color rgb(255,255,255)
					draw string (cx,480-16),txt
					
				screenunlock
				
			end if
			
			if MultiKey(SC_SPACE)=true then spacedown=true
			
			if spacedown=true then
				if MultiKey(SC_SPACE)=false then
					ext=1
					'exit for
				end if
			end if
		
			'' Mouseclick (exit on up)
			res = GetMouse (mx,my,,mb)
			if res=0 then
				select case as const mb
				case 0
					if mouse_down=true then 
						mouse_down=false
						ext=1
					end if
				case 1
					if mouse_down=false then mouse_down=true
				end select
			end if
		
		
			fc+=1
			if fc=10 then
				fc=0	
				frame+=1
				if frame>maxframe then frame=0
				showframe=true
			end if
			
			'' Longer sleep causes problems picking up space bar
			sleep 10,1
	
			if ext=1 then exit do
		loop while true
		
		While Inkey <> "": Wend
	
	next scene
	
end sub


