'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================
''
''

#include "bmp.bi"
#include "header.bi"
#include "fmod.bi"
common shared sample() As Integer

declare sub expo_reset()
declare sub expo_add(x as integer, y as integer)
declare sub expo_draw()	 

declare sub zoom(x as integer,y as integer)

declare sub maze_update()

declare sub title_fail(py as integer)
declare sub title_success(py as integer)

dim shared as xy player

dim shared basemaze(20*15) as ubyte	'' Basemap
dim shared maze(20,15) as ubyte	

dim shared spriteno(12) as any ptr

dim shared as integer mapwidth,mapheight

dim shared as xy block(10) 

''
''
sub block_reset()
	for i as integer=0 to ubound(block)
	block(i).a=0
	next i		
end sub

sub block_add(x as integer,y as integer, t as integer)
	for i as integer=0 to ubound(block)
		if block(i).a=0 then
			with (block(i))
			.a=1
			.x=x
			.y=y
			.ox=0
			.oy=0
			
			if t=0 then
				if int(rnd*10)>=5 then .ydir=1 else .ydir=-1
				.xdir=0
			else
				if int(rnd*10)>=5 then .xdir=1 else .xdir=-1
				.ydir=0
			end if
			
			end with
			return
		end if
	next i 
end sub

sub block_update()
	for i as integer=0 to ubound(block)
		if block(i).a=1 then
		
			with (block(i))
				.ox+=.xdir
				.oy+=.ydir
				
				if .ox=32 or .ox=-32 then
					.ox=0
					.x+=.xdir
					if maze(.x+.xdir,.y)=2 then .xdir*=-1		
				end if
				
				if .oy=32 or .oy=-32 then
					.oy=0
					.y+=.ydir			
					if maze(.x,.y+.ydir)=2 then .ydir*=-1
				end if	
			end with
		end if
	next i 

end sub

sub block_draw()
	for i as integer=0 to ubound(block)
		if block(i).a=1 then
			with (block(i))	
				put ((.x*32)+.ox,(.y*32)+.oy),spriteno(2),trans
			end with
		end if
	next i 
end sub


''

sub maze_flip()
	dim as integer i,j,c
	dim temp(mapwidth*mapheight) as ubyte 

	'' copy
	for i=0 to ubound(temp)
	temp(i)=basemaze(i)
	next i
	
	'' flip row by row..
	c=0
	for j=0 to mapheight-1
		for i=0 to mapwidth-1
			basemaze(c+i)=temp((mapwidth*( (mapheight-1)-j))+i)  '' 32*(31-j)
		next i
		c+=mapwidth	''32
	next j
end sub


sub maze_load(level as integer)
	
	const path as string="gfx\maze\"

	if  Open(path+str(level)+".bmp" For binary access read As #1)=0 then
		dim header as bmphdr

		get #1,,header	
		get #1,header.offset+1,basemaze()  
	    Close #1     
	     
	    mapwidth=header.w
		mapheight=header.h  
		         
	    maze_flip()  	              
	else
		draw string(8,128),"Could not load maze..."
		sleep 100*10 
	end if
	
end sub


''
''
sub maze_init()
	const as string path="gfx\maze\"
	spriteno(0) = ImageCreate( 24, 24,rgb(0,110,0) )
	spriteno(1) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(2) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(3) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(4) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(5) = ImageCreate( 32, 32,rgb(0,110,0) )
	''
	bload "gfx\ship2\down.bmp",spriteno(0)
	bload path+"blue.bmp",spriteno(1)
	bload path+"green.bmp",spriteno(2)
	
	bload "gfx\common\cplus32.bmp",spriteno(3)
	bload "gfx\common\freebasic32.bmp",spriteno(4)
	bload path+"invert.bmp",spriteno(5)
	
	for i as integer=8 to ubound(spriteno)
	spriteno(i) = ImageCreate( 24, 24,rgb(0,110,0) )
	next i
	
	'path="gfx\ship2\"
	bload path+"up.bmp",spriteno(8)
	bload path+"right.bmp",spriteno(9)
	bload path+"down.bmp",spriteno(10)
	bload path+"left.bmp",spriteno(11)
	
end sub

sub maze_reset()
	dim as integer i,j,c
    '' Reset map
    
	block_reset()
	
    c=0
	for j=0 to mapheight-1
	 	for i=0 to mapwidth-1
	 		maze(i,j)=basemaze(c)+1	'' 1= blue, 2=green,
	 		
	 		if maze(i,j)=4 then 
			 	block_add(i,j,0)
			 	maze(i,j)=1
			end if
			
			if maze(i,j)=5 then 
			 	block_add(i,j,1)
			 	maze(i,j)=1
			end if
			
	 			
			c+=1
    	next i
    next j


	expo_reset()

	player.a=1
	player.x=48+4
	player.y=24'48
	player.sprite=10
	
	player.xdir=0
	player.ydir=1
	
end sub

sub maze_draw()
	dim as integer i,j
	cls 
	for j=0 to 14
		for i=0 to 19
		put (i*32,j*32),spriteno(maze(i,j)),trans
		next i
	next j

	put ((2*32)-12,(1*32)-8),spriteno(0),trans


	'' Player (hide if completed level)
	if player.a=1 then put (player.x,player.y),spriteno(player.sprite),trans
	
	block_update()
	block_draw()
	
	expo_draw()
end sub

sub maze_fail()
	for i as integer=0 to 9
		screenlock
			maze_draw()
			zoom(player.x-160,player.y-120)
		screenunlock
		maze_update()
		sleep 10
	next i
	
	screenlock
		title_fail(player.y)
	screenunlock
end sub

sub maze_success()
	dim as integer i,j
	 
	for j=0 to 14
		for i=0 to 19
		put (i*32,j*32),spriteno(maze(i,j)),trans
		next i
	next j
	
	title_success(0)
end sub


sub maze_update()
	'' Move player
	player.x+=(player.xdir*2)
	player.y+=(player.ydir*2)
end sub


function maze_hitwall(wx as integer,wy as integer) as integer
	dim as integer v=0
	const as integer pw=24,ph=24
	const as integer ww=32,wh=32
	
	dim as integer x=player.x
	dim as integer y=player.y
	
	dim as integer x1=wx*32
	dim as integer y1=wy*32
	
	
	if y>=y1 and y<=(y1+wh) then
		'' top left
		if x>=x1 and x<=(x1+ww) then
			v+=1
		end if
	
		'' top right
		if (x+pw)>=x1 and (x+pw)<=(x1+ww) then
			v+=2
		end if
	end if
	
	
	if (y+ph)>=y1 and (y+ph)<=(y1+wh) then
		'' bottom left
		if x>=x1 and x<=(x1+ww) then
			v+=4
		end if
	
		''bottom right
		if (x+pw)>=x1 and (x+pw)<=(x1+ww) then
			v+=8
		end if
	end if
	return v
end function


function maze_hitmoving(wx as integer,wy as integer) as integer
	dim as integer v=0
	const as integer pw=24,ph=24
	const as integer ww=32,wh=32
	
	dim as integer x=player.x
	dim as integer y=player.y
	
	dim as integer x1=wx
	dim as integer y1=wy
	
	
	if y>=y1 and y<=(y1+wh) then
		'' top left
		if x>=x1 and x<=(x1+ww) then
			v+=1
		end if
	
		'' top right
		if (x+pw)>=x1 and (x+pw)<=(x1+ww) then
			v+=2
		end if
	end if
	
	
	if (y+ph)>=y1 and (y+ph)<=(y1+wh) then
		'' bottom left
		if x>=x1 and x<=(x1+ww) then
			v+=4
		end if
	
		''bottom right
		if (x+pw)>=x1 and (x+pw)<=(x1+ww) then
			v+=8
		end if
	end if
	return v
end function


function maze_controls() as integer
	dim as integer ext=0,i,j
	
	if  MultiKey(SC_ESCAPE) then 
		expo_add(player.x+8,player.y+8)
		player.xdir=0
		player.ydir=0
		ext=FAIL
	end if
	
	if  MultiKey(SC_LEFT) then 
		player.xdir=-1
		player.ydir=0
		player.sprite=11
	end if

	if  MultiKey(SC_RIGHT) then 
		player.xdir=1
		player.ydir=0
		player.sprite=9
	end if	

	if  MultiKey(SC_UP) then 
		player.xdir=0
		player.ydir=-1
		player.sprite=8
	end if	
	
	if  MultiKey(SC_DOWN) then 
		player.xdir=0
		player.ydir=1
		player.sprite=10
	end if	

	
	#if CHEAT=1
		if  MultiKey(SC_C) then
			player.xdir=0
				player.ydir=0
				player.a=0	'' Hide player from success screen
				
				for j=0 to 14
					for i=0 to 19
					'' Change c++ to fb block
					if maze(i,j)=3 then maze(i,j)=4
					
					'' Colour walls!
					if maze(i,j)=2 then maze(i,j)=5
					next i
				next j
				
				ext=SUCCESS
				return ext
		end if	
		
		if  MultiKey(SC_S) then 
		    bsave "maze.bmp",0
		end if
	#endif
	
	'' Has player hit the wall?	
	for j=0 to 14
		for i=0 to 19
		
			select case as const maze(i,j)
			case 2
				'' Wall
				if maze_hitwall(i,j)>0 then		
					ext=FAIL
				end if
			
			case 3
				'' C++ block
				if maze_hitwall(i,j)>0 then		
					player.xdir=0
					player.ydir=0
					player.a=0	'' Hide player from success screen
					
					for j=0 to 14
						for i=0 to 19
						'' Change c++ to fb block
						if maze(i,j)=3 then maze(i,j)=4
						
						'' Colour walls!
						if maze(i,j)=2 then maze(i,j)=5
						next i
					next j
					
					ext=SUCCESS
				end if
			end select
		next i
	next j	
		
	for j=0 to ubound(block)
		if block(j).a=1 then
			if maze_hitmoving( (block(j).x*32)+block(j).ox,(block(j).y*32)+block(j).oy)>0 then
				ext=FAIL
			end if
		end if
	next j	
		
	'' Player trys to fly off screen...	
	if player.y<0 then
		ext=FAIL
	end if		
		
	'' General add explosion if failed
	if ext=FAIL then
		expo_add(player.x+8,player.y+8)
		FSOUND_PlaySound(FSOUND_FREE, sample(1))
		player.xdir=0
		player.ydir=0
	end if
		
	return ext
end function





