'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================
'' Sort out RPG moving...
''
'' + Red/Green disc to highlight infected item
'' + Cyber ghosts
''
#include "bmp.bi"
#include "header.bi"
#include "fmod.bi"
common shared sample() As Integer

declare sub infobar(txt as string)

const as integer startx=8''9
const as integer starty=12''6

dim shared sprite(40) as any ptr
dim shared as integer alt=0,fc=0
dim shared as integer bg_alt=0,bg_fc=0 

dim shared basemap(40*30) as ubyte	'' Basemap
dim shared map(40,30) as ubyte
dim shared solid(40,30) as ubyte
dim shared infected(40,30) as ubyte

dim shared mapwidth as integer
dim shared mapheight as integer

dim shared as integer esc=0

type myplayer
	x as integer
	ox as integer
	y as integer
	oy as integer
	xdir as integer
	ydir as integer
	f as integer	'' frame
	health as integer
	delay as integer	
	invincible as integer
		
	declare sub reset()
	declare function show() as boolean
	declare sub hit()
			
	private:
		fc as integer
		alt as integer
end type

sub myplayer.reset()
	x=startx
	y=starty
	f=20
	health=5
	delay=0
	invincible=0
end sub

function myplayer.show() as boolean
	if invincible>0 then
		invincible-=1
		fc+=1
		if fc=5 then
			fc=0
			alt=1-alt
		end if
		if alt=1 then return true else return false
	else
		return true
	end if
end function

sub myplayer.hit()
	health-=1
	
	if health>0 then
		invincible=120
	end if
end sub

dim shared as myplayer player


sub rpg_player_health(no as integer)
	player.health+=no
end sub


dim shared as xy target
dim shared as xy mymap
dim shared as xy shot(10)
dim shared as integer movedir=0
dim shared as integer ghost_state(2)

''
declare function ghost_shot_hit(sx as integer, sy as integer) as boolean

''
'' Player shots
''

sub map_shot_reset()
	for s as integer=0 to ubound(shot)
		shot(s).a=0
	next s
end sub

sub map_shot_add(x as integer,y as integer,xdir as integer,ydir as integer)
	for s as integer=0 to ubound(shot)
		if shot(s).a=0 then
			shot(s).a=1
			shot(s).dist=0
			shot(s).x=x+12
			shot(s).y=y+12
			shot(s).xdir=xdir*4
			shot(s).ydir=ydir*4
			exit for
		end if
	next s
end sub

function map_shot_solid_check(sx as integer, sy as integer) as boolean
	dim as integer x,y,ax,ay

	for y=-1 to 15
		ay=(y*32)+mymap.oy
	
		for x=-1 to 20	
			if 	(mymap.x+x>=0) and (mymap.y+y>=0) then			
				ax=(x*32)+mymap.ox			
			
				if solid(mymap.x+x,mymap.y+y)=1 then
					if sx>ax and sx<ax+32 then
						if sy>ay and sy<ay+32 then
						return true
						end if
					end if	
				end if	
			
			end if
		next x
	next y
	
	return false
end function


sub map_shot_update()
	dim as integer mx=(mymap.x*32)-mymap.ox
	dim as integer my=(mymap.y*32)-mymap.oy

	for s as integer=0 to ubound(shot)
		if shot(s).a=1 then
			shot(s).x+=shot(s).xdir
			shot(s).y+=shot(s).ydir
			shot(s).dist+=1
				
			'' distance check
			if shot(s).dist>100 then shot(s).a=0
			
			'' Solid check here....
			if map_shot_solid_check(shot(s).x-mx,shot(s).y-my)=true then shot(s).a=0
			
			'' Hit a ghost
			if ghost_shot_hit(shot(s).x,shot(s).y)=true then shot(s).a=0
				
		end if
	next s
end sub


sub map_shot_draw()
	dim as integer mx=(mymap.x*32)-mymap.ox
	dim as integer my=(mymap.y*32)-mymap.oy

	for s as integer=0 to ubound(shot)
		if shot(s).a=1 then put (shot(s).x-mx,shot(s).y-my),sprite(28),trans
	next s
end sub

''
'' House ghosts
''

dim shared as xy ghost(14)

sub ghost_reset()
	for g as integer=0 to ubound(ghost)
		ghost(g).a=0
	next g
	
	for g as integer=0 to ubound(ghost_state)
		ghost_state(g)=0
	next g
end sub
		

sub ghost_add(gx as integer, gy as integer)
	for g as integer=0 to ubound(ghost)
		with ghost(g)
			if .a=0 then
				.a=1
				.x=gx
				.y=gy
				.ox=0
				.oy=0
				
				.tx=gx
				.ty=gy
				
				.dist=120
				
				if int(rnd*10)<5 then .xdir=1 else .xdir=-1
				if int(rnd*10)<5 then .ydir=1 else .ydir=-1
				
				
				'' Roaming
				ghost_state(0)+=1
				
				return
				
			end if
		end with
	next g
end sub

sub ghost_update()
	for g as integer=0 to ubound(ghost)
		with ghost(g)
			if .a>0 then
				.ox+=.xdir
				.oy+=.ydir
		
				select case as const .a
				case 1
					'' Ghost bouncing around...
					if abs(.ox)=32 then
						.ox=0
						.x+=.xdir
						if .x=0 or .x=39 then .xdir*=-1
					end if	
					
					if abs(.oy)=32 then
						.oy=0
						.y+=.ydir
						if .y=0 or .y=29 then .ydir*=-1
					end if	
				
				case 2
					'' Ghost returning to item
					if abs(.ox)=32 then
						.ox=0
						.x+=.xdir
					end if	
					
					if abs(.oy)=32 then
						.oy=0
						.y+=.ydir
					end if
					
					dim as integer gx=(ghost(g).x*32)+ghost(g).ox
					dim as integer gy=(ghost(g).y*32)+ghost(g).oy
					
					.xdir=0
					.ydir=0
					if gx<(.tx*32) then .xdir=1
					if gx>(.tx*32) then .xdir=-1
					if gy<(.ty*32) then .ydir=1
					if gy>(.ty*32) then .ydir=-1
					
					if .x=.tx and .y=.ty then
					'' Roaming
						ghost_state(0)-=1
						ghost_state(1)+=1
						
						infected(.tx,.ty)=2
						.a=0
					end if
				end select
			end if
			
		end with
	next g
end sub


sub ghost_draw()
	dim as integer gx,gy
	dim as integer mx=(mymap.x*32)-mymap.ox
	dim as integer my=(mymap.y*32)-mymap.oy

	for g as integer=0 to ubound(ghost)
		if ghost(g).a>0 then
			gx=(ghost(g).x*32)+ghost(g).ox
			gy=(ghost(g).y*32)+ghost(g).oy
			
			select case as const ghost(g).a
			case 1
				'' Normal
				if ghost(g).dist=0 then
					'put (gx-mx,gy-my),sprite(29),trans
					put (gx-mx,gy-my),sprite(29),(bg_alt*32,0)-((bg_alt*32)+31,31),trans
				else
					if ghost(g).dist>0 then ghost(g).dist-=1
					put (gx-mx,gy-my),sprite(31),trans
				end if
			case 2
				'' Dead ghost
				put (gx-mx,gy-my),sprite(30),trans
			end select
			
			'' So when the ghost escapes it does not injure player immediatly!
			
		end if
		
	next g
end sub


function ghost_shot_hit(sx as integer, sy as integer) as boolean
	dim as integer gx,gy

	for g as integer=0 to ubound(ghost)
		if ghost(g).a=1 then
			'' Can on hit ghost that are fully on
			if ghost(g).dist=0 then
				gx=(ghost(g).x*32)+ghost(g).ox
				gy=(ghost(g).y*32)+ghost(g).oy
		
				if sx>gx and sx<gx+32 then
					if sy>gy and sy<gy+32 then
						ghost(g).a=2
						return true
					end if
				end if
			end if
			
		end if
	next g
	
	return false
end function

function ghost_collide(x as integer,y as integer,x1 as integer,y1 as integer) as integer
	dim as integer v=0
	const as integer pw=32-16,ph=32
	const as integer ww=(32-8),wh=32
	
	x+=8
	x1+=4
	
'	line (x,y)-(x+pw,y+ph),rgb(255,255,0),b
'	line (x1,y1)-(x1+ww,y1+wh),rgb(255,255,255),b
	
	if y>=y1 and y<=(y1+wh) then
		'' top left
		if x>=x1 and x<=(x1+ww) then
			v+=1
		end if
	
		'' top right
		if (x+pw)>=x1 and (x+pw)<=(x1+ww) then
			v+=2
		end if
	end if
	
	
	if (y+ph)>=y1 and (y+ph)<=(y1+wh) then
		'' bottom left
		if x>=x1 and x<=(x1+ww) then
			v+=4
		end if
	
		''bottom right
		if (x+pw)>=x1 and (x+pw)<=(x1+ww) then
			v+=8
		end if
	end if
	return v
end function

function ghost_hit_player() as boolean
	dim as integer px=(player.x*32)+player.ox
	dim as integer py=(player.y*32)+player.oy
	
	dim as integer mx=(mymap.x*32)-mymap.ox
	dim as integer my=(mymap.y*32)-mymap.oy
	
	dim as integer gx,gy
	
	for g as integer=0 to ubound(ghost)
		with ghost(g)
			if .a=1 and .dist=0 then
				gx=(.x*32)+.ox
				gy=(.y*32)+.oy
			
				if ghost_collide(px,py,gx-mx,gy-my)>0 then
					.dist=120
					
					return true
				end if 
			end if
		end with
	next g

	return false
end function
''
''
sub map_reset()
	player.reset()	
	map_shot_reset()
	ghost_reset()
	mymap.x=11'0
	mymap.y=15'0
	mymap.ox=0
	mymap.oy=0	
end sub

sub map_init()
	const path as string="gfx\rpg\"

	for i as integer=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	''sprite(4) = ImageCreate( 64, 32,rgb(100,255,100) )
	sprite(11) = ImageCreate( 64, 32,rgb(100,255,100) ) 
	sprite(5) = ImageCreate( 64, 64,rgb(100,255,100) ) '' Bed
	sprite(4) = ImageCreate( 32, 64,rgb(100,255,100) ) '' Cupboard
	sprite(13) = ImageCreate( 32, 64,rgb(100,255,100) ) '' Cooker
	sprite(8) = ImageCreate( 64, 64,rgb(100,255,100) ) '' Circle - red
	sprite(9) = ImageCreate( 64, 64,rgb(100,255,100) ) '' Circle - green

	'' normal 32x32 sprites	
	bload path+"grass.bmp",sprite(0)	
	bload path+"wall.bmp",sprite(1)		
	bload path+"darkwall.bmp",sprite(2)	
	bload path+"floor.bmp",sprite(3)
	bload path+"cupboard.bmp",sprite(4) '' Tall
	bload path+"bed.bmp",sprite(5)	'' Wide sprite
	bload path+"sink.bmp",sprite(6)	'' Wide sprite
	bload path+"tree.bmp",sprite(7)
	bload path+"circle-red.bmp",sprite(8)
	bload path+"circle-green.bmp",sprite(9)
			 
	'' Infected objects
	sprite(10) = ImageCreate( 96, 32,rgb(100,255,100) ) '' Console
	bload path+"console.bmp",sprite(10)	 
	sprite(11) = ImageCreate( 64, 96,rgb(100,255,100) ) '' Console
	bload path+"tv.bmp",sprite(11)	'' Wide sprite
	bload path+"tablet.bmp",sprite(12)
	bload path+"cooker.bmp",sprite(13)
	
	sprite(14) = ImageCreate( 64, 32,rgb(100,255,100) ) '' Router
	bload path+"router.bmp",sprite(14)
	
	''' more house and garden things 
	bload path+"flower.bmp",sprite(15)
		
	sprite(16) = ImageCreate( 32, 64,rgb(100,255,100) ) '' Cupboard
	bload path+"plant.bmp",sprite(16)
	
	bload path+"chair.bmp",sprite(17)
	
	'' Player
	bload path+"player\up.bmp",sprite(20)
	bload path+"player\up_1.bmp",sprite(21)		

	bload path+"player\right.bmp",sprite(22)
	bload path+"player\right_1.bmp",sprite(23)
	
	bload path+"player\down.bmp",sprite(24)
	bload path+"player\down_1.bmp",sprite(25)	
	
	bload path+"player\left.bmp",sprite(26)
	bload path+"player\left_1.bmp",sprite(27)
	
	sprite(28) = ImageCreate( 8, 8,rgb(255,255,100) ) 
	bload path+"player\shot.bmp",sprite(28)
	
	sprite(29) = ImageCreate( 64, 32,rgb(100,255,100) ) '' Router
	bload path+"ghost.bmp",sprite(29)
	bload path+"ghost_dead.bmp",sprite(30)
	bload path+"ghost_returned.bmp",sprite(31)
	
'	map_reset()
	'ghost_add(2,2)
	
	'for g as integer=1 to ubound(ghost)
	'	ghost_add(5+int(rnd*30), 5+int(rnd()*20))
	'next g 
	
end sub




sub map_flip()
	dim as integer i,j,c
	dim temp(mapwidth*mapheight) as ubyte 

	'' copy
	for i=0 to ubound(temp)
	temp(i)=basemap(i)
	next i
	
	'' flip row by row..
	c=0
	for j=0 to mapheight-1
		for i=0 to mapwidth-1
			basemap(c+i)=temp((mapwidth*( (mapheight-1)-j))+i)  '' 32*(31-j)
		next i
		c+=mapwidth	''32
	next j
end sub


sub map_load(level as integer)

	dim as integer i,j,c,t
	dim header as bmphdr

	const path as string="gfx\"

	if  Open(path+str(level)+".bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,basemap()  
	    Close #1     
	              
	    mapwidth=header.w
		mapheight=header.h      
	              
	    map_flip()  
	        
	    '' Reset map and properties
	    c=0
		for j=0 to mapheight-1
		 	for i=0 to mapwidth-1
		 		map(i,j)=basemap(c)
	    		solid(i,j)=0
				infected(i,j)=0
				c+=1
	    	next i
	    next j
	    
		for j=0 to mapheight-1
		 	for i=0 to mapwidth-1
				select case as const map(i,j)
				case 1
					'' Wall
					solid(i,j)=1
	
				case 5
					'' Bed
					for c=0 to 1
						solid(i,j+c)=1
						solid(i+1,j+c)=1
					next c
					
				case 6
					'' Sink
					solid(i,j)=1
					solid(i+1,j)=1
				
				case 4
					'' Cupboard
					solid(i,j)=1
					
				case 10
					'' Console
					solid(i,j)=1
					infected(i,j)=1
					ghost_add(i,j)
				case 11
					'' TV (double width)
					infected(i,j)=1
					solid(i,j)=1
					solid(i+1,j)=1	
					ghost_add(i,j)
					
				case 12
					'' Tablet
					solid(i,j)=1
					infected(i,j)=1
					ghost_add(i,j)
				
				case 13
					'' Cooker
					solid(i,j)=1
					'solid(i,j+1)=1
					infected(i,j)=1	
					ghost_add(i,j)
	
				case 14
					'' Router
					solid(i,j)=1
					infected(i,j)=4			
				case 7
					'' Border tree
					solid(i,j)=1
				
				case 16
					'' Indoor sun flower
					solid(i,j)=1
				
				case 17
					'' Chair
					solid(i,j)=1
										
				end select
			next i
		next j     
		
		
		'map_raw()
	'	draw string(8,128),"Size: "+str(mapwidth)+","+str(mapheight)
	'	sleep 100*10      
	              
	else
		draw string(8,128),"Could not load map "+str(level)
		sleep 100*10 
	end if
	
end sub



sub map_draw()
	dim as integer x,y
	dim as integer sx,sy,m
	
	
	'' Grass and floor  (0>14),(0>19)
	for y=-1 to 15
		sy=(y*32)+mymap.oy	
		for x=-1 to 20	
			if 	(mymap.x+x>=0) and (mymap.y+y>=0) then			
				sx=(x*32)+mymap.ox
							
				m=map(mymap.x+x,mymap.y+y)
				if m=0 or m=3 then put (sx,sy),sprite(m),pset	
				
				'' Put floor under tablet/router table / chair
				if m=12 or m=14 or m=17 then  put (sx,sy),sprite(3),pset
			end if
		next x
	next y
	
	'' Highlight infected objects 
	for y=-1 to 15
		for x=-1 to 20	
			if 	(mymap.x+x>=0) and (mymap.y+y>=0) then						
				m=infected(mymap.x+x,mymap.y+y)
				if m>1 then
					sx=(x*32)+mymap.ox
					sy=(y*32)+mymap.oy
					if map(mymap.x+x,mymap.y+y)=13 then 
						'' Cooker spot lower
						if m=2 then put (sx-16,sy+16),sprite(8),trans	'' Ghost inside
						if m=3 then put (sx-16,sy+16),sprite(9),trans	'' Cured!
					else
					
						if m=2 then put (sx-16,sy-16),sprite(8),trans	'' Ghost inside
						if m=3 then put (sx-16,sy-16),sprite(9),trans	'' Cured!
					end if
				end if
				
				'if m=2 then line (sx-8,sy-8)-(sx+40,sy+40),rgb(0,255,0),bf
			end if
		next x
	next y
		
		
		
	'' Walls + Shadow
	for y=-2 to 15
		sy=(y*32)+mymap.oy
		for x=-1 to 20		
			if 	(mymap.x+x>=0) and (mymap.y+y>=0) then		
				m=map(mymap.x+x,mymap.y+y)		
				if m=1 then 
					sx=(x*32)+mymap.ox
					put (sx,sy+32),sprite(2),pset
					put (sx,sy),sprite(m),pset
				end if
			end if
		next x
	next y
	
	
		
	'' Big sprites (everything else) some are double height/width so starting from -2
	for y=-2 to 15
		for x=-2 to 20			
			if 	(mymap.x+x>=0) and (mymap.y+y>=0) then	
				m=map(mymap.x+x,mymap.y+y)
				if m>3 then 
					sx=(x*32)+mymap.ox
					sy=(y*32)+mymap.oy
					
					select case as const m
					case 10
						'' Blinky laptop
						if infected(mymap.x+x,mymap.y+y)=3 then
							put (sx,sy),sprite(m),(2*32,0)-((2*32)+31,31),trans
						else
							put (sx,sy),sprite(m),(bg_alt*32,0)-((bg_alt*32)+31,31),trans
						end if
					
					case 11
						'' Static TV
						if infected(mymap.x+x,mymap.y+y)=3 then
							put (sx,sy),sprite(m),(0,2*32)-(63,(2*32)+31),trans
						else
							put (sx,sy),sprite(m),(0,bg_alt*32)-(63,(bg_alt*32)+31),trans
						end if
						
						
					case 14
						'' Router
						put (sx,sy),sprite(m),(bg_alt*32,0)-((bg_alt*32)+31,31),trans
					case else
						put (sx,sy),sprite(m),trans
					end select
					
				end if
			end if
		next x
	next y
	
	map_shot_draw()
	
	if player.show()=true then
		put ((player.x*32)+player.ox,(player.y*32)+player.oy),sprite(player.f+alt),trans
	end if
	
	target.a=0
	if player.ox=0 and player.oy=0 then
		'' Above
		if infected(mymap.x+player.x,mymap.y+player.y-1)>0 then
			target.x=mymap.x+player.x
			target.y=mymap.y+player.y-1
			target.a=1	'' Temp value, will give it the correct value lower down...	
		end if
		
		if infected(mymap.x+player.x+1,mymap.y+player.y)>0 then
			target.x=mymap.x+player.x+1
			target.y=mymap.y+player.y
			target.a=1
		end if
				
		if infected(mymap.x+player.x,mymap.y+player.y+1)>0 then	
			target.x=mymap.x+player.x
			target.y=mymap.y+player.y+1	
			target.a=1
		end if

		if infected(mymap.x+player.x-1,mymap.y+player.y)>0 then	
			target.x=mymap.x+player.x-1
			target.y=mymap.y+player.y
			target.a=1
		end if	
		
		if target.a>0 then
			target.a=infected(target.x,target.y)
			
			dim as string devname="??"
			if map(target.x,target.y)=10 then devname="Laptop"
			if map(target.x,target.y)=11 then devname="Smart TV"
			if map(target.x,target.y)=12 then devname="WiFi Tablet"
			if map(target.x,target.y)=13 then devname="WiFi enabled Cooker"
			if map(target.x,target.y)=14 then devname="ominous looking Router"
			
			color rgb(255,255,255)
			dim as string comment="??"
			
			select case as const target.a
			case 1
				comment="Return the corrupted program to this "+devname
			case 2
				comment="Enter this "+devname+" to cure its corrupted programming"
			case 3
				comment="This "+devname+" has be cured!"
			case 4
				comment="An "+devname
			end select
			
			infobar(comment)
			'draw string(20,10),comment
		end if
	end if

	if target.a=0 then
		color rgb(255,255,255)
		infobar("")
		'' Standard hud
		dim as string txt
		dim as integer cx
		'' 
	
		txt="Roaming"
		cx=(160-(len(txt)*8)) shr 1
		draw string(cx,4),txt
		
		txt=str(ghost_state(0))
		cx=(160-(len(txt)*8)) shr 1
		draw string(cx,16),txt
			
		txt="Contained"
		cx=(160-(len(txt)*8)) shr 1	
		draw string(160+cx,4),txt
	
		txt=str(ghost_state(1))
		cx=(160-(len(txt)*8)) shr 1	
		draw string(160+cx,16),txt
		
		txt="Cured"
		cx=(160-(len(txt)*8)) shr 1	
		draw string(320+cx,4),txt
		
		txt=str(ghost_state(2))
		cx=(160-(len(txt)*8)) shr 1	
		draw string(320+cx,16),txt
	
		txt="Health"
		cx=(160-(len(txt)*8)) shr 1	
		draw string(480+cx,4),txt
		
		txt=str(player.health)
		cx=(160-(len(txt)*8)) shr 1	
		draw string(480+cx,16),txt		
	end if
		
'	color rgb(255,255,255)
	'draw string(20,10),"MX:"+str(mymap.x)
	'draw string(20,20),"MY:"+str(mymap.y)
	'draw string(20,30),"MoX:"+str(mymap.ox)
	'draw string(20,40),"MoY:"+str(mymap.oy)
	
	'draw string(100,10),"PX:"+str(player.x)
	'draw string(100,20),"PY:"+str(player.y)
	'draw string(100,30),"PoX:"+str(player.ox)
	'draw string(100,40),"PoY:"+str(player.oy)
	
'	draw string(64,64),str(mymap.x)+" , "+str(mymap.y)
'	draw string(64,96),str(player.x)+" , "+str(player.y)

	
	ghost_draw()
	
	bg_fc+=1
	if bg_fc>=30 then
		bg_fc=0
		bg_alt=1-bg_alt
	end if
	
end sub

sub map_update()
	const as integer spd=2
	
	select case as const movedir
	case 1	
		'' up
		if mymap.y>0 and player.y<4then
			mymap.oy+=spd
			if mymap.oy=32 then 
				mymap.oy=0
				mymap.y-=1
				movedir=0
			end if
		else		
			player.oy-=spd
			if player.oy=-32 then 
				player.oy=0
				player.y-=1
				movedir=0
			end if
		end if
		
	case 2
		'' Right
		if mymap.x<20 and player.x>13 then
			mymap.ox-=spd
			if mymap.ox=-32 then 
				mymap.ox=0
				mymap.x+=1
				movedir=0
			end if
		else
			player.ox+=spd
			if player.ox=32 then 
				player.ox=0
				player.x+=1
				movedir=0
			end if
		end if	
	case 3
		'' Down
		if mymap.y<15 and player.y>10 then
			mymap.oy-=spd
			if mymap.oy=-32 then 
				mymap.oy=0
				mymap.y+=1
				movedir=0
			end if
		else		
			player.oy+=spd
			if player.oy=32 then 
				player.oy=0
				player.y+=1
				movedir=0
			end if
		end if
	case 4
		'' Left
		if mymap.x>0 and player.x<6 then
			mymap.ox+=spd
			if mymap.ox=32 then 
				mymap.ox=0
				mymap.x-=1
				movedir=0
			end if
		else	
			player.ox-=spd
			if player.ox=-32 then 
				player.ox=0
				player.x-=1
				movedir=0
			end if
		end if
	end select

	if movedir>0 then 
		fc+=1
		if fc=4 then
			fc=0
			alt=1-alt
		endif
	end if
	
	if player.delay>0 then 
		player.delay-=1
		if player.delay<0 then player.delay=0
	end if
	
	map_shot_update()
	ghost_update()
end sub

sub map_clean()
	infected(target.x,target.y)=3	'' 0=not infected, 1=infected (no ghost), 2=infected (with ghost), 3=clean
	ghost_state(1)-=1
	ghost_state(2)+=1
	target.a=-1
end sub

'' Fail to defeat a game and the ghost escapes the device
sub map_reborn()
	ghost_state(1)-=1
	ghost_add(target.x,target.y)
	infected(target.x,target.y)=1
	target.a=-1	
end sub

sub map_enable_router()
	dim as integer i,j
	for j=0 to mapheight-1
	 	for i=0 to mapwidth-1
	 		if infected(i,j)=4 then infected(i,j)=2
	 	next i
	next j
end sub



function map_final() as boolean
	dim as integer i,j
	
	dim as boolean infected_router=false
	dim as boolean infected_devices=false
	
	for j=0 to mapheight-1
	 	for i=0 to mapwidth-1
	 		if infected(i,j)=4 then infected_router=true	 		
	 		if infected(i,j)=1 or infected(i,j)=2 then infected_devices=true
	 	next i
	next j
	
	if infected_devices=false and infected_router=true then return true
	
	return false
end function

function map_completed() as boolean
	dim as integer i,j
	
	for j=0 to mapheight-1
	 	for i=0 to mapwidth-1	 		
	 		if infected(i,j)=1 or infected(i,j)=2 then return false
	 	next i
	next j

	return true
end function


function map_controls() as integer
	dim as integer ext=0
	
	if  MultiKey(SC_ESCAPE) then esc=1
	if  MultiKey(SC_ESCAPE)=0 and esc=1 then
		esc=0
		ext=QUIT
	end if
	
	if movedir=0 then
		if  MultiKey(SC_UP) then 
			player.f=20
			if solid(mymap.x+player.x,mymap.y+player.y-1)=0 then movedir=1
		end if
		
		if  MultiKey(SC_RIGHT) then 
			player.f=22
			if solid(mymap.x+player.x+1,mymap.y+player.y)=0 then movedir=2
		end if
		
		if  MultiKey(SC_DOWN) then 
			player.f=24
			if solid(mymap.x+player.x,mymap.y+player.y+1)=0 then movedir=3
		end if
		
		if  MultiKey(SC_LEFT) then 
			player.f=26
			if solid(mymap.x+player.x-1,mymap.y+player.y)=0 then movedir=4
		end if
		
		#if CHEAT=1
		if  MultiKey(SC_C) then 
			'' Simple way to make sure that holding the key does not
			'' set this to zero...	
			if ghost_state(1)=0 then
				ghost_state(1)=ghost_state(0)
				ghost_state(0)=0
				ghost_state(2)=0
				
				dim as integer i,j
				for j=0 to mapheight-1
				 	for i=0 to mapwidth-1
				 	if infected(i,j)=1 then infected(i,j)=2
				 	'if infected(i,j)=1 then infected(i,j)=3
				 	next i
			 	next j
			 	
		 		for g as integer=0 to ubound(ghost)
		 			ghost(g).a=0
				next g
		 	end if
		end if
		
		if  MultiKey(SC_S) then 
		    bsave "map.bmp",0
		end if
		
		#endif
		
	end if

	if  MultiKey(SC_SPACE) then
		if target.a=2 then
			''2
			'' Enter device when ghost has returned!
			ext=map(target.x,target.y)
		else
			'' Shoot
			if player.delay=0 then
				player.delay=30
				dim as integer mpx=(mymap.x*32)-mymap.ox
				dim as integer mpy=(mymap.y*32)-mymap.oy
				
				dim as integer ax=(player.x*32)+player.ox
				dim as integer ay=(player.y*32)+player.oy
				
				if player.f=20 then map_shot_add(mpx+ax,mpy+ay,0,-1)
				if player.f=22 then map_shot_add(mpx+ax,mpy+ay,1,0)
				if player.f=24 then map_shot_add(mpx+ax,mpy+ay,0,1)
				if player.f=26 then map_shot_add(mpx+ax,mpy+ay,-1,0)
				
				FSOUND_PlaySound(FSOUND_FREE, sample(0))
		
			end if
		end if
	end if
	
	
	'' Hit ghost?
	if player.invincible=0 then
		if ghost_hit_player() then
			player.hit()
		end if
	end if
	
	if player.health=0 then
'		infobar("Game over, zero health...")
		map_draw()
		ext=GAMEOVER
	end if
	
	if map_final()=true then
		map_enable_router()
		ext=FINAL
	end if
	
	if map_completed()=true then
		'map_enable_router() ???
		ext=GAMEDONE
	end if
	
	
	return ext
end function


