'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================
''
'' + Mouse arrow on practice screen
'' + Make sure bonus levels unlock!
'' + Thorough testing
'' + Final checks!
'' + TURN OFF CHEAT MODE!!
''

#include "header.bi"
#include "fmod.bi"

''
FSOUND_Init(44100, 8, 0) 

common shared sample() As Integer
dim sample(10) As Integer

sample(0) = FSOUND_Sample_Load(FSOUND_FREE,"snd\zap.wav", FSOUND_HW3D, 0, 0) 
sample(1) = FSOUND_Sample_Load(FSOUND_FREE,"snd\explosion.mp3", FSOUND_HW3D, 0, 0) 
sample(2) = FSOUND_Sample_Load(FSOUND_FREE,"snd\beep.mp3", FSOUND_HW3D, 0, 0) 
sample(3) = FSOUND_Sample_Load(FSOUND_FREE,"snd\success.mp3", FSOUND_HW3D, 0, 0) 


common shared as integer music_on	'' common so it can be turned off on title screen!
dim shared as boolean playmusic


dim as integer gamemusic,mazemusic
common shared as integer rpgmusic	'' <-- Used on title screen


gamemusic = FMUSIC_LoadSong("midi\shooting.mid")
FMUSIC_SetMasterVolume(gamemusic, 100)

mazemusic = FMUSIC_LoadSong("midi\maze.mid")
FMUSIC_SetMasterVolume(mazemusic, 80)	'' Seems loud...

rpgmusic = FMUSIC_LoadSong("midi\rpg.mid")
FMUSIC_SetMasterVolume(rpgmusic, 90)	'' Seems loud...

''
randomize timer

declare sub rpg_player_health(no as integer)

declare function game_save() as boolean
declare function game_load() as boolean

declare sub title_init()
declare function title_welcome(as integer) as integer
declare function title_practice(as integer, as integer) as integer
declare sub title_instructions(as integer)
declare function title_name(as integer) as string
declare sub title_final(as integer)

declare sub expo_init()	 

declare sub invader_init()
declare sub invader_update()
declare sub invader_reset(as integer)
declare sub invader_draw()
declare function invader_controls() as integer
declare sub invader_fail()
declare sub invader_success()
''
declare sub race_init()
declare sub race_update()
declare sub race_reset(as integer)
declare sub race_draw()
declare function race_controls() as integer
declare sub race_fail()
declare sub race_success()
''
declare sub maze_init()
declare sub maze_load(level as integer)
declare sub maze_update()
declare sub maze_reset()
declare sub maze_draw()
declare function maze_controls() as integer
declare sub maze_fail()
declare sub maze_success()


declare sub smash_init()
declare sub smash_update()
declare sub smash_reset(as integer)
declare sub smash_draw()
declare function smash_controls() as integer
declare sub smash_fail()
declare sub smash_success()

declare sub tunnel_init()
declare sub tunnel_update()
declare sub tunnel_reset(as integer)
declare sub tunnel_draw()
declare function tunnel_controls() as integer
declare sub tunnel_fail()
declare sub tunnel_success()


declare sub map_init()
declare sub map_load(as integer)
declare sub map_reset()
declare sub map_draw()
declare sub map_update()
declare sub map_clean()
declare sub map_reborn()
declare function map_controls() as integer

declare sub bug_init()

''
declare sub intro_init()
declare sub intro_load()
declare sub intro_run()

declare sub outro_init()
declare sub outro_load()
declare sub outro_run()


common shared as integer swidth,sheight,sdepth

dim as integer ext=0,gametype=0

'' Ignoring level/game (0)!
dim shared level(5) as integer=>{1,1,1,1,1,1}	

common shared as integer hilevel()
dim hilevel(5) as integer	

'' 5 Games, 6 Levels
common shared as myscore best()
dim best(5,6) as myscore

for h as integer=0 to ubound(hilevel)
	hilevel(h)=0
next h

'hilevel(1)=3
'hilevel(2)=2

dim shared as integer tim=200
dim as integer mpressed=0

'' Pixelise - When entering a device
sub pixelise(stp as integer)
	dim as integer i,j,col,sz
	
	sz=1 shl stp
	for j=0 to 479 step sz
		for i=0 to 639 step sz
			col=point(i,j)
			line(i,j)-(i+sz-1,j+sz-1),col,bf
		next i
	next j	
end sub

'' Zoom - Used when you crash
sub zoom(x as integer,y as integer)
	dim as integer i,j

	if (x+320)>640 then x=320
	if (y+240)>480 then y=240

	if x<0 then x=0
	if y<0 then y=0

	'' Copy a section of screen
	dim as integer scr(320,240)
	
	for j=0 to 239
		for i=0 to 319
			scr(i,j)=point(i+x,j+y)
		next i
	next j
	
	'' Redraw it bigger!
	const as integer sz=2
	
	for j=0 to 239 
		for i=0 to 319
			line(i*sz,j*sz)-((i*sz)+sz-1,(j*sz)+sz-1),scr(i,j),bf
		next i
	next j	
end sub

sub spectral(offset as integer)
	dim as uinteger cols(8)
	
	'' Maybe dim these a little...
	cols(0)=rgb(0,0,0)
	cols(1)=rgb(0,0,255)
	cols(2)=rgb(255,0,0)
	cols(3)=rgb(255,0,255)
	cols(4)=rgb(0,255,0)
	cols(5)=rgb(0,255,255)
	cols(6)=rgb(255,255,0)
	cols(7)=rgb(255,255,255)
	
	const as integer sz=16
	dim as integer i,j,c=0 ',offset=1
	
	for j=0 to 479 step sz
		c=offset
		for i=0 to 639 step sz
				line(i,j)-(i+sz-1,j+sz-1),cols(c),bf
				c=c+1
				if c>7 then c=1
		next i
		
		offset+=1
		if offset>7 then offset=1
	next 

end sub

sub time_draw()
	color 0
	line(0,0)-(26,16),,bf
	
	color rgb(255,255,255)
	draw string(1,1),str(tim)
end sub


sub wait_space()
	dim as boolean extloop=false
	dim as integer res,mx,my,mb
	dim as boolean mouse_down=false
	
	'' Check first for key still pressed from the game
	While Inkey <> "": Wend
	extloop=false
	do
		if MultiKey(SC_SPACE)=false then extloop=true
		sleep 10
	loop while extloop=false

	'' Main wait for key bit...
	dim as boolean spacedown=false
	
	extloop=false
	
	While Inkey <> "": Wend
	
	do
		'' Wait for Space up
		if MultiKey(SC_SPACE)=true then spacedown=true 
		
		if spacedown=true then
			if MultiKey(SC_SPACE)=false then
				extloop=true
			end if
		end if
		
		
		'' Mouseclick (exit on up)
		res = GetMouse (mx,my,,mb)
		if res=0 then
			select case as const mb
			case 0
				if mouse_down=true then extloop=true
			case 1
				if mouse_down=false then mouse_down=true
			end select
			
			'if (mb=1) and (mouse_down=false) then
			'	mouse_down=true
			'else
			'	if mb=0 and mouse_down=true then extloop=true
			'end if
		end if
			
		sleep 10
	loop while extloop=false
	
	While Inkey <> "": Wend
end sub

''
'' Main program
''

windowtitle GAMETITLE+" ["+VERSION+"] "+SITEURL
screen 18,32 '',&h01

screeninfo swidth,sheight,sdepth


outro_init()
outro_load()
'outro_run()
'end

intro_init()
intro_load()
'intro_run()

expo_init()

bug_init()

invader_init()

map_init()

race_init()

title_init()
maze_init()
smash_init()
tunnel_init()

music_on=1
playmusic=true
''
if game_load()=false then
	dim as integer c
	for g as integer=1 to 5
		for l as integer=1 to 6
			with best(g,l)
				.score=123'200+c
				.first="abc"
				'.first=".........."
				.played=false
				.completed=false
			end with
			c=c+1
		next l
	next g
	
	'' Only force intro on first run
	intro_run()
	
else
	'' Sort out high levels etc...
	for g as integer=1 to 5
		for l as integer=1 to 6
		
			'' Cheat!
			#if CHEAT=1 
			'best(g,l).played=true
			#endif
			
			'' NOT RIGHT!! CHECK
			if best(g,l).played=true then hilevel(g)+=1
		next l
	next g
end if

dim as integer opt=1

dim as integer fc=0
dim as string firstname
				
do
	do 	
		''
		'' Title Screen
		''
		FMUSIC_StopAllSongs()
		if music_on=1 then FMUSIC_PlaySong(rpgmusic)
		
		opt=title_welcome(opt)
	
		select case as const opt
		case 0
			FMUSIC_StopAllSongs()
			'' Play intro
			intro_run()
		case 1
			''
			firstname=title_name(0)	
			
			'' Play game
			for i as integer=0 to ubound(level)
				level(i)=1
			next i
			
			map_reset()			
			map_load(2)
			
			'if music_on=1 then FMUSIC_PlaySong(rpgmusic)
				
			ext=0
			
		case 2
			'' Sub Game menu
			dim subgame as integer
			dim as integer game=1
			dim as integer sublevel=1
			
			do 
				'' Restart here otherwise when completing game you get silence!
				FMUSIC_StopAllSongs()
				if music_on=1 then FMUSIC_PlaySong(rpgmusic)
		
				subgame=title_practice(game,sublevel)
						
				if subgame>0 then
				
					FMUSIC_StopAllSongs()
					'wait_space()
					'' e.g. 53 = game 5 level 3 
					game=int(subgame/10)
					sublevel=subgame MOD 10
					
					'game-=1
					
					'cls
					'draw string (8,8),str(game)+" / "+str(sublevel)
					'draw string (8,32),"Press Space"
					'wait_space()
					
					'sublevel-=1
					
					''
					'' Start music
					''
					if music_on=1 then 
						select case as const game
						case 1:
							'' Hills
							FMUSIC_PlaySong(gamemusic)
						case 2
							'' Vertical
							FMUSIC_PlaySong(gamemusic)
						case 3
							'' Maze
							FMUSIC_PlaySong(mazemusic)
						case 4
							'' All directions
							FMUSIC_PlaySong(mazemusic)
						case 5
							'' Isometric
							FMUSIC_PlaySong(gamemusic)
						end select
					end if
					''
					''
					
					tim=200
					fc=0
					ext=0
					
					select case as const game
					case 1
						'' Invaders over hills	
						invader_reset(sublevel)
						
						'color rgb(255,255,255)
						do					
							FSOUND_Update
							'' Invader Game	
							screenlock
								invader_draw()
								time_draw()
							'	draw string(32,32),str(game)+" / "+str(sublevel)
							screenunlock
							
							invader_update()	
							ext=invader_controls()
							
							sleep 10,1
							
							'' Game timer
							fc+=1
							if fc=30 then 
								tim-=1
								fc=0
							end if
							if tim<=0 then ext=FAIL
							
							'' Music Off
							if  MultiKey(SC_M) and (music_on=1) then 
								music_on=0
								FMUSIC_StopAllSongs()
							end if
							
						loop while ext=0
						
						FMUSIC_StopAllSongs()
						
						if ext=SUCCESS then 
							
							FSOUND_PlaySound(FSOUND_FREE, sample(3))
							screenlock
								invader_success()
							screenunlock		
						else				
							if ext=FAIL then 
								invader_fail()
							end if
						end if
					
					case 2
						'' TV - Race / Avoid Game	
						race_reset(sublevel)
						do					
							FSOUND_Update
							screenlock
								race_draw()
								time_draw()
							screenunlock
							
							race_update()	
							ext=race_controls()
							
							sleep 10,1
							
							'' Game timer
							fc+=1
							if fc=30 then 
								tim-=1
								fc=0
							end if
							if tim<=0 then ext=FAIL
							
							'' Music Off
							if  MultiKey(SC_M) and (music_on=1) then 
								music_on=0
								FMUSIC_StopAllSongs()
							end if
						loop while ext=0
						
						FMUSIC_StopAllSongs()
						
						if ext=SUCCESS then 	
							FSOUND_PlaySound(FSOUND_FREE, sample(3))	
							screenlock
								race_success()
							screenunlock
						else		
							if ext=FAIL then 
								race_fail()
							end if
						end if
					
					case 3
						'' Maze game
						maze_load(sublevel)
						maze_reset()
						
						do					
							FSOUND_Update
							screenlock
								maze_draw()
								time_draw()
							screenunlock
							
							maze_update()	
							ext=maze_controls()
							sleep 10,1
							
							'' Game timer
							fc+=1
							if fc=30 then 
								tim-=1
								fc=0
							end if
							if tim<=0 then ext=FAIL
							
							'' Music Off
							if  MultiKey(SC_M) and (music_on=1) then 
								music_on=0
								FMUSIC_StopAllSongs()
							end if
						loop while ext=0
						
						FMUSIC_StopAllSongs()
						
						if ext=SUCCESS then 
							FSOUND_PlaySound(FSOUND_FREE, sample(3))
							for i as integer=1 to 7
								screenlock
									spectral(i)
									maze_success()
								screenunlock
								sleep 100,1
							next i
						else				
							if ext=FAIL then 
								maze_fail()
							end if
						end if
					
					case 4
						'' All direction shooting game
						smash_reset(sublevel)
						do					
							FSOUND_Update
							screenlock
								smash_draw()
								time_draw()
							screenunlock
							
							smash_update()	
							ext=smash_controls()
							sleep 10,1
							
							'' Game timer
							fc+=1
							if fc=30 then 
								tim-=1
								fc=0
							end if
							if tim<=0 then ext=FAIL
								
							'' Music Off
							if  MultiKey(SC_M) and (music_on=1) then 
								music_on=0
								FMUSIC_StopAllSongs()
							end if
						loop while ext=0
						
						FMUSIC_StopAllSongs()
						
						if ext=SUCCESS then 
							FSOUND_PlaySound(FSOUND_FREE, sample(3))
							for i as integer=1 to 7
								screenlock
									spectral(i)
									smash_success()
								screenunlock		
								sleep 100,1
							next i
						
						else
							if ext=FAIL then 
								smash_fail()
							end if
						end if
								
					case 5
						'' Zaxxon clone
						tunnel_reset(sublevel)
						do					
							FSOUND_Update
							screenlock
								tunnel_draw()
								time_draw()
							screenunlock
							
							tunnel_update()	
							ext=tunnel_controls()
							sleep 10,1
							
							'' Game timer
							fc+=1
							if fc=30 then 
								tim-=1
								fc=0
							end if
							if tim<=0 then ext=FAIL
							
							'' Music Off
							if  MultiKey(SC_M) and (music_on=1) then 
								music_on=0
								FMUSIC_StopAllSongs()
							end if
						loop while ext=0
						
						FMUSIC_StopAllSongs()
						
						if ext=SUCCESS then 
							FSOUND_PlaySound(FSOUND_FREE, sample(3))
							for i as integer=1 to 7
								screenlock
									tunnel_success()
								screenunlock		
								sleep 100,1
							next i
						
						else
							if ext=FAIL then 
								tunnel_fail()
							end if
						end if		
					end select
					
					'' Game has finished (success/fail) so wait
					wait_space()
					
					
					FMUSIC_StopAllSongs()
						
					
					'' Check if best time
					if ext=SUCCESS then 
						with best(game,sublevel)
							if (200-tim)<.score then 
								.score=(200-tim)
								.first=title_name(1)
							end if
						end with
					end if	
				end if
						
			loop while subgame>0
			''
			
		end select
			
	loop while opt<>1
	
	''
	'' Main Game
	''
	
	'' Basic instructions
	screenlock
	map_draw()
	title_instructions(0)
	screenunlock
	wait_space()
''

do
	FSOUND_Update
		
	if music_on=1 then 
		if playmusic=true then
			select case as const gametype
			case 0:
				'' House
				FMUSIC_PlaySong(rpgmusic)
			case 1:
				'' Hills
				FMUSIC_PlaySong(gamemusic)
			case 2
				'' Vertical
				FMUSIC_PlaySong(gamemusic)
			case 3
				'' Maze
				FMUSIC_PlaySong(mazemusic)
			case 4
				'' All directions
				FMUSIC_PlaySong(mazemusic)
			case 5
				'' Isometric
				FMUSIC_PlaySong(gamemusic)
			end select
			playmusic=false
		end if
	end if
	''
	''
	select case as const gametype
	case 0
		'' RPG 
		screenlock
			map_draw()
			'zoom(0,0)
		screenunlock
		map_update()
		ext=map_controls()
		'ext=14
		
		if ext>0 and ext<>QUIT and ext<>GAMEOVER then
			'' Transition effect
			if ext<>FINAL and ext<>GAMEDONE then
				for i as integer=0 to 4
					screenlock
						pixelise(i)
					screenunlock
					sleep 100,1
				next i
			end if
		
			'' Reset timers
			tim=200
			fc=0
		
			'' Start a new game so new music!
			if ext>=10 and ext<=14 then
				playmusic=true
			end if
		
			select case as const ext
			case 10
				'' Computer - Invaders		
				gametype=1
				invader_reset(level(gametype))
				screenlock
					invader_draw()
					title_instructions(gametype)
				screenunlock
			case 11
				'' TV - Vertical racer
				gametype=2
				race_reset(level(gametype))
				screenlock
					race_draw()
					title_instructions(gametype)
				screenunlock	
			case 12
				'' Tablet - Maze game
				gametype=3
				maze_load(level(gametype))
				maze_reset()
				screenlock
					maze_draw()
					title_instructions(gametype)
				screenunlock
			case 13
				'' Cooker - Smash shooter
				gametype=4
				smash_reset(level(gametype))
				screenlock
					smash_draw()
					title_instructions(gametype)
				screenunlock
			case 14
				'' Router - Iso
				gametype=5
				tunnel_reset(level(gametype))
				screenlock
					tunnel_draw()
					title_instructions(gametype)
				screenunlock
			case FINAL
				screenlock
					title_final(0) 
				screenunlock
			end select
			
			if ext=GAMEDONE then
			'	screenlock
			'		title_final(1) 
			'	screenunlock
			'	wait_space()
			else			
				ext=0
				wait_space()
			end if
			
		
			best(gametype,level(gametype)).played=true
			
			'' Unlock if we have started the game
			if hilevel(gametype)<level(gametype) then
				hilevel(gametype)=level(gametype)
			end if
			
		end if
		
	case 1
		'' Console - Bug over mountains
		screenlock
			invader_draw()
			time_draw()
		screenunlock
		
		invader_update()	
		ext=invader_controls()
		if tim<=0 then ext=FAIL
		
		if ext<>0 then
			if ext=SUCCESS then 
				FSOUND_PlaySound(FSOUND_FREE, sample(3))
				screenlock
					invader_success()
				screenunlock
			end if
			
			if ext=FAIL then 
				invader_fail()	
			end if
		end if
		
	case 2	
		'' TV - Race / Avoid Game
		screenlock
			race_draw()
			time_draw()
		screenunlock
		
		race_update()	
		ext=race_controls()
		if tim<=0 then ext=FAIL
		
		if ext<>0 then		
			if ext=SUCCESS then 				
				FSOUND_PlaySound(FSOUND_FREE, sample(3))
				screenlock
					race_success()
				screenunlock
			end if
			
			if ext=FAIL then 
				race_fail()
			end if
		end if
		
	case 3	
		'' Tablet - Maze Game
		screenlock
			maze_draw()
			time_draw()
		screenunlock
		
		maze_update()	
		ext=maze_controls()
		if tim<=0 then ext=FAIL
		
		if ext<>0 then
			if ext=SUCCESS then 
				FSOUND_PlaySound(FSOUND_FREE, sample(3))	
				for i as integer=1 to 7
					screenlock
						spectral(i)
						maze_success()
					screenunlock
					
					sleep 100,1
				next i
			end if
			
			if ext=FAIL then 
				maze_fail()
			end if
		end if		
	
	case 4			
		screenlock
			smash_draw()
			time_draw()
		screenunlock
		
		smash_update()	
		ext=smash_controls()
		if tim<=0 then ext=FAIL
		
		if ext<>0 then
			if ext=SUCCESS then 
				FSOUND_PlaySound(FSOUND_FREE, sample(3))		
				for i as integer=1 to 7
					screenlock
						spectral(i)
						smash_success()
					screenunlock					
					sleep 100,1
				next i
			end if
			
			if ext=FAIL then 
				smash_fail()
			end if
		end if			
		
	case 5			
		screenlock
			tunnel_draw()
			time_draw()
		screenunlock
		
		tunnel_update()	
		ext=tunnel_controls()
		if tim<=0 then ext=FAIL
		
		if ext<>0 then
			if ext=SUCCESS then 		
				FSOUND_PlaySound(FSOUND_FREE, sample(3))
				screenlock
					tunnel_success()
				screenunlock			
			end if
			
			if ext=FAIL then 
				tunnel_fail()
			end if
		end if		
	end select
	
	'' This will also stop  music on completion	
	if ext<>0 then
		FMUSIC_StopAllSongs()
	end if
	
	'' General Success / Fail bits
	if ext=SUCCESS or ext=FAIL then
		
		if ext=SUCCESS then 
			'' Mark target device as no longer infected
			map_clean()
			'' Mark as complete, check score
			with best(gametype,level(gametype))
				.completed=true
				if (200-tim)<.score then 
					.score=(200-tim)		
					.first=firstname
				end if		
			end with
			'' Next level
			level(gametype)+=1
			'' Increase health
			rpg_player_health(1)
		else
			if ext=FAIL then 
				'' Zaxxon game does not respawn a ghost!
				if gametype<>5 then
					map_reborn()
				end if
				rpg_player_health(-1)
			end if
		end if	
		wait_space()
		playmusic=true	'' Will play rpg music
		gametype=0
		ext=0
	end if	
	
	'' TODO - Is bit below needed????
'	if ext=GAMEDONE then
'		map_clean()
'		'' Mark as complete, check score
'		with best(gametype,level(gametype))
'			.completed=true
'			if (200-tim)<.score then 
'				.score=(200-tim)		
'				.first=firstname
'			end if		
'		end with
		'' Next level
'		level(gametype)+=1
		'wait_space()
'	end if
		
	'' Game timer
	if (gametype>=1) and (gametype<=5) then
		fc+=1
		if fc=30 then 
			tim-=1
			fc=0
		end if
	end if
	
	''
		'' Music On/Off (on key release)
	if  MultiKey(SC_M) and (mpressed=0) then mpressed=1
	
	if MultiKey(SC_M)=0 and (mpressed=1) then
		mpressed=0
		music_on=1-music_on
		if music_on=0 then 
			FMUSIC_StopAllSongs()
		else
			playmusic=true
		end if
	end if
	
	sleep 10,1	
	
loop while ext=0

	if ext=FAIL then ext=0
	if ext=QUIT then ext=0
	
	if ext=GAMEDONE then 
		'' Message on rpg
		screenlock
			title_final(1) 
		screenunlock
		wait_space()
				
		outro_run()
		ext=0
	end if
	
	if ext=GAMEOVER then
		title_final(3)
		wait_space()
		ext=0	
	end if
	
loop while ext=0

FSOUND_Close()

