'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================
''
'' Horizontal shooting game
''
'' Level 2 - Upward shooting bases
'' Level 3 - + Roof!
''


#include "header.bi"
#include "fmod.bi"
common shared sample() As Integer

'declare sub expo_init()
declare sub expo_reset()
declare sub expo_add(x as integer, y as integer)
declare sub expo_draw()	 

'declare sub shot_bug()
declare sub shot_reset()
declare sub shot_update(as integer,as integer)
declare function shot_hitblock(tx as integer,ty as integer) as integer

declare function shot_hit(tx as integer,ty as integer,owner as integer) as integer
declare sub shot_add(as integer,as integer, as integer)
declare sub shot_addrocket(x as integer,y as integer)

declare sub bug_shoot(as integer,as integer)
declare sub bug_cheat()
declare sub bug_draw(as integer, as integer)
declare sub bug_reset(as integer)
declare function bug_hitplayer(bugx as integer,bugy as integer, px as integer,py as integer) as boolean
declare function bug_isclean() as boolean


declare function hill_hit(ax as integer,ay as integer,tx as integer,ty as integer) as integer
declare function hill_hitroof(x as integer,y as integer,x1 as integer,h1 as integer) as integer

declare sub title_fail(py as integer)
declare sub title_success(py as integer)

declare sub zoom(x as integer,y as integer)
''

dim shared as integer shotdelay
dim shared as integer rocketdelay

dim shared as xy player,invader

dim shared as byte land(21,14)

dim shared spriteno(5) as any ptr

dim shared as integer scrx=0,ofx=0,level=0

'' 
sub invader_init()
	const path="gfx\invaders\"
	spriteno(0) = ImageCreate( 24, 24,rgb(0,110,0) )
	spriteno(1) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(2) = ImageCreate( 32, 32,rgb(0,110,0) )
	spriteno(3) = ImageCreate( 32, 32,rgb(0,110,0) )
	
	''
	bload "gfx\ship2\right.bmp",spriteno(0)
	bload path+"green.bmp",spriteno(1)
	bload path+"blue.bmp",spriteno(2)
	bload path+"red.bmp",spriteno(3)
end sub

sub invader_reset(lev as integer)
	dim as integer i,j

	level=lev

	bug_reset(lev)
	expo_reset()

	player.x=128
	player.y=256
	
	invader.y=480-(16*14)
	invader.x=416
		
	shot_reset()
	
	for j=0 to 14
		for i=0 to 21
			land(i,j)=0		
		next i
	next j
	
	for i as integer=0 to 21		
		land(i,13)=1
		land(i,14)=1
	next i	
	
'	land(13,13)=2	
'	land(21,13)=2
	
	rocketdelay=30
	shotdelay=0
	
end sub

sub invader_draw()
	dim as integer i,j,c,h

	'' Background
	for j=0 to 480 step 32
		for i=0 to 640 step 32
		put (i-scrx,j),spriteno(2),pset
		next i
	next j

	'' Hills
	for j=0 to 14
		for i=0 to 21
			if land(i,j)>0 then
				select case as const land(i,j)
				case 1
					put ((i*32)-ofx,j*32),spriteno(1),trans	
					shot_hitblock((i*32)-ofx,j*32)
					
				case 2
					put ((i*32)-ofx,j*32),spriteno(3),trans
					
					'' Red block back to green
					if shot_hitblock((i*32)-ofx,j*32)>0 then
						land(i,j)=1
					end if
				end select	
					
				'shot_hitblock((i*32)-ofx,j*32)
				
			end if			
		next i
	next j
	
'	color rgb(255,255,255)
'	for i=0 to 21			
'		h=0
'		for c=0 to 14
'			if land(i,c)=1 then h=h+1
'		next c
'		draw string((i*32)-ofx,400),str(i)
'		draw string((i*32)-ofx,414),"["+str(h)+"]"	
'	next i
	
	put (player.x,player.y),spriteno(0),trans

	bug_draw(invader.x,invader.y)
	
	if invader.f=0 then
		if int(rnd*100)=5 then
			 bug_shoot(invader.x,invader.y)
			 invader.f=30
		end if
	else
		invader.f-=1
	end if
	
	shot_update(0,0)
	expo_draw()
end sub

sub invader_update()
	dim as integer h=0
	dim as integer i,j
	
	'' Scroll background
	scrx+=1
	if scrx=32 then scrx=0
	
	'' Scroll mountains
	ofx+=2
	if (ofx=32) then
		ofx=0
		for j=0 to 14
			for i=0 to 20
				land(i,j)=land(i+1,j)		
			next i
		next j
	
		for j=0 to 14
			if land(20,14-j)=1 or land(20,14-j)=1 then 
				h=h+1
			else
				exit for
			end if
		next j
	
		h=h-1	'' Fixes mountain height offset
		if int(rnd()*10)>4 then
			h-=1
			if h<0 then h=0
		else
			h+=1
			if h>8 then h=8 ''
		end if
		
		for j=0 to 14
			land(21,j)=0
		next j
		
		for j=0 to h
			land(21,14-j)=1
		next j
		
		'' Red Turret
		if (level>=2) then
			if int(rnd()*10)>8 then
				land(21,14-h)=2
			end if
		end if
		
		'' ceiling
		if (level=3 or level=6) then
			if (14-h-9)>=0 then
				for j=0 to (14-h-9)
				land(21,j)=1
				next  j
			end if
		end if
	end if	
	
	''
	if rocketdelay=0 then
		
		for j=0 to 14
			for i=0 to 21
				if land(i,j)=2 then
					if int(rnd*9)>7 then
						shot_addrocket((i*32)-ofx,j*32)
						rocketdelay=30
						exit for
					end if
				end if		
			next i
			if rocketdelay=30 then exit for
		next j
	else
		rocketdelay-=1
	end if

	
	'' Move bug
	h=0
	for j=0 to 14
		if land(16,14-j)=1 then 
			h=h+1
		else
			exit for
		end if
	next j
	
	if invader.y<480-(h*32)-(16*12) then invader.y+=2
	if invader.y>480-(h*32)-(16*12) then invader.y-=2
	
	
end sub

function invader_controls() as integer
	dim as integer i,j,h
	dim as integer ext=0
	
	if  MultiKey(SC_ESCAPE) then 
		expo_add(player.x+16,player.y+8)
		FSOUND_PlaySound(FSOUND_FREE, sample(1))
		ext=FAIL
		return ext
	end if
	
	if  MultiKey(SC_RIGHT) and player.x<464 then player.x+=2
	if  MultiKey(SC_LEFT) and player.x>0 then player.x-=2
		
	if  MultiKey(SC_SPACE) and shotdelay=0 then
		shot_add(player.x+12,player.y+6,1)	
		shotdelay=12
		FSOUND_PlaySound(FSOUND_FREE, sample(0))
	end if
	
	if  MultiKey(SC_UP) and player.y>0 then player.y-=2
	if  MultiKey(SC_DOWN) and player.y<(480-32) then player.y+=2
	
	#if CHEAT=1
		if  MultiKey(SC_C) then bug_cheat()	
		
		if  MultiKey(SC_S) then 
		    bsave "laptop.bmp",0
		end if
		
	#endif
		
	if shotdelay>0 then shotdelay-=1
	
	for i=0 to 20
		'' Count blocks from bottom up
		h=0
		for j=0 to 14
			if land(i,14-j)=1 or land(i,14-j)=2 then 
				h=h+1
			else
				exit for
			end if
		next j
		
		'line ((i*32)-ofx,480-(h*32))-((i*32)-ofx+32 ,480),rgb(255,255,255),b
		''		
		if (hill_hit(player.x,player.y,(i*32)-ofx,480-(h*32))>0) then
			ext=FAIL
			exit for
		end if
		
		'' Ceiling
		h=0
		for j=0 to 14
			if land(i,j)=1 or land(i,j)=2 then 
				h=h+1
			else
				exit for
			end if
		next j
		
		'line ((i*32)-ofx,0)-((i*32)-ofx+32 ,(h*32)),rgb(255,255,255),b
		''
		if h>0 then	
			if (hill_hitroof(player.x,player.y, (i*32)-ofx,(h*32))>0) then

				ext=FAIL
				exit for
			end if
		end if
			
	next i	
	
	if bug_isclean()=true then 
		ext=SUCCESS
	end if
	
	if bug_hitplayer(invader.x,invader.y,player.x,player.y)=true then ext=FAIL
	
	if shot_hit(player.x,player.y,2)=2 then ext=FAIL
	
	if ext=FAIL then
		expo_add(player.x+16,player.y+8)
		FSOUND_PlaySound(FSOUND_FREE, sample(1))
	end if
		
	return ext
end function

sub invader_fail()
	for i as integer=0 to 9
		screenlock
			invader_draw()
			zoom(player.x-160,player.y-120)
		screenunlock
		invader_update()
		sleep 10
	next i
	
	screenlock
		title_fail(player.y)
	screenunlock
end sub

sub invader_success()
	invader_draw()
	title_success(player.y)
end sub


function hill_hit(x as integer,y as integer,x1 as integer,y1 as integer) as integer
	dim as integer v=0
	const as integer pw=24,ph=24
	const as integer bw=32,bh=32
	
	dim as integer h1=480-y1

	if y>=y1 and y<=(y1+bh) then
		'' top left
		if x>=x1 and x<=(x1+bw) then
			v+=1
		end if
	
		'' top right
		if (x+pw)>=x1 and (x+pw)<=(x1+bw) then
			v+=2
		end if
	end if
	
	if (y+ph)>=y1 and (y+ph)<=(y1+bh) then
		'' bottom left
		if x>=x1 and x<=(x1+bw) then
			v+=4
		end if
	
		''bottom right
		if (x+pw)>=x1 and (x+pw)<=(x1+bw) then
			v+=8
		end if
	end if

	return v
end function


function hill_hitroof(x as integer,y as integer,x1 as integer,h1 as integer) as integer
	dim as integer v=0
	const as integer pw=24,ph=24
	const as integer bw=32
	const as integer y1=0
	
	dim as integer bh=h1


	if y>=y1 and y<=(y1+bh) then
		'' top left
		if x>=x1 and x<=(x1+bw) then
			v+=1
		end if
	
		'' top right
		if (x+pw)>=x1 and (x+pw)<=(x1+bw) then
			v+=2
		end if
	end if
	
	if (y+ph)>=y1 and (y+ph)<=(y1+bh) then
		'' bottom left
		if x>=x1 and x<=(x1+bw) then
			v+=4
		end if
	
		''bottom right
		if (x+pw)>=x1 and (x+pw)<=(x1+bw) then
			v+=8
		end if
	end if

	return v
end function

