'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================
''
'' Long ago programs lived in harmony
'' Small and efficient
'' They worked together
'' Eager to help mankind
'' (programs skipping)
''  
'' Later, newer programs started to appear
'' Large and bloated
'' Unstable and corrupt
'' They were not here to help
'' (bulky programs)
''
'' These new programs were waiting
'' Wanting only one thing
'' To escape!
'' (bulky programs - sinister looking / lightning in background)
''
'' Meanwhile, in the real world...
'' A lighning bolt strikes Professor
'' White's house...
'' 
'' ...and zaps the router! Freeing all
'' the programs from all the connected
'' devices!
''
'' Fortunatly he gives you a device
'' which will allow you to return these
'' programs to their devices, then
'' go into the device to cure them!
''

#include "bmp.bi"
#include "header.bi"

declare sub wait_space()


dim shared scene_one((40*30)*5) as ubyte	'' Basemap 20*15
dim shared scene_two((40*30)*4) as ubyte	'' Basemap 20*15
dim shared scene_three((40*30)*6) as ubyte	'' Basemap 20*15
dim shared scene_four((40*30)*6) as ubyte	'' Basemap 20*15

dim shared sprite(15) as any ptr

dim shared mapwidth as integer
dim shared mapheight as integer

sub intro_flip(scene as integer)
	dim as integer i,j,c
	dim as ubyte tmp
	dim temp(mapwidth*mapheight) as ubyte 

	'' copy
	for i=0 to ubound(temp)
		if scene=1 then temp(i)=scene_one(i)
		if scene=2 then temp(i)=scene_two(i)
		if scene=3 then temp(i)=scene_three(i)
		if scene=4 then temp(i)=scene_four(i)
	next i
	
	'' flip row by row..
	c=0
	for j=0 to mapheight-1
		for i=0 to mapwidth-1
			tmp=temp((mapwidth*( (mapheight-1)-j))+i)  '' 32*(31-j)
			
			if scene=1 then scene_one(c+i)=tmp
			if scene=2 then scene_two(c+i)=tmp
			if scene=3 then scene_three(c+i)=tmp
			if scene=4 then scene_four(c+i)=tmp
			
		next i
		c+=mapwidth	''32
	next j
end sub

sub intro_zoom()
	dim as integer i,j

	'' Copy a section of screen
	dim as integer scr(80,60)
	
	for j=0 to 59
		for i=0 to 79
			scr(i,j)=point(i,j)
		next i
	next j
	
	'' Redraw it bigger!
	const as integer sz=8
	
	for j=0 to 59 
		for i=0 to 79
			line(i*sz,j*sz)-((i*sz)+sz-1,(j*sz)+sz-1),scr(i,j),bf
		next i
	next j	
end sub


sub intro_load()
	dim header as bmphdr

	const path as string="gfx\intro\"

	if  Open(path+"1.bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,scene_one()  
	    Close #1     
	              
	    mapwidth=header.w
		mapheight=header.h      
	              
	    intro_flip(1)  
	else
		draw string(8,128),"Could not load intro"
		sleep 100*10 
	end if
	
	if  Open(path+"2.bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,scene_two()  
	    Close #1     
	              
	    mapwidth=header.w
		mapheight=header.h      
	              
	    intro_flip(2)  
	else
		draw string(8,128),"Could not load intro"
		sleep 100*10 
	end if	
	
	if  Open(path+"3.bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,scene_three()  
	    Close #1     
	              
	    mapwidth=header.w
		mapheight=header.h      
	              
	    intro_flip(3)  
	else
		draw string(8,128),"Could not load intro"
		sleep 100*10 
	end if
	
	if  Open(path+"4.bmp" For binary access read As #1)=0 then
		get #1,,header	
		get #1,header.offset+1,scene_four()  
	    Close #1     
	              
	    mapwidth=header.w
		mapheight=header.h      
	              
	    intro_flip(4)  
	else
		draw string(8,128),"Could not load intro"
		sleep 100*10 
	end if
	
	
end sub	        

sub intro_init()

	const path as string="gfx\intro\"
	
	for i as integer=0 to 9
		sprite(i) = ImageCreate( 16, 16,rgb(100,255,100) )
	next i
	
	bload path+"blue.bmp",sprite(0)	
	bload path+"green.bmp",sprite(1)	
	bload path+"yellow.bmp",sprite(2)	
	bload "gfx\common\pascal.bmp",sprite(3)	
	bload "gfx\common\c.bmp",sprite(4)	
	bload "gfx\common\basic.bmp",sprite(5)	
	
	bload "gfx\common\java.bmp",sprite(6)	
	bload "gfx\common\python.bmp",sprite(7)	
	bload "gfx\common\cplus.bmp",sprite(8)	
	
	sprite(10) = ImageCreate( 80, 60,rgb(100,255,100) )
	sprite(11) = ImageCreate( 80, 60,rgb(100,255,100) )
	sprite(12) = ImageCreate( 80, 60,rgb(100,255,100) )
	
	bload path+"4.bmp",sprite(10)
	bload path+"5.bmp",sprite(11)
	bload path+"6.bmp",sprite(12)
	
		
end sub


sub intro_window(x as integer,y as integer,w as integer,h as integer)
	dim as integer i,j
	dim as uinteger t,r,g,b
	
	for j=y to y+h
		for i=x to x+w
			t=point(i,j)
			r=(t and &H00ff0000) shr 16
			g=(t and &H0000ff00) shr 8
			b=(t and &H000000ff) 
			
			r=r shr 1
			g=g shr 1
			b=b shr 1
			
			pset(i,j),rgb(r,g,b)
			'pset(i,y+j),rgb(255,255,255)
		next i
	next j
end sub


sub intro_part1(f as integer)
	dim as string txt(3)

	txt(0)="Long ago, programs lived in harmony"
	txt(1)="Small and efficient"
	txt(2)="They worked together"
	txt(3)="Eager to help mankind"

	dim as integer i,j,c=0
	
	c=f*(40*30)
	
	for j=0 to 29
		for i=0 to 39
			put (i*16,j*16),sprite(scene_one(c)),trans
			c=c+1
		next i
	next j

	intro_window(24,24,300,80)

	color rgb(255,255,255)
	for i=0 to ubound(txt)
		if txt(i)="" then exit for
		draw string(32,32+(i*16)),txt(i)
	next i

end sub

sub intro_part2(f as integer)
	dim as string txt(3)

	txt(0)="Later, newer programs started to appear"
	txt(1)="Large and bloated"
	txt(2)="Unstable and corrupt"
	txt(3)="They were NOT here to help"

	dim as integer i,j,c=0
	
	c=f*(40*30)
	
	for j=0 to 29
		for i=0 to 39
			put (i*16,j*16),sprite(scene_two(c)),trans
			c=c+1
		next i
	next j
		
	intro_window(24,24,340,80)
	
	color rgb(255,255,255)
	for i=0 to ubound(txt)
		if txt(i)="" then exit for
		draw string(32,32+(i*16)),txt(i)
	next i

end sub


sub intro_part3(f as integer)
	dim as string txt(2)

	txt(0)="These new programs were waiting"
	txt(1)="Wanting only one thing"
	txt(2)="To escape!"

	dim as integer i,j,c=0
	
	c=f*(40*30)
	
	for j=0 to 29
		for i=0 to 39
			put (i*16,j*16),sprite(scene_three(c)),trans
			c=c+1
		next i
	next j
		
	intro_window(24,24,340,80)
	
	color rgb(255,255,255)
	for i=0 to ubound(txt)
		if txt(i)="" then exit for
		draw string(32,32+(i*16)),txt(i)
	next i

end sub

sub intro_part4()
	dim as string txt(2)
	txt(0)="Meanwhile, in the real world..."
	txt(1)="A lightning bolt strikes Professor"
	txt(2)="White's house..."

	put (0,0),sprite(10),pset
	intro_zoom()
	
	intro_window(24,24,340,80)
	
	color rgb(255,255,255)
	for i as integer=0 to ubound(txt)
		draw string(32,32+(i*16)),txt(i)
	next i
end sub



sub intro_part5()
	dim as string txt(2)
	txt(0)="...and zaps the router! Freeing the"
	txt(1)="programs from all of the connected"
	txt(2)="devices!"

	put (0,0),sprite(11),pset
	intro_zoom()
	
	intro_window(24,24,340,80)
	
	color rgb(255,255,255)
	for i as integer=0 to ubound(txt)
		draw string(32,32+(i*16)),txt(i)
	next i
end sub

sub intro_part6()
	dim as string txt(3)
	txt(0)="Fortunately Prof White gives you a device"
	txt(1)="which will allow you to return these"
	txt(2)="programs to their devices, then go"
	txt(3)="into the device and cure them!"

	put (0,0),sprite(12),pset
	intro_zoom()
	
	intro_window(24,24,340,80)
	
	color rgb(255,255,255)
	for i as integer=0 to ubound(txt)
		draw string(32,32+(i*16)),txt(i)
	next i
end sub



sub intro_run()
	dim as boolean spacedown=false
	dim as integer ext=0
	dim as integer frame=0,fc,maxframe
	dim as boolean showframe=true
	
	dim as integer res,mx,my,mb
	dim as boolean mouse_down=false
	
	const as string txt="< Space / Click to Continue >" 
	
	dim as integer cx
	cx=(640-(len(txt)*8))/2
	
	for scene as integer=1 to 6
		showframe=true
		spacedown=false
		ext=0
		frame=0
		fc=0
		if scene=1 then maxframe=4	'' 0 - 4
		if scene=2 then maxframe=3	'' 0 - 3
		if scene=3 then maxframe=5 
	
		do
			'' Only draw if the frame has changed
			if showframe=true then
				showframe=false
				
				screenlock
					cls 0
					'' Animated
					if scene=1 then intro_part1(frame)
					if scene=2 then intro_part2(frame)
					if scene=3 then intro_part3(frame)
					'' Static
					if scene=4 then intro_part4()
					if scene=5 then intro_part5()
					if scene=6 then intro_part6()
					
					color rgb(0,0,0)
					draw string (cx+1,480-16+1),txt
					
					color rgb(255,255,255)
					draw string (cx,480-16),txt
					
				screenunlock
				
			end if
			
			if (scene>=1) and (scene<=3) then
				if MultiKey(SC_SPACE)=true then spacedown=true
				
				if spacedown=true then
					if MultiKey(SC_SPACE)=false then
						ext=1
						'exit for
					end if
				end if
			
				'' Mouseclick (exit on up)
				res = GetMouse (mx,my,,mb)
				if res=0 then
					select case as const mb
					case 0
						if mouse_down=true then 
							mouse_down=false
							ext=1
						end if
					case 1
						if mouse_down=false then mouse_down=true
					end select
				end if
			
			
				fc+=1
				if fc=10 then
					fc=0	
					frame+=1
					if frame>maxframe then frame=0
					showframe=true
				end if
			else
				wait_space()
				ext=1
			end if 
			
			'' Longer sleep causes problems picking up space bar
			sleep 10,1
	
			if ext=1 then exit do
		loop while true
		
		While Inkey <> "": Wend
	
	next scene
	
end sub


