'' FBGD 2018 Entry
'' by ssjx (November 2018) [http://ssjx.co.uk]
'' ==============================================================
''
''

declare function shot_hit(tx as integer,ty as integer,owner as integer) as integer
declare sub shot_add(as integer,as integer, as integer)

dim shared basebug(63) as byte=>{_
0,0,0,1,1,0,0,0,_
0,0,1,1,1,1,0,0,_
0,1,1,1,1,1,1,0,_
1,1,0,1,1,0,1,1,_
1,1,1,1,1,1,1,1,_
0,1,0,1,1,0,1,0,_
1,0,0,0,0,0,0,1,_
0,1,0,0,0,0,1,0}

dim shared applebug(63) as byte=>{_
0,0,0,0,1,0,0,0,_
0,0,0,1,0,0,0,0,_
0,1,1,0,1,1,0,0,_
1,1,1,1,1,1,1,0,_
1,1,1,1,1,1,0,0,_
1,1,1,1,1,1,1,0,_
0,1,1,1,1,1,0,0,_
0,0,1,0,1,0,0,0}

dim shared msbug(63) as byte=>{_
0,0,0,0,0,0,0,0,_
1,1,1,0,1,1,1,0,_
1,1,1,0,1,1,1,0,_
1,1,1,0,1,1,1,0,_
0,0,0,1,0,0,0,0,_
1,1,1,0,1,1,1,0,_
1,1,1,0,1,1,1,0,_
1,1,1,0,1,1,1,0}


''
dim shared as byte bug(63)

dim shared spriteno(4) as any ptr

const as integer bugsize=8
 
sub bug_init()
	const path="gfx\common\"
	
	for i as integer=0 to ubound(spriteno)
		spriteno(i) = ImageCreate( 16, 16,rgb(0,110,0) )
	next i
	''
	bload path+"cplus_hard.bmp",spriteno(1)
	bload path+"cplus.bmp",spriteno(2)
	bload path+"freebasic.bmp",spriteno(3)
	bload path+"java.bmp",spriteno(4)
	
end sub

sub bug_reset(lev as integer)

		for c as integer=0 to ubound(basebug)
			if lev=1 or lev=4 then bug(c)=basebug(c)
			if lev=2 or lev=5 then bug(c)=applebug(c)
			if lev=3 or lev=6 then bug(c)=msbug(c)
		next c	
	
	'' Bug defaults to hard(1) so make it softer(2) for lower levels
	if lev<=3 then
		for c as integer=0 to ubound(bug)
			if bug(c)=1 then bug(c)=2
		next c
	end if
end sub

sub bug_cheat()
	for c as integer=0 to ubound(bug)
		if bug(c)<>0 then bug(c)=3
	next c
end sub

function bug_isclean() as boolean

	for c as integer=0 to ubound(bug)
		if bug(c)=1 or bug(c)=2 then return false
	next c

	'' Back to completed
	'for c as integer=0 to ubound(bug)
	'	if bug(c)=1 then bug(c)=2
	'next c
	
	return true
end function

sub bug_draw(px as integer,py as integer)
	dim as integer i,j,c=0
	dim as integer ax,ay

	c=0
	ay=py
	for j=0 to bugsize-1
		ax=px
		for i=0 to bugsize-1
			
			select case as const bug(c)
			case 1 
				'' Hard C++ segment
				put (ax,ay),spriteno(1),trans
				'' Has shot hit invader segment?
				if shot_hit(ax,ay,1) then bug(c)=2	
				
			case 2
				'' C++ segment
				put (ax,ay),spriteno(2),trans
				'' Has shot hit invader segment?
				if shot_hit(ax,ay,1) then bug(c)=3	
			
			case 4
				'' Java segment
				put (ax,ay),spriteno(4),trans
				'' Has shot hit invader segment?
				if shot_hit(ax,ay,1) then bug(c)=3	
			
			case 3
				'' 	FB segment
				put (ax,ay),spriteno(3),trans
			end select
			
			ax+=16
			c+=1
		next i
		ay+=16
	next j
	
end sub


function collide(x as integer,y as integer,x1 as integer,y1 as integer) as integer
	dim as integer v=0
	const as integer pw=32,ph=16
	const as integer ww=16,wh=16
	
	if y>=y1 and y<=(y1+wh) then
		'' top left
		if x>=x1 and x<=(x1+ww) then
			v+=1
		end if
	
		'' top right
		if (x+pw)>=x1 and (x+pw)<=(x1+ww) then
			v+=2
		end if
	end if
	
	if (y+ph)>=y1 and (y+ph)<=(y1+wh) then
		'' bottom left
		if x>=x1 and x<=(x1+ww) then
			v+=4
		end if
	
		''bottom right
		if (x+pw)>=x1 and (x+pw)<=(x1+ww) then
			v+=8
		end if
	end if
	return v
end function


function bug_hitplayer(bugx as integer,bugy as integer, px as integer,py as integer) as boolean

	dim as integer i,j,c=0
	dim as integer ax,ay
	
	ay=bugy
	for j=0 to bugsize-1
		ax=bugx
		for i=0 to bugsize-1
			select case as const bug(c)
			case 1 
				if collide(px,py,ax,ay)>0 then return true
			case 2
				if collide(px,py,ax,ay)>0 then return true
			case 3
				'' 	FB segment
			case 4
				if collide(px,py,ax,ay)>0 then return true
				
			end select
			
			ax+=16
			c+=1
		next i
		ay+=16
	next j
	
	return false
end function

function fire_point() as integer
	dim as integer lst(255)					
	dim as integer c,sht=-1
	
	'' Bad parts of bug
	for c=0 to ubound(bug)
		if bug(c)=1 or bug(c)=2  then lst(c)=c else lst(c)=-1
	next c
		
	'' Jumble
	dim as integer ta,tb,tmp
	for c=0 to 500
		ta=int(rnd*256)
		tb=int(rnd*256)
		tmp=lst(ta)
		lst(ta)=lst(tb)
		lst(tb)=tmp
	next c
	
	'' Select first shot to fire from
	for c=0 to ubound(lst)
		if lst(c)>-1 then 
			sht=lst(c) 
			exit for
		end if
	next 
	
	return sht
end function

sub bug_shoot(px as integer,py as integer)
	dim as integer sht
	sht=fire_point()
			
	'' Need to get x/y for shot
	if sht>-1 then
		dim as integer i,j,c=0
		for j=0 to bugsize-1
			for i=0 to bugsize-1
				if c=sht then
					shot_add(px+(i*16)+4,py+(j*16)+4,2)
					return
				end if
				c=c+1
			next i
		next j
	end if
			
end sub


