''
'' Invader Rescue by ssjx
''
''
''
'' Level plan
'' 1 = 10 drones 2 paddle
'' 2 = 15 drones 3 paddles
'' 4 = 10 drone 1 turret
'' 5 = 10 drones 1 turret 1 paddle
'' 6 = 15 drones 1 turret 2 paddle
'' 7 = 20 drone 1 turret 3 paddles
''

#include "header.bi"
#include "fmod.bi"

Const PI As Double = 3.1415926535897932

randomize timer
#define FIRST    33
#define LAST    90

declare sub myprint(as integer, as integer, as string)
declare sub inittable()
declare sub addname(as integer)
declare sub showtable()

'' in explosion.bas
declare sub addexplosion(as integer, as integer, as integer, as integer,  as integer)
declare sub showexplosion()
declare sub clrexplosion()

'const maxexplo as integer =50
Const framerate as integer =60

dim shared stars(100) as xyz

const key_left=24
const key_right=25
const key_up=16
const key_down=30
const key_fire=57
const key_esc=1

const arrow_left=&h4B
const arrow_right=&h4D
const arrow_up=&h48
const arrow_down=&h50


sub screendim(w as integer,h as integer,d as integer)

        dim as uinteger c
        Dim buffer As UByte Ptr = ScreenPtr()    
      
        ScreenLock()
        
                for c=0 to (w*h*d)    
                buffer[c]=(buffer[c] and &hff) shr 1
                next c
      
        ScreenUnlock()
	             
end sub

''
''
''

sub clr(w as integer,h as integer,d as integer,s as integer)
	cls
	dim as integer i

''
''
for i=0 to 100
with stars(i)
color rgb(255-.z,255-.z,0)
pset (.x,.y)
end with
next i
''
	for i=0 to 40 
	
	Select Case As Const s
	Case 0
		'' Green
		color rgb(0,255-(i*5),0)
		
	case 1	
		'' Yellow 
		color rgb(255-(i*5),255-(i*5),0)
	case 2
		'' Red	
		color rgb(255-(i*5),0,0)
	end select


	'' Draw Ground
	
	line (0,h-40+i)-(w,h-40+i)
	
	'' draw top of screen
	''if (i<20) then line (0,0+i)-(w,0+i),rgb(0,0,255-(i*11))

	next i
end sub

''
'' Main program
''
dim as integer px,py,pxdir,pydir,i,j, x,y,c,quit,alt,ct,e,f,ext
dim as integer score,level,scene
dim as integer barrier,floor,paddles,turret,gravity
dim as integer drones,pdrone,saved,hit,tdrones,mxdrones
dim nmeshot(MAXEXPLO) as coord
dim playershot(20) as coord
dim nmepaddle(20) as coord
dim rescue(20)as coord '' positions of the downed invaders



common shared explosion() as expo
dim explosion(MAXEXPLO) as expo

dim  as rect gate,introgate
''
dim as cannon ball(20)
dim as double cdeg
''
dim as string info,levelname(5),txt(20),key
dim as integer infocount

'' Timer related
Dim As Double now
Dim As Double oneFrame
oneFrame = 1/framerate '1/?th of a second

'' Fonts..
Dim As UByte Ptr p, myFont
Dim As Single w
Dim As Integer value


'' Get screen info
dim as integer swidth,sheight,sdepth
screen 18,24,2 '',&h01
screenset 1, 0
screeninfo swidth,sheight,sdepth

''
'' Sound..
''
FSOUND_Init(11025, 8, 0) 

Dim sample(10) As Integer
for i=0 to 8
	sample(i) = FSOUND_Sample_Load(FSOUND_FREE,"wav\"+str(i)+".wav", FSOUND_HW3D, 0, 0) 
next i

''
'' Load the graphics bitmap
''
dim as ubyte map(128,64),a,b
common shared sprite() as any ptr
Dim shared As Any Ptr sprite(128)
 
if  Open("graphics\graphics.bmp" For binary As #1)=0 then

	seek 1,1079 ''skip the header as we know the size already
	for j=63 to 0 step -1
		for i=0 to 127        
                	get #1, ,map(i,j)			
		next i
	next j
	        
        Close #1     
end if

''
''  bitmap (to check it's loaded properly)
''
'	for j=0 to 63
'		for i=0 to 127        
'		
       ''  	if map(i,j)=253 then 
'		 	pset (10+i,400+j),rgb(255,0,255)
'		else
'		
''	  		pset (10+i,400+j),rgb(255,255,255)
'		end if	
'		next i
'	next j
'screencopy
'sleep

''
'' Create our sprites
''
for c=0 to 128
sprite(c) = ImageCreate( 16, 16,rgb(255,0,255) )
next c

c=0
for y=0 to 7
for x=0 to 15
	for j=0 to 7
	
		for i=0 to 7        
         	if map((x*8)+i,(y*8)+j)=255 then
			if c<32 then color rgb(255,255,255) '' invaders
			if c>32 and c<=47 then color rgb(255-(j*30),255-(j*30),0)  ''letters
		
			if c>47 and c<63 then color rgb(255-(j*30),0,0) ''numbers
			if c>64 then color rgb(255-(j*30),255-(j*30),0)  ''letters
			
			if c=15 or c=31 then color rgb(0,255,255) '' barrier
			
			line sprite(c),((i*2),(j*2))-((i*2)+1,(j*2)+1),,bf 	
		end if
		 			
		next i
	next j
	
	c=c+1
next x
next y 

'' turn the first (empty) sprite to solid block
color rgb(255,255,255)
line  sprite(0),(0,0)-(15,15),,bf

''

'' Display all sprites (to check)   
''c=0
'for y=0 to 15
'for x=0 to 7   
'put (x*24,y*24),sprite(c),TRANS
'c=c+1
'next x
'next y

''
'' Set up our font... (pretty much just pasted from the wiki-manual...)
''
dim as integer fontwidth
fontwidth=16
c=33
myFont = ImageCreate((LAST - FIRST + 1) * fontwidth, fontwidth+1)
p = myFont + IIf(myFont[0] = 7, 32, 4)
p[0] = 0
p[1] = FIRST
p[2] = LAST
For i = FIRST To LAST
    ' Here we could define a custom width for each letter, but for simplicity we use
    ' a fixed width of 8 since we are reusing the default font glyphs
    p[3 + i - FIRST] = fontwidth
    ' Create character onto custom font buffer by drawing using default font
    put myfont,((i - FIRST) * fontwidth,1),sprite(c),TRANS
    c=c+1
Next i
''
''
''
for i=0 to 100
	stars(i).x=int(rnd*swidth)
	stars(i).y=int(rnd*sheight)
	stars(i).z=int(rnd*255)
next i

''
'' set up hi score table
inittable()

do
''
'' Title Screen
''

txt(0)=TITLE
txt(1)=VERSION
txt(2)="by ssjx"
txt(3)=""
txt(4)="Controls"
txt(5)="QAOP/Arrows - Move Ship"
txt(6)="Space - Drop/Fire"
txt(7)=""
txt(8)="Press [H] to view hi-scores"
txt(9)="Press [Space] to Start"
txt(10)="Press [Escape] to Quit"
txt(11)="FREEBASIC COMPETITON"

px=64
py=64

pxdir=1
pydir=1
do
	do
	FSOUND_Update
	now = Timer
	clr(swidth,sheight,sdepth,1)
	
	for j=0 to 7
	for i=0 to 7
	if map((8+i),j)=255 then put ((i*32)+px,(j*32)+py),sprite(1),alpha,50
	next i
	next j
	
	
	for i=0 to 12
		myprint( (swidth/2)-(len(txt(i))*8),40+(i*32),txt(i)  )
	next i
	

	key=inkey
	
	'' bouncey giant invader!
	px+=pxdir
	py+=pydir
	
	if (px+(32*7)+16>=swidth) or (px<0) then
		pxdir*=-1
		FSOUND_PlaySound(FSOUND_FREE, sample(6))
	end if
	
	if (py+(32*7)+16>=(sheight-40)) or (py<0) then
		pydir*=-1
	 	FSOUND_PlaySound(FSOUND_FREE, sample(7))
	end if
	screencopy
	if Timer < (now + oneFrame) Then Sleep ((now + oneFrame) - Timer) * 1000

	loop while key=""

	if multikey(key_esc) then
		FSOUND_Close
		end
	end if

	if ucase(key)="H" then
		showtable()
	end if
	


loop until key=" "
''
''



level=3
score=0
hit=100

''
'' Main game loop
''

do

for i=0 to 20
	txt(i)=""
	rescue(i).active=0
next i




ext=0
''
'' Set up the the level
''
gravity=0
'' Player start position
px=128
py=128
'' ground level
barrier=0
floor=(sheight-40)
	
Select Case As Const level
Case 0
	'' Gate Position
	levelname(0)="A SIMPLE DROP AND PICKUP!"
	gate.startx=swidth/2
	gate.starty=50
	
	'' Background
	scene=0
	
	'' Invader ships to be rescued
	for c=6 to 15
	with rescue(c) 
	.active=1
	.x=c*30
	.y=424
	.sx=.x
	.sy=.y
	end with
	next c
		
	'' Set up paddle start positions
	paddles=1
	turret=0
	
	'' Witty level comment
	info="HELP THE INVASION! RECOVER THE DRONES!!"
	
case 1
	'' Gate Position
	levelname(0)="double trouble on the moon"
	gate.startx=swidth/2
	gate.starty=50
	
	'' Background
	scene=1
	
	'' Invader ships to be rescued
	for c=6 to 15
	with rescue(c) 
	.active=1
	.x=c*30
	.y=424
	.sx=.x
	.sy=.y
	end with
	next c
		
	'' Set up paddle start positions
	paddles=2
	turret=0

	
	'' Witty level comment
	info="rescue drones hidden on earths moon!"

case 2
	'' Gate Position
	levelname(0)="triple threat!"
	gate.startx=swidth/2
	gate.starty=50
	
	'' Background
	scene=1
	
	'' Invader ships to be rescued
	for c=5 to 16
	with rescue(c) 
	.active=1
	.x=c*30
	.y=424
	.sx=.x
	.sy=.y
	end with
	next c
		
	'' Set up paddle start positions
	paddles=3
	turret=0

	
	'' Witty level comment
	info="rescue drones hidden on earths moon!"
		
case 3

	'' Gate Position
	levelname(0)="earths new weapon"
	gate.startx=swidth/2
	gate.starty=50
	
	'' Background
	scene=0
	
	'' Invader ships to be rescued
	for c=1 to 20
	with rescue(c) 
	.active=1
	.x=c*30
	.y=424
	.sx=.x
	.sy=.y
	end with
	next c
	
	for c=6 to 15
	rescue(c).active=0
	next c
		
	'' Set up paddle start positions
	paddles=0
	turret=1
	
	'' Witty level comment
	info="watch out for that cannon!"
	
case 4	
	'' Gate Position
	levelname(0)="mars attacks!"
	gate.startx=swidth/2
	gate.starty=50
	
	'' Background
	scene=2
	
	'' Invader ships to be rescued
	for c=1 to 20
	with rescue(c) 
	.active=1
	.x=c*30
	.y=424
	.sx=.x
	.sy=.y
	end with
	next c
	
	for c=6 to 15
	rescue(c).active=0
	next c
		
	'' Set up paddle start positions
	paddles=1
	turret=1
	
	'' Witty level comment
	info=""	

case 5	
	'' Gate Position
	levelname(0)="low warp gate"
	gate.startx=swidth/2
	gate.starty=200
	
	'' Background
	scene=2
	
	'' Invader ships to be rescued
	for c=1 to 20
	with rescue(c) 
	.active=1
	.x=c*30
	.y=424
	.sx=.x
	.sy=.y
	end with
	next c
	
	for c=6 to 15
	rescue(c).active=0
	next c
		
	
	'' Set up paddle start positions
	paddles=1
	turret=1
	
	'' Witty level comment
	info="shield restored to full strength!"
	hit=100		

case 6	
	'' Gate Position
	levelname(0)="back to earth"
	gate.startx=swidth/2
	gate.starty=100
	
	'' Background
	scene=0
	gravity=1
	
	'' Invader ships to be rescued
	for c=1 to 20
	with rescue(c) 
	.active=1
	.x=c*30
	.y=424
	.sx=.x
	.sy=.y
	end with
	next c
	
	for c=7 to 14
	rescue(c).active=0
	next c
		
	'' Set up paddle start positions
	paddles=0
	turret=1
	
	'' Witty level comment
	info="anti-grav malfunction!"	
	
case 7	
	'' Gate Position
	levelname(0)="more drones more trouble"
	gate.startx=swidth/2
	gate.starty=100
	
	'' Background
	scene=0
	gravity=1
	
	'' Invader ships to be rescued
	for c=1 to 20
	with rescue(c) 
	.active=1
	.x=c*30
	.y=424
	.sx=.x
	.sy=.y
	end with
	next c
	
	for c=7 to 14
	rescue(c).active=0
	next c
		
	'' Set up paddle start positions
	paddles=1
	turret=1
	
	'' Witty level comment
	info="anti-grav malfunction!"		

case 8	
	'' Gate Position
	levelname(0)="even more drones"
	gate.startx=swidth/2
	gate.starty=100
	
	'' Background
	scene=0
	gravity=1
	
	'' Invader ships to be rescued
	for c=1 to 20
	with rescue(c) 
	.active=1
	.x=c*30
	.y=424
	.sx=.x
	.sy=.y
	end with
	next c
	
	for c=8 to 13
	rescue(c).active=0
	next c
		
	'' Set up paddle start positions
	paddles=2
	turret=1
	
	'' Witty level comment
	info="anti-grav malfunction!"		

case 9	
	'' Gate Position
	levelname(0)="chaos!"
	gate.startx=swidth/2
	gate.starty=100
	
	'' Background
	scene=0
	gravity=1
	
	'' Invader ships to be rescued
	for c=1 to 20
	with rescue(c) 
	.active=1
	.x=c*30
	.y=424
	.sx=.x
	.sy=.y
	end with
	next c
	
	for c=9 to 12
	rescue(c).active=0
	next c
		
	'' Set up paddle start positions
	paddles=3
	turret=1
	
	'' Witty level comment
	info="anti-grav malfunction!"
		
	
end select


	for i=1 to paddles
		with nmepaddle(i)
		.x=16*int(rnd*40)
		.y=400-(i*16)
		if (int(rnd(10))<5) then .xdir=-1 else .xdir=1
		end with
	next i

with gate	
	.x=.startx
	.y=.starty
	.w=50	
	.h=50
	for i=0 to 100
	.particle(i)=180+int(rnd*180)
	.dist(i)=int(rnd*(sheight/2))
	next i
end with

''
''
''

with introgate
	.startx=swidth/2
	.starty=sheight/2	
	.w=sheight/2
	.h=sheight/2
	for i=0 to 100
	.particle(i)=180+int(rnd*180)
	.dist(i)=int(rnd*(sheight/2))
	next i
end with

''
'' Get ready screen
''
txt(0)="LEVEL "+str(level+1)
txt(2)=levelname(0)
txt(4)="GET READY!"

txt(6)="PRESS SPACE TO START"

do
	now = Timer
	''clr(swidth,sheight,sdepth)
	cls 
		with introgate
	            	for f=1 to 50
	            	
	            		.dist(f)+=1                   	
		        	if .dist(f)>=.w then .dist(f)=0
	            
	                    	.x=.startx+(cos(.particle(f))*.dist(f))
	            	        .y=.starty+(sin(.particle(f))*.dist(f))
	                            	                                  
	                          pset(.x,.y),rgb(255,255,0)   
	                                                                                                                    
	                next f
		        
		end with
			
	for i=0 to 7
		myprint( (swidth/2)-(len(txt(i))*8),180+(i*16),txt(i)  )
	next i

	if Timer < (now + oneFrame) Then Sleep ((now + oneFrame) - Timer) * 1000

	screencopy
loop while inkey<>" "

''
'' Set up shot starting places
''

for i=0 to 20
	nmeshot(i).active=0
	playershot(i).active=0
next i

''
''
'' Set all explosion inactive
''

clrexplosion()

'' Count how many drones need saving (if any....)
mxdrones=0
for i=1 to 20
if rescue(i).active=1 then mxdrones+=1
next i
tdrones=mxdrones

''
'' Reset variables 
''
saved=0
quit=0
alt=0
ct=0
infocount=(framerate*5)

do
	FSOUND_Update
	clr(swidth,sheight,sdepth,scene)
	
	'' crosshairs (to make sure everything is centered)
	'color rgb(100,100,100)
	'line(0,0)-(swidth,sheight)
	'line(swidth,0)-(0,sheight)
	
	now = Timer
	
	if (MultiKey(key_right) or MultiKey(arrow_right)) and (px+32)<swidth then px+=2
	if (MultiKey(key_left) or MultiKey(arrow_left)) and (px-2)>=0then px-=2
	if (MultiKey(key_up) or MultiKey(arrow_up)) and (py>16) then py-=2
	if (MultiKey(key_down) or MultiKey(arrow_down)) and (py+16)<floor then py+=2
	if MultiKey(key_fire) then
		''drop a carried drone
		if drones=1 then
			
			FSOUND_PlaySound(FSOUND_FREE, sample(1))
			drones=0
			rescue(pdrone).active=3
			info="DRONE "+str(pdrone)+" DROPPED!!"
			infocount=(framerate*5)
		
		'else
		'	for c=1 to 1	
		'		with playershot(c)
		'			if .active=0 then
		'			.x=px
		'			.y=py
		'			.ydir=1
		'			.xdir=0
		'			.active=1
		'			.speed=2	
		'			FSOUND_PlaySound(FSOUND_FREE, sample(1))
		'			exit for
		'			end if
		'		end with
		'	next c
		end if
	end if
	
	if MultiKey(key_esc) then quit=1
	
	While Inkey <> "": Wend
	
	'' Draw warp gate

	with gate
              ''  circle (.startx+.w/2,.starty+.w/2),.w/2,rgb(0,0,255),,,,f
	''	circle (.startx+.w/2,.starty+.w/2),.w/2,rgb(0,0,255)

            	for f=1 to 50
            	if ct and 1 then
            		.dist(f)-=1                   	
	        	if .dist(f)<=0 then .dist(f)=.w/2
            	end if
                    	.x=(.startx+.w/2)+(cos(.particle(f))*.dist(f))
            	        .y=(.starty+.h/2)+(sin(.particle(f))*.dist(f))
                            	                                  
                        ''  pset(.x,.y),rgb(155-f,155-f,0)
			 pset(.x,.y),rgb(0,255-f,255-f)   
                       '' if .dist(f)>100 then .dist(f)=0
                                                                                                                    
                next f
''	line (.startx,.starty)-(.startx+.w,.starty+.h),rgb(255,255,255)

	end with

	'' invader mothership
	put (px,py),sprite(6),TRANS
	put (px+16,py),sprite(7),TRANS
		

	''invaders
	for c=1 to 20
	with rescue(c)
	
	if .active>0 then put (.x,.y),sprite(1+(16*alt)),TRANS
	if .active=1 then
		''number below if parked
		myprint(.x,.y+18,str(c)) 
	end if	
	
	end with
	next c
	
	if barrier=1 then
		'' barrier
		for c=0 to 39 
			put (c*16,sheight-100),sprite(15+(16*alt)),TRANS
		next c
		
		'' barrier generator
		for c=0 to 2 
			put (swidth-48+(c*16),sheight-40-32),sprite(11+c),TRANS
			put (swidth-48+(c*16),sheight-40-16),sprite(27+c),TRANS
		next c
	
	end if
	

	
	'' display shots
	for i=1 to 20
		with nmeshot(i)
			.x+=(.xdir*.speed)
			.y+=(.ydir*.speed)
			
			if .x<0 or .x>swidth then .active=0
			if .y<0 then .active=0 
		
			if .active=1 then
			put (.x,.y),sprite(24),TRANS
			pset (.x+8,.y+8),rgb(255,0,0)
			end if
		end with
		
		with playershot(i)
			.x+=(.xdir*.speed)
			.y+=(.ydir*.speed)
			
			if .x<0 or .x>swidth then .active=0
			if .y>440 then .active=0 
			
			if .active=1 then
			put (.x,.y),sprite(25),TRANS
			end if
		end with
		
	next i
	
	'' move paddles
	for i=1 to paddles
		with nmepaddle(i)
			'' enemy paddle thing
			put (.x,.y),sprite(22),TRANS
			put (.x+16,.y),sprite(23),TRANS
			
			.x=.x+.xdir
			if (.x+32)>=swidth and .xdir=1 then .xdir=-1
			if (.x)<=0 and .xdir=-1 then .xdir=1
			
			if int(rnd*100)>90 then
				if .x>(swidth/2)-30 and .x<(swidth/2)+30 then 
				.xdir*=-1
				end if
			end if 
			
		end with
			'' enemy firing
			if int(rnd*10)>6 then
				for c=1 to 20
					with nmeshot(c)
						if .active=0 then
						.x=nmepaddle(i).x
						.y=nmepaddle(i).y
						.ydir=-1
						.xdir=0
						.active=1
						.speed=alt+1
						FSOUND_PlaySound(FSOUND_FREE, sample(3))
						exit for
						end if
					end with
				next c
			end if
	
	next i
	''
	'' Collision (enemy hitting player) 
	''
		for c=1 to 20
			with nmeshot(c)
				if .active=1 then
					pset (.x+8,.y+8),rgb(255,0,0)
					if (.x+8>px and .x+8<px+32) then
					if (.y+8>py and .y+8<py+16) then
					.active=0 '' turn off the shot
					hit-=10
					''set explosion
					FSOUND_PlaySound(FSOUND_FREE, sample(2))
					addexplosion(.x+8,.y+8,255,255,0)
					
					end if
					end if
				end if
			end with
		next c
	''
	'' Check for hit on drone
	'' (only check if we actually have a drone towing...)	
	''if drones=1 then 
	for i=1 to 20	
	if rescue(i).active>1 then
		for c=1 to 20
			with nmeshot(c)
				if .active=1 then
					''pset (.x+8,.y+8),rgb(255,0,0)
					if (.x+8>rescue(i).x and .x+8<rescue(i).x+16) then
						if (.y+8>rescue(i).y and .y+8<rescue(i).y+16) then
						.active=0 '' turn off the shot
						rescue(i).active=0
						drones=0
						tdrones-=1
						FSOUND_PlaySound(FSOUND_FREE, sample(2))
						info="DRONE "+str(i)+" DESTROYED!!"
						infocount=(framerate*5)
						''set explosion
						addexplosion(rescue(i).x+8,rescue(i).y+8,0,255,0)
						exit for					
						end if
					end if
					
				end if
			end with
		next c
	end if
	next i
	
	''
	'' Canon
	''
	''Centre turret
	if turret=1 then
		'cdeg=0
		cdeg=atan2(440-py-8,px-(swidth/2)+16)
		
		color rgb(255,0,0)
		line ((swidth/2),440)-((swidth/2)+(cos(cdeg)*50) ,440-(sin(cdeg)*50))
		if (rnd*100)>95 then
		for i=0 to 10
			with ball(i)
			if .active=0 then
			FSOUND_PlaySound(FSOUND_FREE, sample(3))
			.active=1
			.deg=cdeg
			.dist=50
			exit for
			end if
			end with
		next i	
		end if
		
		''
		'' Draw shots
		for i=0 to 10
		with ball(i)
			if .active=1 then
			.dist+=2
			.x=(swidth/2)+(cos(.deg)*.dist)
			.y=440-(sin(.deg)*.dist)
			
			pset (.x,.y),rgb(255,255,0)
			pset (.x+1,.y),rgb(255,255,0)
			pset (.x,.y+1),rgb(255,255,0)
			pset (.x+1,.y+1),rgb(255,255,0)
			
			
			if (.x<0 or .x>swidth) then .active=0
			if (.y<0 or .y>440) then .active=0
			
			
			''
			'' hit ship
				if (.x>px and .x<px+32) then
					if (.y>py and .y<py+16) then
					.active=0 '' turn off the shot
					hit-=5
					''set explosion
					FSOUND_PlaySound(FSOUND_FREE, sample(2))
					addexplosion(.x,.y,255,0,0)
					
					end if
				end if
			
					
	
			for c=1 to 20
				'' 2= airborne drone.. 3=falling
				if rescue(c).active>1 then
					''pset (.x+8,.y+8),rgb(255,0,0)
					if (.x>rescue(c).x and .x<rescue(c).x+16) then
						if (.y>rescue(c).y and .y<rescue(c).y+16) then
						.active=0 '' turn off the shot
						rescue(c).active=0
						drones=0
						tdrones-=1
						FSOUND_PlaySound(FSOUND_FREE, sample(2))
						info="DRONE "+str(c)+" DESTROYED!!"
						infocount=(framerate*5)
						''set explosion
						addexplosion(.x,.y,0,255,0)
						exit for					
						end if
					end if
					
				end if
			
			next c

			''
			''
			
			
			end if
		end with
		next
	end if
	''
	'' drone
	'''
	
	for i=0 to 20
		with rescue(i)
		if drones=0 then
		
		'' Parked or falling drone
		if .active=1 then

				pset (.x+8,.y+8),rgb(255,0,0)
				if (px+16>rescue(i).x and px+16<.x+16) then
				if (py+28>rescue(i).y and py+24<rescue(i).y+16) then
				.active=2 ''drone invader
				drones=1
				pdrone=i
				end if
				end if
		end if
		end if
		
		'' Drone being towed
		if .active=2 then
				.x=px+8
				.y=py+16
				
				if (.x+8)>gate.startx and (.x+8)<gate.startx+gate.w then
				if (.y+8)>gate.starty and (.y+8)<gate.starty+gate.h then
					FSOUND_PlaySound(FSOUND_FREE, sample(0))
					info="DRONE "+str(pdrone)+" RECOVERED!!"
					infocount=(framerate*5)
					.active=0 
					drones=0
					saved+=1
					score+=10
				end if
				end if			
		end if
		
		'' Returing drone (after being dropped)
		if .active=3 then
			if .x>.sx then .x-=1
			if .x<.sx then .x+=1
			if .y>.sy then .y-=1
			if .y<.sy then .y+=1
			
			if .x=.sx and .y=.sy then .active=1	
							
		end if
		
		end with
		
	next i
	
	''	
	'' explosions  
	''  
	
	showexplosion()
	 	
	''
	'' alternate sprites
	''
	
	if ct=framerate*2 then
		alt=1-alt
		ct=0
		
	else
		ct+=1		
	end if 

	if gravity=1 then
		if (ct and 1) and ((py+16)<floor) then py+=1
	end if
	''
	''
	''
	
	color rgb(255,0,0)
	
	if hit<0 then hit=0 '' so we don't display a negative hit
	
	myprint(0,0,"SCORE: "+str(score) )
	myprint(220,0,"DRONES: "+str(saved)+"/"+str(tdrones) )
	myprint(440,0,"SHIELDS: "+str(hit) )
	
	if infocount>0 then
		myprint((swidth/2)-(len(info)*8),17,info )
		infocount-=1
	end if
	
	screencopy
	
	if Timer < (now + oneFrame) Then Sleep ((now + oneFrame) - Timer) * 1000
	
	
	if quit=1 then ext=1
	if saved=tdrones then ext=2
	if hit<=0 then ext=3
	
	
loop while (ext=0)

for i=0 to 10
txt(i)=""
next i

if ext=2 then
	if (saved>int(mxdrones/2)) then
	
		if saved=tdrones then
		
			level+=1
			
			if saved=mxdrones then
				txt(0)="EXCELLENT WORK!"
				txt(1)="YOU SAVED ALL "+str(mxdrones)+" OF THE DRONES"
				txt(2)="YOU GET 100 BONUS POINTS"
				txt(3)="GET READY FOR LEVEL "+str(level+1)+"!"
				score+=100
			else
				txt(0)="WELL DONE!"
				txt(1)="YOU SAVED "+str(saved)+" OUT OF "+str(mxdrones)+" DRONES"
				txt(3)="GET READY FOR THE NEXT LEVEL!"
			end if
			
			if level=MAXLEVELS then
				txt(3)="YOU HAVE COMPLETED THIS GAME!"
				txt(4)="THE INVASION CAN CONTINUE!"
				txt(5)="THANKS FOR PLAYING!"
			else
				
				
			end if
			
			txt(6)="press space"
			
			for i=0 to 7
				myprint((swidth/2)-(len(txt(i))*8),(sheight/2)-(6*16)+(i*32),txt(i) )
			next i
		end if
	else
		
		txt(0)="YOU DID NOT SAVE ENOUGH DRONES!"
		txt(1)="PRESS SPACE TO RETRY THIS LEVEL"
		txt(2)=""
		txt(3)="GET READY FOR LEVEL "+str(level+1)+"!"
		
		for i=0 to 3
			myprint((swidth/2)-(len(txt(i))*8),(sheight/2)-(6*16)+(i*32),txt(i) )
		next i
	
			
	end if
	''
	hit+=10
	if hit>100 then hit=100
	
	screencopy	
	do
	sleep 1
	loop until inkey=" "
	
end if



loop until hit=0 or quit=1 or level=MAXLEVELS

	if hit=0 or quit=1 then
		txt(0)="GAME OVER"
		txt(2)="SCORE "+str(score)
		txt(3)="press space"
			
		if hit=0 then
			txt(1)="YOUR SHIP WAS DESTROYED"
		end if
		
		if quit=1 THEN
			txt(1)="PLAYER QUITS"
		end if
	
		for i=0 to 7
			myprint((swidth/2)-(len(txt(i))*8),(sheight/2)-(4*16)+(i*32),txt(i) )
		next i
		''
		screencopy
		do
		sleep 1
		loop until inkey=" "
	end if
	
	addname(score)

loop ''until quit=1
''sleep
