''
'' Infinite Road Racer (2018)
'' v0.1 by ssjx (http://ssjx.co.uk)
''

#include "header.bi"



declare sub expo_init()
declare sub expo_reset()
declare sub expo_add(x as integer, y as integer)
declare sub expo_draw(ax as integer,sx as integer)	 

type ptype
	active as integer
        dist as integer
        x as integer
        y as integer
end type

dim shared exposprite(5) as any ptr
dim shared particle(20) as ptype

sub expo_reset()
	for e as integer=0 to ubound(particle)
		particle(e).active=0
	next e	
end sub

sub expo_init()
	for i as integer=0 to ubound(exposprite)
		exposprite(i) = ImageCreate( 8, 8,rgb(100,255,100) )
	next i
	
	bload "gfx\shot.bmp",exposprite(0)
	
	expo_reset()
end sub

sub expo_add(x as integer, y as integer)
	for e as integer=0 to ubound(particle)
		with particle(e)
		  	if .active=0 then
		                .active=1
		                .dist=0
		                .x=x
		                .y=y
		        	exit for
			end if 
		end with
	next e
end sub

sub expo_draw(ax as integer, sx as integer)	         
       dim as integer tdist
       
	for i as integer=0 to ubound(particle)
	  
	        with particle(i)
	        
		        if .active=1 and .x=ax then
		            put (sx-.dist,.y),exposprite(0),trans	
					put (sx+.dist,.y),exposprite(0),trans	
					put (sx,.y-.dist),exposprite(0),trans	
					put (sx,.y+.dist),exposprite(0),trans	
					
					tdist=.dist*0.75	
					put (sx+tdist,.y+tdist),exposprite(0),trans
					put (sx+tdist,.y-tdist),exposprite(0),trans
					put (sx-tdist,.y-tdist),exposprite(0),trans
					put (sx-tdist,.y+tdist),exposprite(0),trans
		                        
					if .dist>=20 then .active=0 else .dist+=1
				
		        end if
		        
			'draw string (400,120+(i*15)),"E: "+str(.active)+" - "+str(.x)+","+str(.y)
	
	        end with
	next i
end sub 
''
''
''

