''
'' Guardian (2018)
'' v0.1 by ssjx (http://ssjx.co.uk)
''

#include "header.bi"

#include "font.bi"
dim shared text as myfont

common shared as xy player
common shared level as integer

dim shared title(5*38) as integer => {0,0,0,0,1,0,1,1,0,1,0,0,0,0,1,0,0,0,0,1,0,0,0,1,1,0,0,0,1,0,0,0,0,1,0,0,0,0,_
0,1,1,1,1,0,1,1,0,1,0,1,1,0,1,0,1,1,0,1,0,1,1,0,1,1,0,1,1,0,1,1,0,1,0,1,1,0,_
0,1,0,0,1,0,1,1,0,1,0,0,0,0,1,0,0,0,1,1,0,1,1,0,1,1,0,1,1,0,0,0,0,1,0,1,1,0,_
0,1,1,0,1,0,1,1,0,1,0,1,1,0,1,0,1,1,0,1,0,1,1,0,1,1,0,1,1,0,1,1,0,1,0,1,1,0,_
0,0,0,0,1,0,0,0,0,1,0,1,1,0,1,0,1,1,0,1,0,0,0,1,1,0,0,0,1,0,1,1,0,1,0,1,1,0}


dim shared as integer hiscore, prescore

sub title_init()
	text.load()
	hiscore=0
	prescore=0	
end sub

sub title_welcome()
	const as integer sz=12
	dim as integer c,i,j,esc=0,ox,oy
	dim as string key,txt(10)

	ox=(640-(38*sz))/2	
	oy=100
	for j=0 to 4

	for i=0 to 37
	if title(c)=0 then line (ox+(i*sz),oy+(j*sz))-(ox+(i*sz)+sz-1,oy+(j*sz)+sz-1),rgb(255-(j*40),0,0),bf 'draw string(i*12,j*12),"O"
	c+=1
	next i
	
	
	next j
	
	txt(0)="Stop the invaders taking the pods!"
	txt(1)=""
	txt(2)="Control your ship using the "
	txt(3)="Arrow and Space keys!"
	txt(4)=""
	txt(5)="High score: "+str(hiscore)
	txt(6)=""
	txt(7)="Previous score: "+str(prescore)
	txt(8)=""
	txt(9)="Press Space to start"

	'' Stars
	dim as integer sx,sy
	for i=0 to 200
		sx=int(rnd()*640)
		sy=int(rnd()*300)
		
		pset (sx,sy),rgb(255,200,0)
	next i

	''	Mountains
	dim as integer starty=280
	for i=0 to 639
	
		for j=0 to 10
			pset (i,starty+j),rgb(255-(j*25),0,0)
		next j
		
		'' Black out below peaks to hide any stars
		line (i,starty+11)-(i,480),rgb(0,0,0)
		
		if rnd()*10>5 then
			starty+=1
		else
			starty-=1
		end if	
	next i
''
	

	for i=0 to ubound(txt)
		text.centre(190+(i*24),txt(i))	''300
	next i
		
	'' Title version/url
	color rgb(255,255,0)
	draw string (2,480-14),VERSION
	draw string (500,480-14),SITEURL	
		
	While Inkey <> "": Wend
	
	do
		key=inkey
		sleep 10
		
		if multikey(SC_ESCAPE) then esc=1
		if multikey(SC_ESCAPE)=0 and esc=1 then end
		
		if key=Chr(255)&"k" then end
	
	loop while key<>" "

	While Inkey <> "": Wend
end sub

sub title_ready()
	dim as string key
			
	text.centre(170, "Stage "+str(level) )
	text.centre(210, "Get Ready!" )		
	text.centre(250, "Press Space to Start" )	
		
	While Inkey <> "": Wend
	
	do
		key=inkey
		sleep 10
		
		if multikey(SC_ESCAPE) then
			end
		end if
	
	loop while key<>" "			

	While Inkey <> "": Wend
end sub

sub title_stagedone(t as integer,p as integer)
	dim as string key

	text.centre(140, "Stage "+str(level)+" Completed!" )
		
	text.centre(180, "Pod Bonus : "+str(p*10) )
	text.centre(200, "Time Bonus : "+str(t) )	
	
	player.score=player.score+t+(p*10)

	text.centre(240, "Score : "+str(player.score))	
	text.centre(280, "Press Space to Continue" )
		
	While Inkey <> "": Wend
	
	do
		key=inkey
		sleep 10
		
		if multikey(SC_ESCAPE) then
			end
		end if
	
	loop while key<>" "			

	While Inkey <> "": Wend
end sub

sub title_over(r as integer)
	dim as string key,reason
		
	text.centre(140,"Game Over!" )	
	
	if r=0 then reason="Too many pods were taken!"
	if r=1 then reason="Your ship has been destroyed!"
	if r=2 then reason="You ran out of time!"
	
	text.centre(180,reason)	
	text.centre(220, "Final Score : "+str(player.score) )	
	text.centre(260, "Press Space to Continue" )
	
	if player.score>hiscore then hiscore=player.score	
	prescore=player.score	
		
	While Inkey <> "": Wend
	
	do
		key=inkey
		sleep 10
		
		if multikey(SC_ESCAPE) then
			end
		end if
	
	loop while key<>" "			

	While Inkey <> "": Wend
end sub

