''
'' Guardian (2018) 
'' v0.1 by ssjx (http://ssjx.co.uk)
''

#include "header.bi"

randomize timer

declare function collide(px as integer,py as integer,tx as integer,ty as integer,tw as integer,th as integer) as integer


declare sub bomb_reset()
declare sub bomb_add(sx as integer,sy as integer)
declare sub bomb_update()

declare sub expo_init()
declare sub expo_reset()
declare sub expo_add(x as integer, y as integer)
declare sub expo_draw(ax as integer,sx as integer)

declare sub shot_reset()
declare sub shot_add(sx as integer,sy as integer,sxd as integer)
declare sub shot_update()

declare sub title_init()
declare sub title_welcome()
declare sub title_ready()
declare sub title_stagedone(t as integer,p as integer)
declare sub title_over(as integer)

common shared as xy player
dim shared as xy drone(19)
dim shared as xy pod(9)


dim shared as xy saucer(2)


function drone_count() as integer
	dim as integer c=0
	for i as integer=0 to ubound(drone)
		if drone(i).active>0 then c+=1
	next i
	
	return c
end function

function pod_count() as integer
	dim as integer c=0
	for i as integer=0 to ubound(pod)
		if pod(i).active>0 then c+=1
	next i	
	return c
end function

common shared as integer swidth,sheight,sdepth


dim shared as xy star(200)

dim shared as xy morestar(50)

dim as integer i,alt=0
dim shared as integer fire,firedelay=0,speeddelay=0

dim shared as integer peak(640*3)
dim shared as integer tim,lc

common shared shot() as xy
dim shared as xy shot(10)

common shared bomb() as xy
dim shared as xy bomb(10)

common shared level as integer

dim as integer ext=0,x=0,col
dim as integer startx,ax
dim as integer besttarget,shipdir=1,hit=0
dim shared as integer px=320
''
'' Main program
''

windowtitle GAMETITLE+" ["+VERSION+"] "+SITEURL
screen 18,32,2 '',&h01

screeninfo swidth,sheight,sdepth

dim shared as any ptr spriteno(10)

spriteno(1) = ImageCreate( 32, 17,rgb(0,0,0) )
spriteno(2) = ImageCreate( 32, 17,rgb(0,0,0) )
spriteno(3) = ImageCreate( 32, 32,rgb(0,0,0) )
spriteno(4) = ImageCreate( 16, 16,rgb(0,0,0) )
spriteno(5) = ImageCreate( 8, 8,rgb(0,0,0) )
spriteno(6) = ImageCreate( 64, 32,rgb(0,0,0) )
spriteno(7) = ImageCreate( 8, 8,rgb(0,0,0) )

''
bload "gfx\ship_left.bmp",spriteno(1)
bload "gfx\ship_right.bmp",spriteno(2)
bload "gfx\invader.bmp",spriteno(3)
bload "gfx\pod.bmp",spriteno(4)
bload "gfx\shot.bmp",spriteno(5)
bload "gfx\saucer.bmp",spriteno(6)
bload "gfx\bomb.bmp",spriteno(7)

title_init()

sub setlevel(lv as integer)
	dim as integer i
	
	'' Starting places for saucers
	for i=0 to ubound(saucer)
		saucer(i).active=0
		saucer(i).target=-1
		saucer(i).health=5
		
		saucer(i).x=120+int(rnd()*(500*3))
		saucer(i).y=32+(i*32)	'' Top of screen
		
		if int(rnd()*10)>5 then saucer(i).xdir=2 else saucer(i).xdir=-2
	next i
		
	'' Starting places for drones
	for i=0 to ubound(drone)
		drone(i).active=0
		drone(i).target=-1
		drone(i).health=1
		
		drone(i).x=int(rnd()*(640*3))
		drone(i).y=int(rnd()*240)	'' Top of screen
	next i
	
	'' Increase difficulty
	if lv>1 then saucer(0).active=1 	
	if lv>3 then saucer(1).active=1 	
	if lv>5 then saucer(2).active=1 
		
	dim as integer maxdrones=8+lv
	if maxdrones>ubound(drone) then maxdrones=ubound(drone)
	
	for i=0 to maxdrones
		drone(i).active=1
	next i	
	
	
	
	'' Starting places for pod
	for i=0 to ubound(pod)
		pod(i).active=1	'' 0=destroyed 2=carried
		pod(i).target=-1	'' If it is being targeted
		pod(i).carry=-1
		pod(i).x=int(rnd()*640)*3
		pod(i).y=480-16
	next i
	
	'' Create mountain background
	peak(0)=280 
	for i=1 to ubound(peak)
		if rnd()*10>5 then
			peak(i)=peak(i-1)+1
		else
			peak(i)=peak(i-1)-1
		end if	
	next i
	
	'' Stars
	for i=0 to ubound(star)
		star(i).x=int(rnd()*(640*3))
		star(i).y=int(rnd()*peak(star(i).x))
	next i
	
	for i=0 to ubound(morestar)
		morestar(i).x=int(rnd()*640)
		morestar(i).y=int(rnd()*300)
	next i
		
	player.y=240
	player.xdir=0
	
	px=320
	
	speeddelay=0
	firedelay=0
	shot_reset()
	expo_reset()
	bomb_reset()
	
	tim=333
	lc=0
	
end sub


expo_init()


do
'' Welcome Screen
cls
title_welcome()
level=1

	player.score=0
do

	setlevel(level)

	cls
	
	for i=0 to 639
		'' Draw Mountains
		for y as integer=0 to 10
			col=rgb(255-(y*25),0,0)
			pset (i,peak(i)+y),col
		next y
			
		'' Slow way of drawing stars...
		for s as integer=0 to ubound(star)	
			if (star(s).x=i) then 
				pset (i,star(s).y),rgb(255,200,0)
			end if
		next s

	next i


title_ready()
hit=0
ext=0
do
	if  MultiKey(SC_ESCAPE) then ext=1
	
	if  MultiKey(SC_RIGHT) and player.xdir<4 then 
		shipdir=1
		if speeddelay=0 then 
			player.xdir+=1 ':px=px+4	
			speeddelay=10
		end if
	end if
	
	if  MultiKey(SC_LEFT) and player.xdir>-4 then 
		shipdir=-1: 
		if speeddelay=0 then 
			player.xdir-=1 ': px=px-4
			speeddelay=10
		end if
	end if
	
	if speeddelay>0 then speeddelay-=1
	
	if  MultiKey(SC_UP) and (player.y>0) then player.y-=4
	if  MultiKey(SC_DOWN) and (player.y+32)<480 then player.y+=4
	
	px+=player.xdir
	
	if  MultiKey(SC_SPACE) and firedelay=0 then
		firedelay=10
		fire=1
	end if
	
	if firedelay>0 then firedelay-=1
	
	if fire=1 then
		shot_add((px-320)+320,player.y+8,shipdir)
		fire=0
	end if
	
	'' Check exit conditions at the start so screen redraws
	if pod_count()<5 then ext=3
	if drone_count()=0 then ext=2
	if hit>0 then ext=4
	if tim<0 then ext=5
	
	
	if px<0 then px=640*3
	if px>640*3 then px=0
	
	screenlock
		cls
		startx=(px-320)
				
		color rgb(255,0,0)	
		draw string ((160-(5*8))/2,0),"SCORE"
		draw string (160+((160-(4*8))/2),0),"TIME"
		draw string (320+((160-(7*8))/2),0),"INVADERS"
		draw string (480+((160-(4*8))/2),0),"PODS"
		
		''
		color rgb(255,255,0)
		draw string ( (160-(len(str(player.score))*8))/2, 12),str(player.score)
		draw string (160+((160-(3*8))/2),12),str(tim)
		draw string (320+((160-(2*8))/2),12),str(drone_count())
		draw string (480+((160-(2*8))/2),12),str(pod_count())
		
		for i=0 to 639
			ax=startx+i
			
			if ax<0 then ax=1920+ax 
			if ax>1920 then ax=ax-1920
		
			'' Draw Mountains
			for y as integer=0 to 10
				col=rgb(255-(y*25),0,0)
				pset (i,peak(ax)+y),col
			next y
				
			'' Slow way of drawing stars...
			for s as integer=0 to ubound(star)	
				if (star(s).x=ax) then 
					pset (i,star(s).y),rgb(255,200,0)
				end if
			next s
		next i


		for s as integer=0 to ubound(morestar)	 
				pset (morestar(s).x,morestar(s).y),rgb(150,100,0)
				morestar(s).x-=(player.xdir/2)
				
				if morestar(s).x<0 then morestar(s).x=640+morestar(s).x
				if morestar(s).x>639 then morestar(s).x=morestar(s).x-640
		next s


		for i=-32 to 640
			ax=startx+i
			
			if ax<0 then ax=1920+ax 
			if ax>1920 then ax=ax-1920
		
			for s as integer=0 to ubound(shot)
				if shot(s).active>0 then
					if shot(s).x=ax then
						put (i,shot(s).y),spriteno(5),trans
					end if
				end if
			next s
			
			for b as integer=0 to ubound(bomb)
				if bomb(b).active>0 then
					if bomb(b).x=ax then
						put (i,bomb(b).y),spriteno(7),trans
					end if
				end if
			next b
		
			for d as integer=0 to ubound(drone)	
				if drone(d).active>0 then
					if drone(d).x=ax then
						put (i,drone(d).y),spriteno(3),trans
					end if
				end if
			next d
			
			for s as integer=0 to ubound(saucer)	
				if saucer(s).active>0 then
					if saucer(s).x=ax then
						put (i,saucer(s).y),spriteno(6),trans
					end if
				end if
			next s
			
			for p as integer=0 to ubound(pod)
				if pod(p).active>0 then
					if pod(p).x=ax then
						put (i,pod(p).y),spriteno(4),trans
					end if
				end if
			next p
			
			expo_draw(ax,i)
			
		next i
		
		'' Outside main loop because slow otherwise...
		'for s as integer=0 to ubound(shot)
	'		draw string (8,s*12),str(s)+" x:"+str(shot(s).x),rgb(0,200,200)
	'	next s
	
	
		if shipdir=-1 then put (320,player.y),spriteno(1),trans
		if shipdir=1 then put (320,player.y),spriteno(2),trans
	
	screenunlock
	
	'' Update Saucers
	for s as integer=0 to ubound(saucer)	
		if saucer(s).active>0 then		
			'' Bounce along top
			saucer(s).x+=saucer(s).xdir
			if saucer(s).x<10 or saucer(s).x>1800 then saucer(s).xdir*=-1
			
			if int(rnd()*100)>98 then
				bomb_add(saucer(s).x+28,saucer(s).y+24)
			end if 
		end if
	next s
	
	
	'' Update drones
	dim as integer dist,best
	
	for d as integer=0 to ubound(drone)	
	
		'draw string (8,i*12),str(d)+" t:"+str(drone(d).target)
	
		select case as const drone(d).active
		case 1	
			'' Find closest Pod
			best=500
			besttarget=-1
			for p as integer=0 to ubound(pod)
				if pod(p).active=1  then
					dist=abs(drone(d).x-pod(p).x)+abs(drone(d).y-pod(p).y)
					
					if (dist<best) then
					
						besttarget=p
						best=dist
					end if 
				end if
			next p
			
			drone(d).target=besttarget
			
			''
			if drone(d).target>-1 then	
			
				pod(drone(d).target).target=d	
				'' Move
				if drone(d).x<pod(drone(d).target).x-8 then drone(d).x+=1
				if drone(d).x>pod(drone(d).target).x-8 then drone(d).x-=1
				
				if drone(d).y<pod(drone(d).target).y-24 then drone(d).y+=1
				if drone(d).y>pod(drone(d).target).y-24 then drone(d).y-=1
			else
				'' Roaming	
				drone(d).x+=1
			end if
		
		
			'' Have we hit ANY pod?
			for p as integer=0 to ubound(pod)
				if pod(p).active=1 then
					if drone(d).x=pod(p).x-8 then
						if drone(d).y=pod(p).y-24 then
							drone(d).active=2
							drone(d).carry=p
							
							pod(p).active=2
							pod(p).carry=d
							exit for
						end if
					end if
				end if
			next p
		
		case 2
			'' Picked up a drone (slower moving upward)
			if alt=1 then drone(d).y-=1
			
			if drone(d).y<=-64 then	
				pod(drone(d).target).active=0
			
				with drone(d)
					.active=1
					.target=-1	
					.x=int(rnd()*(640*3))
					.y=int(rnd()*240)	'' Top of screen
				end with
			end if
			
		end select
		
		if drone(d).x>1919 then drone(d).x=0
		if drone(d).x<0 then drone(d).x=(1920-1)
	next d 
	
		'' Update pods
	for p as integer=0 to ubound(pod)
	
		select case as const pod(p).active
			case 1
				'' Not on ground (falling)
				if pod(p).y<(480-16) then pod(p).y+=1
			
			case 2 
				''
				if drone(pod(p).carry).active=2 then
					pod(p).x=drone(pod(p).carry).x+8
					pod(p).y=drone(pod(p).carry).y+24
				else
					'' Drone AWOL so not being carried anymore... :(
					pod(p).carry=-1
					pod(p).active=1
				end if
		end select
	
	next p
	
	'' Shooting invaders (top half)
	shot_update()
	bomb_update()
		
	for s as integer=0 to ubound(shot)
	
		if shot(s).active=1 then
		
			for d as integer=0 to ubound(drone)	
				if drone(d).active>0 then
					if shot(s).x+4>drone(d).x and shot(s).x+4<drone(d).x+32 then
						if shot(s).y+4>drone(d).y and shot(s).y+4<drone(d).y+20 then
							drone(d).active=0
							
							'' Drop any pod
							for p as integer=0 to ubound(pod)
								if pod(p).active=2 then
									if pod(p).carry=d then 
										pod(p).carry=-1
										pod(p).active=1
									end if
								end if
							next p
							''
							
							shot(s).active=0
							player.score+=10
							
							expo_add(drone(d).x+12,drone(d).y+12)
							exit for
						end if
					end if
				end if
			next d
		end if
	next s
	
	'' Shot hit saucer
	for s as integer=0 to ubound(shot)
		if shot(s).active=1 then
			for d as integer=0 to ubound(saucer)	
				if saucer(d).active>0 then
					if shot(s).x+4>saucer(d).x and shot(s).x+4<saucer(d).x+32 then
						if shot(s).y+4>saucer(d).y and shot(s).y+4<saucer(d).y+32 then
							saucer(d).health-=1
							''
								if saucer(d).health=0 then
									expo_add(saucer(d).x+28,saucer(d).y+12)
									player.score+=20
									saucer(d).active=0
								end if
							
							shot(s).active=0
							''
						end if
					end if
				end if
			next d
		end if
	next s	
	
	'' Shot hit pod?
	for s as integer=0 to ubound(shot)
		if shot(s).active=1 then
			for d as integer=0 to ubound(pod)	
				if pod(d).active>0 then
					if shot(s).x+4>pod(d).x and shot(s).x+4<pod(d).x+32 then
						if shot(s).y+4>pod(d).y and shot(s).y+4<pod(d).y+32 then
							
							expo_add(pod(d).x+8,pod(d).y+8)
							pod(d).active=0
							
							shot(s).active=0
							''
						end if
					end if
				end if
			next d
		end if
	next s
	
	'' Check if carried pods are still active
	for d as integer=0 to ubound(drone)	
		if drone(d).active=2 then
			if pod(drone(d).carry).active=0 then
				drone(d).carry=-1
				drone(d).active=1
			end if
		end if
	next d
	
	
	
	'' Player crashed into drone?
	hit=0
	player.x=px

	for d as integer=0 to ubound(drone)	
		if drone(d).active>0 then
			hit+=collide(player.x,player.y,drone(d).x,drone(d).y,32,32)
		end if
	next d
	
	for s as integer=0 to ubound(saucer)	
		if saucer(s).active>0 then
			hit+=collide(player.x,player.y,saucer(s).x,saucer(s).y,64,32)
		end if
	next s
	
	'' Bomb hit player?
	for b as integer=0 to ubound(bomb)
		if bomb(b).active=1 then
			with bomb(b)
				if (.x+4)>player.x and (.x+4)<player.x+32 then
					if (.y+4)>(player.y+5) and (.y+4)<(player.y+11) then
						expo_add(.x,.y)
						hit=1
					end if
				end if
				
				if .y>=472 then 
					.active=0
					expo_add(.x,.y)
				end if
						
			end with
		end if
	next b
	
	


	'' Screenshot
	if inkey="s" then
	        bsave "screen.bmp",0
	end if
	
	sleep 10,1	
	
	'' Game timer
	lc+=1
	if lc>=50 then
		if tim>0 then tim-=1
		lc=0
	end if
		
	alt=1-alt
loop while ext=0

select case as const ext
case 1
	'' Exit
case 2
	'' Next Stage
	title_stagedone(tim,pod_count())
	level+=1
case 3
	'' Game Over (no pods)
	title_over(0)
	ext=0
case 4
	'' Game Over (ship collide)
	title_over(1)
	ext=0
case 5
	'' Game Over (ship collide)
	title_over(2)	
	ext=0
end select
	
loop while ext=2


loop while ext=0








