''
'' Stixx 2016 > 2020
''
'' ? Option to continue from level #
''
'' 
'' DONE
'' + Different colour fills
'' + Only move along created path
'' + spark following line
'' + Title Screen
'' + Multi line dialog box
'' + Better handling of exit key
'' + Center play area
'' + Target 60 to 90 then add more bouncing things
'' + Multiple Stixx (add array)
'' + Auto fill when land back on edge
'' + Player loses if trail gets hit
'' + Scale so bigger!
'' + Stop diagonals
''
'' VERSION HISTORY
'' ===============
'' Version 0.2 (Oct 2020)
'' + Fixed out of bounds error. Detected compiling with -exx
''
'' Version 0.1 [09/10/16]
'' + First Release
''
randomize

''
'' Put in a header file...
''
type xy
	active as integer
	x as integer
	y as integer
	xdir as integer
	ydir as integer
	t as integer
end type

const as integer SC_UP=&h48
const as integer SC_LEFT=&h4B
const as integer SC_RIGHT=&h4D
const as integer SC_DOWN=&h50
const as integer SC_SPACE=&h39
const as integer SC_ESCAPE=&h01
const as integer SC_S=&h1F

const as string title="Colour Fill"
const as string version="v0.2 (25/10/20)"
const as string url="http://ssjx.co.uk"

''
''
''


dim shared as integer order(3)

sub dialog_box(txt as string)
	const as integer w=250
	dim as integer h=100
	

	dim as string lin(10),ch
	dim as integer i,l=0

	for i=0 to 10
		lin(i)=""
	next i
	
	for i=0 to len(txt)
		ch=mid(txt,i,1)
		if ch="\" then l+=1 else lin(l)=lin(l)+ch
	next i
	
	h=90+(8*l)
	
	''
	''
	dim as integer ax=(640-w)/2
	dim as integer ay=(480-h)/2
	
	color rgb(0,0,0)
	line(ax,ay)-(ax+w,ay+h),,bf

	color rgb(255,0,0)
	line(ax,ay)-(ax+w,ay+h),,b

	color rgb(255,0,0)
	line(ax+2,ay+2)-(ax+w-2,ay+h-2),,b
	
	''
	dim as integer tw=0
	
	for i=0 to 10
	
		if i=0 then color rgb(0,255,0) else color rgb(0,255,255)
	
		tw=len(lin(i))*8
		ax=(640-tw)/2
		draw string (ax,ay+10+(i*12)),lin(i)
	next i
	
	color rgb(255,200,0)
	txt="Press Space"
	tw=len(txt)*8
	ax=(640-tw)/2
	draw string (ax,ay+h-20),txt
	
	'' Wait for user to press a key
	dim as string key	
	While Inkey <> "": Wend
	
	do
		key=inkey
		sleep 10
		
		if multikey(SC_ESCAPE) then
			end
		end if
	
	
		if key=chr(255)+"k" then
			end
		end if
	
	loop while key<>" "


end sub


''
''
''
dim shared as ubyte map(102,102)
dim shared as ubyte map_col(102,102)

dim shared as integer level,target,lives,score,bonus,fc,alt

''
sub map_fill(x as integer,y as integer,c as integer)

	if (map(x,y)=0) then 
		map(x,y)=c
		if (x<101) then map_fill(x+1,y,c)
		if (x>0) then map_fill(x-1,y,c)
		if (y<101) then map_fill(x,y+1,c)
		if (y>0) then map_fill(x,y-1,c)
	end if 	

end sub

sub map_init()
	dim as integer i,j
	for j=0 to 101
		for i=0 to 101
			map(i,j)=0
			map_col(i,j)=0
		next i
	next j
	
	for i=0 to 101
		map(i,0)=1
		map(i,101)=1
	next i
	
	for j=0 to 101
		map(0,j)=1
		map(101,j)=1
	next j
end sub

sub map_change(a as integer,b as integer)
	dim as integer i,j
	for j=0 to 101
		for i=0 to 101
			if map(i,j)=a then map(i,j)=b
		next i
	next j	
end sub

function map_count(col as integer) as integer
	dim as integer c=0,i,j

	for j=0 to 101
		for i=0 to 101
			if map(i,j)=col then c+=1
		next i
	next j	

	return c
end function

const as integer ofx=(640-408)/2

sub map_block(ix as integer,iy as integer,c as integer)
	dim as integer x,y,t
	
	x=ix*4
	y=iy*4
	select case as const c
	case 0:
		'color rgb(200,200,200) ''empty
		color rgb(100,100,100) ''empty
	case 1:
		'color rgb(200,200,0) '' border
		color rgb(255,255,255)
	case 2:
		t=map_col(ix,iy)
		color rgb(255,0,0) '' fill
		if (t=0) then color rgb(255,0,0)
		if (t=1) then color rgb(150,0,255) 
		if (t=2) then color rgb(0,200,100) 
		if (t=3) then color rgb(255,200,50) 
		if (t=4) then color rgb(0,100,250) 
		
	case 3:
		color rgb(0,200,255) '' trail
				
	case 4:
		if bonus<115 or level>1 then			
			color rgb(0,0,255) ''player		
		else
			if alt=0 then color rgb(0,0,255) else color rgb(255,0,0)
			
		end if
	
	case 5:	
		color rgb(255,0,255) ''stixx
	end select
	
	line(ofx+x,y+40)-(ofx+x+3,y+3+40),,bf

end sub


sub map_colour()
	dim as integer i,j
	dim as integer c
	
	c=int(rnd*5)
	for j=0 to 101
		for i=0 to 101
			if map(i,j)=99 then map_col(i,j)=c
		next i
	next j	
end sub

sub map_draw()
	dim as integer i,j

	for j=0 to 101
		for i=0 to 101
			map_block(i,j, map(i,j) )	
		next i
	next j
end sub
''
sub top_text()
	dim as string txt
	dim as integer xpos,fp
	
	color rgb(200,200,0)
	
	txt="-Level-"
	draw string (0,0),txt
	draw string (3*8,12),str(level)
	
	''
	txt="-Score-"
	xpos=(160)-len(txt)*4
	draw string (xpos,0),txt
	
	txt=str(score)
	xpos=(160)-len(txt)*4
	draw string (xpos,12),txt
	''
	txt="-Bonus-"
	xpos=(320)-len(txt)*4
	draw string (xpos,0),txt
	
	txt=str(bonus)
	xpos=(320)-len(txt)*4
	draw string (xpos,12),txt
	''
	txt="-Fill-"
	xpos=(480)-len(txt)*4		
	fp=int(fc/100)
	draw string (xpos,0),txt
	
	txt=str(fp)+"% ("+str(target)+"%)"
	xpos=(480)-len(txt)*4
	draw string (xpos,12),txt
	
	txt="-Lives-"
	draw string (640-(len(txt)*8),0),txt
	draw string (640-(4*8),12),str(lives)
	
	'' Debug stuff
	'dim as integer i
	'for i=0 to 3
	'draw string (10+(i*20),30),str(order(i))
	'next i
	
	
end sub



sub order_jumble()
	dim as integer a,b,i,t

	for i=0 to 3
		order(i)=i
	next i
	
	for i=0 to 20
		a=int(rnd*4)
		b=int(rnd*4)
		
		t=order(a)
		order(a)=order(b)
		order(b)=t
	next i

end sub

dim as xy player,stixx(10),spark(10)
dim as boolean onborder,moved,nextlevel,newdir
dim as integer i,j,d,cnt,fp,xpos,mp
dim as integer ext
dim as integer hiscore=0
dim as integer stx,spx
dim as string txt=""




dim as boolean esc=false

windowtitle title+" "+version+" - "+url
screen 18,32,2

do

cls
map_init()
map_draw()
'top_text()
	
color rgb(150,150,150)
draw string (0,480-14),version
draw string (640-(8*17),480-14),url

	color rgb(200,200,0)

	txt="-High Score-"
	xpos=(320)-len(txt)*4
	draw string (xpos,0),txt
	
	txt=str(hiscore)
	xpos=(320)-len(txt)*4
	draw string (xpos,12),txt


dialog_box(title+"\-----------\Use the arrow keys\to fill the box!\\Avoid anything that moves!")

level=1
lives=3
target=60
stx=1
spx=1
ext=0
score=0
''
''
''
do
	cls

	cnt=0
	player.x=0
	player.y=0
	onborder=true
	moved=false
	nextlevel=false
	newdir=false
	bonus=120
	fc=0
	
	map_init()
	map_draw()
	top_text()
	dialog_box("Level "+str(level)+"\\Target:"+str(target)+"%")

	
	
	for i=0 to 10
		stixx(i).active=0
		stixx(i).x=10+int(rnd*80)
		stixx(i).y=10+int(rnd*80)
		if (rnd()*10)>5 then stixx(i).xdir=1 else stixx(i).xdir=-1
		if (rnd()*10)>5 then stixx(i).ydir=1 else stixx(i).ydir=-1
	next i
	
	for i=0 to 10
		spark(i).active=0
		spark(i).ydir=0
		spark(i).ydir=0
	next i
	
	spark(0).x=50
	spark(0).y=0
	spark(0).xdir=1

	spark(1).x=50
	spark(1).y=101
	spark(1).xdir=-1
	
	spark(2).x=101
	spark(2).y=50
	spark(2).ydir=1
	
	spark(3).x=0
	spark(3).y=50
	spark(3).ydir=-1	
	
	for i=0 to spx-1
		spark(i).active=1
	next i
	
	for i=0 to stx-1
		stixx(i).active=1
	next i
	
	do
		'' Box
		screenlock
			cls
			map_draw()
			top_text()
			
			map_block(player.x,player.y, 4)
			
			for i=0 to 10
				if stixx(i).active=1 then
					map_block(stixx(i).x,stixx(i).y, 5)
					map_block(stixx(i).x+1,stixx(i).y, 5)
					map_block(stixx(i).x-1,stixx(i).y, 5)
					map_block(stixx(i).x,stixx(i).y+1, 5)
					map_block(stixx(i).x,stixx(i).y-1, 5)
				end if
				
				if spark(i).active=1 then
					map_block(spark(i).x,spark(i).y, 5)
					map_block(spark(i).x+1,spark(i).y, 5)
					map_block(spark(i).x-1,spark(i).y, 5)
					map_block(spark(i).x,spark(i).y+1, 5)
					map_block(spark(i).x,spark(i).y-1, 5)
				end if
			next i
		
		screenunlock
		
		
		for i=0 to 10
			'' Bouncing Stixx
			if stixx(i).active=1 then
				if map(stixx(i).x,stixx(i).y)=3 then ext=2
				if stixx(i).x=player.x and stixx(i).y=player.y then ext=3
		
				if ext>0 then goto skip
			end if
			
			if spark(i).active=1 then
				if spark(i).x=player.x and spark(i).y=player.y then ext=4
		
				if ext>0 then goto skip
			end if
			
		next i
		
		''
		'' Do level check at the top so that everything gets filled
		if (fc>=(target*100) ) then
			ext=1
			nextlevel=true
		end if
	
		moved=false
	
		if  (MultiKey(SC_LEFT) and player.x>0) then
			if (map(player.x-1,player.y)=1 or map(player.x-1,player.y)=0) then		
				player.x-=1
				moved=true
			end if
		end if
		
		if moved=false then
			if  (MultiKey(SC_RIGHT)and player.x<101) then
				if (map(player.x+1,player.y)=1 or map(player.x+1,player.y)=0) then	 		
					player.x+=1
					moved=true
				end if
			end if	
		end if
		
		if moved=false then	
			if  (MultiKey(SC_UP) and player.y>0) then
				if (map(player.x,player.y-1)=1 or map(player.x,player.y-1)=0) then
					player.y-=1
					moved=true		
				end if
			end if
		end if
		
		if moved=false then
			if  (MultiKey(SC_DOWN) and player.y<101) then
				if (map(player.x,player.y+1)=1 or map(player.x,player.y+1)=0) then
					player.y+=1
					moved=true			
				end if
			end if	
		end if
		
		if moved=true then
		
			if map(player.x,player.y)=0 then
				map(player.x,player.y)=3 '' 3
			else
				'' Joined existing filled area?
				if map(player.x,player.y)=1 then
					map_change(3,1)	'' trail to wall 3,2
					
					for i=0 to 10
						if stixx(i).active=1 then map_fill(stixx(i).x,stixx(i).y,99)
					next i
					map_colour()
					map_change(0,2)
					map_change(99,0)
					fc=map_count(2)
	
				end if
			end if
			
			if onborder=false then
				if (player.x=0 or player.x=101) then onborder=true
				
				if (player.y=0 or player.y=101) then onborder=true
				
				if onborder=true then
					map_change(3,1)	'' trail to wall
					'map_fill(stixx.x,stixx.y,99)
					for i=0 to 10
						if stixx(i).active=1 then map_fill(stixx(i).x,stixx(i).y,99)
					next i
					
					map_colour()
					
					map_change(0,2)
					map_change(99,0)
					fc=map_count(2)
				end if	
			else
				if (player.x>0 and player.x<101) then
					if (player.y>0 and player.y<101) then
					onborder=false
					end if
				end if
			end if
		
		end if
		
		'if  MultiKey(SC_SPACE) then 
		'	map_fill(50,50,99)
		'	map_change(0,2)
		'	map_change(99,0)
		'	
		'end if
		
		if MultiKey(SC_S) then
	        	bsave "screen.bmp",0
		end if
		
		if  MultiKey(SC_ESCAPE) then esc=true		
		
		if (esc=true) then
			if  (MultiKey(SC_ESCAPE)=false)  then
				ext=1
				esc=false
			end if
		end if
		
		if inkey=chr(255)+"k" then
			end
		end if
		
		''
		''
		''
	
		for i=0 to 10
			'' Bouncing Stixx
			if stixx(i).active=1 then
			'	if map(stixx(i).x,stixx(i).y)=3 then ext=2
			'	if stixx(i).x=player.x and stixx(i).y=player.y then ext=3
		
			'	if ext>0 then exit for
				
				if map(stixx(i).x+stixx(i).xdir,stixx(i).y)>0 then
				
					if map(stixx(i).x+stixx(i).xdir,stixx(i).y)<>3 then stixx(i).xdir*=-1 else stixx(i).x+=stixx(i).xdir
				
				else
					if stixx(i).x+stixx(i).xdir<0 or stixx(i).x+stixx(i).xdir>99 then
						stixx(i).xdir*=-1
					else	
						stixx(i).x+=stixx(i).xdir
					end if
				end if
				
				
				if map(stixx(i).x,stixx(i).y+stixx(i).ydir)>0 then
					if map(stixx(i).x,stixx(i).y+stixx(i).ydir)<>3 then stixx(i).ydir*=-1 else stixx(i).y+=stixx(i).ydir
				else
					if stixx(i).y+stixx(i).ydir<0 or stixx(i).y+stixx(i).ydir>99 then
						stixx(i).ydir*=-1
					else	
						stixx(i).y+=stixx(i).ydir
					end if
				end if
		
			end if
			
			'' Sparks which follows track (1) or trail (3)
			if (cnt mod 2)=0 then
 				if spark(i).active=1 then
 					
					newdir=false
 					mp=map(spark(i).x+spark(i).xdir,spark(i).y+spark(i).ydir)
					if mp=1 or mp=3 then
						spark(i).x+=spark(i).xdir
						spark(i).y+=spark(i).ydir
					else
						newdir=true
					end if
					
					if spark(i).xdir<>0 then
						'' check if route up
						if (spark(i).y-1>=0) then
							mp=map(spark(i).x,spark(i).y-1)
							if mp=1 or mp=3 then newdir=true
						end if
						
						'' ..or down
						if (spark(i).y+1<=100) then
							mp=map(spark(i).x,spark(i).y+1)
							if mp=1 or mp=3 then newdir=true
						end if
					end if
					
					if spark(i).ydir<>0 then
						'' check if route left
						if (spark(i).x-1>=0) then
							mp=map(spark(i).x-1,spark(i).y)
							if mp=1 or mp=3 then newdir=true
						end if
						
						'' ..or right
						if (spark(i).x+1<=100) then
							mp=map(spark(i).x+1,spark(i).y)
							if mp=1 or mp=3 then newdir=true
						end if
					end if
					
					
					if newdir=true then
						spark(i).xdir=0
						spark(i).ydir=0
						''
						order_jumble()
						
						'' find a direction
						for d=0 to 3
							select case as const order(d)
							case 0
								if (spark(i).y-1>=0) then
									mp=map(spark(i).x,spark(i).y-1)
									if mp=1 or mp=3 then
										spark(i).ydir=-1
										exit for
									end if
								end if
							case 1
								if (spark(i).x+1<=101) then
									mp=map(spark(i).x+1,spark(i).y)
									if mp=1 or mp=3 then
										spark(i).xdir=1
										exit for
									end if
								end if
							case 2
								if (spark(i).y+1<=101) then
									mp=map(spark(i).x,spark(i).y+1)
									if mp=1 or mp=3 then
										spark(i).ydir=1
										exit for
									end if
								end if
							case 3
								if (spark(i).x-1>=0) then
									mp=map(spark(i).x-1,spark(i).y)
									if mp=1 or mp=3 then
										spark(i).xdir=-1
										exit for
									end if
								end if 
							end select
						next d
					end if
					
				end if
				
				'if (spark(i).x+spark(i).xdir<0) or (spark(i).x+spark(i).xdir>101) then
			'		spark(i).xdir*=-1
			'	else
			'		spark(i).x+=spark(i).xdir	
			'	end if
				
				'spark(i).y=spark(i).y+spark(i).ydir
			end if
			
		next i
		
		sleep 10,1
		
		cnt+=1
		if cnt=30 or cnt=60 then alt=1-alt
		
		if cnt=60 then
			cnt=0
			if bonus>0 then bonus-=1	
		end if
		
		'' Quick way to skip to the end....
		skip:
		
	loop while (ext=0)
	
	if nextlevel=true then
	
		fp=int(fc/100)
	
		txt="Level Complete"
		txt+="\--------------"
		txt+="\Filled: "+str(fp)+"%"
		txt+="\Bonus: "+str(bonus)
		txt+="\Level Score: "+str(fp+bonus)
		
		dialog_box(txt)
	
		score=score+fp+bonus
	'''
		level+=1
		target+=10
		''
		if target=100 then
			target=90
			if stx<10 then stx+=1
			
			'' Should be near impossible by this point...
			if stx=4 then spx=2
			if stx=6 then spx=3
			if stx=8 then spx=4
			
			'' Extra life!
			lives+=1
		end if
		
		nextlevel=false
		ext=0
	end if
 
 	if ext=1 then
		txt="Player Quits!"
 		dialog_box(txt)
 	else	
		if ext>1 then
			if ext=2 then txt="Bouncer hits trail!"
			if ext=3 then txt="Bouncer hits player!"
			if ext=4 then txt="Creeper hits player!"
			
			lives-=1
			
			if lives>0 then 
				txt=txt+"\\"+Str(lives)+" lives remaining!" 
				ext=0
			else 
				txt=txt+"\\Game Over!"
				
				if score>hiscore then
					hiscore=score
					txt=txt+"\\New High Score!"
				end if
			end if
			
			dialog_box(txt)
		end if
	end if

loop while ext=0

loop
