''
'' Chuckie Egg Returns (2016) 
'' v0.4 by ssjx (http://ssjx.co.uk)
''
'' Swans
''

#include "header.bi"

''
''
declare function collide3( as integer, as integer, as integer, as integer, as zone, as zone) as integer

declare function map_get(x as integer,y as integer) as integer

common shared map() as xypos

common shared viewx as integer
common shared viewy as integer

''
''

declare sub swans_reset()

''
''

common shared swan() as swanpos
dim shared as swanpos swan(20)

dim shared as any ptr swansprite(6)

dim shared as integer swc

sub swans_init()
	dim i as integer

	for i=0 to ubound(swansprite)
		swansprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	bload "gfx\swan-r1.bmp",swansprite(0) 'r1
	bload "gfx\swan-r2.bmp",swansprite(1) 'r2'
	
	bload "gfx\swan-l1.bmp",swansprite(2) 'l1
	bload "gfx\swan-l2.bmp",swansprite(3) 'l2'
	
	bload "gfx\swan-u1.bmp",swansprite(4) 'l1
	bload "gfx\swan-u2.bmp",swansprite(5) 'l2'
end sub


sub swans_add(x as integer,y as integer)

	if swc<ubound(swan) then
	
		with swan(swc)
			.active=1
			.px=x
			.py=y
			.ox=.px
			.oy=.py
			.sx=0
			.sy=0
			if int(rnd*9)>5 then .xdir=-1 else .xdir=1
		end with
	
		swc+=1
	end if
end sub

''
'' Draw
''

sub swans_draw()
	dim as integer i,ax,ay
	
	'' draw swans	
	for i=0 to ubound(swan)
		with swan(i)
			if .active=1 then
			
				ax=(.px shl 5)+.sx+viewx
				ay=(.py shl 5)+.sy+viewy
				
				if .ydir=0 then
					if .xdir=1 then 
						put (ax,ay),swansprite(0+.alt),trans
					end if
					
					if .xdir=-1 then
						put (ax,ay),swansprite(2+.alt),trans
					end if
				else 
					'' Climbing
					put (ax,ay),swansprite(4+.alt),trans
				end if
				
			end if
		end with
	next i
end sub

''
''
sub swans_move()
	dim as integer i,c,moved
	dim as integer order(1)
	

	
	for i=0 to ubound(swan)
	with swan(i)
		if .active=1 then
			.sc+=1
			if (.sc and 1) then
			
				if .sx=0 and .sy=0 then
						
					'' swan on ladder (will only climb from top or bottom)		
					if  map_get(.px,.py)=4 then
					
						''ladder on ground
						if map_get(.px,.py+1)=1 or map_get(.px,.py+1)=0 then
						
							if .ydir=0 then
								''random whether ladder is climbed
								if int(rnd*10)>4 then .ydir=-1
							
							else
								'' Had been climbing ladder, now hit bottom
								
								.ydir=0
								
								moved=0
								order(0)=0
								order(1)=1
	
								if int(rnd*10)>4 then
									order(0)=1
									order(1)=0
								end if
								
								for c=0 to 1
								
									select case as const order(c)
									case 0:
										''      floor right                 no wall
										if map_get(.px+1,.py+1)=1 and map_get(.px+1,.py)=0 then
											.xdir=1
											moved=1
										end if
									case 1:
										''      floor left                 no wall
										if map_get(.px-1,.py+1)=1 and map_get(.px-1,.py)=0 then
											.xdir=-1
											moved=1
										end if
									end select
								
									if moved=1 then exit for
								
								next c
								
								'' Cannot move so back up!
								if moved=0 then .ydir=-1
						
							end if
						end if
			
						''top of ladder	(above clear)				
						if  map_get(.px,.py-1)=0 then 
					
							if .ydir=-1 then
								'just climbed
								.ydir=0
								
								moved=0
								order(0)=0
								order(1)=1
	
								if int(rnd*10)>4 then
									order(0)=1
									order(1)=0
								end if
								
								for c=0 to 1
								
									select case as const order(c)
									case 0:
										''      floor right                 no wall
										if map_get(.px+1,.py+1)=1 and map_get(.px+1,.py)=0 then
											.xdir=1
											moved=1
										end if
									case 1:
										''      floor left                 no wall
										if map_get(.px-1,.py+1)=1 and map_get(.px-1,.py)=0 then
											.xdir=-1
											moved=1
										end if
									end select
								
									if moved=1 then exit for
								
								next c
								
								'' Cannot move so back down!
								if moved=0 then .ydir=1
								
							else
								''stepped on to
								''random whether ladder is climbed
								if int(rnd*9)>5 then .ydir=1
							end if
							
						end if
					
						'' Walking through middle of ladder	
						if .ydir=0 then
							if map_get(.px+.xdir,.py)=1 or map_get(.px+.xdir,.py+1)=0 then
								.xdir*=-1
							end if
						end if
					''
					else
						'' if not on ladder change dir if wall or floor ahead
						if map_get(.px+.xdir,.py)=1 or map_get(.px+.xdir,.py+1)=0 then
							.xdir*=-1
						end if		
					end if
				end if
				
				if .ydir=0 then
					.sx+=.xdir
				else
					.sy+=.ydir
				end if
				
				''
				
				if .sx=-32 then
					.sx=0
					.px-=1
				end if
				
				if .sx=32 then
					.sx=0
					.px+=1	
				end if
				
				if .sy=-32 then
					.sy=0
					.py-=1
				end if
				
				if .sy=32 then
					.sy=0
					.py+=1	
				end if
				
				'' alternate sprite
				if .sc=11 then 
					.alt=1-.alt
					.sc=0	
				end if
			end if				
		end if 
	end with
	next i	

end sub

''
'' Deactivate and reset all swans
''

sub swans_clear()
	for i as integer=0 to ubound(swan)
		with swan(i)
			.active=0
			.xdir=0
			.ydir=0
			.sx=0
			.sy=0
			.alt=0
			.sc=0
		end with
	next i
	
	swc=0
end sub

''
'' Put swans in starting places
sub swans_reset()
	for i as integer=0 to ubound(swan)
		with swan(i)
			.px=.ox
			.py=.oy
			.sx=0
			.sy=0
			.alt=0
			if int(rnd*9)>5  then .xdir=-1 else .xdir=1
			.ydir=0
			.sc=0
		end with
	next i	
end sub
