''
'' Chuckie Egg Returns 2016 
'' v0.4 by ssjx (http://ssjx.co.uk)
''
'' Player
''

#include "header.bi"

''
''
declare function map_hscroll(xdir as integer) as integer
declare function map_vscroll(ydir as integer) as integer

''

declare function player_over(no as integer, x as integer, y as integer) as integer
declare function player_collide(x as integer, y as integer) as integer
declare sub map_set(p as integer, s as integer)
''
''

common shared map() as xypos

common shared viewx as integer
common shared viewy as integer

common shared mapwidth as integer
common shared mapheight as integer

common shared player as myplayer

const ofx as integer=6
const wid as integer=20

dim shared as any ptr player_sprite(6)

dim shared as integer moveleft,moveright,alt,sc

dim shared jump as integer
dim shared onladder as integer

sub player_init()
	dim i as integer
	
	for i=0 to ubound(player_sprite)
		player_sprite(i) = ImageCreate( 32, 32,rgb(0,0,0) )
	next i
	
	bload "gfx\player.bmp",player_sprite(0) 'r1
	bload "gfx\player1.bmp",player_sprite(1) 'r2
	
	bload "gfx\player-l1.bmp",player_sprite(2) 'l1
	bload "gfx\player-l2.bmp",player_sprite(3) 'l2
	
	bload "gfx\player-u1.bmp",player_sprite(4) 'up1
	bload "gfx\player-u2.bmp",player_sprite(5) 'up2'
	
	alt=0
	sc=0
	jump=0
end sub

sub player_reset()

	with player
		.x=.ox
		.y=.oy
		viewx=.vx
		viewy=.vy
	end with
	jump=0
end sub

sub player_draw()
	put (player.x,player.y),player_sprite(player.s+alt),trans
	
	'draw string(20,20),"Ladder"+str(onladder)	
end sub

sub player_update()
	const as integer speed=2
	dim as integer hit=0

	'' Actual ladder
	onladder=player_over(4,0,0)

	'' Egg!
	hit=player_over(7,0,0)
	if hit>-1 then
		map_set(hit,0)	''
		player.eggs+=1
		player.score+=10
	end if
	
	'' Seed
	hit=player_over(3,0,0)
	if hit>-1 then
		map_set(hit,0)	''
		player.score+=5
	end if

	''
	'' player on a movable block (player is slightly above block...)
	hit=player_over(8,0,0)
	if hit>-1 and player_collide(0,-1)<>1 then		
		with player
			if (.y<=(64+32)) then
				if map_vscroll(1)=0 then .y-=1
			else
				.y-=1
			end if
		end with
	end if

	'' Falling
	'' =======
	'' Check in 1 pixel increments due to jumping off u/d moving
	'' platform interfering with landing offset
	''

	dim as integer c
	if onladder=-1 and jump=0 then
		for c=0 to 3 ' 3'
			'' Not on solid ground    and  not on ladder top 'and player_over(4,0,1)=-1'
			if player_collide(0,1)=-1 and player_over(4,0,1)=-1 then  
				'' 416-32
				if (player.y>=(480-128) ) then
					if map_vscroll(-1)=0 then player.y+=1
				else
					player.y+=1
				end if	
			end if	
		next c
	end if


		if  (MultiKey(SC_RIGHT)) then 
			moveright=1
			player.s=0
		else
			moveright=0
		end if
		
		if  (MultiKey(SC_LEFT)) then 
			moveleft=1
			player.s=2
		else	
			moveleft=0
		end if
		''
		
		if  MultiKey(SC_UP) then
			
			hit=player_collide(0,-speed)
			
			if hit=-1 then 
				
				if onladder>-1 then
					'' Climbing a ladder
					if (player.y<=(64+32)) then
						if map_vscroll(speed)=0 then player.y-=speed
					else
						player.y-=speed
					end if
					
					player.s=4
					
					sc+=1
					if sc>10 then sc=0:alt=1-alt
					'goto eokeys:
				else
					'' NOT on ladder... but on top of one?
					if player_over(4,0,1)>-1 then
						jump=24
					end if
					
					'' are we on the ground if so then jump!
					if jump=0 then
						if player_collide(0,1)>-1 then
							jump=24 ''was 16
						end if
					end if
					
				end if	
			
			end if
		end if
		
		if  MultiKey(SC_DOWN)then
			hit=player_collide(0,speed)
			
			if hit=-1  then
				''   Ladder below (player at top) or actually on a ladder
				if player_over(4,0,1)>-1 or onladder>-1 then
					''              v-- 416 
					if (player.y>=(480-128) ) then
						if map_vscroll(-speed)=0 then player.y+=speed
					else
						player.y+=speed
					end if
					
					player.s=4
					
					sc+=1
					if sc>10 then sc=0:alt=1-alt
					'goto eokeys:
				end if
			end if
		end if
		
		
		
		if moveright=1 then
			if player_collide(speed,0)=-1 then
			
				''             v-- 448  
				if (player.x>=640-160) then
					if map_hscroll(-speed)=0 then player.x+=speed
				else
					player.x+=speed
				end if
				
				sc+=1
				if sc>10 then sc=0:alt=1-alt
			end if
		end if 
		
		if moveleft=1 then
			if player_collide(-speed,0)=-1 then
				''             v-- 160
				if (player.x<=128) then
					if map_hscroll(speed)=0 then player.x-=speed
				else
					player.x-=speed
				end if
				
				sc+=1
				if sc>10 then sc=0:alt=1-alt
			end if
		end if
		
			''

	
	
	if jump>0 then
		dim as integer fallspeed
		if player_collide(0,-2)=-1 then
			'' jump slows near top of jump 'was 8 , 12
			if jump>8 then
				fallspeed=speed
			else
				fallspeed=1 '2'
			end if
	'	
			with player
				if (.y<=(64+32)) then
					if map_vscroll(fallspeed)=0 then .y-=fallspeed
				else
					.y-=fallspeed
				end if	
			end with
	''	
			jump-=1
		else
			jump=0
		end if	
	end if	
		
end sub

function player_collide(x as integer, y as integer)  as integer
	dim as integer c	
	
	dim as integer px=player.x-viewx+x+ofx
	dim as integer py=player.y-viewy+y
	
	dim as integer h=31
	
	for c=0 to ubound(map)			
		with map(c)	
			'' Block OR moving platform
			if .s=1 or .s=8 or .s=9 then
			
				'' Most things
				h=31
					
				'' Moving platforms
				if .s=8 or .s=9 then h=15
				
				'' first check
				'' Player in object
				if (px>=.x and px<=(.x+31) ) or ((px+wid)>=.x and (px+wid)<=(.x+31) ) then
					if (py>=(.y) and py<=(.y+h) ) then return 1
					if ( (py+31)>=(.y) and (py+31)<=(.y+h) ) then return 1
				end if 	
				
				'' Object in player
				if (.x>=px and .x<=(px+wid) ) or  ((.x+31)>=px and (.x+31)<=(px+wid) ) then
					
					if (.y>=py) and (.y<=(py+31) ) then return 1
					if (.y+h>=(py)) and ((.y+h)<=(py+31) ) then return 1
				end if 
				
			end if
		end with
	next c
	
	return -1
end function

'' Return value is the element number
function player_over(no as integer, x as integer, y as integer) as integer
	dim as integer c	
	
	dim as integer px=player.x-viewx+x+ofx
	dim as integer py=player.y-viewy+y
	'px+=ofx '' player position slightly inside 32x32...
		
	dim as integer oy=0
	dim as integer h=31
	
	c=0
	for c=0 to ubound(map)		
		with map(c)	
			if .s=no then
				'' Most things
				oy=0
				h=31
					
				'' Moving platforms
				if no=8 or no=9 then
					oy=0
					h=15	
				end if	
					
				'' Seeds or eggs
				if no=3 or no=7 then
					oy=16	'' Seeds are bottom of sprite
					h=15	
				end if
			
				'' first check
				if (px>=.x and px<=(.x+31) ) or ((px+wid)>=.x and (px+wid)<=(.x+31) ) then
					
					'' '=' on the first bit causes the player to be slightly off the ground
					if (py>=(.y+oy) and py<=(.y+h+oy) ) then return c
					if ( (py+31)>=(.y+oy) and (py+31)<=(.y+h+oy) ) then return c
				end if 		
			end if
		end with
	next c


	return -1
end function

sub map_set(p as integer, s as integer)
	map(p).s=s
end sub


