''
'' Chuckie Egg Returns 2016 
'' v0.4 by ssjx (http://ssjx.co.uk)
''
'' 256 Map Loading
''

#include "header.bi"
''
''
''
common shared map() as xypos

common shared player as myplayer

common shared viewx as integer
common shared viewy as integer

common shared mapwidth as integer
common shared mapheight as integer

common shared swidth as integer 

''
''
''
declare sub swans_add(as integer, as integer)
declare sub swans_clear()

declare sub duck_set(as integer, as integer)

''
''
''

declare sub map_flip()

dim shared basemap(40*25) as ubyte	'' Basemap

dim shared as any ptr mapsprite(10)

dim shared as integer blocks

''
''
''

sub map_init()
	dim i as integer

	for i=0 to ubound(mapsprite)
		mapsprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	bload "gfx\block.bmp",mapsprite(1)
	bload "gfx\seed.bmp",mapsprite(3)
	bload "gfx\ladder.bmp",mapsprite(4)
	bload "gfx\egg.bmp",mapsprite(7)
	bload "gfx\moving.bmp",mapsprite(8)
	bload "gfx\moving.bmp",mapsprite(9)	
end sub


sub map_load(lev as integer)
	dim as integer i,j,c,rg,dif
	dim header as bmphdr

	'lev=9

	''clear the entire map array
 	for i=0 to ubound(map)
 		with map(i)
	 		.s=-1
	 		.xdir=0
	 		.ydir=0
 		end with
	next i	

	swans_clear()

	''
	'' Load the map	
	if  Open("levels\"+str(lev)+".bmp" For binary access read As #1)=0 then
		get #1,,header
		get #1,header.offset+1,basemap()  
	        Close #1   
		
		mapwidth=header.w
		mapheight=header.h
		
		map_flip()
		
		blocks=0
		c=0
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)     
				   
				rg=basemap(c)	
					
				select case as const rg
				case 1:
					'' Solid Brick
				case 2:
					'' Swan / Person
					swans_add(i,j)
					rg=0
				
				case 3:
					'' Seed / Fire
				case 4: 
					'' Ladder
				case 5:
					'' Start Position
					with player
						.x=i
						.y=j
						
						viewx=-((.x-9)*32)
						viewy=-((.y-7)*32)
						
						.x=(9*32)
						.y=(7*32)
						
						if viewx<-640 then
							.x=.x+(abs(viewx)-640)
							viewx=-640
						end if
						
						dif=(mapheight*32)-480
						
						if viewy<-dif then
							.y=.y+(abs(viewy)-dif)
							viewy=-dif
						end if
						
						'' Default start in case we reset
						.ox=.x
						.oy=.y
						
						.vx=viewx
						.vy=viewy
						
					end with
					rg=0
				case 6:
					'' Duck
					duck_set(i,j)
					rg=0
				case 7:
					'' egg	
				case 8:
					'platforms up/down
				case 9:
					'platform left/right	
				end select
				
				with map(c)
					.s=rg
					.mx=i
					.my=j
					''
					.x=.mx*32 
					.y=.my*32 
					''
					if .s=8 then .ydir=1
					if .s=9 then .xdir=1
				end with
				
				c+=1
			next i
		next j
		       
	end if
	
	blocks=(c-1)
end sub

sub map_flip()
	dim as integer i,j,c
	dim temp(mapwidth*mapheight) as ubyte 

	'' copy
	for i=0 to ubound(temp)
	temp(i)=basemap(i)
	next i
	
	'' flip row by row..
	c=0
	for j=0 to mapheight-1
		for i=0 to mapwidth-1
			basemap(c+i)=temp((mapwidth*( (mapheight-1)-j))+i)  '' 32*(31-j)
		next i
		c+=mapwidth	''32
	next j
	

end sub
''


'' check if a block has hit the player (and vice versa)
function map_hitplayer(no as integer,x as integer,y as integer) as integer

	dim as integer px
	
	dim as integer mx=map(no).x+(x+viewx)
	dim as integer my=map(no).y+(y+viewy)
	
	const as integer pw=16
	
	with player
		
		px=.x+8
		
		'' Player in platform/object
		if (px>=mx and px<=(mx+31) ) or  ( (px+pw)>=mx and (px+pw)<=(mx+31) ) then
			if (.y>=my) and (.y<=(my+15) ) then return 1
			if (.y+31>=my) and ((.y+31)<=(my+15) ) then return 1
		end if 
	
		'' Object in player
		if (mx>=px and mx<=(px+pw) ) or  ((mx+31)>=px and (mx+31)<=(px+pw) ) then
			if ( (my+15)>=.y and (my+15)<=(.y+31) ) then return 1
			if (my>=.y and my<=(.y+31) ) then return 1
		end if 
	
	end with
	return 0
end function

'' see if box 'no' has hit anything 32x32
function map_collide(no as integer,x as integer,y as integer) as integer
	'' move blocks
	dim as integer i
	
	dim as integer mx=map(no).x+x
	dim as integer my=map(no).y+y
	
	for i=0 to blocks
	
		if (i<>no) then
			with map(i)
				if (.s>0) then
				
					if (mx>=.x and mx<=(.x+31) ) or  ((mx+31)>=.x and (mx+31)<=(.x+31) )  then
						
						if (my>=.y and my<=(.y+31) ) then return 1
						
						if ( (my+15)>=.y and (my+15)<=(.y+31) ) then return 1
								
					end if 
				
				end if 
			end with
		end if
	next i

					
	return 0	
end function

sub map_update()
	dim as integer c,i
	
	for c=0 to blocks
	
		select case as const map(c).s
			case 8:
				'' floating up/down block...
				with map(c)
					if .ydir<0 then
						'' going up (extra height so we don't squash player)
						if map_collide(c,0,1-64)=0 then
							.y+=.ydir
						else	
							.ydir*=-1
						end if
						
						if .y<=0 then .ydir*=-1
					else
						'' going down (if it hits player head, then change dir) 
						if map_collide(c,0,1)=0  and map_hitplayer(c,0,1)=0  then
							.y+=.ydir
						else	
							.ydir*=-1
						end if
						
						if .y>=(mapheight*32)-16 then .ydir*=-1
					end if
				end with
				
			case 9
				'' floating left/right block...
				with map(c)
					if map_collide(c,.xdir,0)=0  and map_hitplayer(c,.xdir,0)=0 then
						.x+=.xdir
					else	
						.xdir*=-1
					end if
				end with
		end select
	next c
end sub



''
function map_draw() as integer
	dim as integer i,j,px,py,c=0
	''
	'' Draw level
	''
	for i=0 to blocks
	
		with map(i)
			py=.y+viewy
			if py>=-32 and py<480 then
				px=.x+viewx ''-32 as we have a column hidden
				if px>=-32 and px<=640 then
					if .s>0 then
						if .s=4 then
							'' ladder (not transparent)
							put (px,py),mapsprite(.s),pset	
						else 
							'' everything else...
							put (px,py),mapsprite(.s),trans
						end if	
						c+=1
					end if
				end if
		
			end if
		end with
	next i
	return c
end function
''



function map_hscroll(xdir as integer) as integer
	dim as integer avx
	avx=(-viewx)

	if (avx-xdir)>=0 and (avx-xdir)<=640 then
		viewx+=xdir
		return 1	
	end if	
	
	'' Could not push/move map..
	return 0
end function


function map_vscroll(ydir as integer) as integer
	dim as integer avy
	dim as integer dif
	
	dif=(mapheight*32)-480
	avy=(-viewy)
	
	''
	if (avy-ydir)>=0  and (avy-ydir)<=dif then
		viewy+=ydir
		return 1	
	end if
	
	'' Could not push/move map..
	return 0
	
end function



sub map_small()
	const as integer smallx=640-80-10
	const as integer smally=14
	
	dim as integer i,j,c=0
	dim as integer dx,dy
		
	for j=0 to (mapheight-1)
		for i=0 to (mapwidth-1)        
	         			
	         	select case as const map(c).s
			case 1:
				'' floor
				color rgb(0,255,0)
				line (smallx+(i shl 1),smally+(j  shl 1))-(smallx+(i shl 1)+1,smally+((j shl 1)+1)),,bf
			
			case 7:	
				'' egg
			 	color rgb(255,255,0)
				line (smallx+(i shl 1),smally+(j  shl 1))-(smallx+(i shl 1)+1,smally+((j shl 1)+1)),,bf
			 	
		 	case 4:	
				'' ladder
			 	color rgb(255,0,255)
			 	line (smallx+(i shl 1),smally+(j  shl 1))-(smallx+(i shl 1)+1,smally+((j shl 1)+1)),,bf
				
			 end select	
         		c+=1					
		next i		
	next j

	'' player
	color rgb(255,0,0)
	dx=(player.x-viewx) shr 4	'' div 16
	dy=(player.y-viewy) shr 4
        line (smallx+dx, smally+dy)-(smallx+dx+1,smally+dy+1),,bf
	
end sub	

function map_eggs() as integer
	dim as integer c,eggs

	for c=0 to blocks
		if map(c).s=7 then eggs+=1
	next c
	
	return eggs
end function

'' Use by swans to find gaps/walls...
function map_get(x as integer,y as integer) as integer
	dim as integer ps,v
	
	ps=(y*mapwidth)+x
	
	v=map(ps).s
	
	'' Start points for the moving platforms, treat as clear
	if v=8 or v=9 then v=0
	
	return v
end function


