''
'' Chuckie Egg Returns (2016) 
'' v0.4 by ssjx (http://ssjx.co.uk)
''
''

#include "header.bi"

randomize timer

''
''
declare sub map_load(as integer)
declare function map_draw() as integer
declare sub map_small()
declare sub map_init()
declare sub map_update()
declare function map_eggs() as integer
''
declare sub swans_add(as integer, as integer)
declare sub swans_clear()
declare sub swans_reset()
declare sub swans_init()
declare sub swans_draw()
declare sub swans_move()
''
declare sub duck_init()
declare sub duck_reset()
declare sub duck_draw()
declare function duck_update() as integer
''
declare sub player_init()
declare sub player_draw()
declare sub player_update()
declare sub player_reset()
''
declare function collide3( as integer, as integer, as integer, as integer, as zone, as zone) as integer
''
''

common shared map() as xypos
dim shared as xypos map(40*40)

common shared swan() as swanpos
common shared duck as swanpos
common shared player as myplayer

common shared viewx as integer
common shared viewy as integer

'common shared plat() as swanpos

common shared as integer swidth,sheight,sdepth


dim shared as integer maxeggs

dim shared as string txt(20)

dim shared as any ptr spriteno(5)
dim scene as xy 

sub title()
	dim as integer i,j,xpos
	dim as string key
	''
	''
	cls
	for i=0 to 19
		put (i*32,0),spriteno(1)
		put (i*32,sheight-32),spriteno(1)
	next i
	
	for j=1 to 13
		put (0,j*32),spriteno(1)
		put (swidth-32,j*32),spriteno(1)
	next j
	
	for i=1 to 8
		put ((160)+(i*32),10*32),spriteno(1)
	next i
	
	'' Some swans!
	put (1*32,13*32),spriteno(3),trans
	put (18*32,13*32),spriteno(4),trans
	
	put (6*32,9*32),spriteno(3),trans
	put (13*32,9*32),spriteno(4),trans
	
	
	color rgb(255,255,0)
	for i=0 to 11
		xpos=(swidth-(len(txt(i))*8))/2
		draw string(xpos,50+(i*16)),txt(i)
	next i
	screencopy
		
	While Inkey <> "": Wend
	
	do
		key=inkey
		sleep 10
		
		if multikey(SC_ESCAPE) then
			end
		end if
	
	loop while key<>" "
	
end sub

sub infobox(txt as string)
	const as integer w=180
	const as integer h=70
	
	dim as integer xpos
	dim as integer x1,y1,x2,y2
	dim as string key
	
	x1=(swidth-w)/2
	y1=(sheight-h)/2
	x2=(swidth+w)/2
	y2=(sheight+h)/2
	
	color rgb(0,0,0)
	line(x1,y1)-(x2,y2),,bf
	
	color rgb(255,0,255)
	line(x1,y1)-(x2,y2),,b	
	line(x1-2,y1-2)-(x2-2,y2-2),,b
			
	color rgb(255,255,0)
	xpos=(swidth-(len(txt)*8))/2
	draw string(xpos,(sheight/2)-20),txt
	
	txt="Press Space"
	xpos=(swidth-(len(txt)*8))/2
	draw string(xpos,(sheight/2)),txt

	screencopy
	While Inkey <> "": Wend
		
	do
		key=inkey
		sleep 10
	loop while key<>" "

end sub





''
'' Main program
''

windowtitle GAMETITLE+" ["+VERSION+"] "+SITEURL
screen 18,32,2 '',&h01

screeninfo swidth,sheight,sdepth

screenset 0,1

dim as integer i,j, x,y,ext
dim as integer tim,lc,level,levelmap,hiscore=0,lives,near
dim as integer swans,hit

dim as zone playerzone,quack,qleft,qright

''
'' The following is the hit area of the player,
'' it is also the right size for the swans which is handy.
'' co-ords are relative to top left
''
playerzone.x=6
playerzone.y=0
playerzone.w=20
playerzone.h=31

''duck (body + head left/right)
quack.x=9
quack.y=39
quack.w=63-18 '' 57
quack.h=24

qleft.x=1
qleft.y=17
qleft.w=25
qleft.h=22

qright.x=38
qright.y=17
qright.w=25
qright.h=22

'' Used for the title screen
for i=0 to ubound(spriteno)
	spriteno(i) = ImageCreate( 32, 32,rgb(0,0,0) )
next i

''
bload "gfx\block.bmp",spriteno(1)
bload "gfx\moving.bmp",spriteno(2)
bload "gfx\swan-r1.bmp",spriteno(3)
bload "gfx\swan-l1.bmp",spriteno(4)
''

'' Load graphics
map_init()
swans_init()
duck_init()
player_init()

''
do
	txt(0)=GAMETITLE
	txt(1)=VERSION
	txt(2)="by ssjx"
	txt(3)=""
	txt(4)="Controls"
	txt(5)="Arrows  - Move"
	txt(6)=""
	txt(7)="High Score : "+str(hiscore)
	txt(8)=""
	txt(9)="Press [Space] to Start"
	txt(10)="Press [Escape] to Quit"
	txt(11)=SITEURL
	
	title()

	'' set up at game start	
	lives=3
	level=1
	levelmap=1
	
	duck.active=0 	''no duck
	swans=1 	''active swans
	hit=0
	player.score=0
		
''
do
	map_load(levelmap)
	
	maxeggs=map_eggs()
	''
	''
	'' draw screen
	Screenlock
		color ,rgb(0,0,0) ',rgb(0,180,220)'	
		cls
		map_draw()
		map_small()
		
	Screenunlock
	''
	infobox("Level "+str(level)) '+" Map:"+str(levelmap))

	tim=MAXTIME
	lc=0
	player.eggs=0
	ext=0
	
	'' To restart
	do
		map_update()
		player_update()
		
		cls
		near=map_draw()	
		player_draw()
			
		if  MultiKey(SC_ESCAPE) then ext=1
	
		''' Move swans	
		if swans=1 then	
		
			swans_move()
			swans_draw()	
			
			for i=0 to ubound(swan)
				with swan(i)
					if .active=1 then
						if collide3(player.x,player.y,(.px shl 5)+.sx+viewx, (.py shl 5)+.sy+viewy,playerzone,playerzone )>0 then
							hit=1
							exit for
						end if
					end if
				end with
			next i
		end if
		
		'' Move duck
		duck_update()
		duck_draw()
		
		if duck.active=1 then
			with duck
				if .xdir=1 then
					if collide3(player.x,player.y,.px+viewx,.py+viewy,playerzone,qright )>0 then
					hit=1
					end if
				else
					if collide3(player.x,player.y,.px+viewx,.py+viewy,playerzone,qleft )>0 then
					hit=1
					end if
				end if
				
				if collide3(player.x,player.y,.px+viewx,.py+viewy,playerzone,quack )>0 then
					hit=1
				end if
			end with
		end if
		
		'' Falling off screen!
		if player.y>sheight or player.y<=-32 then hit=1
		
		
		
		if hit=1 then
			lives-=1
		
			if lives>0 then
				infobox("You lost a life!")
			
				hit=0	
				'' Start positions
				swans_reset()
				duck_reset()
				player_reset()
			end if		
			
		end if
		
		'color rgb(255,255,255)
		'draw string (10,30),"px"+str(player.x)+" py"+str(player.y) 
		'draw string (10,45),"VX:"+str(viewx)+" VY:"+str(viewy)
		'draw string (10,60),"Duck:"+str(duck.active)
		
		''
		color rgb(255,0,255)
		draw string (10,0),"SCORE:"
		draw string (120,0),"TIME:" 
		draw string (220,0),"LEVEL:" 
		draw string (300,0),"LIVES:" 
		draw string (400,0),"EGGS:" 
	
		color rgb(255,255,0)
		draw string (60,0),str(player.score) ''"0000000"	
		draw string (170,0),str(tim) ''"999"	
		draw string (270,0),str(level) ''"000"	
		draw string (350,0),str(lives) '"000"
			
		draw string (450,0),str(player.eggs)+"/"+str(maxeggs)
		
		map_small()
	
		'' Screenshot
		if inkey="s" then
		        bsave "screen.bmp",0
		end if
	
		sleep 10,1
				
		'' Game timer
		lc+=1
		if lc>=50 then
			if tim>0 then tim-=1
			lc=0
		end if		
				
		if tim=0 then 
			tim=MAXTIME
			lives-=1
			infobox("Time Up!")
			
			if lives>0 then
				cls
				swans_clear()
				map_load(level)
				map_draw()
			end if
		end if
			
		if lives=0 then ext=1
		if player.eggs=maxeggs then ext=2 '' maxeggs
		'
		screencopy
	loop while ext=0

	if ext=2 then
	
		if level=(MAPS*3) then
			player.score+=tim
			infobox("All levels completed!")
			ext=1
		else 
			'' Next level
			level+=1
			levelmap+=1
			
			if levelmap>MAPS then levelmap=1
			
			if level=MAPS or level=(MAPS*2) then lives+=1
			
			if level>MAPS then swans=0 : duck.active=1
			if level>(2*MAPS) then swans=1 : duck.active=1
			
			player.score+=tim
		end if
			
	end if


loop while ext<>1 

if lives=0 then infobox("Game Over")

infobox("Final Score: "+str(player.score))
if player.score>hiscore then hiscore=player.score

loop

