''
'' Chuckie Egg Returns (2016) 
'' v0.4 by ssjx (http://ssjx.co.uk)
''
'' Duck
''

#include "header.bi"

''
''

common shared viewx as integer
common shared viewy as integer
common shared player as myplayer
common shared as integer swidth,sheight,sdepth

declare function collide3( as integer, as integer, as integer, as integer, as zone, as zone) as integer

''
''
common shared duck as swanpos 
''
''

dim shared as any ptr ducksprite(6)

sub duck_init()
	dim i as integer

	for i=0 to ubound(ducksprite)
		ducksprite(i) = ImageCreate( 64, 64,rgb(100,255,100) )
	next i
	
	bload "gfx\duck-r1.bmp",ducksprite(0) 'r1
	bload "gfx\duck-r2.bmp",ducksprite(1) 'r2'
	bload "gfx\duck-l1.bmp",ducksprite(2) 'l1
	bload "gfx\duck-l2.bmp",ducksprite(3) 'l2'
end sub

sub duck_set(dx as integer,dy as integer)
	with duck
		'.active=0
		.px=dx*32
		.py=dy*32
		.ox=.px
		.oy=.py	
	end with
end sub

sub duck_reset()
	with duck
		.px=.ox
		.py=.oy
	end with
end sub

sub drawcage(x as integer,y as integer)
	x-=8
	y-=8
	
	if x>-80 and x<swidth+80 then
		if y>-80 and y<sheight+80 then
		
		color rgb(204,102,0)
		
		line(x,y)-(x+80,y+80),,b
		line(x-1,y-1)-(x+81,y+81),,b
		
			for i as integer=0 to 80 step 16
			line(x+i,y)-(x+i,y+80),,b
			line(x+i+1,y)-(x+i+1,y+80),,b
			
			next i
		end if
	end if

end sub

sub duck_draw()
	dim as integer ax,ay

	with duck
		ax=.px+viewx
		ay=.py+viewy
	
		if .active=1 then
			'' Roaming!
			if .xdir=1 then	
				put (ax,ay),ducksprite(0+.alt),trans
			else
				put (ax,ay),ducksprite(2+.alt),trans
			end if
		else
			'' Caged!
			put (ax,ay),ducksprite(0+.alt),trans
			drawcage(ax,ay)
		end if
	end with
end sub



function duck_update() as integer
	dim as integer hitduck
	dim target as xy

	hitduck=0

	target.x=player.x-16
	target.y=player.y-24
	
	with duck
		' 
		if .sc>10 then
			.alt=1-.alt
			.sc=0
		else
			.sc+=1
		end if
		
		if .active=1 then
			if (.sc and 1) then
			
				if ((.px+viewx)<>target.x) then
					if (.px+viewx)>(target.x) then .xdir=-1 else .xdir=1
					.px+=.xdir
				end if
				'if .px<player.x then .xdir=1
				
				if (.py+viewy)>target.y then .py-=1
				if (.py+viewy)<target.y then .py+=1
			end if
		
		 	'draw string (10,70),"Play px: "+str(player.x)+" py: "+str(player.y)
			'draw string (10,80),"Duck px: "+str(.px)+" py: "+str(.py)
		end if
	
	end with
	
	return hitduck
end function
