//
// Centipede .Net6 (C# 2022) by ssjx ( http://ssjx.co.uk )
// 
// Based on the Javascript/Canvas game also by me.
//
// Compiles with:
// 		dotnet build -c Release

using System;
using System.Windows.Forms;
using System.Drawing;
//
using System.Timers;
//
using System.Runtime.InteropServices;

public class Centipede:Form
{	
	public struct Shotxy
	{
		public int a;
		public int x,y;
	}

	public struct Playerxy
	{
		public int x,y;
		public int inv,lives;
	}

	public struct Centxy
	{
		public int a,x,y,xdir,ydir;
		public bool head;
	}
		
	const string title="Centipede .Net";
	const string url="http://ssjx.co.uk";
	const string version="v0.2b (28/10/22)";
	
	const int swidth=480;
	const int sheight=480;
	
	// Keys
	bool up=false;
	bool down=false;
	bool left=false;
	bool right=false;
	bool fire=false;
		
	// Specific to this game
	int[] grid=new int[30*30];
	
	Centxy[] cent=new Centxy[100]; 
	Playerxy player=new Playerxy();
	Shotxy[]  shot=new Shotxy[20]; 
	
	int score=0,time=0,hiscore=10,level=1,clen=10;
	
	int alt=0;
	int fc=0;	
	int firecount=0;
	
	// Large Text	
	int[] over_text={
	2,1,1,1,0,0,1,1,0,0,1,0,0,0,1,0,1,1,1,2,
	1,0,0,0,0,1,0,0,1,0,1,1,0,1,1,0,1,0,0,0,
	1,0,1,1,0,1,1,1,1,0,1,0,1,0,1,0,1,1,1,0,
	1,0,0,1,0,1,0,0,1,0,1,0,0,0,1,0,1,0,0,0,
	1,1,1,1,0,1,0,0,1,0,1,0,0,0,1,0,1,1,1,2,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	2,1,1,1,0,1,0,0,0,1,0,1,1,1,1,0,1,1,1,2,
	1,0,0,1,0,1,0,0,0,1,0,1,0,0,0,0,1,0,0,1,
	1,0,0,1,0,1,0,0,0,1,0,1,1,1,0,0,1,1,1,0,
	1,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,1,0,0,1,
	1,1,1,1,0,0,0,1,0,0,0,1,1,1,1,0,1,0,0,2,
	};
	
	int[] title_text={
	1,1,1,0,1,1,1,0,1,0,0,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,1,0,0,1,1,1,
	1,0,0,0,1,0,0,0,1,1,0,1,0,0,1,0,0,0,1,0,0,1,0,1,0,1,0,0,0,1,0,1,0,1,0,0,
	1,0,0,0,1,1,0,0,1,0,1,1,0,0,1,0,0,0,1,0,0,1,1,1,0,1,1,0,0,1,0,1,0,1,1,0,
	1,0,0,0,1,0,0,0,1,0,0,1,0,0,1,0,0,0,1,0,0,1,0,0,0,1,0,0,0,1,0,1,0,1,0,0,
	1,1,1,0,1,1,1,0,1,0,0,1,0,0,1,0,0,1,1,1,0,1,0,0,0,1,1,1,0,1,1,0,0,1,1,1,
	};
	
	public enum State{WELCOME,GAME,OVER}
	State gamestate=State.WELCOME;
	
	// For sprites
	static Image mushroom_img,cent_img,player_img;
	
	Rectangle dest=new Rectangle(0, 0, 16, 16);
	Rectangle src=new Rectangle(0, 0, 16, 16);
	static  GraphicsUnit units = GraphicsUnit.Pixel;
		
	System.Timers.Timer aTimer = new System.Timers.Timer();
	
	Font smlFont=new Font("Arial",12);
	Font medFont=new Font("Arial",14);
	Font bigFont=new Font("Arial",18);
	
	public Centipede()
	{
		this.Text = title+" "+version;
		this.ClientSize = new Size(swidth, sheight);
		
		this.Paint += new PaintEventHandler(f1_paint);
		this.DoubleBuffered = true;
		
		this.KeyPreview = true;
		this.KeyPress +=new KeyPressEventHandler(Form1_KeyPress);
		
		this.KeyUp +=new KeyEventHandler(Form1_KeyUp);
		this.KeyDown +=new KeyEventHandler(Form1_KeyDown);
		
		this.BackColor= Color.FromArgb(0, 0, 0);
		
		// Tidy window
		this.FormBorderStyle = FormBorderStyle.FixedSingle;
		this.MaximizeBox = false;
		
		//
		//System.Timers.Timer aTimer = new System.Timers.Timer();
		aTimer.Elapsed+=new ElapsedEventHandler(OnTimedEvent);
		// Set the Interval to 1 millisecond.  Note: Time is set in Milliseconds
		aTimer.Interval=(20); //(10);
		aTimer.Enabled=true;
		
		for(int i=0;i<cent.Length;i++){
			cent[i]=new Centxy();
		}
		
		for(int i=0;i<shot.Length;i++){
			shot[i]=new Shotxy();
		}
		
		mushroom_img = new Bitmap(@"mushroom.gif");
		player_img = new Bitmap(@"player.gif");
		cent_img = new Bitmap(@"cent.gif");
		
		//Console.WriteLine("{0} x {1}",this.ClientSize.Width,this.ClientSize.Height);
		setstate(gamestate);
	}

	void reset(){
		for (int i=0;i<cent.Length;i++){
			cent[i].a=-1;
		}
		
		int clen=10;
		
		for (int i=0;i<clen;i++){
			cent[i].head=false;
			cent[i].a=1;
			cent[i].x=-i;
			cent[i].y=1;
			cent[i].xdir=1;
			cent[i].ydir=1;
		}
		cent[0].head=true;
	
	
		for (int i=0;i<shot.Length;i++){
			shot[i].a=0;
		}
		
		player.x=15;
		player.y=27;
		player.lives=3;
	
		// Array.Fill(grid,0);
		for(int i=0;i<grid.Length;i++){
			grid[i]=0;
		}
		
	 	add_mushrooms(50);
		
		up=false;
		down=false;
		left=false;
		right=false;
		
		fire=false;
		firecount=0;
		
		score=0;
		time=5;
	}
	
	
	void add_mushrooms(int no)
	{
		int pos=0;
		const int mx=(30*30)-(6*30);
		Random r = new Random();
			
		for (int i=0;i<no;i++){
			pos=60+(int)(r.Next(mx));
			grid[pos]=4;
		}
	}
	
	void next_level()
	{
		int i=0;
	
		level++;
		score+=time;
		time=199;
	
		for (i=0;i<cent.Length;i++)
		{
			cent[i].a=-1;
		}
	
		// Safety check first...
		if (clen+2<cent.Length){clen+=2;}
		
		for (i=0;i<clen;i++)
		{
			cent[i].head=false;
			cent[i].a=1;
			cent[i].x=-i;
			cent[i].y=1;
			cent[i].xdir=1;
			cent[i].ydir=1;
		}
		
		cent[0].head=true;
		
		// More mushrooms
		add_mushrooms(5);
	}
	
	void setstate(State s)
	{
		switch(s)
		{
		case State.WELCOME:
			aTimer.Interval=100;
			// when we go from over/complete back to title
			if (score>hiscore){hiscore=score;}
		break;
		
		case State.GAME:
			aTimer.Interval=20;
			reset();
		break;
		}
		
		gamestate=s;
	}
	
	private void f1_paint(object sender,PaintEventArgs e)
	{
		switch (gamestate)
		{
		case State.WELCOME:
			draw_bg(e.Graphics);
			draw_title(e.Graphics);
			draw_footer(e.Graphics);
		break;
		
		case State.GAME:
			draw_bg(e.Graphics);
			draw_game(e.Graphics);
			
			if (cent_hit()==1 && player.inv==0){
				player.lives--;
				
				if (player.lives<0){
					setstate(State.OVER);
				}else{
					player.inv=10;
				}
			}
	
			alt=1-alt;
			fc++;
			
			if (fc>1){
				shot_update();
			}
			
			if (fc>=4){
				cent_update();
				fc=0;
			}
			
		break;
		
		case State.OVER:
			draw_bg(e.Graphics);
			draw_game(e.Graphics);
			draw_gameover(e.Graphics);
		break;
		}
	}
	
	//
	//
	//
	
	void draw_bg(Graphics g)
	{
	//	g.fillStyle = "black";
	//	g.fillRect(0,0,swidth,sheight);
	}
	
	void draw_footer(Graphics g)
	{
		// Footer		
		Size textSize = TextRenderer.MeasureText(version, smlFont);
		int xs=(swidth-textSize.Width);
		const int y=sheight-18;

		TextRenderer.DrawText(g, version, smlFont, new Point(xs, y), Color.Cyan);
		TextRenderer.DrawText(g, url, smlFont, new Point(2, y), Color.Cyan);
	}
	
	
	
	void draw_title(Graphics g)
	{
		int i,j;

		// Large Text
		const int sz=12;
		const int ofy=sz*4; //(canvas.height-(9*sz))>>1; //(8*16)
		const int ofx=(swidth-(36*sz))>>1;
		int c=0;
		
		src.X=(16*3);
		src.Y=0;
		
		for(j=0;j<5;j++)
		{
			dest.Y=ofy+(j*sz);
			for(i=0;i<36;i++)
			{
				if (title_text[c]>0)
				{
					dest.X=ofx+(i*sz);	
					if (mushroom_img!=null){
						g.DrawImage(mushroom_img,dest,src,units);
					}
				}
				c++;
			}
		}
	
		src.X=(16*1);
		src.Y=0;
		if (cent_img!=null){
			for(i=0;i<36;i++){
				dest.X=ofx+(i*sz);
				dest.Y=ofy-(2*sz);	
				g.DrawImage(cent_img,dest,src,units);
				
				dest.Y=ofy+(6*sz);
				g.DrawImage(cent_img,dest,src,units);
			}
		}
	
		// Main text
		string[] line=new string[10];
		line[0]="Use the arrows and space key to";
		line[1]="defeat the centipede!";
		line[2]="";
		line[3]="High Score";
		line[4]=""+hiscore;
		line[5]="";
		line[6]="Recent Score";
		line[7]=""+score;
		line[8]="";	
		line[9]="Press Space to start!";
				
		Color txtcolor;	
		const int y=192-20;
		string txt="";
		
		for(i=0;i<line.Length;i++) 
		{	
			switch(i)
			{
			case 3:
			case 6:
				txtcolor = Color.Orange;
			break;
			case 9:
				txtcolor = Color.Yellow;
			break;
			default:
				txtcolor = Color.White;
			break;
			}
		
			txt=line[i];
	
			Size textSize = TextRenderer.MeasureText(txt, bigFont);
			int fx=(swidth-textSize.Width)/2;
			int fy=y+(i*24); //20
	
			TextRenderer.DrawText(g, txt, bigFont, new Point(fx, fy), txtcolor);
		}
		
	}

	void draw_game(Graphics g)
	{
		int i,j;
		int c=0;
		const int sz=16;
			
		// Draw Shot
		if (player_img!=null){
			for(i=0;i<shot.Length;i++){
				if (shot[i].a==1){
					src.X=(1*sz);
					src.Y=0;
		
					dest.X=shot[i].x*16;
					dest.Y=shot[i].y*16;
					g.DrawImage(player_img,dest,src,units);
				}
			}
		}
	
		// Draw mushrooms
		if (mushroom_img!=null){
			for(j=0;j<30;j++){
				dest.Y=j*16;
				for(i=0;i<30;i++){	
					if (grid[c]>0){
						int mush=grid[c]-1 ;//3-(grid[c]-1)
						
						src.X=(mush*sz);
						src.Y=0;
			
						dest.X=i*16;
						g.DrawImage(mushroom_img,dest,src,units);
					}
					c++;
				}
			}
		}
	
		// Draw Centipede
		if (cent_img!=null){
			src.Y=0;
			for(i=0;i<cent.Length;i++){
				if (cent[i].a==1 && cent[i].x>=0){
					dest.X=cent[i].x*16;
					dest.Y=cent[i].y*16;
						
					if (cent[i].head==false){
						src.X=0;	
						g.DrawImage(cent_img,dest,src,units);
					}else{
						src.X=1*sz;
						g.DrawImage(cent_img,dest,src,units);
					}
				}
				
				if (cent[i].a==-1){break;}
			}
		}
		
		// Draw Player
		if (player_img!=null){
			src.X=0;
			src.Y=0;

			dest.X=player.x*16;
			dest.Y=player.y*16;
						
			if (player.inv>0){
				player.inv--;
				// Flash
				if (alt==1){
					g.DrawImage(player_img,dest,src,units);
				}
			}else{
				// Standard
				g.DrawImage(player_img,dest,src,units);
			}
		}
		
		//
		// Controls
		//
		
		if (left==true && gridpos(player.x-1,player.y)==0){
			if (player.x>0){player.x--;};	
		}
		
		if (right==true && (player.x+1)<=29){
			if (gridpos(player.x+1,player.y)==0){player.x++;};
		}
	
		if (up==true && gridpos(player.x,player.y-1)==0){
			if (player.y>21){player.y--;};
		}
		
		
		if (down==true && (player.y+1)<=29){
			if (gridpos(player.x,player.y+1)==0){player.y++;};
		}
	
		if (firecount==0){
			if (fire==true){
				shot_add(player.x,player.y);	
				firecount=5;
			}
		}else{
			firecount--;
		}
			
		// Lives (Left)
		src.X=0;
		src.Y=0;
		if (player_img!=null){
			for(i=0;i<player.lives;i++)
			{
				dest.X=(i*16);
				dest.Y=0;
				g.DrawImage(player_img,dest,src,units);
			}
		}
		// Score (Right)
		string txt=""+score;
		Size textSize = TextRenderer.MeasureText(txt, medFont);
		int xs=(swidth-textSize.Width);
		int y=0;//12;
		
		TextRenderer.DrawText(g, txt, medFont, new Point(xs, y), Color.Yellow);
	}
	
	void draw_gameover(Graphics g)
	{
		const int sz=16;
		int i,j,c=0;
		int mush=0;
		
		//
		// Draw dark mushrooms
		//
		if (mushroom_img!=null){
			src.X=(mush*sz);
			src.Y=0;
			
			for(j=0;j<30;j++)
			{
				dest.Y=(j*16);
				for(i=0;i<30;i++)
				{	
					if (grid[c]>0)
					{
						dest.X=(i*16);
						g.DrawImage(mushroom_img,dest,src,units);
					}
					c++;
				}
			}
		}
		
		//
		// Large Text
		//
		const int ofx=(swidth-(20*16))>>1;
		const int ofy=(8*16);
		
		if (cent_img!=null){
			c=0;
			src.X=16;
			src.Y=0;
						
			for(j=0;j<11;j++)
			{
				dest.Y=ofy+(j*16);
				for(i=0;i<20;i++)
				{
					if (over_text[c]>0)
					{
						dest.X=ofx+(i*16);
						g.DrawImage(cent_img,dest,src,units);
					}
					c++;
				}
			}
		}
		
		//
		// Highscore?
		//
		if (score>hiscore)
		{
			const string txt="You have a new high score!";
			const int y=364-20;
		
			Size textSize = TextRenderer.MeasureText(txt, bigFont);
			int xs=(swidth-textSize.Width)/2;
			
			TextRenderer.DrawText(g, txt, bigFont, new Point(xs, y), Color.Yellow);	
		}
	}
	
	void draw_welldone(Graphics g)
	{	
	}
	
	//
	// Centipede
	//
	
	void cent_update()
	{
		int newx=0,newy=0;
	
		for(int i=0;i<clen;i++)//cent.Length
		{
			if (cent[i].y==1 && cent[i].x<0)
			{
				newx=0;
			}
			else
			{
				newx=cent[i].x+cent[i].xdir;
			}
		
			if (newx>29 || newx<0)
			{
				cent[i].xdir*=-1;
			
				newy=cent[i].y+cent[i].ydir;
				
				if (newy<0 || newy>29)
				{
					cent[i].ydir*=-1;
				}
			
				if (cent[i].ydir==-1 && newx>29 &&newy<=20)
				{
					cent[i].ydir*=-1;
				}
			
				cent[i].y+=cent[i].ydir;
			}
			else
			{
				if (gridpos(cent[i].x+cent[i].xdir,cent[i].y)==0)
				{
					cent[i].x+=cent[i].xdir;
				}
				else
				{
					cent[i].xdir*=-1;
				
					newy=cent[i].y+cent[i].ydir;
					if (newy<0 || newy>29)
					{
						cent[i].ydir*=-1;
					}
				
					if (cent[i].ydir==-1 && newy<=20)
					{
						cent[i].ydir*=-1;
					}
					
					cent[i].y+=cent[i].ydir;	
				}
			}	
		}
	}
	
	
	int cent_check()
	{
		int ln=0;
		
		for(int i=0;i<cent.Length;i++)
		{
			if (cent[i].a==1){ln++;}
		}
		return ln;
	}
	
	// Player hit/moved onto centipede?
	int cent_hit()
	{
		if (player.inv>0){return 0;}
		
		for(int i=0;i<clen;i++)//cent.Length
		{
			if (cent[i].a==1)
			{
				if (cent[i].x==player.x && cent[i].y==player.y)
				{
				return 1;
				}
			}
		}
		
		return 0;
	}
	
	// See if part of centipede is a head!
	void cent_head()
	{
		for(int i=1;i<clen;i++)//cent.Length
		{
			if (cent[i-1].a==0){cent[i].head=true;}
		}
	}
	//
	//
	//
	
	void shot_add(int x,int y)
	{
		for(int i=0;i<shot.Length;i++)
		{
			if (shot[i].a==0)
			{
			shot[i].a=1;
			shot[i].x=x;
			shot[i].y=y;
			break;
			}
		}
	}
	
	void shot_update()
	{
		int c=0;
	
		for(int i=0;i<shot.Length;i++)
		{
			if (shot[i].a==1)
			{
				if (shot[i].y<0)
				{
					shot[i].a=0;
					//break;
				}
				else
				{
					// Hit centipede
					for(c=0;c<cent.Length;c++)
					{
						if (cent[c].a==1)
						{
							if (cent[c].x==shot[i].x && cent[c].y==shot[i].y)
							{
								score+=10;
								shot[i].a=0;
								cent[c].a=0;
								grid_set(cent[c].x,cent[c].y,4);	// Add Mushroom
								
								//
								if (cent_check()==0)
								{
								next_level();
								}
								cent_head();
							}
						}
					}
					
					if (shot[i].a==1)
					{
						// Hit mushroom
						int gp=gridpos(shot[i].x,shot[i].y);
						if (gp>0)
						{
							grid_set(shot[i].x, shot[i].y, gp-1); //gp-1	
							shot[i].a=0;
							
							// Removed mushroom!
							if (gridpos(shot[i].x,shot[i].y)==0)
							{
							score+=10;
							}
						}
					}
					
					// If shot is still active...
					if (shot[i].a==1)
					{
						shot[i].y--;
					}
				}
			}
		}
	}
	
	//
	//
	//
	
	void grid_set(int x,int y,int v)
	{
		int pos=(y*30)+x;
		grid[pos]=v;
	}
	
	int gridpos(int x,int y)
	{
		int pos=(y*30)+x;
		if (pos<0){return 0;}
		return grid[pos];
	}
	
	//
	//
	//
	
	private void OnTimedEvent(object source, ElapsedEventArgs e)
	{ 	
    	this.Invalidate();
	}
    
	//
	// Keyboard
	//
	/*
	void Form1_KeyUp(object sender, KeyEventArgs e)
    {	
    	byte[] keys = new byte[256];
		GetKeyboardState(keys);
		
		if ((keys[(int)Keys.Up] & 128 ) == 128){up=true;}else{up=false;}
    	if ((keys[(int)Keys.Down] & 128 ) == 128){down=true;}else{down=false;}
    	if ((keys[(int)Keys.Left] & 128 ) == 128){left=true;}else{left=false;}
    	if ((keys[(int)Keys.Right] & 128 ) == 128){right=true;}else{right=false;}
	
    	if ((keys[(int)Keys.Space] & 128 ) == 128){fire=true;}else
		{
			//fire=false;
			switch(gamestate)
			{
				//case State.WELCOME:setstate(State.GAME);break;
				case State.GAME:fire=false;break;
				//case State.OVER:setstate(0);break;
			}
		}
    }
	*/
	
	void Form1_KeyUp(object sender, KeyEventArgs e){
		// System.out.println("Key Released!");
		switch (gamestate){
			case State.GAME: 
				switch(e.KeyCode){
					case Keys.Right:
						right=false;
					break;
					case Keys.Left:
						left=false;
					break;
					case Keys.Up:
						up=false;
					break;
					case Keys.Down:
						down=false;
					break;
					case Keys.Space:
						fire=false;
					break;
				}
			break;			
		}
	}
	
	void Form1_KeyDown(object sender, KeyEventArgs e){
		var kc=e.KeyCode;
		
	    switch (gamestate){
			case State.GAME:  
				switch(kc){
					case Keys.Up:
						up=true;
					break;

					case Keys.Down:
						down=true;	
					break;

					case Keys.Left:
						left=true;
						right=false;	// in case it does not stop...
					break;

					case Keys.Right:
						right=true;
						left=false;		// in case it does not stop...
					break;
				}

				if (kc==Keys.Space){fire=true;}
			break;
		}
	}
	
	void Form1_KeyPress(object sender, KeyPressEventArgs e)
    {
	    switch (gamestate)
		{
		case State.WELCOME:  	
	  		if (e.KeyChar==(char)Keys.Escape){this.Close();}
			if (e.KeyChar==(char)Keys.Space){setstate(State.GAME);}
		break;
		
		case State.GAME:  	
	  		if (e.KeyChar==(char)Keys.Escape){setstate(State.WELCOME);}
	  		if (e.KeyChar==(char)Keys.Q){setstate(State.OVER);}
		break;
		
		case State.OVER:  	
	  		if (e.KeyChar==(char)Keys.Escape){setstate(State.WELCOME);}
	  		if (e.KeyChar==(char)Keys.Space){setstate(State.WELCOME);}
		break;
		}
	}

	public static void Main()
	{
		Application.EnableVisualStyles();
		Application.Run(new Centipede());
	}
	
}