'' Adventure for Breakfast by ssjx (15/01/11) [http://ssjx.co.uk]
'' ==============================================================
''
''
'' Various UI related stuff
''
#include "header.bi"

'' in asm.bas
declare sub screendim()

''in inventory
declare function inventory_itemcheck( as string,  as integer) as integer

dim shared sprite(20) as any ptr 

common shared as integer swidth,sheight,sdepth

common shared bar_title as string

common shared player as myplayer

common shared inventory() as item

common shared mytasks() as task

const as integer wx=100,wy=50,ww=440,wh=320 '' wh = 280

''

common shared ui_text() as string
dim shared ui_text(20) as string

sub ui_load()
	dim path as string="gfx/ui/"
	dim i as integer	
	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i
	
	bload path+"box.bmp",sprite(0)
	bload path+"apple.bmp",sprite(1)
	bload path+"strawberry.bmp",sprite(2)	
	bload path+"cherry.bmp",sprite(3)
	bload path+"fish.bmp",sprite(4)
	bload path+"diamond.bmp",sprite(5)
	bload path+"milk.bmp",sprite(6)
	bload path+"oats.bmp",sprite(7)
	bload path+"sweets.bmp",sprite(8)
	
	path="gfx/stones/"
	bload path+"air.bmp",sprite(9)
	bload path+"earth.bmp",sprite(10)
	bload path+"fire.bmp",sprite(11)
	bload path+"water.bmp",sprite(12)
			
	'' add a border to each ui element
	for i=1 to ubound(sprite)
		put sprite(i),(0,0),sprite(0),trans
	next i
	
end sub

sub ui_bar()
	dim as integer i,x,y
	dim as integer isprite,iqty
	dim as string text
	
	'' clear bar
	Line (0, sheight-64)-(swidth, sheight), rgb(0,0,0), bf
	''
		
	if left(bar_title,1)="#" then
		'' yellow info bar
		text=right(bar_title,len(bar_title)-1)
		Line (0, sheight-64)-(swidth-1, sheight-48), rgb(255,255,0), bf
		color rgb(0,0,0)
		draw string (10,sheight-64+1),text
	else
		if left(bar_title,1)="%" then
			''red bar
			text=right(bar_title,len(bar_title)-1)
			Line (0, sheight-64)-(swidth-1, sheight-48), rgb(200,0,0), bf
			color rgb(0,0,0)
			draw string (10,sheight-64+1),text
		else
			color rgb(255,255,255)
			draw string (10,sheight-64+1),bar_title
		end if
	
	'	color rgb(255,255,255)
	'	draw string (10,sheight-64+1),bar_title
	end if
	
	
	Line (0, sheight-64)-(swidth-1, sheight-48), rgb(255,0,0), b
	
	
	'Line (0+10, sheight-64+10)-(swidth-10, sheight-10), rgb(255,0,0), b
	
	y=sheight-32-8
	
	for i=0 to 10
		isprite=0
		iqty=0
		with inventory(i)
			if .name="Apple" then isprite=1 :  iqty=.quantity
			if .name="Strawberry" then isprite=2 :  iqty=.quantity
			if .name="Cherry" then isprite=3 :  iqty=.quantity
			if .name="Fish" then isprite=4 : iqty=.quantity
			if .name="Diamond" then isprite=5 :  iqty=.quantity
			
			if .name="Milk" then isprite=6 : iqty=.quantity
			if .name="Oats" then isprite=7 :  iqty=.quantity
			if .name="Sweets" then isprite=8 :  iqty=.quantity
			
			if .name="Air_Stone" then isprite=9 : iqty=.quantity
			if .name="Earth_Stone" then isprite=10 : iqty=.quantity
			if .name="Fire_Stone" then isprite=11 : iqty=.quantity
			if .name="Water_Stone" then isprite=12 : iqty=.quantity
			
		end with
		
		x=8+(i*40) 'x=8+(i*32)+(8*i)

		put (x,y),sprite(isprite),trans
		
		if iqty>1 then
			color rgb(0,0,200)
			draw string (x+20,y+15),str(iqty)
			color rgb(255,255,255)
			draw string (x+21,y+16),str(iqty)
			
		end if
	next i

	

end sub 


sub ui_frame()

	screenlock
	screendim()
	
'	const as integer x=100,y=50,w=440,h=280
	
	'' clear bar
	
	Line (wx, wy)-(wx+ww, wy+wh), rgb(0,0,0), bf
	Line (wx, wy)-(wx+ww, wy+wh), rgb(0,255,0), b
	''
	color rgb(255,200,0)
	draw string (wx+10,wy+wh-20),"Press Space to continue..."
	screenunlock
end sub

sub ui_cleartext()
	dim i as integer
	for i=0 to ubound(ui_text)
		ui_text(i)=""
	next i
end sub 


sub ui_smallwindow(txt as string)
const as integer x=10,y=10,w=330,h=15

	Line (x, y)-(x+w, y+h), rgb(0,0,0), bf
	Line (x, y)-(x+w, y+h), rgb(0,255,0), b
	
	'Line (wx, wy)-(wx+ww, wy+wh), rgb(0,255,0), b
	''
	color rgb(255,255,255)
	draw string (x+10,y+1),txt

end sub

''
'' This is it's own function as it caused problems below if called
'' within screenlock/unlock
''

sub ui_waitspace()
	dim as integer ext=0,spacepressed=0,escapepressed=0
	
	'' wait for space up
	do
	
		if  MultiKey(SC_SPACE) then
			spacepressed=1
			
		end if
		
		if MultiKey(SC_SPACE)=0 and spacepressed=1 then
			ext=1
		end if	
			
		''	
		if  MultiKey(SC_ESCAPE) then
			escapepressed=1
		end if	
		
		if MultiKey(SC_ESCAPE)=0 and escapepressed=1 then
			ext=1
		end if
			
		sleep 10
	loop until ext=1
	While Inkey <> "": Wend
end sub	

function ui_waitescape() as integer
	dim as integer ext=0,spacepressed=0,escapepressed=0
	
	'' wait for space up
	do
	
		if  MultiKey(SC_SPACE) then
			spacepressed=1
			
		end if
		
		if MultiKey(SC_SPACE)=0 and spacepressed=1 then
			return SC_SPACE
		end if	
			
		''	
		if  MultiKey(SC_ESCAPE) then
			escapepressed=1
		end if	
		
		if MultiKey(SC_ESCAPE)=0 and escapepressed=1 then
			return SC_ESCAPE
		end if
			
		sleep 10
	loop until ext=1
	While Inkey <> "": Wend
end function	


sub ui_basicwindow()
	dim as integer i ',ext,spacepressed=0
	dim as string text
	
'	const as integer x=100,y=50
	
	ui_frame()
	
	color rgb(255,255,255)
	
	for i=0 to  ubound(ui_text)
	
		text=ui_text(i)
		'draw string (x+10,y+10+(i*15)),ui_text(i)
		
		if left(text,1)="%" then

			text=right(text,len(text)-1)
			'color rgb(50,200,0)
			color rgb(0,153,255)
			
			draw string (wx+10,wy+10+(i*15)),text
		else
			color rgb(255,255,255)
			draw string (wx+10,wy+10+(i*15)),text
		end if

	next i

end sub 

sub ui_window()
	ui_basicwindow()
	ui_waitspace()
end sub 




	


''
'' Show tasks and status of them
''
sub ui_tasklist()
	dim as integer i,r,offset=0,rpos=0
	dim as integer taskcount=0,havetask=0
	dim as string rtext

	'dim as integer x=100+10,y=50+10	
	ui_frame()

	color rgb(0,200,0)
	for i=0 to 5
		
		with mytasks(i)
			if .active=1 then
				havetask=1
				color rgb(255,200,0)
				draw string (wx+10,wy+10),str(i+1)+". "+.name
				
				color rgb(0,200,255)
				draw string (wx+10,wy+30),.desc
		
				for r=0 to 5
					if .required(r).quantity=0 then exit for
					
					if inventory_itemcheck(.required(r).name,.required(r).quantity)=1 then
						color rgb(0,200,0)
					else
						color rgb(200,0,0)
					end if
					
					rtext=.required(r).name
					
					rpos=instr(rtext,"_")
					if rpos>0 then rtext[rpos-1]=32
					
					draw string (wx+10+20,wy+50+(r*20)),str(.required(r).quantity)+"x "+rtext
					
				next r		
			end if
		end with
	
		'offset+=40+((r+1)*20)
	
	next i
	
	if havetask=0 then
		color rgb(255,200,0)
		draw string (wx+10,wy+10),"You currently have no tasks..."
	end if
	
sleep

end sub
