'' Adventure for Breakfast by ssjx (15/01/11) [http://ssjx.co.uk]
'' ==============================================================
''
''
'' Shop!
''


#include "bmp.bi"
#include "header.bi"
#include "fmod.bi"

'' in inventory.bas
declare sub inventory_add(as string)
declare sub inventory_remove(as string,as integer)
declare function inventory_count( as string) as integer
'' Sound samples
common shared sample() As Integer
''
''
declare sub ui_window()
''
common shared player as myplayer
common shared bar_title as string
common shared game as integer

dim shared as integer spacepressed=0
dim shared tplayer as myplayer

dim shared sprite(20) as any ptr 
dim shared map(20,13) as integer

sub shop_exit()

	player.x=tplayer.x
	player.y=tplayer.y
	player.mx=tplayer.mx
	player.my=tplayer.my

	player.ox=0
	player.oy=0
	player.xdir=0
	player.ydir=0
	
		
end sub

sub shop_start()
	
	'' entry point
	tplayer.x=player.x
	tplayer.y=player.y
	tplayer.mx=player.mx
	tplayer.my=player.my
	
	'' find and set start
	
	player.mx=0
	player.my=0
	player.ox=0
	player.oy=0
	player.xdir=1
	player.x=0
	player.y=11



end sub

sub shop_initsprites()
	dim i as integer
		
	for i=0 to 15
		sprite(i) = ImageCreate( 32, 32,rgb(0,0,0) )
	next i
end sub

sub shop_loadsprites()

	const path as string="gfx/shop/"

	bload path+"block.bmp",sprite(1)
	bload path+"infoblock.bmp",sprite(2)
	
	bload path+"milk.bmp",sprite(3)
	bload path+"oats.bmp",sprite(4)
	bload path+"sweets.bmp",sprite(5)
	bload "gfx/stones/fire.bmp",sprite(6)
	''' Skip #7 (block)

end sub

sub shop_loadmap()

	dim as ubyte r,g,b
	dim as integer i,j
	dim header as bmphdr
	dim as uinteger mapwidth,mapheight
	const path as string="maps/shop.bmp"

	'' load the map
	if  Open(path For binary access read As #1)=0 then
		get #1,,header
		
		mapwidth=header.w
		mapheight=header.h
		
		for j=0 to 12
			for i=0 to 19
				map(i,j)=0
			next i
		next j
		
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)        
	                	get #1, ,b,1
				get #1, ,g,1
				get #1, ,r,1
				
				'' block
				if (r=192 and g=192 and b=192) then map(i,(mapheight-1)-j)=7
				
				'' block
				if (r=0 and g=0 and b=0) then map(i,(mapheight-1)-j)=1
				
				'' infoblock
				if (r=255 and g=255 and b=0) then map(i,(mapheight-1)-j)=2
				
				'' milk
				if (r=255 and g=128 and b=128) then map(i,(mapheight-1)-j)=3
				
				'' oats
				if (r=255 and g=255 and b=128) then map(i,(mapheight-1)-j)=4
				
				'' sweets
				if (r=128 and g=255 and b=128) then map(i,(mapheight-1)-j)=5
				
				'' fire stone (only for sale if we don't already have it)
				if inventory_count("Fire_Stone")=0 then
					if (r=0 and g=255 and b=128) then map(i,(mapheight-1)-j)=6
				end if
					
			next i
		next j
		
			
	        Close #1    
	else
		bar_title="#Load Error!"	
	 	ui_window()
	end if


end sub


sub shop_drawmap()
	dim as integer i,j,d
'	line (0,0)-(640,224),rgb(50,150,250),bf	
'	line (0,224)-(640,440),rgb(40,0,0),bf
	
	'' clear bg
	line (0,240)-(640,440),rgb(00,0,0),bf
	
	for j=0 to 11
		line (0,(j*20)) -(640,(j+1)*20),rgb(0,j*12,255),bf
	next j
	
	
	for j=0 to 12
		for i=0 to 19
			'if map(i,j)>2 then put (i*32,j*32),sprite(0),pset
			if map(i,j)<>7 then put (i*32,j*32),sprite(map(i,j)),trans '' map(i,j),trans
		next i
	next j
	



	if map(player.x,player.y+1)=2 then
		d=inventory_count("Diamond")
			
		select case as const map(player.x,player.y-3)
		case 0:
			'' nothing...
		case 3
			bar_title="Pint of Milk = 5 Diamonds"		
			if d<5 then bar_title="%"+bar_title+" (You only have "+str(d)+")"
	
		case 4
			bar_title="Box of Oats = 5 Diamonds"
			if d<5 then bar_title="%"+bar_title+" (You only have "+str(d)+")"
	
	
		case 5
			bar_title="Sweets = 5 Diamonds"
			if d<5 then bar_title="%"+bar_title+" (You only have "+str(d)+")"
	
		case 6
			bar_title="Fire Stone = 40 Diamonds!"
			if d<40 then bar_title="%"+bar_title+" (You only have "+str(d)+")"
		
		case else
			bar_title="That item is not for sale... ["+str(map(player.x,player.y-3))+"]"
		
		end select
	else
		bar_title="Buy things in this little shop! Stand under the item and press [Space] to buy!"
	
	
	end if
	
end sub

sub shop_purchase()
dim as integer itemcost,d


	if map(player.x,player.y+1)=2 then
	
		d=inventory_count("Diamond")
	
		select case as const map(player.x,player.y-3)
		case 3
			itemcost=5
			if d>=itemcost then
				inventory_add("Milk")
				inventory_remove("Diamond",itemcost)
				FSOUND_PlaySound(FSOUND_FREE, sample(0))
			end if
			
		case 4
			itemcost=5
			if d>=itemcost then
				inventory_add("Oats")
				inventory_remove("Diamond",itemcost)
				FSOUND_PlaySound(FSOUND_FREE, sample(0))
			end if
			
		case 5
			itemcost=5
			if d>=itemcost then
				inventory_add("Sweets")
				inventory_remove("Diamond",itemcost)
				FSOUND_PlaySound(FSOUND_FREE, sample(0))
			end if
		case 6
			itemcost=40
			if d>=itemcost then
				inventory_add("Fire_Stone")
				inventory_remove("Diamond",itemcost)
				FSOUND_PlaySound(FSOUND_FREE, sample(0))
				map(player.x,player.y-3)=0
			end if
		case else
			bar_title="That item is not for sale... ["+str(map(player.x,player.y+1))+"]"
		
		end select
	else
		bar_title="Stand on a yellow platform to buy things"
	
	
	end if


end sub

sub shop_controls()
''
	''
	'' Player controls
	''
	with player
	
	if .xdir=0 and .ydir=0 then
	
		
		if  MultiKey(SC_LEFT) then
		
			if (.x=0) then
				game=MODE_RPG
				goto eokeys:
			else
				if (map(.x-1, .y)=0) then
					.xdir=-1
					goto eokeys:
				end if
			end if
		end if
		
		
		if  MultiKey(SC_RIGHT)then	
			if (map(.x+1, .y)=0) then
				.xdir=1					
				goto eokeys:		
			end if	
		end if
		
		if  MultiKey(SC_SPACE) then
			spacepressed=1
		end if
		
		if MultiKey(SC_SPACE)=0 and spacepressed=1 then
			spacepressed=0
			shop_purchase
			'' see if we can buy item above plus some info if on a step
			
			''
		
		end if
		'if .xdir=1 then .s=0 else 
		eokeys:
	end if
	

	'' Move 	
	if .xdir<>0 then
	
		.ox+=(2*.xdir)
		
		if .xdir=1 then
			if abs(.ox)<16 then
			 .s=5
			else
			 .s=0
			end if	
		end if
		
		if .xdir=-1 then
			if abs(.ox)<16 then
			 .s=6
			else
			 .s=1
			end if	
		end if
		
		if abs(.ox)=30 then
			.ox=0
			.x+=.xdir	
			.xdir=0
		end if	
	
	end if

	
	end with

	''
	'''
end sub
