'' Adventure for Breakfast by ssjx (15/01/11) [http://ssjx.co.uk]
'' ==============================================================
''
''
'' Non Player Characters
''
#include "header.bi"

common shared map() as xypos
common shared player as myplayer
common shared bar_title as string

dim shared general_talk(5) as string
dim shared sprite(10) as any ptr
dim shared npc(10) as myplayer 
dim shared as integer npc_count=0

dim shared as integer alt=0
dim shared as integer altc=0


sub npc_init()
	dim as integer i

	const path as string="gfx/town1/npc/"

	for i=0 to ubound(sprite)
		npc(i).status=0
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i

	'' normal 32x32 sprites
	'bload path+"npc1.bmp",sprite(0)
	
	bload path+"right.bmp",sprite(0)
	bload path+"right_1.bmp",sprite(1)
	
	bload path+"left.bmp",sprite(2)
	bload path+"left_1.bmp",sprite(3)
	
	
	bload path+"up.bmp",sprite(4)
	bload path+"up.bmp",sprite(5)
	
	bload path+"down.bmp",sprite(6)
	bload path+"down.bmp",sprite(7)

	bload path+"guard.bmp",sprite(8)
	bload path+"oldman.bmp",sprite(9)

		
	''
	general_talk(0)="Good Morning!0"
	general_talk(1)="Good Morning!1"
	general_talk(2)="Good Morning!2"
	general_talk(3)="Good Morning!3"
	general_talk(4)="Good Morning!4"
	general_talk(5)="Good Morning!5"

end sub

sub npc_add(x as integer,y as integer)

	with npc(npc_count)
		.status=1
		.x=x
		.y=y
		.ox=0
		.oy=0
		.xdir=0
		.ydir=0
		.s=0
	end with
	
	npc_count+=1
end sub

sub npc_update()
	dim as integer i,j,d,newdir 
	dim dirlist(3) as integer
	dim as integer ra,rb,rt
	
	for d=0 to 3
		dirlist(d)=d
	next d
	
	for j=0 to 10
		ra=int(rnd*4)
		rb=int(rnd*4)
		
		rt=dirlist(ra)
		dirlist(ra)=dirlist(rb)
		dirlist(rb)=rt
	next j
	
	'' move npc's
	for i=0 to ubound(npc)
		with npc(i)
			if .status=0 then continue for
				
			''
			if .xdir<>0 then .ox+=.xdir
			if .ydir<>0 then .oy+=.ydir
			
			if abs(.ox)=32 then .ox=0:.x+=.xdir
			if abs(.oy)=32 then .oy=0:.y+=.ydir
			
			if .ox=0 and .oy=0 then
			
				'' no path ahead, change direction
				if map(.x+.xdir,.y+.ydir).s<>1 or (.xdir=0 and.ydir=0) then
					'.xdir=0
					'.ydir=0
					''
					
					for d=0 to 3
						newdir=dirlist(d)
						if newdir=0 then .xdir=0:.ydir=-1 ''up
						if newdir=1 then .xdir=0:.ydir=1 ''down
						if newdir=2 then .xdir=-1:.ydir=0 ''left
						if newdir=3 then .xdir=1:.ydir=0 ''right
						
						if map(.x+.xdir,.y+.ydir).s=1 then exit for
					next d
					
					'' if we are here then something is wrong above...
					if map(.x+.xdir,.y+.ydir).s<>1 then
						.xdir=0
						.ydir=0
						bar_title="NPC Error!"
					end if
					''
				
				if .xdir=1 then .s=0
				if .xdir=-1 then .s=2
				if .ydir=-1 then .s=4
				if .ydir=1 then .s=6
				
				
				end if	
			end if 
	
		end with
	next i

end sub

sub npc_draw()

	dim as integer i,j
	dim as integer gx,gy
	
	for i=0 to ubound(npc)
		with npc(i)
			if .status=0 then continue for
		
			gx=((.x*32)+.ox)-(player.mx*32)
			gy=((.y*32)+.oy)-(player.my*32)
			
			#if DEBUG=1
			draw string (10,10+(i*20)),str(i)+". "+str(gx)+", "+str(gy)
			#endif
			
			if gx>=0 and gx<640 then
				if gy>=0 and gy<400 then				
					put (gx ,gy),sprite(.s+alt),trans
				end if
			end if
			
			
			
			
		end with
	next i
	
	if altc>10 then
		altc=0
		alt=1-alt
	else
		altc+=1
	end if
	
end sub

sub npc_task()

end sub

sub npc_generic()

end sub


sub npc_wandering()

end sub
