'' Adventure for Breakfast by ssjx (15/01/11) [http://ssjx.co.uk]
'' ==============================================================
''
''
'' Mountain area
''


#include "bmp.bi"
#include "header.bi"
#include "fmod.bi"

'' Sound samples
common shared sample() As Integer
''
'' in asm.bas
declare sub togray()

'' in inventory.bas
declare sub inventory_add(as string)

'' used in ui
common shared bar_title as string
common shared ui_text() as string

declare function ui_window() as integer
declare sub ui_waitspace()
declare sub ui_cleartext()
declare sub ui_bar()
declare sub ui_smallwindow(as string)
''
declare function task_iscomplete(as integer) as integer
common shared mytasks() as task

''
common shared player as myplayer
common shared game as integer


dim shared as integer spacepressed=0,alt=0,sc=0
dim shared location(20) as string

dim shared sprite(20) as any ptr 
dim shared map(96,64) as xypos
dim shared tplayer as myplayer

dim shared spider(10) as myghost

sub rotsprite(no as integer)
	dim as integer pix=0
	
	Dim buffer As UByte Ptr = sprite(no) 
	dim temp(5) as ubyte
	
	pix=32
   	for j as integer=0 to 31
	   
	        for i as integer=0 to 3 	'
	       	temp(i)=buffer[pix+i]
	       	next i
		 
	        for i as integer=0 to 123 	
	       	buffer[pix+i]=buffer[pix+i+4]
	       	next i
	       	
	       	for i as integer=0  to 3
		buffer[pix+124+i]=temp(i)
	       	next i
	       	''
	       	pix+=128
	
	next j
	
end sub

sub mountain_initsprites()
	dim i as integer
	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(0,0,0) )
	next i

end sub

sub mountain_loadsprites()

	const path as string="gfx/mountain/"


	'' normal 32x32 sprites
	bload path+"block.bmp",sprite(1)
	bload path+"ladder.bmp",sprite(2)
	
	bload path+"water.bmp",sprite(3)
	bload path+"path.bmp",sprite(4)
	bload path+"tree.bmp",sprite(5)
	bload path+"floor.bmp",sprite(6)
	bload path+"pillar.bmp",sprite(7)
	bload path+"prof.bmp",sprite(8)
	
	bload "gfx/player/right.bmp",sprite(9)
	bload path+"water2.bmp",sprite(10)

	bload path+"spider.bmp",sprite(11)
	bload path+"spider2.bmp",sprite(12)
	
	bload path+"boulder2.bmp",sprite(13)	
	bload path+"cavewall.bmp",sprite(14)

	bload path+"floor.bmp",sprite(15)	
	bload path+"grass.bmp",sprite(16)
	
	bload "gfx/stones/air.bmp",sprite(17)
	bload "gfx/stones/earth.bmp",sprite(18)
	bload "gfx/stones/fire.bmp",sprite(19)
	bload "gfx/stones/water.bmp",sprite(20)	

		
end sub

sub mountain_exit()

	'player.x=tplayer.x '' player x pos stays the same
	player.y=tplayer.y
	player.mx=tplayer.mx
	player.my=tplayer.my

	player.ox=0
	player.oy=0
	player.xdir=0
	player.ydir=0
	
		
end sub

sub mountain_start()
	
	'' entry point
	tplayer.x=player.x
	tplayer.y=player.y
	tplayer.mx=player.mx
	tplayer.my=player.my
	
	with player
		.mx=0
		.my=13*3
		'.x=0
		.y=12
		.xdir=0
		.ydir=0
	end with
end sub


sub mountain_loadmap()
	dim as ubyte r,g,b,gc=0
	dim as integer i,j, nextexit=0
	dim header as bmphdr
	dim as uinteger mapwidth,mapheight
	const path as string="maps/mountain.bmp"

	''clear the entire map array
 	for j=0 to 64
		for i=0 to 96
		with map(i,j) 
		.s=0
		.x=0
		.y=0
		.c=0
		end with
		next i
	next j	

	'' load the map
	if  Open(path For binary access read As #1)=0 then
		get #1,,header
		
		mapwidth=header.w
		mapheight=header.h
		
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)        
	                	get #1, ,b,1
				get #1, ,g,1
				get #1, ,r,1
				
				'' background wall
				if (r=255 and g=255 and b=128) then 
					map(i,(mapheight-1)-j).c=0
					map(i,(mapheight-1)-j).s=14
				end if
				
				'' wall
				if (r=0 and g=0 and b=0) then 
					map(i,(mapheight-1)-j).c=1
					map(i,(mapheight-1)-j).s=1
				end if
				
				'' ladder
				if (r=0 and g=255 and b=255) then 
					map(i,(mapheight-1)-j).c=0
					map(i,(mapheight-1)-j).s=2
				end if
			
				'' water
				if (r=0 and g=0 and b=255) then 
					map(i,(mapheight-1)-j).c=0
					map(i,(mapheight-1)-j).s=3
				end if
				
				'' path
				if (r=255 and g=255 and b=0) then 
					map(i,(mapheight-1)-j).c=0
					map(i,(mapheight-1)-j).s=4
				end if
				
				'' tree stump
				if (r=255 and g=128 and b=0) then 
					map(i,(mapheight-1)-j).c=0
					map(i,(mapheight-1)-j).s=5
				end if
				
				'' pillar
				if (r=128 and g=128 and b=128) then 
					map(i,(mapheight-1)-j).c=0
					map(i,(mapheight-1)-j).s=7
				end if
				
				'' prof
				if (r=255 and g=0 and b=255) then 
					map(i,(mapheight-1)-j).c=0
					map(i,(mapheight-1)-j).s=8
				end if
			
				'' spider (in cave)
				if (r=255 and g=0 and b=0) then 
					map(i,(mapheight-1)-j).s=map(i-1,(mapheight-1)-j).s
					
					with spider(gc)
						.t=1
						.x=i
						.y=(mapheight-1)-j
						.ox=0
						.oy=0
						.xdir=1
						.ydir=0
						.s=11
					end with
					gc+=1
					
				end if
				
				'' blocking boulder
				if mytasks(2).active=0 then
					if (r=0 and g=64 and b=64) then 
						map(i,(mapheight-1)-j).c=1
						map(i,(mapheight-1)-j).s=13
					end if
				end if
				
				'' blocking boulder
				
				'' floor
				if (r=0 and g=128 and b=255) then 
					map(i,(mapheight-1)-j).c=1
					map(i,(mapheight-1)-j).s=15
				end if
			
				'' grass
				if (r=128 and g=255 and b=0) then 
					map(i,(mapheight-1)-j).c=1
					map(i,(mapheight-1)-j).s=16
				end if
				
				'' water 2
				if (r=0 and g=64 and b=128) then 
					map(i,(mapheight-1)-j).c=1
					map(i,(mapheight-1)-j).s=10
				end if
				
			next i
		next j
		
			
	        Close #1     
	end if

	location(0)="?????"
	location(1)="Nothing"
	location(2)="Nothing"
	location(3)="Nothing"
	location(4)="Nothing"
	location(5)="Nothing"
	location(6)="Nothing"
	location(7)="Nothing"
	location(8)="Nothing"
	location(9)="Nothing"
	location(10)="Professor White and the 4 Stone Pillars"
	location(11)="Nothing"
	location(12)="Bridge to the Dark Mountain"
	location(13)="Enter the mysterious Dark Mountain?"
	location(14)="Inside the mountain!"
	location(15)="Avoid the green monsters!"
	
end sub

''
'' remove item from a loaded map
sub mapremove(sno as integer)
	dim as integer i,j
	
	for j=0 to 64
		for i=0 to 96
			with map(i,j)
			if .s=sno then
				.s=0
				.c=0
			end if
			end with
		next i
	next j
end sub

sub mountain_shake(oy as integer,stones as integer)
	dim as integer i,j

	'' scenery
	for j=0 to 12
		for i=0 to 19
		
		put (i*32,(j*32)+oy ),sprite(0),pset
		
			with map(i+player.mx,j+player.my)
				put (i*32,(j*32)+oy),sprite(.s),trans
			end with
			
		next i
	next j
	
	'' player and the Air Stone
	put ((player.x*32),(player.y*32)+oy),sprite(9),trans
	if stones=1 then
		put ((6*32),(7*32)+oy),sprite(17),trans
	end if
	
	if stones>1 then 
		put (6*32,7*32),sprite(17),trans 'stones
		put (8*32,7*32),sprite(18),trans
		put (12*32,7*32),sprite(19),trans
		put (14*32,7*32),sprite(20),trans
	end if
end sub


sub mountain_vanish()
	dim vpos(20*13) as xypos
	
	dim as integer i,j,c,d

	'' make a note of each piece
	for j=0 to 12
		for i=0 to 19
			with vpos(c)
				.s=map(i+player.mx,j+player.my).s
				
				.x=i*32
				.y=j*32
			
				if (rnd*10)>5 then .xdir=4 else .xdir=-4
				if (rnd*10)>5 then .ydir=4 else .ydir=-4
			end with
			c+=1
		next i
	next j
	
	player.mx=0
	player.my=0
	
	
	'' draw everything
	for d=1 to 120
	
	screenlock
	
		''purple sky
		
		for j=0 to 19
		line (0,(j*20)) -(640,(j+1)*20),rgb(255,j*12,255),bf
		next j
		
		'' new background
		for j=0 to 12
			for i=0 to 19
			with map(i,j)
				if .s>0 then
					put (i*32,j*32),sprite(.s),trans
				end if
			end with
			next i
		next j
	
		'' draw vanishing background
		for c=0 to ubound(vpos)-1
			with vpos(c)
				if .s>0 and .s<>8 then
					put (.x,.y ),sprite(.s),trans
					.x+=.xdir
					.y+=.ydir
				end if
			end with
		next c
	
		'' player and the Air Stone
		put ((player.x*32),(player.y*32)),sprite(9),trans
		'put ((6*32),(7*32)),sprite(17),trans
		
		ui_bar()
	screenunlock
	sleep 10
	next d
end sub


sub mountain_drawmap()
	dim as integer i,j,gradient=0
	dim as integer gx,gy

	'' scenery
	if player.mx=20 and player.my=39 then gradient=1
	if player.mx=0 and player.my=0 then gradient=2
	
	'' blue sky
	if gradient=1 then
		for j=0 to 19
		line (0,(j*20)) -(640,(j+1)*20),rgb(0,j*12,255),bf
		next j
	end if
	
	'' purple sky
	if gradient=2 then
		for j=0 to 19
		line (0,(j*20)) -(640,(j+1)*20),rgb(255,j*12,255),bf
		next j
	end if
	
	
	for j=0 to 12
		for i=0 to 19
		
			if gradient=0 then put (i*32,j*32),sprite(0),pset
		
			with map(i+player.mx,j+player.my)
				if .s>0 then put (i*32,j*32),sprite(.s),trans
			end with
			
		next i
	next j
	
	''draw spiders
	
	'' change frame
	sc+=1
	if sc>10 then
		alt=1-alt
		sc=0
	end if		
			
	for i=0 to ubound(spider)
		with spider(i)
			if .t=1 then 
				gx=((.x-player.mx)*32)+.ox
				
				if gx>0 and gx<640 then
					
					gy=((.y-player.my)*32)+.oy 
				
					if gy>0 and gy<400 then				
						put (gx ,gy),sprite(.s+alt),trans
					end if
				end if
			end if
			
		end with		
	next i
	
	with player
		if map(.x+.mx+1, .y+.my).s=8 or map(.x+.mx, .y+.my).s=8 or map(.x+.mx-1, .y+.my).s=8 then
			bar_title="#Press Space to talk to Professor White!"
		else
			bar_title=location((.mx/20)+((.my/13)*4))
			'bar_title="Dark Mountain.."
		end if
	end with
end sub

'' move spiders left and right!
sub mountain_update()
	dim as integer i,d
	dim as integer gx,gy,px,py

	rotsprite(3) '' water
	rotsprite(10) '' water
	'' 
	'' move spikes and check for hits, throw player out of forest if hit
	with player
		px=8+((.mx+.x)*32)+.ox
		py=((.my+.y)*32)+.oy
	end with
	
	'' move spikes
	for i=0 to ubound(spider)
		with spider(i)
			if .t=1 then 
				''
				if .xdir<>0 then .ox+=.xdir
				if .ydir<>0 then .oy+=.ydir
				
				if abs(.ox)=32 then .ox=0:.x+=.xdir
				if abs(.oy)=32 then .oy=0:.y+=.ydir
				
				if .ox=0 and .oy=0 then
				
					'' if hit wall or on end, bounce!
					if map(.x+.xdir,.y+.ydir).c=1 or map(.x+.xdir,.y+1).s=0 or map(.x+.xdir,.y+1).s=14 then
						.xdir*=-1
					end if
				end if
				
				'' See if spike hit player
				gx=8+(.x*32)+.ox '????
				gy=(.y*32)+.oy '????
				
				if (px>=gx and px<=gx+16) or (px+16>=gx and px+16<=gx+16) then
				
					if (py>=gy and py<=gy+31) or (py+31>=gy and py+31<=gy+31) then
					
					
						bar_title="%You hit a spider-lizard thing! Press Space to continue! "
			
						togray()
						ui_bar()
						ui_waitspace()
			
						'' hit a ghost
						player.x=tplayer.x '' entry X postion
						game=MODE_RPG
						
						#if DEBUG=1
							ui_text(0)="Hit by a spider/spike ["+str(i)+"]"
							ui_text(1)="gx:"+str(gx)
							ui_text(2)="gy:"+str(gy)
							ui_text(3)="px:"+str(px)
							ui_text(4)="py:"+str(py)
							ui_text(5)="pl_mx:"+str(player.mx)
							ui_text(6)="pl_my:"+str(player.my)
							ui_text(7)="pl_x:"+str(player.x)
							ui_text(8)="pl_y:"+str(player.y)
							
							ui_text(9)="sp_x:"+str(.x)
							ui_text(10)="sp_y:"+str(.y)
							ui_window()
						#endif
						
					end if
				end if
				
				
				''
			end if
		end with
			
	next i

''
end sub

sub mountain_controls()
dim i as integer
	''
	'' Player controls
	''
	with player
	
	if .xdir=0 and .ydir=0 then
		if  MultiKey(SC_UP) then
			'' ladder
			if (map(.x+.mx, .y+.my-1).s=2) then
				.ydir=-1
				.s=2
				goto eokeys:
			end if
			
			'' path
			if (map(.x+.mx, .y+.my-1).s=4) then
				.ydir=-1
				.s=2
				goto eokeys:
			end if
			
		end if
		
		if  MultiKey(SC_DOWN)then
			'' exit this stage
			if (.my+.y)=51 then
				game=MODE_RPG
				goto eokeys:
			end if
			
			'' on a ladder
			if (map(.x+.mx, .y+.my+1).s=2) then
				.ydir=1
				.s=2
				goto eokeys:
			end if
			
			'' path
			if (map(.x+.mx, .y+.my+1).s=4) then
				.ydir=1
				.s=3
				goto eokeys:
			end if
			
		end if
		
		if  MultiKey(SC_LEFT)   then
		
		
			'' path
			if (map(.x+.mx-1, .y+.my).s=4) then
				.xdir=-1
				goto eokeys:
			end if
		
			if map(.x+.mx-1, .y+.my).c=0 then
				'' on a ladder
				if map(.x+.mx, .y+.my).s=2 then
					'' solid next to+under player
					if  map(.x+.mx-1, .y+.my+1).c=1 then
						.xdir=-1
						goto eokeys:
					end if
				else
					'' solid or ladder next under player
					if  map(.x+.mx-1, .y+.my+1).c=1 or map(.x+.mx-1, .y+.my+1).s=2 then
						.xdir=-1
						goto eokeys:
					end if
					
					'.xdir=-1
					'goto eokeys:
				end if
			end if
		
		end if
		
		
		if  MultiKey(SC_RIGHT) then
			'' path
			if (map(.x+.mx+1, .y+.my).s=4) then
				.xdir=1
				goto eokeys:
			end if
			''
			if map(.x+.mx+1, .y+.my).c=0 then
				if map(.x+.mx, .y+.my).s=2 then
					'' on a ladder
					 if map(.x+.mx+1, .y+.my+1).c=1 then
						.xdir=1
						goto eokeys:
					end if
				else
					'' solid or ladder next under player
					 if map(.x+.mx+1, .y+.my+1).c=1 or map(.x+.mx+1, .y+.my+1).s=2 then
						.xdir=1
						goto eokeys:
					end if
				end if
			end if
				
		end if
			
		if  MultiKey(SC_SPACE) then
			spacepressed=1	
		end if
		
		if MultiKey(SC_SPACE)=0 and spacepressed=1 then
			spacepressed=0
	
			'' Begin chat with people
			ui_cleartext()
			if map(.x+.mx, .y+.my).s=8 or map(.x+.mx+1, .y+.my).s=8 or map(.x+.mx-1, .y+.my).s=8 then
			
				'' prof
				select case as const mytasks(2).active
				case 0
					'' chat and give task
					ui_text(0)="Hello stranger, I am Professor White!"
					ui_text(1)="%Hi, Mr Oldman said I should take a look up here!"
					
					ui_text(3)="Oh, yes. Last weeks earthquake unearthed the"
					ui_text(4)="entrance to this cave."
					
					ui_text(6)="The pillars here look like they are for some kind"
					ui_text(7)="of ancient stone to sit on..."
					ui_text(8)="%Something like this Air Stone perhaps?"
					
					ui_text(10)="I wonder what would happen if we put this stone"
					ui_text(11)="on one of the pillars?"
					
					ui_window()
				
					
					'' Move player
					player.x=5
					player.y=8
					mountain_drawmap()
					put (player.x*32,player.y*32),sprite(9),trans
					
					'' place the crystal...
					ui_smallwindow("Press Space to place the Air Stone...")
					ui_waitspace()
					FSOUND_PlaySound(FSOUND_FREE, sample(3))
					put (6*32,7*32),sprite(17),trans
					
					'' shake screen
					for i=0 to 40
						if (i MOD 2)=0 then mountain_shake(4,1) else mountain_shake(-4,1)
						sleep 10
					next i
					
					'' put screen back to normal!
					mountain_drawmap()
					put (player.x*32,player.y*32),sprite(9),trans
					ui_bar()
					
					'ui_waitspace()
					
					ui_cleartext()
					ui_text(0)="Yikes! That tremor must mean the stone belongs here!"
						
					ui_text(2)="There should be 3 more elemental stones hidden near "
					ui_text(3)="the town. You should see if you can find them for me!"
					
					ui_text(5)="I bet we would see something more interesting then!"
					ui_text(6)=""
					
					ui_text(7)="%Okay, but if the planet suddenly splits in half,"
					ui_text(8)="%it's your fault..."
					ui_text(9)=""
					
					ui_text(10)="That earlier tremor may have opened up new areas"
					ui_text(11)="for you to explore. Just be careful!"
					
					ui_window()
					
					ui_cleartext()
					ui_text(0)="%One more thing, what's with those monsters?"
						
					ui_text(2)="Those green things below? No idea, I guess they"
					ui_text(3)="must have been dormant before."
					
					ui_text(5)="%They don't look like they come from around here.."
					ui_text(6)=""
					
					ui_text(7)="Best avoid them If you can!"
					ui_text(8)=""
					ui_text(9)="Now get going!"
					
					
					ui_window()
					
					'' New task!
					mytasks(2).active=1
					mapremove(13)
					
					'' ui_waitspace()
				case 1
					if task_iscomplete(2)=1 then
						'' task completed
						ui_text(0)="Excellent! You have all the stones!"
						ui_text(1)="Let's see what happens now!"
						ui_text(2)="%Should we be wearing goggles for this?"
						ui_window()
						''
						'' End game anim
						mountain_drawmap()
						put (player.x*32,player.y*32),sprite(9),trans
						put (6*32,7*32),sprite(17),trans 'stones
						put (8*32,7*32),sprite(18),trans
						put (12*32,7*32),sprite(19),trans
						put (14*32,7*32),sprite(20),trans
						ui_smallwindow("Press Space to continue...")
						ui_waitspace()
						FSOUND_PlaySound(FSOUND_FREE, sample(3))
						
						'' shake screen
						for i=0 to 50
							if (i MOD 2)=0 then mountain_shake(4,4) else mountain_shake(-4,4)
							sleep 10
						next i
						
						FSOUND_PlaySound(FSOUND_FREE, sample(2))
						mountain_vanish()
						ui_smallwindow("Press Space to continue...")
						ui_waitspace()
						
						
						mountain_drawmap()
						
						ui_cleartext()
						ui_text(0)="%What the heck was that?!"
						ui_text(1)="It appears we've been transported to another world!"
						
						ui_text(3)="%How do we get home!?"
						ui_text(4)="These pillars look like the ones in the cave,"
						ui_text(5)="judging by the natives below us. They must"
						ui_text(6)="have used similar stones to transport to our world."
						
						ui_text(8)="%So we need another 4 stones then?"
						ui_text(9)="I think so..."
						
						ui_window()
						
						mountain_drawmap()
						put (player.x*32,player.y*32),sprite(9),trans
						
						ui_smallwindow("To be continued?")
						ui_waitspace()
						mountain_drawmap()
						
						game=MODE_COMPLETE
						'end
					''	
					else
						'' task given but not done..
						ui_text(0)="Not found all the stones yet?"
						
						ui_text(2)="That earlier tremor may have opened up new"
						ui_text(3)="areas for you to explore. Just be careful!"
						
					ui_window()		
					end if
					
					'' ui_waitspace()
				case 2
					'' hello after task done..
					ui_window()
					'' ui_waitspace()

				case else
					ui_text(0)="ERROR! Task 1 active state = "+str(mytasks(1).active)	
					ui_window()
					'' ui_waitspace()
				end select
			end if
		
		end if
		
		eokeys:
	end if
	

	'' Move 	
	if .xdir<>0 then
	
		.ox+=(2*.xdir)
		
		if .xdir=1 then
			if abs(.ox)<16 then
			 .s=5
			else
			 .s=0
			end if	
		end if
		
		if .xdir=-1 then
			if abs(.ox)<16 then
			 .s=6
			else
			 .s=1
			end if	
		end if
		
		if abs(.ox)=30 then
			.ox=0
		
			if .xdir=1 then
				if (.x=19) then
					.x=0
					.mx+=20
				else
					.x+=.xdir
				end if
			else
				if (.x=0 and .mx>0) then
					.x=19
					.mx-=20
				else
					.x+=.xdir
				end if
			end if
			
			'' collect diamond
			'if map(.x+.mx,.y+.my).s=4 then
				'player.diamonds+=1
			'	map(.x+.mx,.y+.my).r=1
			'	inventory_add("Diamond")
			'end if
			
			.xdir=0
		end if	
	
	end if

	
	if .ydir<>0 then
	
		.oy+=(2*.ydir)
		
		'' animate up/down
		if .ydir=1 then
			if abs(.oy)<16 then
			 .s=3
			else
			 .s=8
			end if	
		end if
		
		'' Faces towards player when going down ladders...
		if .ydir=-1 then
			if abs(.oy)<16 then
			.s=2
			else
			.s=7
			end if	
		end if
		''
		
		
		if abs(.oy)=30 then
			.oy=0
						
			if .ydir=1 then
				if (.y=12) then
					.y=0
					.my+=13
				else
					.y+=.ydir
				end if
			else
				if (.y=0 and .my>0) then
					.y=12
					.my-=13
				else
					.y+=.ydir
				end if
			end if
			
			'' collect diamond
			'if map(.x+.mx,.y+.my).s=4 then
				'player.diamonds+=1
			'	map(.x+.mx,.y+.my).r=1
			'	inventory_add("Diamond")
			'end if
			
			.ydir=0
		end if	
	
	end if
	
	end with

''
end sub
