'' Adventure for Breakfast by ssjx (15/01/11) [http://ssjx.co.uk]
'' ==============================================================
''
''
'' Rockfall bit...
''
''
''

#include "bmp.bi"
#include "header.bi"
#include "fmod.bi"
'' in inventory.bas
declare sub inventory_add(as string)
declare sub inventory_restore()

'' in ui.bas
common shared bar_title as string
common shared ui_text() as string
declare sub ui_waitspace()
declare sub ui_bar()

'' in asm.bas
declare sub togray()
''
common shared map() as xypos
common shared player as myplayer

common shared game as integer

'dim shared as integer spacepressed=0

dim shared sprite(20) as any ptr 

dim shared spike(10) as myghost

'' Sound samples
common shared sample() As Integer
''

sub mine_removed(v as integer)
dim as integer i,j
	''clear the entire map array
 	for j=0 to 64
		for i=0 to 64
		if map(i,j).r=2 then map(i,j).r=v '' 0= active 1= removed 2 = pending
		next i
	next j	
end sub

sub mine_initsprites()
	dim i as integer
	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(0,0,0) )
	next i

end sub

sub mine_loadsprites(town as integer)

	dim i as integer
	dim path as string="gfx/rockfall/"

	select case as const town
		case 1:
			'' normal 32x32 sprites
			bload path+"earth.bmp",sprite(1)
			bload path+"block.bmp",sprite(2)
			bload path+"boulder.bmp",sprite(3)
			bload path+"diamond.bmp",sprite(4)
		''	bload path+"earth2.bmp",sprite(5)
		''	6 = entrance/exit
		
		bload "gfx/stones/fire.bmp",sprite(7)
		bload path+"spike.bmp",sprite(8)
		
	end select
	

end sub

sub mine_start()
	dim as integer i,j
	
	for j=0 to 12 
	for i=0 to 19
	
		with player
			if map(.mx+i,.my+j).s=6 then
				.x=i
				.y=j
					
			end if
		end with
	
	next i
	next j
end sub


sub mine_loadmap(town as integer)
	dim as ubyte r,g,b,gc=0
	dim as integer i,j, nextexit=0
	dim header as bmphdr
	dim as uinteger mapwidth,mapheight
	dim path as string="maps/mine.bmp"

	''clear the entire map array
 	for j=0 to 64
		for i=0 to 64
		with map(i,j) 
		.s=0
		.x=0
		.y=0
		.c=0
		end with
		next i
	next j	

	'' load the map
	if  Open(path For binary access read As #1)=0 then
		get #1,,header
		
		mapwidth=header.w
		mapheight=header.h
		
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)        
	                	get #1, ,b,1
				get #1, ,g,1
				get #1, ,r,1
				
				'' don't put diamond back if collected
				if map(i,(mapheight-1)-j).r=1 then
					continue for
				end if
				
				'' earth
				if (r=255 and g=128 and b=0) then 
					map(i,(mapheight-1)-j).s=1
				end if
				
				'' wall
				if (r=0 and g=0 and b=0) then 
					map(i,(mapheight-1)-j).c=1
					map(i,(mapheight-1)-j).s=2
				end if
				
				'' boulder
				if (r=255 and g=0 and b=0) then
					map(i,(mapheight-1)-j).c=1 
					map(i,(mapheight-1)-j).s=3
				end if
				
				'' diamond
				if (r=255 and g=255 and b=0) then 
					map(i,(mapheight-1)-j).s=4
				end if
				
				'' skip #5
				
				if (r=255 and g=0 and b=255) then 
					map(i,(mapheight-1)-j).s=6	
				end if
				
				'' spike
				if (r=0 and g=0 and b=255) then 
					map(i,(mapheight-1)-j).s=0
					
					with spike(gc)
						.t=1
						.x=i
						.y=(mapheight-1)-j
						.ox=0
						.oy=0
						.xdir=0
						.ydir=0
						.s=8
					end with
					gc+=1
					
				end if
				
			next i
		next j
		
			
	        Close #1     
	end if


end sub


sub mine_drawmap()
	dim as integer i,j
	dim as integer gx,gy

	for j=0 to 12
		for i=0 to 19
		
		put (i*32,j*32),sprite(0),pset
		
			with map(i+player.mx,j+player.my)
				put (i*32,j*32),sprite(.s),trans
			end with
			
		next i
	next j
	
		'' move spikes
	for i=0 to ubound(spike)
		with spike(i)
			if .t=1 then 
				gx=((.x-player.mx)*32)+.ox '
				gy=((.y-player.my)*32)+.oy '
				
				if gx>0 and gx<640 then
					if gy>0 and gy<400 then				
						put (gx ,gy),sprite(8),trans
					end if
				end if
			end if
			
			'put (.x*32 ,.y*32),sprite(8),trans
			
		end with
			
	next i
	
	with player
		select case as const map(.x+.mx,.y+.my).s
		case 6:
			bar_title="#Press Up to leave this mine!"
		case else:
			bar_title="Underground diamond mine..."
		end select
	end with
	
	
end sub

'' move rocks down if space below
sub mine_update()
	dim as integer i,j,d,bc=0
	dim as integer ra,rb,rt,newdir
	dim as integer gx,gy,px,py
	dim dirlist(3) as integer

	for d=0 to 3
		dirlist(d)=d
	next d

	'' boulder related stuff
	for j=0 to 12
		for i=0 to 19
			'' make boulders fall into empty spaces
			if map(i+player.mx,j+player.my).s=3 then ''boulder
			
				if map(i+player.mx,j+player.my+1).s=0 then
					map(i+player.mx,j+player.my+1).s=3
					map(i+player.mx,j+player.my+1).c=1
					
					map(i+player.mx,j+player.my).s=0
					map(i+player.mx,j+player.my).c=0				
				end if
			end if
			
		
		next i
		
		'' only need to check player after a row has moved down
		'' has boulder hit player?
		if map(player.mx+player.x,player.my+player.y).s=3 then
			
			FSOUND_PlaySound(FSOUND_FREE, sample(1))
			
			mine_drawmap()
			bar_title="%You got hit by a boulder! Press Space to continue! "
			
			togray()
			ui_bar()
			ui_waitspace()
		
			'' remove items collected
			''
			inventory_restore()
			mine_removed(0)
			''
			''restore removed items
			'''
			
			game=MODE_RPG
			
			#if DEBUG=1
			ui_text(0)="Hit by boulder"		
			#endif
			return
			''	
		end if	
	''
		
	next j
		
	'' 
	'' move spikes and check for hits, throw player out of forest if hit
	with player
		px=8+((.mx+.x)*32)+.ox
		py=((.my+.y)*32)+.oy
	end with
	
	'' move spikes
	for i=0 to ubound(spike)
		with spike(i)
			if .t=1 then 
				''
				if .xdir<>0 then .ox+=.xdir
				if .ydir<>0 then .oy+=.ydir
				
				if abs(.ox)=32 then .ox=0:.x+=.xdir
				if abs(.oy)=32 then .oy=0:.y+=.ydir
				
				if .ox=0 and .oy=0 then
				
					for j=0 to 10
						ra=int(rnd*4)
						rb=int(rnd*4)
						
						rt=dirlist(ra)
						dirlist(ra)=dirlist(rb)
						dirlist(rb)=rt
					next j
				
					if map(.x+.xdir,.y+.ydir).c=1 or map(.x+.xdir,.y+.ydir).s>0 or (.xdir=0 and.ydir=0) then
				
						for d=0 to 3
							newdir=dirlist(d)
							if newdir=0 then .xdir=0:.ydir=-1 ''up
							if newdir=1 then .xdir=0:.ydir=1 ''down
							if newdir=2 then .xdir=-1:.ydir=0 ''left
							if newdir=3 then .xdir=1:.ydir=0 ''right
							
							if map(.x+.xdir,.y+.ydir).c=0 and map(.x+.xdir,.y+.ydir).s=0 then exit for
						next d
					end if
				end if
				
				'' See if spike hit player
				gx=(.x*32)+.ox '????
				gy=(.y*32)+.oy '????
				
				if (px>=gx and px<=gx+31) or (px+16>=gx and px+16<=gx+31) then
				
					if (py>=gy and py<=gy+31) or (py+31>=gy and py+31<=gy+31) then
						FSOUND_PlaySound(FSOUND_FREE, sample(1))
						'' hit a spike
						bar_title="%You hit a spike! Press Space to continue! "
						togray()
						ui_bar()
						ui_waitspace()
						
						''
						'' remove items collected
						''
						inventory_restore()
						mine_removed(0)
						''
						''restore removed items
						'''
					''
					
						game=MODE_RPG
						
						#if DEBUG=1
							ui_text(0)="Hit by a spike ["+str(i)+"]"
							ui_text(1)="gx:"+str(gx)
							ui_text(2)="gy:"+str(gy)
							ui_text(3)="px:"+str(px)
							ui_text(4)="py:"+str(py)
							ui_text(5)="pl_mx:"+str(player.mx)
							ui_text(6)="pl_my:"+str(player.my)
							ui_text(7)="pl_x:"+str(player.x)
							ui_text(8)="pl_y:"+str(player.y)
							
							ui_text(9)="sp_x:"+str(.x)
							ui_text(10)="sp_y:"+str(.y)
							ui_window()
						#endif
						
					end if
				end if
				
				
				''
			end if
		end with
			
	next i
''
end sub

sub mine_controls()
''
	''
	'' Player controls
	''
	with player
	
	if .xdir=0 and .ydir=0 then
		if  MultiKey(SC_UP) then
		
			if map(.x+.mx, .y+.my).s=6 then
				game=MODE_RPG
				mine_removed(1)
				
					#if DEBUG=1
					ui_text(0)="Exit point s=6 (UP)"
					ui_window()
					#endif
					
				goto eokeys:
			end if
		
			if (map(.x+.mx, .y+.my-1).c=0) then
				.ydir=-1
				.s=2
				goto eokeys:
			end if
		end if
		
		if  MultiKey(SC_DOWN)then
			if (map(.x+.mx, .y+.my+1).c=0) then
				.ydir=1
				.s=3
				
				'' if boulder above, clears the player space so boulder falls
				if (map(.x+.mx, .y+.my-1).s=3) then
					map(.x+.mx, .y+.my).s=0
					.ydir=0
				end if 
				
				goto eokeys:
			end if
		end if
		
		if  MultiKey(SC_LEFT) then
			if (map(.x+.mx-1, .y+.my).c=0) then
				.xdir=-1
				.s=1
				goto eokeys:
			end if
		end if
		
		
		if  MultiKey(SC_RIGHT)then
			if (map(.x+.mx+1, .y+.my).c=0) then
				.xdir=1	
				
				goto eokeys:		
			end if	
		end if
			
	'	if  MultiKey(SC_SPACE) then
	'		spacepressed=1	
	'	end if
		
	'	if MultiKey(SC_SPACE)=0 and spacepressed=1 then
	'		spacepressed=0
	
		'	select case as const map(.x+.mx, .y+.my).s
		'	case 6:
		'		game=MODE_RPG
				
	'			#if DEBUG=1
	'			ui_text(0)="Exit point s=6 (SPACE)"
'	'			ui_window()
	'			#endif
	'		end select
			
		
	'	end if
		
		
		
		'if .xdir=1 then .s=0 else 
		eokeys:
	end if
	

	'' Move 	
	if .xdir<>0 then
	
		.ox+=(2*.xdir)
		
		if .xdir=1 then
			if abs(.ox)<16 then
			 .s=5
			else
			 .s=0
			end if	
		end if
		
		if .xdir=-1 then
			if abs(.ox)<16 then
			 .s=6
			else
			 .s=1
			end if	
		end if
		
		if abs(.ox)=30 then
			.ox=0
			
			
			
			'' clear square (but not exit)
			if map(.x+.mx,.y+.my).s<>6 then map(.x+.mx,.y+.my).s=0
			
			if .xdir=1 then
				if (.x=19) then
					.x=0
					.mx+=20
				else
					.x+=.xdir
				end if
			else
				if (.x=0 and .mx>0) then
					.x=19
					.mx-=20
				else
					.x+=.xdir
				end if
			end if
			
			'' collect diamond
			if map(.x+.mx,.y+.my).s=4 then
				'player.diamonds+=1
				map(.x+.mx,.y+.my).r=2
				FSOUND_PlaySound(FSOUND_FREE, sample(0))
				inventory_add("Diamond")
			end if
			
			'' clear square
			if map(.x+.mx,.y+.my).s=1 or map(.x+.mx,.y+.my).s=4 then
				map(.x+.mx,.y+.my).s=5
			end if
			
			''
			
			.xdir=0
		end if	
	
	end if

	
	if .ydir<>0 then
	
		.oy+=(2*.ydir)
		
		'' animate up/down
		if .ydir=1 then
			if abs(.oy)<16 then
			 .s=3
			else
			 .s=8
			end if	
		end if
		
		if .ydir=-1 then
			if abs(.oy)<16 then
			 .s=2
			else
			 .s=7
			end if	
		end if
		''
		
		if abs(.oy)=30 then
			.oy=0
			
			
			
			'' clear square (but not exit)
			if map(.x+.mx,.y+.my).s<>6 then map(.x+.mx,.y+.my).s=0
			
			if .ydir=1 then
				if (.y=12) then
					.y=0
					.my+=13
				else
					.y+=.ydir
				end if
			else
				if (.y=0 and .my>0) then
					.y=12
					.my-=13
				else
					.y+=.ydir
				end if
			end if
			
			
			'' collect diamond
			if map(.x+.mx,.y+.my).s=4 then
				'player.diamonds+=1
				map(.x+.mx,.y+.my).r=2
				FSOUND_PlaySound(FSOUND_FREE, sample(0))
				inventory_add("Diamond")
			end if
			
			'' clear square
			if map(.x+.mx,.y+.my).s=1 or map(.x+.mx,.y+.my).s=4 then
				map(.x+.mx,.y+.my).s=5
			end if
			''
			.ydir=0
		end if	
	
	end if
	
	end with

''
end sub
