'' Adventure for Breakfast by ssjx (15/01/11) [http://ssjx.co.uk]
'' ==============================================================
''
''
'' RPG Map stuff
''
'' This could easily be turned into a class...
''
''
#include "bmp.bi"
#include "header.bi"

declare sub npc_add( as integer, as integer)
declare sub npc_draw()
 
common shared map() as xypos
common shared player as myplayer

'' used in ui
common shared bar_title as string
common shared ui_text() as string

declare function ui_window() as integer
declare sub ui_cleartext()
declare sub ui_waitspace()

'' used in game.bas
common shared game as integer

'' used in mine.bas
'common shared mine_entry as mappos
'common shared mine_exit as mappos

'' from tasks.bas
declare function task_iscomplete(as integer) as integer

'' in inventory.bas
declare sub inventory_add(as string)
declare sub inventory_remove(as string,as integer)

common shared mytasks() as task

''''''''
'common shared sprite() as any ptr
dim shared sprite(20) as any ptr
dim shared location(12) as string

dim shared as integer spacepressed=0
dim shared as integer done_npc=0	'' to prevent npcs being reloaded.. 

dim shared tplayer as myplayer
 
'' --------- 
 '' remove item from a loaded map
sub rpg_mapremove(sno as integer)
	dim as integer i,j
	
	for j=0 to 64
		for i=0 to 64
			with map(i,j)
			if .s=sno then
				.s=0
				.c=0
			end if
			end with
		next i
	next j
end sub
 
sub gen_start
	tplayer.x=player.x
	tplayer.y=player.y
	tplayer.mx=player.mx
	tplayer.my=player.my
end sub

sub gen_exit
	player.x=tplayer.x
	player.y=tplayer.y
	player.mx=tplayer.mx
	player.my=tplayer.my

	player.ox=0
	player.oy=0
	
	player.xdir=0
	player.ydir=0
end sub 
 
 
'''----------
sub rpg_initsprites()
	dim i as integer	
	for i=0 to 18
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i
	
	for i=19 to ubound(sprite) 
		sprite(i) = ImageCreate( 128, 128,rgb(100,255,100) )
	next i
	
'	for i=15 to ubound(sprite)
'		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
'	next i
end sub

sub rpg_exitmine()
	dim as integer i,j,done=0
	
	for j=0 to 12 
	for i=0 to 19
	
		with player
			if map(.mx+i,.my+j).s=8 then
				.x=i
				.y=j	
				done=1	
			end if
		end with
	
	next i
	next j
	
	if done=0 then
		gen_exit()
	end if
	
	'''
end sub




sub rpg_loadsprites(town as integer)

	dim i as integer
	dim path as string="gfx/town"+str(town)+"/"

	select case as const town
		case 1:
			'' normal 32x32 sprites
			bload path+"grass.bmp",sprite(0)
			bload path+"path.bmp",sprite(1)
			bload path+"water.bmp",sprite(2)
			bload path+"fence_horizontal.bmp",sprite(3)
			bload path+"boulder.bmp",sprite(4)
			bload path+"step.bmp",sprite(5)
			bload path+"fence_vertical.bmp",sprite(6)
			bload path+"tree.bmp",sprite(7)
			bload path+"mine_hole.bmp",sprite(8)
			bload path+"boulder2.bmp",sprite(9)
			bload path+"grass2.bmp",sprite(10)
			bload path+"barrier.bmp",sprite(11)
			bload path+"flower.bmp",sprite(12)
			
			bload path+"sign_shop.bmp",sprite(13)
			bload path+"sign_fishing.bmp",sprite(14)
			bload path+"sign_forest.bmp",sprite(15)
							
			'' static npc
			bload path+"npc/guard.bmp",sprite(17)
			bload path+"npc/oldman.bmp",sprite(18)
						
			
			'' larger 128x128 sprites
			bload path+"building1.bmp",sprite(19)
			bload path+"building2.bmp",sprite(20)
			

			
	end select
	

end sub


sub rpg_loadmap(town as integer)
	dim as ubyte r,g,b,c
	dim as integer i,j
	dim header as bmphdr
	dim as uinteger mapwidth,mapheight
	const path as string="maps/town.bmp"

	''clear the entire map array
 	for j=0 to 64
		for i=0 to 64
		with map(i,j)
		.c=0 
		.s=0
		.x=0
		.y=0
		end with
		next i
	next j	

	'' load the map
	if  Open(path For binary access read As #1)=0 then
		get #1,,header
		
		mapwidth=header.w
		mapheight=header.h
		
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)        
	                	get #1, ,b,1
				get #1, ,g,1
				get #1, ,r,1
				
				'' NPC
				
				if (r=255 and g=128 and b=255) then
					'' wanderer.. 
					map(i,(mapheight-1)-j).s=1
					
					if done_npc=0 then
						npc_add(i,(mapheight-1)-j)
					end if
				end if
				
				if (r=0 and g=128 and b=0) then 
					'' guard
					map(i,(mapheight-1)-j).s=17
					map(i,(mapheight-1)-j).c=1
				end if
				
				if (r=0 and g=128 and b=64) then 
					'' oldman
					map(i,(mapheight-1)-j).s=18
					map(i,(mapheight-1)-j).c=1
				end if
				
				'' General graphics
				if (r=0 and g=0 and b=0) then 
					map(i,(mapheight-1)-j).s=1 'path'
				end if
				
				if (r=0 and g=0 and b=255) then 
					map(i,(mapheight-1)-j).s=2 '' water
					map(i,(mapheight-1)-j).c=1
				end if
				
				if (r=128 and g=64 and b=0) then 
					map(i,(mapheight-1)-j).s=3 ''fence
					map(i,(mapheight-1)-j).c=1
				end if
				
				if (r=128 and g=128 and b=128) then '' boulder
					map(i,(mapheight-1)-j).s=4
					map(i,(mapheight-1)-j).c=1
				end if
				
				if (r=0 and g=64 and b=0) then   '' step
					map(i,(mapheight-1)-j).s=5
				end if
				
				if (r=255 and g=128 and b=0) then  '' fence
					map(i,(mapheight-1)-j).s=6
					map(i,(mapheight-1)-j).c=1
				end if
				
				if (r=0 and g=255 and b=0) then   '' tree
					map(i,(mapheight-1)-j).s=7
					map(i,(mapheight-1)-j).c=1
				end if
				
				if (r=192 and g=192 and b=192) then '' mine hole
					map(i,(mapheight-1)-j).s=8
				end if
				
				if (r=200 and g=200 and b=0) then
					'' if tremor not happened
					if mytasks(2).active=0 then
						map(i,(mapheight-1)-j).s=9 '' gold boulder
						map(i,(mapheight-1)-j).c=1
					end if
				end if
				
				if (r=255 and g=255 and b=128) then 
					map(i,(mapheight-1)-j).s=10 '' Shop entrance
				end if
				
				
				if (r=64 and g=0 and b=128) then
					'' only have barrier if sweet task not complete
					if mytasks(1).active<2 then 
						map(i,(mapheight-1)-j).s=11 '' Mountain barrier
						map(i,(mapheight-1)-j).c=1
					end if
				end if
				
				if (r=128 and g=255 and b=255) then 
					map(i,(mapheight-1)-j).s=12	'' flower patch
				end if
				
				if (r=255 and g=0 and b=0) then 
					map(i,(mapheight-1)-j).s=19 '' house building
					
					for c=0 to 3	
					map(i,c+(mapheight-1)-j).c=1
					map(i+1,c+(mapheight-1)-j).c=1
					map(i+2,c+(mapheight-1)-j).c=1
					map(i+3,c+(mapheight-1)-j).c=1	
					next c	
					
					
				end if
				
				if (r=128 and g=0 and b=0) then 
					map(i,(mapheight-1)-j).s=20 '' shop building
					
					for c=0 to 3	
					map(i,c+(mapheight-1)-j).c=1
					map(i+1,c+(mapheight-1)-j).c=1
					map(i+2,c+(mapheight-1)-j).c=1
					map(i+3,c+(mapheight-1)-j).c=1	
					next c	
				end if
				
				'' too lazy to find colours for the following:
				
				'' shop sign
				map(34,8).s=13
				map(34,8).c=1
				
				'' fishing sign
				map(58,3).s=14
				map(58,3).c=1
				
				map(58,17).s=14
				map(58,17).c=1
				
				'' forest sign
				map(1,33).s=15
				map(1,33).c=1
				
			next i
		next j
		
			
	        Close #1     
	end if
	
	
	'' load collision map
'	if  Open(path+"col.bmp" For binary access read As #1)=0 then
'		get #1,,header
		
'		mapwidth=header.w
'		mapheight=header.h
		
'		for j=0 to (mapheight-1)
'			for i=0 to (mapwidth-1)        
'	                	get #1, ,b,1
'				get #1, ,g,1
'				get #1, ,r,1
				
'				if (r=255 and g=0 and b=255) then 
'					map(i,(mapheight-1)-j).c=1
'				end if
'			next i
'		next j
		
'		Close #1
'	end if
	
	'' load area names
	'if  Open(path+"map.txt" For input As #1)=0 then
	'	for i=0 to 11
	'	input #1,location(i)
	'	next i
	'Close #1
	'end if
	
	location(0)="Mr Oldman"
	location(1)="Shop / Mountain path"
	location(2)="Nothing of note.."
	location(3)="Maze with a hole"
	location(4)="Three houses.."
	location(5)="Access to the fishing lake"
	location(6)="Access to the Haunted Forest"
	location(7)="More flowers"
	location(8)="Odd stone arrangement"
	location(9)="Nothing"
	location(10)="Nothing"
	location(11)="Nothing"
	
	''
	
	done_npc=1	

end sub

sub rpg_drawmap()
	dim as integer i,j

	for j=0 to 12
		for i=0 to 19
			with map(i+player.mx,j+player.my)
				put (i*32,j*32),sprite(0),pset
			
				if .s>0 and .s<17 then put (i*32,j*32),sprite(.s),trans
			end with
			
		next i
	next j
	
	'' do these seperatly so scenery does not overwrite part of the image
	for j=0 to 12
		for i=0 to 19
			with map(i+player.mx,j+player.my)
				if .s>=17 then put (i*32,j*32),sprite(.s),trans
			end with
		next i
	next j

	'' draw other characters
	npc_draw()

	'' Messages: Location Prompts...

	bar_title=""
	
	with player
	
		select case as const map(.x+.mx,.y+.my-1).s
		case 17:
			bar_title="#Press Space to talk to the guard!"
		case 18:
			bar_title="#Press Space to talk to Mr Oldman!"
		end select

		if bar_title="" then
			select case as const map(.x+.mx,.y+.my).s
			case 8:
				bar_title="#Press Space to climb down the hole!"
			case 10:
				bar_title="#Press Space enter this shop!"	
				
			case else:
				bar_title=location((.mx/20)+((.my/13)*3))
				
				'' Links to other areas
				if (.y+.my=0) then
					bar_title="#Across the river to the Dark Mountains!"	
				end if
		
				if (.x+.mx=0) then
					bar_title="#Onward to the Haunted Fruit Forest!"	
				end if
		
				if (.x+.mx=59) then
					bar_title="#To The Great Fishing Lake!"	
				end if
				
			end select
		end if
	end with	

end sub

sub rpg_controls()
	dim as integer i
	''
	'' Player controls
	''
	with player
	
	if .xdir=0 and .ydir=0 then
		if  MultiKey(SC_UP) then
		
			if (.y+.my=0) then
				game=MODE_MOUNTAIN
				goto eokeys:
			else	
				if (map(.x+.mx, .y+.my-1).c=0) then
					.ydir=-1
				'	.s=2
					goto eokeys:
				end if
			end if
		end if
		
		if  MultiKey(SC_DOWN)then
			if (map(.x+.mx, .y+.my+1).c=0) then
				.ydir=1
			'	.s=3
				goto eokeys:
			end if
		end if
		
		if  MultiKey(SC_LEFT) then
		
			if (.x+.mx=0) then
				game=MODE_FOREST
				goto eokeys:
			else
				if (map(.x+.mx-1, .y+.my).c=0) then
					.xdir=-1
					.s=1
					goto eokeys:
				end if
			end if
		end if
		
		
		if  MultiKey(SC_RIGHT)then
		
			if (.x+.mx=59) then
				game=MODE_FISHING
				goto eokeys:
			else
		
				if (map(.x+.mx+1, .y+.my).c=0) then
					.xdir=1					
					goto eokeys:		
				end if	
			end if
			
			
			
		end if
		
		if  MultiKey(SC_SPACE) then
			spacepressed=1
			
		end if
		
		if MultiKey(SC_SPACE)=0 and spacepressed=1 then
			spacepressed=0
	
			select case as const map(.x+.mx, .y+.my).s
			case 8:
			
				gen_start()
			
				game=MODE_ROCKFALL
				
			case 10:
				
				game=MODE_SHOP	
				
			end select
			
			'' Begin chat with people
			ui_cleartext()
			select case as const map(.x+.mx, .y+.my-1).s
			case 17:
				'' guard
				select case as const mytasks(1).active
				case 0
					'' chat and give task
					ui_text(0)="Sorry I can't let you pass!"
					ui_text(1)="%Er... why not?"
					
					ui_text(3)="Last weeks earthquake uncovered some ancient"
					ui_text(4)="ruins inside the mountains. Could be dangerous.."
					ui_text(5)="%Oh.."
					
					'' If first task complete, add the next!
					if mytasks(0).active=2 then
						ui_text(7)="Guarding is sooo boring, I wish I had some sweets to "
						ui_text(8)="suck on. That would help pass the time..."
						ui_text(9)="%*Hmmm... so the guard wants some sweets?....*"			
						mytasks(1).active=1
					end if
					
					ui_window()
					'' ui_waitspace()
				case 1
					if task_iscomplete(1)=1 then
						'' task completed
						ui_text(0)="Sorry I can't let you pass!"
						ui_text(1)=""
						ui_text(2)="%(You give the guard the sweets)"
						ui_text(3)=""
						ui_text(4)="What? Some sweets for me? Wow! Thanks!"
						ui_text(5)="Okay, you can pass, just don't tell anyone I"
						ui_text(6)="let you through!"
						rpg_mapremove(11)
						
					else
						ui_text(0)="Sorry I can't let you pass!"
						ui_text(2)="Guarding is sooo boring, I wish I had some sweets to "
						ui_text(3)="suck on. That would help pass the time..."
					end if
					
					inventory_remove("Sweets",1)
						
					ui_window()
				case 2
					ui_text(0)="Slurp.. slurp.. slurp..."
					ui_window()
					'' ui_waitspace()
					
				case else
					ui_text(0)="ERROR! Task 1 active state = "+str(mytasks(1).active)	
					ui_window()
					'' ui_waitspace()
				end select
				
				'' ui_waitspace()
					
			case 18:
				''old man
				select case as const mytasks(0).active
				case 0
					'' chat and give task
					ui_text(0)="Good morning!"
					ui_text(1)="%Morning Mr Oldman!"
					ui_text(2)=""
					ui_text(3)="Are you busy?"
					ui_text(4)="%Well, I do have..."
					ui_text(5)=""
					ui_text(6)="That's great! I need someone to collect"
					ui_text(7)="some things for my breakfast!"
					ui_text(8)="%Fine... What do you need then?"
					ui_text(9)=""
					ui_text(10)="Some milk, oats, fish, fruit. If you press [T]"
					ui_text(11)="later, you can see the complete list."
					ui_text(12)="%That sounds easy enough, though I don't"
					ui_text(13)="%understand the press tea part.."
					ui_text(14)=""
					ui_text(15)="If you make it back safely, I will give you an"
					ui_text(16)="excellent item as a reward!"
					ui_text(17)="%'Make it back safely'? Oh dear..."
				
					
				'	ui_window()
				'	ui_cleartext()
				'	ui_text(0)="If you make it back safely, I will give you an"
				'	ui_text(1)="excellent item as a reward!"
				'	ui_text(2)=""
				'	ui_text(3)="%'Make it back safely'? Oh dear..."
					
					
					ui_window()
					
					mytasks(0).active=1
				case 1
					if task_iscomplete(0)=1 then
						'mytasks(0).active=2
						'' task completed
						ui_text(0)="Great, you got all my stuff!"
						ui_text(1)="%The fruit was a pain to get.."
						ui_text(2)="Yeah, those ghosts sure like their fruit.."
						ui_text(3)=""
						
						ui_text(4)="Anyway, here's a reward for your troubles!"
						ui_text(5)="%What is it??"
						ui_text(6)=""
						
						ui_text(7)="Some ancient thing, I think it's called an 'Air Stone'"
						ui_text(8)="%Okaay..."
						ui_text(9)=""
						
						ui_text(10)="Have you been to the mountains? I've heard some "
						ui_text(11)="interesting stuff is happening up there!"
						ui_text(12)="%The guard is not letting anyone pass..."
						ui_text(13)=""
					
						ui_text(14)="The guard can be stubborn but if you speak to him, he"
						ui_text(15)="may give you an idea of how to get passed..."
					
						with mytasks(0)
						for i=0 to 4
						inventory_remove(.required(i).name,.required(i).quantity)
						next i
						end with
						
						inventory_add("Air_Stone")
						
					else
						
						'' task not complete
						ui_text(0)="Have you got my stuff yet?"	
						ui_text(1)="Press [T] if you need a reminder..."	
						
						
	
					end if
					ui_window()
					
				case 2
					ui_text(0)="Thanks for fetching my food earlier!"
					ui_text(1)="Have you been to the mountains yet?"
					ui_window()

					
				end select
				'' end of old man banter...
			end select
			
			
			
		
		end if
		'if .xdir=1 then .s=0 else 
		eokeys:
	end if
	

	'' Move 	
	if .xdir<>0 then
	
		.ox+=(2*.xdir)
		
		if .xdir=1 then
			if abs(.ox)<16 then
			 .s=5
			else
			 .s=0
			end if	
		end if
		
		if .xdir=-1 then
			if abs(.ox)<16 then
			 .s=6
			else
			 .s=1
			end if	
		end if
		
		if abs(.ox)=30 then
			.ox=0
			
			if .xdir=1 then
				if (.x=19) then
					.x=0
					.mx+=20
				else
					.x+=.xdir
				end if
			else
				if (.x=0 and .mx>0) then
					.x=19
					.mx-=20
				else
					.x+=.xdir
				end if
			end if
			
			.xdir=0
		end if	
	
	end if
	
	
	if .ydir<>0 then
	
		.oy+=(2*.ydir)
		
		if .ydir=1 then
			if abs(.oy)<16 then
			 .s=3
			else
			 .s=8
			end if	
		end if
		
		if .ydir=-1 then
			if abs(.oy)<16 then
			 .s=2
			else
			 .s=7
			end if	
		end if
		
		
		if abs(.oy)=30 then
			.oy=0
			
			if .ydir=1 then
				if (.y=12) then
					.y=0
					.my+=13
				else
					.y+=.ydir
				end if
			else
				if (.y=0 and .my>0) then
					.y=12
					.my-=13
				else
					.y+=.ydir
				end if
			end if
			
			.ydir=0
		end if	
	
	end if
	
	end with
end sub
