'' Adventure for Breakfast by ssjx (15/01/11) [http://ssjx.co.uk]
'' ==============================================================
''
''
'' Player / Inventory
''
#include "header.bi"

common shared inventory() as item
dim inventory(20) as item

dim shared inventorytemp(20) as item


sub inventory_save()
	dim i as integer
	for i=0 to ubound(inventory)
		inventorytemp(i)=inventory(i)
		'inventorytemp(i).name=inventory(i).name
		'inventorytemp(i).quantity=inventory(i).quantity
	next i
end sub

sub inventory_restore()
	dim i as integer
	for i=0 to ubound(inventory)
		inventory(i)=inventorytemp(i)
'		inventory(i).name=inventorytemp(i).name
'		inventory(i).quantity=inventorytemp(i).quantity
	next i
end sub

sub inventory_clear()
	dim i as integer
	for i=0 to ubound(inventory)
		with inventory(i)
			.quantity=0
			.name=""	
		end with
	next i
end sub

sub inventory_add(item as string)
	dim as integer i,done=0
	''
	'' Add to existing item
	for i=0 to ubound(inventory)
		with inventory(i)
			if .name=item then
			.quantity+=1
			done=1
			end if 		
		end with
	next i
	''
	''
	'' Not found? Then it's a new item!
	if done=0 then
		for i=0 to ubound(inventory)
			with inventory(i)
				if .name="" then
					.name=item
					.quantity=1
					exit for	
				end if
			end with
		next i
	end if
	

end sub

sub inventory_remove(item as string,qty as integer)
	dim as integer i

	for i=0 to ubound(inventory)
		with inventory(i)
			if .name=item then
				.quantity-=qty	
				if .quantity=0 then .name=""			
			end if 		
		end with
	next i

end sub

function inventory_itemcheck(item as string, quantity as integer) as integer
	dim as integer i

	for i=0 to ubound(inventory)
		with inventory(i)
			if .name=item then
				if .quantity>=quantity then return 1 else return 0			
			end if 		
		end with
	next i
	
	return 0
end function

function inventory_count(item as string) as integer
	dim as integer i

	for i=0 to ubound(inventory)
		with inventory(i)
			if .name=item then
				return .quantity			
			end if 		
		end with
	next i
	
	return 0
end function
