'' Adventure for Breakfast by ssjx (15/01/11) [http://ssjx.co.uk]
'' ==============================================================
''
''
'' Forest
''

#include "bmp.bi"
#include "header.bi"
#include "fmod.bi"

common shared player as myplayer
'' Sound samples
common shared sample() As Integer
''

'' in inventory.bas
declare sub inventory_add(as string)
declare sub inventory_restore()

''  in ui
common shared bar_title as string
common shared ui_text() as string
declare sub ui_waitspace()
declare sub ui_bar()

'' in asm.bas
declare sub togray()


'' used in game.bas
common shared game as integer

'common shared sprite() as any ptr
dim shared sprite(12) as any ptr

dim shared as integer spacepressed=0

dim shared map(64,64) as xypos

common shared mytasks() as task

dim shared ghost(20) as myghost
dim shared tplayer as myplayer
 
sub forest_exit()

	player.x=tplayer.x
	player.y=tplayer.y
	player.mx=tplayer.mx
	player.my=tplayer.my

	player.ox=0
	player.oy=0
	player.xdir=0
	player.ydir=0
	
		
end sub
 
sub forest_initsprites()
	dim i as integer	
	for i=0 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
	next i
end sub

sub forest_loadsprites(town as integer)

	dim i as integer
	dim path as string="gfx/forest"+str(town)+"/"

	select case as const town
		case 1:
			'' normal 32x32 sprites
			bload path+"grass.bmp",sprite(0)
			bload path+"tree.bmp",sprite(1)
			bload path+"ghost.bmp",sprite(2)
			bload path+"ghost.bmp",sprite(3)
			
			bload path+"red_apple.bmp",sprite(4)
			bload path+"cherry.bmp",sprite(5)
			bload path+"green_apple.bmp",sprite(6)
			bload path+"strawberry.bmp",sprite(7)
			
			bload path+"grass2.bmp",sprite(8)
			
			bload path+"ghost2.bmp",sprite(9)
			bload path+"ghost2.bmp",sprite(10)
			
			bload "gfx/stones/earth.bmp",sprite(11)
			
			bload path+"boulder2.bmp",sprite(12)
			
	end select
	

end sub

sub forest_start()

'' entry point
tplayer.x=player.x
tplayer.y=player.y
tplayer.mx=player.mx
tplayer.my=player.my

'' find and set start

player.mx=40
'player.my=13

player.x=19
'player.y=8

end sub



sub forest_loadmap(town as integer)
	dim as ubyte r,g,b
	dim as integer gc=0
	
	dim as integer i,j
	dim header as bmphdr
	dim as uinteger mapwidth,mapheight
	dim path as string="maps/forest.bmp"

	'' Reset ghosts
	'' ghosts
	for i=0 to ubound(ghost)
		with ghost(i)
			.t=0
		end with
	next i

	''clear the entire map array
 	for j=0 to 64
		for i=0 to 64
		with map(i,j) 
		.s=0
		.x=0
		.y=0
		.c=0
		end with
		next i
	next j	

	'' load the map
	if  Open(path For binary access read As #1)=0 then
		get #1,,header
		
		mapwidth=header.w
		mapheight=header.h
		
		for j=0 to (mapheight-1)
			for i=0 to (mapwidth-1)        
	                	get #1, ,b,1
				get #1, ,g,1
				get #1, ,r,1
				
				
				'' don't put fruit back if collected
				if map(i,(mapheight-1)-j).r=1 then
					continue for
				end if
				
				'' tree
				if (r=0 and g=0 and b=0) then 
					map(i,(mapheight-1)-j).s=1
					map(i,(mapheight-1)-j).c=1
					
				end if
				
				''' path
				if (r=255 and g=255 and b=255) then 
					map(i,(mapheight-1)-j).s=0
				end if
				
				''' link path (ghost avoid)
				if (r=255 and g=0 and b=255) then 
					map(i,(mapheight-1)-j).s=8
				end if
				
				''' red apple
				if (r=255 and g=0 and b=0) then 
					map(i,(mapheight-1)-j).s=4
				end if
			
				''' 
				if (r=0 and g=255 and b=0) then 
					map(i,(mapheight-1)-j).s=5
				end if
				
				
				''' ghost start point
				if (r=255 and g=255 and b=0) then 
					map(i,(mapheight-1)-j).s=0
					
					with ghost(gc)
						.t=1
						.x=i
						.y=(mapheight-1)-j
						.ox=0
						.oy=0
						.xdir=0
						.ydir=0
						.s=2
					end with
					gc+=1
					
				end if
				
					''' super ghost start point
				if (r=128 and g=0 and b=255) then 
					map(i,(mapheight-1)-j).s=0
					
					with ghost(gc)
						.t=2
						.x=i
						.y=(mapheight-1)-j
						.ox=0
						.oy=0
						.xdir=0
						.ydir=0
						.s=9
					end with
					gc+=1
					
				end if
				
				''' 
				if (r=0 and g=0 and b=255) then 
					map(i,(mapheight-1)-j).s=11	'' Earth Stone
				end if
				
				if (r=200 and g=200 and b=0) then
					'' if tremor not happened
					if mytasks(2).active=0 then
						map(i,(mapheight-1)-j).s=12 '' gold boulder
						map(i,(mapheight-1)-j).c=1
					else
						map(i,(mapheight-1)-j).s=8 '' link path
					end if
				end if
				
			next i
		next j
		
			
	        Close #1     
	end if
	
	
	
		

end sub

sub forest_drawmap()
	dim as integer i,j
	dim as integer gx,gy

	'' trees
	for j=0 to 12
		for i=0 to 19
			with map(i+player.mx,j+player.my)
			
				put (i*32,j*32),sprite(0),pset
				if .s>0 then put (i*32,j*32),sprite(.s),trans
			end with
		next i
	next j
	
	
	'' ghosts
	for i=0 to ubound(ghost)
		with ghost(i)
			if .t>0 then
				gx=((.x-player.mx)*32)+.ox '????
				gy=((.y-player.my)*32)+.oy '????
				
				if gx>0 and gx<640 then
					if gy>0 and gy<400 then				
						put (gx ,gy),sprite(.s),trans
					end if
				end if
			end if
			
		end with
	next i
	
	'' Messages: Location Prompts...
	bar_title="Haunted Fruit Forest"

end sub

sub forest_collect()

	with player
		select case as const  map(.x+.mx,.y+.my).s
		case 4:
			map(.x+.mx,.y+.my).s=0
			map(.x+.mx,.y+.my).r=2 ''
			inventory_add("Apple")
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
		case 5:
			map(.x+.mx,.y+.my).s=0
			map(.x+.mx,.y+.my).r=2 ''
			inventory_add("Cherry")
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
			
		case 11:
			map(.x+.mx,.y+.my).s=0
			map(.x+.mx,.y+.my).r=2 ''
			inventory_add("Earth_Stone")
			FSOUND_PlaySound(FSOUND_FREE, sample(0))
			
		end select
	end with

end sub

sub forest_removed(v as integer)
dim as integer i,j
	''clear the entire map array
 	for j=0 to 64
		for i=0 to 64
		if map(i,j).r=2 then map(i,j).r=v '' 0= active 1= removed 2 = pending
		next i
	next j	
end sub


sub forest_update()

	dim as integer i,j,d,newdir 
	dim dirlist(3) as integer
	dim as integer ra,rb,rt
	dim as integer gx,gy,px,py
	dim as integer txdir,tydir
	
	for d=0 to 3
		dirlist(d)=d
	next d
	
	for j=0 to 10
		ra=int(rnd*4)
		rb=int(rnd*4)
		
		rt=dirlist(ra)
		dirlist(ra)=dirlist(rb)
		dirlist(rb)=rt
	next j

	'' move ghosts and check for hits, throw player out of forest if hit
	with player
	px=8+((.mx+.x)*32)+.ox
	py=((.my+.y)*32)+.oy
	end with
	
	#if DEBUG=1
		draw string (10,20+(i*20)),"P. "+str(px)+", "+str(py)
	#endif
	
	for i=0 to 20
		with ghost(i)
			
			''
			if .xdir<>0 then .ox+=.xdir
			if .ydir<>0 then .oy+=.ydir
			
			if abs(.ox)=32 then .ox=0:.x+=.xdir
			if abs(.oy)=32 then .oy=0:.y+=.ydir
			
			if .ox=0 and .oy=0 then
			
				for j=0 to 10
					ra=int(rnd*4)
					rb=int(rnd*4)
					
					rt=dirlist(ra)
					dirlist(ra)=dirlist(rb)
					dirlist(rb)=rt
				next j
			
				select case as const .t
				
				case 1:
				'' regular ghosts
				'' wall ahead, change direction
					if map(.x+.xdir,.y+.ydir).c=1 or map(.x+.xdir,.y+.ydir).s=8 or (.xdir=0 and.ydir=0) then
				
						for d=0 to 3
							newdir=dirlist(d)
							if newdir=0 then .xdir=0:.ydir=-1 ''up
							if newdir=1 then .xdir=0:.ydir=1 ''down
							if newdir=2 then .xdir=-1:.ydir=0 ''left
							if newdir=3 then .xdir=1:.ydir=0 ''right
							
							if map(.x+.xdir,.y+.ydir).c=0 and map(.x+.xdir,.y+.ydir).s<>8 then exit for
						next d
					end if
					
				case 2:
				'' super ghosts
					if player.mx=20 and player.my=26 then
					'' target player if in the particular area
						.xdir=0:.ydir=0
					
						for d=0 to 3
							newdir=dirlist(d)
							select case as const newdir
						
							case 0:
								if .x<player.x+player.mx then
								 	txdir=1:tydir=0
									if map(.x+txdir,.y+tydir).c=0 and  map(.x+txdir,.y+tydir).s<>8 then
										.xdir=1
										exit for
									end if
								end if
							
							case 1:
								if .x>player.x+player.mx then 
									txdir=-1:tydir=0
									if map(.x+txdir,.y+tydir).c=0 and  map(.x+txdir,.y+tydir).s<>8 then
										.xdir=-1
										exit for
									end if
								end if
							
							case 2:
								if .y<player.y+player.my then 
									txdir=0:tydir=1
									if map(.x+txdir,.y+tydir).c=0 and  map(.x+txdir,.y+tydir).s<>8 then
										.ydir=1
										exit for
									end if
								end if
							
							case 3:
								if .y>player.y+player.my then
									txdir=0:tydir=-1
									if map(.x+txdir,.y+tydir).c=0 and  map(.x+txdir,.y+tydir).s<>8 then
										 .ydir=-1
										exit for
									end if
								end if
							end select
						next d
						
					else
					'' super ghosts - move randomly if player not in area
						if map(.x+.xdir,.y+.ydir).c=1 or map(.x+.xdir,.y+.ydir).s=8 or (.xdir=0 and.ydir=0) then
					
							for d=0 to 3
								newdir=dirlist(d)
								if newdir=0 then .xdir=0:.ydir=-1 ''up
								if newdir=1 then .xdir=0:.ydir=1 ''down
								if newdir=2 then .xdir=-1:.ydir=0 ''left
								if newdir=3 then .xdir=1:.ydir=0 ''right
								
								if map(.x+.xdir,.y+.ydir).c=0 and map(.x+.xdir,.y+.ydir).s<>8 then exit for
							next d
						end if
					''
					end if
				end select	
				'' end of super ghosts ---
			end if 
		
			'' Actual ghost position
			gx=(.x*32)+.ox
			gy=(.y*32)+.oy
			
			#if DEBUG=1
				draw string (10,40+(i*20)),str(i)+". "+str(gx)+", "+str(gy)
			#endif
			
			'' see if ghost hit player	
			if (px>=gx and px<=gx+31) or (px+16>=gx and px+16<=gx+31) then
				
				if (py>=gy and py<=gy+31) or (py+31>=gy and py+31<=gy+31) then
				
					bar_title="%You hit a ghost! Press Space to continue!"
					togray()
					ui_bar()
					ui_waitspace()
					
					''
					'' remove items collected
					''
					inventory_restore()
					forest_removed(0)
					''
					''restore removed items
					'''
					''
					game=MODE_RPG
				
				end if
				
			end if
		
		end with
	next i



end sub




sub forest_controls()
	''
	'' Player controls
	''
	with player
	
	if .xdir=0 and .ydir=0 then
		if  MultiKey(SC_UP) then
			if (map(.x+.mx, .y+.my-1).c=0) then
				.ydir=-1
				.s=2
				goto eokeys:
			end if
		end if
		
		if  MultiKey(SC_DOWN)then
			if (map(.x+.mx, .y+.my+1).c=0) then
				.ydir=1
				.s=3
				goto eokeys:
			end if
		end if
		
		if  MultiKey(SC_LEFT) then
			if (map(.x+.mx-1, .y+.my).c=0) then
				.xdir=-1
				.s=1
				goto eokeys:
			end if
		end if
		
		
		if  MultiKey(SC_RIGHT)then
		
			if (.x+.mx=59) then
				game=MODE_RPG
				forest_removed(1)	'' if we have exited then really remove fruits (2=>1)
				goto eokeys:
			else
		
				if (map(.x+.mx+1, .y+.my).c=0) then
					.xdir=1					
					goto eokeys:		
				end if	
			end if
			
			
			
		end if
		
		
		'if .xdir=1 then .s=0 else 
		eokeys:
	end if
	

	'' Move 	
	if .xdir<>0 then
	
		.ox+=(2*.xdir)
		
		if .xdir=1 then
			if abs(.ox)<16 then
			 .s=5
			else
			 .s=0
			end if	
		end if
		
		if .xdir=-1 then
			if abs(.ox)<16 then
			 .s=6
			else
			 .s=1
			end if	
		end if
		
		if abs(.ox)=30 then
			.ox=0
			
			if .xdir=1 then
				if (.x=19) then
					.x=0
					.mx+=20
				else
					.x+=.xdir
				end if
			else
				if (.x=0 and .mx>0) then
					.x=19
					.mx-=20
				else
					.x+=.xdir
				end if
			end if
			
			'' collect
			forest_collect()
			
			.xdir=0
		end if	
	
	end if
	
	
	if .ydir<>0 then
	
		.oy+=(2*.ydir)
		
		'' animate up/down
		if .ydir=1 then
			if abs(.oy)<16 then
			 .s=3
			else
			 .s=8
			end if	
		end if
		
		if .ydir=-1 then
			if abs(.oy)<16 then
			 .s=2
			else
			 .s=7
			end if	
		end if
		''
		
		
		if abs(.oy)=30 then
			.oy=0
			
			if .ydir=1 then
				if (.y=12) then
					.y=0
					.my+=13
				else
					.y+=.ydir
				end if
			else
				if (.y=0 and .my>0) then
					.y=12
					.my-=13
				else
					.y+=.ydir
				end if
			end if
			
			'' collect
			forest_collect()
			
			
			.ydir=0
		end if	
	
	end if
	
	end with
end sub

