'' Adventure for Breakfast by ssjx (15/01/11) [http://ssjx.co.uk]
'' ==============================================================
''
''
'' Fishing!
''
''

#include "bmp.bi"
#include "header.bi"
#include "fmod.bi"

'' in inventory.bas
declare sub inventory_add(as string)

''
common shared player as myplayer
common shared bar_title as string
common shared game as integer
'' Sound samples
common shared sample() As Integer
''
''
dim shared as integer spacepressed=0,drophook
dim shared sprite(20) as any ptr 

dim shared fishstage as integer '' whether fish or jellies

'' list of all the exits and entries
dim shared exits(5) as mappos 

dim shared fish(10) as xypos
dim shared stone as xypos

dim shared as integer caught(10)

dim shared hook as xypos

dim shared tplayer as myplayer

sub fishing_initsprites()
	dim i as integer
	
	sprite(0) = ImageCreate( 64, 32,rgb(0,0,0) )	'' Boat
	sprite(1) = ImageCreate( 64, 32,rgb(0,0,0) )	'' 
	sprite(2) = ImageCreate( 16, 16,rgb(0,0,0) )	'' Hook
	
	for i=3 to ubound(sprite)
		sprite(i) = ImageCreate( 32, 32,rgb(0,0,0) )
	next i

	'' all fish not caught yet
	for i=0 to ubound(fish)
		caught(i)=0
	next i
	

end sub

sub fishing_loadsprites(town as integer)

	dim i as integer
	dim path as string

	''player
	path="gfx/player/"
	bload path+"boat_r.bmp",sprite(0)
	bload path+"boat_l.bmp",sprite(1)

	'' 
	path="gfx/fishing/"
	bload path+"hook.bmp",sprite(2)
	bload path+"yellow_fish_r.bmp",sprite(3)
	bload path+"green_fish_r.bmp",sprite(4)
	bload path+"red_fish_r.bmp",sprite(5)
	
	bload path+"yellow_fish_l.bmp",sprite(6)
	bload path+"green_fish_l.bmp",sprite(7)
	bload path+"red_fish_l.bmp",sprite(8)	
	
	bload path+"jelly_1.bmp",sprite(10)
	bload path+"jelly_2.bmp",sprite(11)
	bload path+"jelly_3.bmp",sprite(12)

	bload "gfx/stones/water.bmp",sprite(13)

	bload path+"plant.bmp",sprite(14)
	
end sub

sub fishing_start(stage as integer)
	dim as integer i,c=5
	
	fishstage=stage
	
	if fishstage=2 then c=10
	
	for i=0 to c
	
	with fish(i)
	
		'' sprite and direction
		if fishstage=1 then
			'' fish
			.x=int(rnd*600)
			.y=260+i*24
			.s=3+int(rnd*3)
		else
		
			.x=int(rnd*600)
			.y=260+int(rnd*5)*24
		
			'' jelly
			.s=10+int(rnd*3)
		end if
		
		if int(rnd*10)>5 then
			.xdir=1
		else
			.xdir=-1
		end if
		
	end with
	next i
	
	with stone
		if int(rnd*10)>5 then
			.xdir=1
		else
			.xdir=-1
		end if
		
		.x=int(rnd*600)
		.y=360
	end with
	
	
	tplayer.x=player.x
	tplayer.y=player.y
	tplayer.mx=player.mx
	tplayer.my=player.my
	
	
	player.x=0
	player.y=200-32
	
end sub

sub fishing_exit()

	player.x=tplayer.x
	player.y=tplayer.y
	player.mx=tplayer.mx
	player.my=tplayer.my

	player.ox=0
	player.oy=0
	
	player.xdir=0
	player.ydir=0
	
end sub



sub fishing_drawmap()
	dim as integer i,j,c=5

	'' background
	'line (0,0)-(640,200),rgb(50,150,250),bf
	'line (0,200)-(640,480),rgb(50,200,200),bf

	for j=0 to 19
	line (0,(j*10)) -(640,(j+1)*10),rgb(50+(j*8),150+(j*4),250),bf
	next j
		
	for j=0 to 12
	line (0,200+(j*20)) -(640,200+(j+1)*20),rgb(0,0,200-(j*15)),bf
	next j
	
	'' seaweed
	for i=0 to 19
	put (i*32,12*32),sprite(14),trans
	next i
	

	'' fish
	if fishstage=2 then c=10
	
	for i=0 to c
		with fish(i)
			'' draw fish is swimming or moving up
			
		
			if fishstage=1 then
				if caught(i)<2 then
					'' fish
					if .xdir=1 then
						put (.x,.y),sprite(.s),trans
					else
						put (.x,.y),sprite(.s+3),trans
					end if
				end if
			else	
				'' jelly
				put (.x,.y),sprite(.s),trans
			end if
		
		end with
	next i
	
	
	
	

	
	if fishstage=2 and stone.r=0 then
		'' water stone
		put (stone.x,stone.y),sprite(13),trans
	end if
	
	
	'' player + boat
	with player
		put (.x,.y),sprite(0),trans
	end with
	
		
	if drophook=0 then
		'' hang onto boat
		with player
			put (.x+48,.y+8),sprite(2),trans
		end with
	else
		'' dropped
		with hook
			put (.x,.y),sprite(2),trans
		end with
		
		with player
			line (.x+48+6,.y+6)-(.x+48+6,hook.y),rgb(255,255,255)
		end with
	end if
	
	
	
	bar_title="Fishing! Press [SPACE] to drop your hook"
	
	
	
end sub

'' move fish arround
sub fishing_update()
	dim as integer i
	
	'' move fish
	if fishstage=1 then
		for i=0 to 5
			with fish(i)
			
				'' move fish up with hook if caught
				if caught(i)=1 then
					.x=hook.x-8
					.y=hook.y
				end if
				
				'' not caught
				if caught(i)=0 then
				
					'' move
					.x+=.xdir
					if (.x=0 or .x=(640-32)) then
						.xdir*=-1
					end if
					
					'' see if we have hooked it!
					
					
					if drophook=1 then				
						if (hook.x+8>.x and hook.x+8<.x+32) then
							if (hook.y+8>.y and hook.y+8<.y+32) then
								'' caught a fish!
								FSOUND_PlaySound(FSOUND_FREE, sample(0))
								caught(i)=1
								hook.ydir=-2
							
							end if
						end if
					
					end if
					''		
				end if
			
			end with
		next i
	end if
	''
	''
	if fishstage=2 then
		for i=0 to 10
			with fish(i)
		
				'' move jelly
				.x+=.xdir
				if (.x=0 or .x=(640-32)) then
					.xdir*=-1
				end if
			
				'' see if hook hit jelly
				if drophook=1 then	
					if (hook.x+8>.x and hook.x+8<.x+32) then
						if (hook.y+8>.y and hook.y+8<.y+32) then
							'' hit a jelly...
							hook.ydir=-2
							'.r=
						end if
					end if		
				end if
			end with
		next i
		
		
		
		with stone
			if .r=0 then
			
				'' Move the stone
				if .c=0 then
					'' Not collected so move l<>r
					.x+=.xdir
					if (.x=0 or .x=(640-32)) then
						.xdir*=-1
					end if
					
					'' See if we have caught it
					if drophook=1 then	
						if (hook.x+8>.x and hook.x+8<.x+32) then
							if (hook.y+8>.y and hook.y+8<.y+32) then
								'' hooked stone
								FSOUND_PlaySound(FSOUND_FREE, sample(0))
								hook.ydir=-2
								.c=1	'' using C as caught in this case
							end if
						end if		
					end if
				else
					'' move up as caught
					.x=hook.x-8
					.y=hook.y
				end if
				
			end if 
		end with
		 

	end if
	''
	''
	
	if drophook=1 then
		with hook
			.y+=.ydir
			
			'' change hook direction if hit the bottom
			if .y>=480-(48+16) then .ydir=-2
			
			'' hook returned to start point
			if .y=player.y+8 then
				drophook=0
				for i=0 to 10
					if caught(i)=1 then
						caught(i)=2
						inventory_add("Fish")
					end if 
				next i
				
				if stone.c=1 and stone.r=0 then
					stone.r=1
					inventory_add("Water_Stone")
				end if 
			end if
			
		end with
	end if
	

end sub

sub fishing_controls()
''
	''
	'' Player controls
	''
	with player
		if drophook=0 then
		
			if  MultiKey(SC_LEFT) then
				.xdir=-1
				if .x>0 then
					.x-=2
				else
					if .x=0 then game=MODE_RPG
				end if
				
			end if
			
			
			if  MultiKey(SC_RIGHT)then
				.xdir=1
				if (.x+64)<640 then .x+=2
			end if
				
			if  MultiKey(SC_SPACE) then
				spacepressed=1
			end if
		end if
		'' space bar released
		if MultiKey(SC_SPACE)=0 and spacepressed=1 then
			spacepressed=0
	
			if drophook=0 then
				hook.x=player.x+48
				hook.y=player.y+8
				hook.ydir=2
				drophook=1
			end if
			
		end if
		
		eokeys:
	end with

''
end sub

