'' Adventure for Breakfast by ssjx (15/01/11) [http://ssjx.co.uk]
'' ==============================================================
''
'' Freebasic Flip Screen walk around (7/11/10)
''
'' TODO:
'' + Get game timer working!
'' + Sign posts - almost done
'' + Transitions when ghost/boulder/spider hit...  - Done
'' + End game effect + Fade Effect to ... ! - Almost done
'' + Title / Exit (+hit summary?) screen graphics - Mostly Done
'' + Sound (collect/boulder fall) - Mostly Done
'' + Improve fishing graphics! - Done (gradients)
'' + TESTING
''
'' + Remove Firestone from shop when bought - Done?
'' + Add guard barrier - Done!
'' + Add Cave spiders	- Done!
'' + Increase mine difficulty? -Done!
'' +
'' + UI get sprite ranges! - Done
'' + Sort out super ghosts when not visisble - Done
''
'' + Characters to talk to plus some wandering aimlesslessy
'' + Shop (like the one in C64 Midnight Resistance)
'' 	+-> Oats, Milk, Gem * Almost done
'' + Key Stones that open new areas
'' + Super Ghosts that home in on the player  * Done!
'' + Jelly Fish to avoid in the 2nd Lake * Done!
'' + New underground bit with key puzzle and maybe spiders to avoid??
''
''
#include "header.bi"
#include "fmod.bi"

'' in map.bas
declare sub rpg_initsprites()
declare sub rpg_loadsprites(as integer)
declare sub rpg_loadmap(as integer)
declare sub rpg_drawmap()
declare sub rpg_controls()
declare sub rpg_exitmine()


'' in mine.bas
declare sub mine_initsprites()
declare sub mine_loadsprites(as integer)
declare sub mine_loadmap(as integer)
declare sub mine_drawmap()
declare sub mine_controls()
declare sub mine_update()
declare sub mine_start()

'' used in mine.bas
common shared mine_entry as mappos
common shared mine_exit as mappos


'' in fishing.bas
declare sub fishing_initsprites()
declare sub fishing_loadsprites(town as integer)
declare sub fishing_start(as integer)
declare sub fishing_exit()
declare sub fishing_drawmap()
declare sub fishing_update()
declare sub fishing_controls()

'' in forest.bas
declare sub forest_loadmap(as integer)
declare sub forest_initsprites()
declare sub forest_loadsprites(town as integer)
declare sub forest_start()
declare sub forest_drawmap()
declare sub forest_update()
declare sub forest_controls()

declare sub forest_exit()

'' in ui.bas
declare sub ui_load()
declare sub ui_bar()
declare sub ui_window()
declare sub ui_basicwindow()
declare sub ui_tasklist()
declare sub ui_cleartext()
'declare sub ui_waitspace()
common shared bar_title as string
declare sub ui_smallwindow(as string)
common shared ui_text() as string
declare function ui_waitescape() as integer

'' in tasks.bas
declare sub task_add(as integer)
common shared mytasks() as task

'' in npc.bas
declare sub npc_init()
declare sub npc_update()

'' shop.bas
declare sub shop_initsprites()
declare sub shop_loadsprites()
declare sub shop_loadmap()
declare sub shop_start()
declare sub shop_exit()
declare sub shop_controls()
declare sub shop_drawmap()

'' in mountain.bas
declare sub mountain_initsprites()
declare sub mountain_loadsprites()
declare sub mountain_loadmap()
declare sub mountain_drawmap()
declare sub mountain_controls()
declare sub mountain_update()
declare sub mountain_start()
declare sub mountain_exit()

'' in asm.bas
declare sub togray()

'' in inventory.bas
declare sub inventory_clear()
declare sub inventory_add(item as string)
declare sub inventory_save()
''' =========================

'dim sprite(20) as any ptr 
dim playersprite(10) as any ptr 

'' map things...

common shared map() as xypos
dim map(64,64) as xypos

dim as integer quit,i,j,release,xdir,ydir,escapepressed=0

dim as double starttime,endtime
dim as integer ttime,mins,secs,besttime=20*60

common shared game as integer

common shared as integer swidth,sheight,sdepth
''
common shared  player as myplayer


''' -- Sound ---

FSOUND_Init(44100, 8, 0) 

common shared sample() As Integer
dim sample(10) As Integer

for i=0 to 3
	sample(i) = FSOUND_Sample_Load(FSOUND_FREE,"wav\"+str(i)+".mp3", FSOUND_HW3D, 0, 0) 
next i

''''''''''''''''''''''''''
windowtitle GAMETITLE+" ["+VERSION+"]"
screen 18,32,1'''  ,&h01

screeninfo swidth,sheight,sdepth

for i=0 to ubound(playersprite)
playersprite(i) = ImageCreate( 32, 32,rgb(100,255,100) )
next i

bload "gfx/player/right.bmp",playersprite(0)
bload "gfx/player/left.bmp",playersprite(1)
bload "gfx/player/up.bmp",playersprite(2)
bload "gfx/player/down.bmp",playersprite(3)

bload "gfx/player/right_1.bmp",playersprite(5)
bload "gfx/player/left_1.bmp",playersprite(6)
bload "gfx/player/up_1.bmp",playersprite(7)
bload "gfx/player/down_1.bmp",playersprite(8)
''
ui_load()

quit=0
'' reset player
#if DEBUG=3
	inventory_clear()
	task_add(-1)
	mytasks(0).active=2 '' oldman
	mytasks(1).active=2 '2 '' sweets
	mytasks(2).active=1
	inventory_add("Air_Stone")
	inventory_add("Earth_Stone")
	inventory_add("Fire_Stone")
	inventory_add("Water_Stone")
#endif

with player
	.s=0
	.x=8
	.y=8
	.mx=0
	.my=0
	.xdir=0
	.ydir=0
end with

'' welcome 
game=MODE_WELCOME

'' Load best time
	if Open("save.dat" For Binary Access read As #1)=0 then
		get #1, , besttime

		' Close the file.  
		Close #1		
	End If

''
npc_init()

rpg_initsprites()
rpg_loadsprites(1)

mine_initsprites()
mine_loadsprites(1)

fishing_initsprites()
fishing_loadsprites(1)

forest_initsprites()
forest_loadsprites(1)

shop_initsprites()
shop_loadsprites()

mountain_initsprites()
mountain_loadsprites()


	select case as const game
	case MODE_RPG: 
		rpg_loadmap(1)	
		rpg_drawmap()
		
	case MODE_ROCKFALL:
		mine_loadmap(1)
		mine_drawmap()

	case MODE_FISHING
		fishing_start(1)
		fishing_drawmap()

	case MODE_FOREST
		forest_loadmap(1)	
		forest_start()
		forest_drawmap()

	case MODE_MOUNTAIN
		mountain_loadmap()	
		mountain_start()
		mountain_drawmap()		
	end select
	
rpg_loadmap(1)	

do
	FSOUND_Update
	''
	'' Draw everything
	''
	
	screenlock()
		
		select case as const game
		case MODE_WELCOME: 
			rpg_loadmap(1)		
			rpg_drawmap()
			togray()
			bar_title="#Welcome to '"+GAMETITLE+"' ("+VERSION+") by ssjx ["+SITEURL+"]"
		case MODE_RPG: 	
			rpg_drawmap()			
		case MODE_ROCKFALL:
			mine_drawmap()
		case MODE_FISHING
			fishing_drawmap()
		case MODE_FOREST
			forest_drawmap()
		case MODE_SHOP
			shop_drawmap()
		case MODE_MOUNTAIN
			mountain_drawmap()
		
		case MODE_COMPLETE:
			mountain_drawmap()
			togray()
		end select
	
		'' Fishing using player in boat sprites...
		if (game<>MODE_FISHING and game<>MODE_WELCOME) then
			with player
				put ((.x*32)+.ox,(.y*32)+.oy),playersprite(.s),trans
			end with	
		end if
		
		ui_bar()
	
		#if DEBUG=2
			with player
			draw string (10,10),"mx:"+str(.mx)+" , "+str(.my)
			draw string (10,30),"x:"+str(.x)+" , "+str(.y)
			
			end with
		#endif
	
	screenunlock()
	
	
	select case as const game
		case MODE_WELCOME
		
		if besttime>59 then
			ttime=besttime
			mins=0
			secs=0
			do
				ttime-=60
				mins+=1
			loop while (ttime-60)>=0
			secs=ttime
		else
			mins=0
			secs=besttime
		end if
		
			ui_cleartext()
			ui_text(0)=GAMETITLE
			ui_text(1)="%========================"
			ui_text(2)="FBGD November 2010 Competition Entry"
			ui_text(3)="by ssjx (http://ssjx.co.uk)"
			ui_text(4)=""
			ui_text(5)="Welcome to a small town in Gardenia, take a"
			ui_text(6)="look around and see what you find!"
			ui_text(7)=""
			ui_text(8)="Mr Oldman looks like he wants to speak to you..."
			ui_text(9)=""
			
			ui_text(10)="Controls"
			ui_text(11)="%--------"
			ui_text(12)="Arrows : Move the player"
			ui_text(13)="Space  : Action"
			ui_text(14)="Escape : Quit/Exit"
			
			ui_text(16)="Best Completion Time"
			ui_text(17)="%--------------------"
			ui_text(18)=str(mins)+" minutes and "+str(secs)+" seconds"
			
			ui_basicwindow()
			if ui_waitescape()=SC_SPACE then
			
				'' reset player
				inventory_clear()
				task_add(-1)
				
				with player
					.s=0
					.x=8
					.y=8
					.mx=0
					.my=0
					.xdir=0
					.ydir=0
				end with

				''				
				game=MODE_RPG
				starttime=timer
			else
				quit=1
			end if
			
		case MODE_COMPLETE
		
		endtime=timer
		ttime=int(endtime-starttime)
		
		if ttime>59 then
			mins=0
			secs=0
			do
				ttime-=60
				mins+=1
			loop while (ttime-60)>=0
			
			secs=ttime
			
		else
			'' prob cheated...
			mins=0
			secs=ttime
		end if
		
		ui_cleartext()
			ui_text(0)="WELL DONE!"
			ui_text(1)="%=========="
			ui_text(2)=""
			ui_text(3)="You have completed your adventure..."
			ui_text(4)=""
			ui_text(5)="...and maybe started another!"
			ui_text(6)=""
			ui_text(7)="%THANKS FOR PLAYING!"
			ui_text(8)="" '+str(int(endtime-starttime))
			ui_text(9)="You took "+str(mins)+" minutes and "+str(secs)+" seconds"
			ui_text(10)=""
			
			if endtime>besttime then
				besttime=int(endtime-starttime)
				ui_text(10)="%** A NEW BEST TIME! **"
				
				if Open("save.dat" For Binary Access write As #1)=0 then
					put #1, , besttime
					' Close the file.  
				Close #1		
			End If
				
			end if
			
			ui_window()
			
			
			
			game=MODE_WELCOME
		case MODE_RPG: 	
			rpg_controls()
			npc_update()
			
			'' if changed must have entered new section
			select case as const game
				case MODE_ROCKFALL:
					inventory_save() '' restored from this if killed...
					mine_loadmap(1)
					mine_start()
					'mine_drawmap()
			
				case MODE_FISHING:
				
					if player.my=0 then
						'' jelly
						fishing_start(2)
					else
						'' fish
						fishing_start(1)	
					end if	
					'mine_drawmap()
				
				case MODE_FOREST
					inventory_save() '' restored from this if killed...
				
					forest_loadmap(1)
					forest_start()
					'mine_drawmap()
					
				case MODE_SHOP
					shop_loadmap()
					shop_start()
					
				case MODE_MOUNTAIN
					mountain_loadmap()
					mountain_start()
			
			end select
			'' end of section change
			
		case MODE_ROCKFALL:
			mine_controls()
			mine_update()
			
			'' if changed must have left mine	
			if game=MODE_RPG then
			
				rpg_loadmap(1)	
				rpg_exitmine()
				
				rpg_drawmap()
				'mine_drawmap()
			end if
			
		case MODE_FISHING: 	
			fishing_controls()	
			fishing_update()
			
			if game=MODE_RPG then
				fishing_exit()
				rpg_loadmap(1)	
				''
				rpg_drawmap()
				'mine_drawmap()
			end if
			
			
		case MODE_FOREST: 	
			forest_controls()	
			forest_update()
			
			if game=MODE_RPG then
			
				forest_exit()
			
				rpg_loadmap(1)	
			
				'with player
				'	.x=0
				'	.mx=0
				'end with
				
				rpg_drawmap()
			end if
		
		case MODE_SHOP: 	
			shop_controls()	
		'	forest_update()
			
			if game=MODE_RPG then
				shop_exit()
				rpg_loadmap(1)	
				rpg_drawmap()
			end if
			
		case MODE_MOUNTAIN
			mountain_controls()
			mountain_update()
			
			if game=MODE_RPG then
				mountain_exit()
				rpg_loadmap(1)	
				''
				rpg_drawmap()
				'mine_drawmap()
			end if	
	end select
	
		
	''
	'' Escape to exit
	''
	
'	if multikey(SC_ESCAPE) then 
'		game=MODE_WELCOME
'	end if
	
			''	
		if  MultiKey(SC_ESCAPE) then
			escapepressed=1
		end if	
		
		if MultiKey(SC_ESCAPE)=0 and escapepressed=1 then
			escapepressed=0
			togray()
			ui_smallwindow("Are you sure you want to quit? Y/N")
			dim gk as integer
			
			While Inkey <> "": Wend
				
			gk=getkey()
			if gk=asc("y") then
				
				'' mountain larger than RPG map so..
				if game=MODE_MOUNTAIN then
					player.mx=0
					player.my=0
				end if
				
				game=MODE_WELCOME
			end if
			
		end if
	
	if multikey(SC_T) then
		ui_tasklist()
		''screencopy
	end if
	
	if multikey(SC_S) then
		bsave "screen.bmp",0
	end if
	
	''
	'' Sleep so we don't hog cpu...
	'' 
	
	sleep 10,1
		
loop while quit=0


''



