/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Vector;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;

public class Tar
implements ActionListener {
    private Vector<TarDescription> tarlist = new Vector();
    private String tarfile;
    private String basename;
    private JTable table;
    private JTextArea preview;
    Notepad parent;

    public Tar(Notepad notepad, String string) {
        File file = new File(string);
        this.basename = file.getName();
        this.basename = this.basename.substring(0, this.basename.lastIndexOf("."));
        this.basename = this.basename + ".txt";
        this.parent = notepad;
        this.tarfile = string;
    }

    private void check_end() {
        File file = new File(this.tarfile);
        if (file.exists()) {
            byte[] byArray = new byte[512];
            try {
                RandomAccessFile randomAccessFile = new RandomAccessFile(this.tarfile, "rw");
                long l = randomAccessFile.length();
                randomAccessFile.seek(randomAccessFile.length() - 1024L);
                randomAccessFile.read(byArray);
                boolean bl = true;
                for (byte by : byArray) {
                    if (by == 0) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    System.out.println("Removing empty end blocks from TAR");
                    randomAccessFile.setLength(l - 1024L);
                }
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                System.out.println("File exists but problem opening it?!");
            }
        }
    }

    public boolean exists() {
        File file = new File(this.tarfile);
        return file.exists();
    }

    private long octal(long l) {
        long l2 = 1L;
        long l3 = 0L;
        while (l != 0L) {
            l3 += l % 8L * l2;
            l2 *= 10L;
            l /= 8L;
        }
        System.out.println("T:" + l3);
        return l3;
    }

    public void adddata(byte[] byArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        long l = byArray.length;
        byte[] byArray2 = new byte[512];
        String string = this.basename;
        for (n5 = 0; n5 < string.length(); ++n5) {
            byArray2[n5] = (byte)string.charAt(n5);
        }
        System.out.println("Act Size: " + l);
        n5 = (int)this.octal(l);
        String string2 = Long.toString(n5);
        string2 = string2.trim();
        System.out.println("Oct Size: [" + string2 + "] Len:" + string2.length());
        for (n4 = 0; n4 < 11; ++n4) {
            byArray2[124 + n4] = 48;
        }
        for (n4 = 0; n4 < string2.length(); ++n4) {
            byArray2[135 - string2.length() + n4] = (byte)string2.charAt(n4);
        }
        long l2 = Instant.now().getEpochSecond();
        long l3 = this.octal(l2);
        String string3 = Long.toString(l3);
        string3 = string3.trim();
        for (n3 = 0; n3 < 12; ++n3) {
            byArray2[136 + n3] = 48;
        }
        byArray2[147] = 0;
        System.out.println("Oct Date: [" + string3 + "] Len:" + string3.length());
        for (n3 = 0; n3 < string3.length(); ++n3) {
            byArray2[147 - string3.length() + n3] = (byte)string3.charAt(n3);
        }
        long l4 = this.chksum(byArray2);
        n5 = (int)this.octal(l4);
        string2 = Long.toString(n5);
        string2 = string2.trim();
        System.out.println("M Oct Str: " + string2 + " Len:" + string2.length());
        for (n2 = 0; n2 < 8; ++n2) {
            byArray2[148 + n2] = 48;
        }
        byArray2[154] = 0;
        byArray2[155] = 32;
        for (n2 = 0; n2 < string2.length(); ++n2) {
            byArray2[154 - string2.length() + n2] = (byte)string2.charAt(n2);
        }
        n2 = 0;
        while ((long)(++n2 * 512) < l) {
        }
        int n6 = n2 * 512 - (int)l;
        byte[] byArray3 = new byte[n6];
        System.out.println("Blocks needed:" + n2);
        System.out.println("Block space  :" + n2 * 512);
        this.check_end();
        try {
            File file = new File(this.tarfile);
            FileOutputStream fileOutputStream = new FileOutputStream(file, true);
            fileOutputStream.write(byArray2);
            fileOutputStream.write(byArray);
            fileOutputStream.write(byArray3);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("File exists but problem opening it?!");
        }
    }

    public void listdata() {
        Object object;
        this.list();
        JFrame jFrame = new JFrame("Archive Browser");
        JLabel jLabel = new JLabel("Choose a point to preview or restore:");
        JButton jButton = new JButton("Preview");
        jButton.addActionListener(this);
        jButton.setActionCommand("Preview");
        JButton jButton2 = new JButton("Restore");
        jButton2.addActionListener(this);
        jButton2.setActionCommand("Restore");
        Object[] objectArray = new String[]{"Document", "Size", "Date", "Time"};
        DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray, 0);
        this.table = new JTable(defaultTableModel){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        this.table.setSelectionMode(0);
        this.table.setPreferredScrollableViewportSize(new Dimension(500, 200));
        for (TarDescription object22 : this.tarlist) {
            object = new Object[]{object22.name, object22.bytes, object22.date, object22.time};
            defaultTableModel.addRow((Object[])object);
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.table);
        this.preview = new JTextArea("Select a document above to see a preview", 18, 40);
        this.preview.setDisabledTextColor(Color.BLACK);
        this.preview.setEnabled(false);
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setViewportView(this.preview);
        object = new JPanel();
        GroupLayout groupLayout = new GroupLayout((Container)object);
        ((Container)object).setLayout(groupLayout);
        groupLayout.setAutoCreateGaps(true);
        groupLayout.setAutoCreateContainerGaps(true);
        groupLayout.setHorizontalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel).addComponent(jScrollPane).addComponent(jScrollPane2).addGroup(groupLayout.createSequentialGroup().addComponent(jButton).addComponent(jButton2))));
        groupLayout.setVerticalGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jScrollPane)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jScrollPane2)).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jButton).addComponent(jButton2)));
        jFrame.add((Component)object);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        switch (string = actionEvent.getActionCommand()) {
            case "Restore": {
                int n = JOptionPane.showConfirmDialog(null, "Restoring this document will overwrite the existing text, are you sure you wish to proceed?", "Are you sure?", 0, 2);
                if (n != 0) break;
                int n2 = this.table.getSelectedRow();
                this.loaddata(this.tarfile, this.tarlist.get((int)n2).pos, true);
                break;
            }
            case "Preview": {
                int n = this.table.getSelectedRow();
                this.loaddata(this.tarfile, this.tarlist.get((int)n).pos, false);
            }
        }
    }

    private boolean loaddata(String string, int n, boolean bl) {
        boolean bl2 = false;
        File file = new File(string);
        if (file.exists()) {
            long l = file.length();
            System.out.println("Tar Size: " + l);
            try {
                byte[] byArray = new byte[512];
                FileInputStream fileInputStream = new FileInputStream(file);
                fileInputStream.skip(n);
                int n2 = fileInputStream.read(byArray);
                if (n2 > 0) {
                    String string2 = new String(byArray, 0, 100);
                    string2 = string2.trim();
                    System.out.println(string2);
                    String string3 = new String(byArray, 124, 11);
                    int n3 = Integer.parseInt(string3, 8);
                    byte[] byArray2 = new byte[n3];
                    fileInputStream.read(byArray2);
                    String string4 = new String(byArray2);
                    if (bl) {
                        this.parent.inpText.setText(string4);
                    } else {
                        this.preview.setText(string4);
                    }
                    bl2 = true;
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File exists but problem opening it?!");
            }
        }
        return bl2;
    }

    public void addend() {
        try {
            File file = new File(this.tarfile);
            if (file.exists()) {
                FileOutputStream fileOutputStream = new FileOutputStream(file, true);
                byte[] byArray = new byte[512];
                fileOutputStream.write(byArray);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
                System.out.println("Adding end to Tar file.");
            } else {
                System.out.println("No Tar file to add end too.");
            }
        }
        catch (IOException iOException) {
            System.out.println("File exists but problem opening it?!");
        }
    }

    private long chksum(byte[] byArray) {
        int n = 0;
        long l = 0L;
        for (byte by : byArray) {
            l = n < 148 || n > 155 ? (l += (long)Byte.toUnsignedInt(by)) : (l += 32L);
            ++n;
        }
        System.out.println("Calc: " + l + " (" + n + ")");
        int n2 = (int)this.octal(l);
        String string = Long.toString(n2);
        string = string.trim();
        System.out.println("Oct Str: " + string + " Len:" + string.length());
        return l;
    }

    private void list() {
        File file = new File(this.tarfile);
        if (file.exists()) {
            long l = file.length();
            System.out.println("Tar Size: " + l);
            this.tarlist.clear();
            try {
                int n;
                int n2 = 0;
                byte[] byArray = new byte[512];
                FileInputStream fileInputStream = new FileInputStream(file);
                do {
                    int n3 = fileInputStream.read(byArray);
                    System.out.println("Read: " + n3);
                    if (n3 <= 0) break;
                    String string = new String(byArray, 0, 100);
                    if ((string = string.trim()).equals("")) break;
                    String string2 = new String(byArray, 124, 11);
                    String string3 = new String(byArray, 136, 11);
                    System.out.println("File: [" + string + "]");
                    System.out.println("Size: " + string2 + " in octal");
                    int n4 = Integer.parseInt(string2, 8);
                    System.out.println("actu: " + n4);
                    System.out.println("Date: [" + string3 + "] in Octal");
                    long l2 = Long.parseLong(string3, 8);
                    Instant instant = Instant.ofEpochSecond(l2);
                    LocalDate localDate = instant.atZone(ZoneId.systemDefault()).toLocalDate();
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("dd / MM / YYYY");
                    String string4 = dateTimeFormatter.format(localDate);
                    System.out.println(l2 + " => " + string4);
                    int n5 = instant.atZone(ZoneId.systemDefault()).getHour();
                    int n6 = instant.atZone(ZoneId.systemDefault()).getMinute();
                    String string5 = "" + n6;
                    if (string5.length() == 1) {
                        string5 = "0" + n6;
                    }
                    System.out.println("Time => " + n5 + ":" + string5);
                    TarDescription tarDescription = new TarDescription();
                    tarDescription.name = string;
                    tarDescription.pos = n2;
                    tarDescription.bytes = n4;
                    tarDescription.date = string4;
                    tarDescription.time = n5 + ":" + string5;
                    this.tarlist.add(tarDescription);
                    String string6 = new String(byArray, 148, 6);
                    System.out.println("Magic: [" + string6 + "]");
                    int n7 = Integer.parseInt(string6, 8);
                    System.out.println("Value: " + n7);
                    this.chksum(byArray);
                    n = 0;
                    while ((n += 512) < n4) {
                    }
                    fileInputStream.skip(n);
                    System.out.println("Blk Size: " + n);
                } while ((long)(n2 += 512 + n) < l);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("File exists but problem opening it?!");
            }
        } else {
            System.out.println("Cannot find file " + this.tarfile);
        }
    }
}

