/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Notepad
implements ActionListener,
DocumentListener,
WindowListener {
    private final boolean debug = false;
    private boolean saved = false;
    private boolean changed = false;
    JFrame frame;
    final String prog_name = "Notepad Minor";
    final String prog_desc = "Very Basic Text Editor";
    final String prog_author = "ssjx";
    final String prog_version = "v0.1a (04/10/2024)";
    final String prog_url = "https://ssjx.co.uk";
    final String settings_file = "settings.txt";
    private boolean showtext = true;
    private boolean showintro = true;
    private JMenuItem[] item = new JMenuItem[35];
    private JPanel mypanel = new JPanel();
    JTextArea inpText;
    Font fs;
    int fontsize = 0;
    private boolean full = false;
    Dimension framesize = new Dimension(800, 480);
    String undo;
    int undo_caret;
    FileDialog fd;
    String loaded_file;
    String tar_file;
    String user_name;
    String user_candno;
    String user_centre;
    String user_subject;
    private boolean exammode = false;
    private int version = 0;
    ArrayList<String> file_versions = new ArrayList();
    private boolean auto_save = false;
    private boolean auto_arch = false;
    private boolean word_wrap = true;
    private String save_location;
    private Tar versions;
    private BackgroundSave bgsave = new BackgroundSave();

    public Notepad() {
        this.bgsave.init(this);
        this.createUI(false);
        if (!this.load_settings()) {
            int n = JOptionPane.showConfirmDialog(null, "Welcome to Notepad Minor!\nDo you want to start in Exam Mode? This will be saved as the default.\nYou can set other defaults in the settings.txt file", "Create Settings File", 0, 2);
            if (n == 0) {
                this.exammode = true;
            }
            this.save_settings();
        }
        if (this.exammode) {
            ExamPrompt examPrompt = new ExamPrompt(this, this.user_centre);
            if (examPrompt.abort) {
                System.exit(0);
            }
            if (this.save_location != null) {
                this.tar_file = this.save_location + this.loaded_file + ".tar";
                this.loaded_file = this.save_location + this.loaded_file + ".txt";
            } else {
                this.tar_file = this.loaded_file + ".tar";
                this.loaded_file = this.loaded_file + ".txt";
            }
            this.versions = new Tar(this, this.tar_file);
            String[] stringArray = new String[]{"New", "Open...", "Save As...", "About", "Auto Save", "Auto Archive"};
            int n = 0;
            for (JMenuItem jMenuItem : this.item) {
                if (jMenuItem == null) continue;
                for (String string : stringArray) {
                    if (!jMenuItem.getText().equals(string)) continue;
                    this.item[n].setEnabled(false);
                    System.out.println("Disabling: " + jMenuItem.getText());
                    break;
                }
                ++n;
            }
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd / MM / yyy");
            String string = simpleDateFormat.format(date);
            this.inpText.setText("");
            String string6 = "Candidate Name: " + this.user_name + "\n";
            string6 = string6 + "Candidate Number: " + this.user_candno + "\n";
            string6 = string6 + "Centre Number: " + this.user_centre + "\n";
            string6 = string6 + "Subject: " + this.user_subject + "\n";
            string6 = string6 + "Date: " + string + "\n\n";
            this.inpText.setText(string6);
            this.saved = true;
            this.changed = false;
            this.update_title();
            this.auto_save = true;
            this.auto_arch = true;
        } else {
            this.saved = true;
            this.changed = false;
        }
        this.update_ticks();
        this.bgsave.start();
    }

    private void createUI(boolean bl) {
        JComponent jComponent;
        JMenuBar jMenuBar = new JMenuBar();
        this.fs = new Font("Arial", 0, 16);
        this.frame = new JFrame();
        this.frame.addWindowListener(this);
        this.frame.setSize(this.framesize.width, this.framesize.height);
        this.frame.setDefaultCloseOperation(3);
        this.frame.setTitle("Notepad Minor v0.1a (04/10/2024) by ssjx (https://ssjx.co.uk)");
        if (!bl) {
            String[] stringArray;
            jComponent = new JMenu("File");
            ((AbstractButton)jComponent).setMnemonic(70);
            String[] stringArray2 = new String[]{"New", "", "Open...", "Save", "Save As...", "", "Export...", "", "Print...", "", "Information", "", "Exit"};
            int n = 0;
            for (String string : stringArray2) {
                if (string.equals("")) {
                    ((JMenu)jComponent).addSeparator();
                    continue;
                }
                this.item[n] = new JMenuItem(string);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                if (string.equals("New")) {
                    this.item[n].setMnemonic(78);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(78, 2));
                }
                if (string.equals("Open")) {
                    this.item[n].setMnemonic(79);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(79, 2));
                }
                if (string.equals("Save")) {
                    this.item[n].setMnemonic(83);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(83, 2));
                }
                if (string.equals("Exit")) {
                    this.item[n].setMnemonic(88);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(115, 8));
                }
                ((JMenu)jComponent).add(this.item[n]);
                ++n;
            }
            JMenu jMenu = new JMenu("Edit");
            jMenu.setMnemonic(83);
            String[] stringArray3 = new String[]{"Undo", "", "Cut", "Copy", "Paste"};
            for (String string : stringArray3) {
                if (string.equals("")) {
                    jMenu.addSeparator();
                    continue;
                }
                this.item[n] = new JMenuItem(string);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                if (string.equals("Undo")) {
                    this.item[n].setMnemonic(85);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(90, 2));
                }
                if (string.equals("Cut")) {
                    this.item[n].setMnemonic(88);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(88, 2));
                }
                if (string.equals("Copy")) {
                    this.item[n].setMnemonic(67);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(67, 2));
                }
                if (string.equals("Paste")) {
                    this.item[n].setMnemonic(80);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(80, 2));
                }
                jMenu.add(this.item[n]);
                ++n;
            }
            JMenu jMenu2 = new JMenu("Line");
            jMenu2.setMnemonic(83);
            String[] stringArray4 = new String[]{"Duplicate", "Underline", "Bullet", "", "Word Wrap"};
            for (String string : stringArray4) {
                if (string.equals("")) {
                    jMenu2.addSeparator();
                    continue;
                }
                if (string.equals("Word Wrap")) {
                    this.item[n] = new JCheckBoxMenuItem(string);
                    this.item[n].setSelected(true);
                } else {
                    this.item[n] = new JMenuItem(string);
                }
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                if (string.equals("Duplicate")) {
                    this.item[n].setMnemonic(68);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(68, 2));
                }
                if (string.equals("Underline")) {
                    this.item[n].setMnemonic(85);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(85, 2));
                }
                if (string.equals("Bullet")) {
                    this.item[n].setMnemonic(73);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(66, 2));
                }
                if (string.equals("Word Wrap")) {
                    this.item[n].setMnemonic(87);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(87, 2));
                }
                jMenu2.add(this.item[n]);
                ++n;
            }
            JMenu jMenu3 = new JMenu("View");
            jMenu3.setMnemonic(83);
            String[] stringArray5 = new String[]{"Fullscreen", "Invert", "", "Zoom In", "Zoom Out", "Zoom Default"};
            for (String string : stringArray5) {
                if (string.equals("")) {
                    jMenu3.addSeparator();
                    continue;
                }
                this.item[n] = new JMenuItem(string);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                if (string.equals("Fullscreen")) {
                    this.item[n].setMnemonic(70);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(122, 0));
                }
                if (string.equals("Invert")) {
                    this.item[n].setMnemonic(73);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(73, 2));
                }
                if (string.equals("Zoom In")) {
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(61, 2));
                }
                if (string.equals("Zoom Out")) {
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(45, 2));
                }
                if (string.equals("Zoom Default")) {
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(48, 2));
                }
                jMenu3.add(this.item[n]);
                ++n;
            }
            JMenu jMenu4 = new JMenu("Document");
            jMenu4.setMnemonic(68);
            String[] stringArray6 = new String[]{"Auto Save", "Auto Archive", "", "Browse Archive"};
            for (String string : stringArray6) {
                if (string.equals("")) {
                    jMenu4.addSeparator();
                    continue;
                }
                if (string.contains("Auto")) {
                    this.item[n] = new JCheckBoxMenuItem(string);
                    this.item[n].setSelected(false);
                } else {
                    this.item[n] = new JMenuItem(string);
                }
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                jMenu4.add(this.item[n]);
                ++n;
            }
            JMenu jMenu5 = new JMenu("Help");
            jMenu5.setMnemonic(72);
            for (String string : stringArray = new String[]{"About"}) {
                if (string.equals("")) {
                    jMenu5.addSeparator();
                    continue;
                }
                this.item[n] = new JMenuItem(string);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                if (string.equals("About")) {
                    this.item[n].setMnemonic(65);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(112, 0));
                }
                jMenu5.add(this.item[n]);
                ++n;
            }
            jMenuBar.add((JMenu)jComponent);
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu3);
            jMenuBar.add(jMenu4);
            jMenuBar.add(jMenu5);
            this.frame.setJMenuBar(jMenuBar);
        } else {
            this.frame.setUndecorated(true);
        }
        this.inpText = new JTextArea("", 8, 40);
        this.inpText.setFont(this.fs);
        this.inpText.setLineWrap(true);
        this.inpText.setWrapStyleWord(true);
        this.inpText.getDocument().addDocumentListener(this);
        this.inpText.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), "changed");
        this.inpText.getActionMap().put("changed", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Notepad.this.undo = Notepad.this.inpText.getText();
                Notepad.this.undo_caret = Notepad.this.inpText.getCaretPosition();
                Notepad.this.changed = true;
                Notepad.this.saved = false;
            }
        });
        jComponent = new JScrollPane(this.inpText);
        ((JScrollPane)jComponent).setVerticalScrollBarPolicy(22);
        this.frame.add(jComponent);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    boolean save_settings() {
        try {
            File file = new File("settings.txt");
            System.out.println("Creating settings file!");
            PrintStream printStream = new PrintStream(file);
            printStream.println("# Exam mode forces the student to enter their name, saves version history and");
            printStream.println("# disables various options including the start up splash screen.");
            if (this.exammode) {
                printStream.println("exam=true");
            } else {
                printStream.println("exam=false");
            }
            printStream.println("centrenumber=");
            printStream.println("savelocation=");
            printStream.println("# Display defaults");
            printStream.println("invert=false");
            printStream.println("fontsize=0");
            printStream.println("wordwrap=true");
            printStream.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private boolean load_settings() {
        try {
            File file = new File("settings.txt");
            if (file.exists()) {
                Scanner scanner = new Scanner(file);
                while (scanner.hasNextLine()) {
                    Object object;
                    String[] stringArray;
                    String string = scanner.nextLine();
                    if (string.charAt(0) == '#' || (stringArray = string.split("=")).length != 2 || ((String)(object = stringArray[1].trim())).length() == 0) continue;
                    switch (stringArray[0]) {
                        case "exam": {
                            if (!((String)object).equals("true")) break;
                            this.exammode = true;
                            break;
                        }
                        case "savelocation": {
                            Object object2;
                            File file2 = new File((String)object);
                            System.out.println("Settings save location:" + (String)object);
                            if (file2.isDirectory()) {
                                object2 = ((String)object).substring(((String)object).length() - 1);
                                if (!((String)object2).equals(File.separator)) {
                                    object = (String)object + File.separator;
                                }
                                this.save_location = object;
                                System.out.println("Exam save location:" + this.save_location);
                                break;
                            }
                            System.out.println("Not a directory:" + this.save_location);
                            this.save_location = null;
                            break;
                        }
                        case "centrenumber": {
                            this.user_centre = object;
                            break;
                        }
                        case "fontsize": {
                            try {
                                this.fontsize = Integer.parseInt((String)object);
                                if (this.fontsize < 0) {
                                    this.fontsize = 0;
                                }
                                this.fs = new Font("Arial", 0, 16 + this.fontsize);
                                this.inpText.setFont(this.fs);
                            }
                            catch (NumberFormatException numberFormatException) {
                                System.out.println("Font size exception:");
                                System.out.println(numberFormatException);
                                this.fontsize = 0;
                            }
                            break;
                        }
                        case "wordwrap": {
                            if (!((String)object).equals("false")) break;
                            this.inpText.setLineWrap(false);
                            this.word_wrap = false;
                            break;
                        }
                        case "invert": {
                            if (!((String)object).equals("true")) break;
                            Object object2 = this.inpText.getForeground();
                            Color color = this.inpText.getBackground();
                            this.inpText.setForeground(color);
                            this.inpText.setBackground((Color)object2);
                            this.inpText.setCaretColor(color);
                        }
                    }
                }
                scanner.close();
                return true;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        Notepad notepad = new Notepad();
    }

    public void update_title() {
        String string = "";
        if (!this.saved) {
            string = "*";
        }
        if (this.loaded_file != null) {
            this.frame.setTitle(string + this.loaded_file + " - Notepad Minor");
        } else {
            this.frame.setTitle(string + "Notepad Minor v0.1a (04/10/2024)");
        }
    }

    void save_as() {
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Save As", 1);
        fileDialog.setFile("*.txt");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            if (!string.endsWith(".txt")) {
                string = string + ".txt";
            }
            this.save(string);
        }
    }

    boolean save(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.inpText.getText());
            fileWriter.close();
        }
        catch (Exception exception) {
            return false;
        }
        this.loaded_file = string;
        this.saved = true;
        this.update_title();
        return true;
    }

    void export_as() {
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Export As", 1);
        fileDialog.setFile("*.txt");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            if (!string.endsWith(".txt")) {
                string = string + ".txt";
            }
            this.export(string);
        }
    }

    boolean export(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(this.inpText.getText());
            fileWriter.close();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void history() {
        if (this.auto_arch && this.changed) {
            this.history_add();
        }
        if (this.auto_save && !this.saved) {
            this.save(this.loaded_file);
            this.saved = true;
        }
    }

    public void history_add() {
        System.out.println("Saving version #" + this.version + " of document");
        byte[] byArray = this.inpText.getText().getBytes();
        this.versions.adddata(byArray, this.version);
        ++this.version;
        this.changed = false;
    }

    boolean load_as() {
        this.saved = true;
        this.update_title();
        return true;
    }

    private void reset() {
        if (this.versions != null) {
            this.history();
            this.versions.addend();
            this.versions = null;
        }
        this.inpText.setText("");
        this.inpText.setCaretPosition(0);
        this.tar_file = null;
        this.loaded_file = null;
        this.saved = true;
        this.changed = false;
        this.auto_save = false;
        this.auto_arch = false;
        this.update_ticks();
        this.update_title();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        switch (string = actionEvent.getActionCommand()) {
            case "Open...": {
                Object object;
                int n;
                boolean bl = true;
                if (!this.saved && (n = JOptionPane.showConfirmDialog(null, "This document is not saved!\nDo you want to return and save it?", "Not saved!", 0, 2)) == 0) {
                    bl = false;
                }
                if (!bl) break;
                this.fd = new FileDialog((Frame)this.frame, "Open", 0);
                this.fd.setFile("*.txt;*.tar;");
                this.fd.setVisible(true);
                if (this.fd.getFile() == null) break;
                this.reset();
                String string2 = new String(this.fd.getDirectory() + this.fd.getFile());
                if (string2.toLowerCase().endsWith(".txt")) {
                    this.inpText.getDocument().removeDocumentListener(this);
                    this.inpText.setText("");
                    try {
                        String string3;
                        this.loaded_file = string2;
                        object = new BufferedReader(new FileReader(this.loaded_file));
                        while ((string3 = ((BufferedReader)object).readLine()) != null) {
                            this.inpText.append(string3 + "\n");
                        }
                        ((BufferedReader)object).close();
                        this.inpText.setCaretPosition(0);
                        this.saved = true;
                        this.update_title();
                        this.inpText.getDocument().addDocumentListener(this);
                        this.auto_save = false;
                        this.auto_arch = false;
                        this.tar_file = this.loaded_file.substring(0, this.loaded_file.lastIndexOf("."));
                        this.tar_file = this.tar_file + ".tar";
                        File file = new File(this.tar_file);
                        if (file.exists()) {
                            this.versions = new Tar(this, this.tar_file);
                            this.auto_arch = true;
                        } else {
                            this.tar_file = null;
                        }
                        this.update_ticks();
                    }
                    catch (IOException iOException) {
                        System.out.println("File exists but problem opening it?!");
                    }
                }
                if (!string2.toLowerCase().endsWith(".tar")) break;
                object = new Tar(this, string2);
                ((Tar)object).listdata();
                this.loaded_file = null;
                break;
            }
            case "Export...": {
                this.save_as();
                break;
            }
            case "Save As...": {
                this.save_as();
                break;
            }
            case "Save": {
                if (this.loaded_file == null) {
                    this.save_as();
                    break;
                }
                this.save(this.loaded_file);
                break;
            }
            case "Information": {
                JOptionPane.showMessageDialog(this.frame, "Filename:" + this.loaded_file + "\nTar File:" + this.tar_file + "\n\nSaved:" + this.saved + "\nChanged:" + this.changed, "File Information", 1);
                break;
            }
            case "Zoom In": {
                this.fontsize += 2;
                this.fs = new Font("Arial", 0, 16 + this.fontsize);
                this.inpText.setFont(this.fs);
                break;
            }
            case "Zoom Out": {
                this.fontsize -= 2;
                if (this.fontsize < 0) {
                    this.fontsize = 0;
                }
                this.fs = new Font("Arial", 0, 16 + this.fontsize);
                this.inpText.setFont(this.fs);
                break;
            }
            case "Zoom Default": {
                this.fontsize = 0;
                this.fs = new Font("Arial", 0, 16 + this.fontsize);
                this.inpText.setFont(this.fs);
                break;
            }
            case "Word Wrap": {
                boolean bl = this.inpText.getLineWrap();
                if (bl) {
                    this.inpText.setLineWrap(false);
                    break;
                }
                this.inpText.setLineWrap(true);
                break;
            }
            case "Auto Save": {
                if (this.loaded_file == null) {
                    this.save_as();
                }
                if (this.loaded_file != null) {
                    this.auto_save = !this.auto_save;
                }
                this.update_ticks();
                break;
            }
            case "Auto Archive": {
                if (!this.auto_arch) {
                    if (this.loaded_file == null) {
                        this.save_as();
                    }
                    if (this.loaded_file != null) {
                        this.auto_arch = true;
                        this.tar_file = this.loaded_file.substring(0, this.loaded_file.lastIndexOf("."));
                        this.tar_file = this.tar_file + ".tar";
                        this.versions = new Tar(this, this.tar_file);
                        this.version = 0;
                        System.out.println("Turning On version history.");
                    } else {
                        System.out.println("Cannot turn ON version history. No file name.");
                    }
                } else {
                    this.auto_arch = false;
                    if (this.versions != null) {
                        if (this.versions.exists()) {
                            this.history_add();
                            System.out.println("Turning off version history. Adding end to TAR file.");
                            this.versions.addend();
                        } else {
                            System.out.println("Turning off version history. No version file created.");
                        }
                        this.versions = null;
                    }
                }
                this.update_ticks();
                break;
            }
            case "Browse Archive": {
                if (this.versions == null) break;
                boolean bl = this.auto_arch;
                this.auto_arch = false;
                this.versions.listdata();
                this.auto_arch = bl;
                break;
            }
            case "New": {
                int n;
                boolean bl = true;
                if (!this.saved && (n = JOptionPane.showConfirmDialog(null, "This document is not saved!\nDo you really want to clear it?", "New", 0, 2)) == 1) {
                    bl = false;
                }
                if (!bl) break;
                this.reset();
                break;
            }
            case "Print...": {
                try {
                    JTextArea jTextArea = new JTextArea();
                    boolean bl = this.inpText.getLineWrap();
                    if (bl) {
                        jTextArea.setLineWrap(false);
                    } else {
                        jTextArea.setLineWrap(true);
                    }
                    jTextArea.setText(this.inpText.getText());
                    jTextArea.print();
                }
                catch (PrinterException printerException) {
                    System.out.println("Problem printing...");
                }
                break;
            }
            case "Undo": {
                this.inpText.setText(this.undo);
                this.inpText.setCaretPosition(this.undo_caret);
                break;
            }
            case "Cut": {
                this.inpText.cut();
                break;
            }
            case "Copy": {
                this.inpText.copy();
                break;
            }
            case "Paste": {
                this.inpText.paste();
                break;
            }
            case "Bullet": {
                try {
                    int n;
                    int n2 = this.inpText.getCaretPosition();
                    this.undo = this.inpText.getText();
                    this.undo_caret = n2;
                    int n3 = this.inpText.getSelectionStart();
                    int n4 = this.inpText.getSelectionEnd();
                    if (n3 > n4) {
                        n = n3;
                        n3 = n4;
                        n4 = n;
                    }
                    n = this.inpText.getLineOfOffset(n3);
                    int n5 = this.inpText.getLineOfOffset(n4 + 1);
                    for (int i = n; i < n5; ++i) {
                        int n6 = this.inpText.getLineStartOffset(i);
                        this.inpText.insert("* ", n6);
                    }
                    break;
                }
                catch (Exception exception) {
                    System.out.println("Bullet Exception:");
                    System.out.println(exception);
                    break;
                }
            }
            case "Duplicate": {
                try {
                    int n = this.inpText.getLineCount();
                    int n7 = this.inpText.getCaretPosition();
                    int n8 = this.inpText.getLineOfOffset(n7);
                    int n9 = this.inpText.getLineStartOffset(n8);
                    int n10 = this.inpText.getLineEndOffset(n8);
                    String string4 = this.inpText.getText(n9, n10 - n9);
                    this.undo = this.inpText.getText();
                    this.undo_caret = n7;
                    if (n8 == n - 1) {
                        this.inpText.append("\n" + string4);
                        break;
                    }
                    this.inpText.insert(string4, n10);
                }
                catch (Exception exception) {
                    System.out.println("Exception!");
                }
                break;
            }
            case "Underline": {
                try {
                    int n = this.inpText.getLineCount();
                    int n11 = this.inpText.getCaretPosition();
                    int n12 = this.inpText.getLineOfOffset(n11);
                    int n13 = this.inpText.getLineStartOffset(n12);
                    int n14 = this.inpText.getLineEndOffset(n12);
                    String string5 = this.inpText.getText(n13, n14 - n13);
                    this.undo = this.inpText.getText();
                    this.undo_caret = n11;
                    String string6 = "=".repeat(string5.length());
                    if (n12 == n - 1) {
                        this.inpText.append("\n" + string6 + "\n");
                        break;
                    }
                    this.inpText.insert(string6 + "\n", n14);
                }
                catch (Exception exception) {
                    System.out.println("Exception!");
                }
                break;
            }
            case "Invert": {
                Color color = this.inpText.getForeground();
                Color color2 = this.inpText.getBackground();
                this.inpText.setForeground(color2);
                this.inpText.setBackground(color);
                this.inpText.setCaretColor(color2);
                break;
            }
            case "About": {
                Intro intro = new Intro();
                break;
            }
            case "Fullscreen": {
                if (!this.full) {
                    this.frame.setExtendedState(6);
                    this.full = true;
                    break;
                }
                this.frame.setExtendedState(0);
                this.full = false;
                break;
            }
            case "Exit": {
                int n;
                if (this.exammode) {
                    if (!this.saved) {
                        this.save(this.loaded_file);
                    }
                    if (this.versions != null) {
                        this.history_add();
                        System.out.println("Adding to end of TAR file...");
                        this.versions.addend();
                    }
                    this.stop_bgsave();
                    System.exit(0);
                    break;
                }
                if (this.saved || (n = JOptionPane.showConfirmDialog(this.frame, "Changes will be lost! Do you really want to exit?", "Exit Confirmation : ", 0)) != 0) break;
                this.frame.setDefaultCloseOperation(2);
                System.exit(0);
            }
        }
    }

    private void update_ticks() {
        int n = 0;
        for (JMenuItem jMenuItem : this.item) {
            if (jMenuItem == null) continue;
            if (jMenuItem.getText().equals("Auto Save")) {
                this.item[n].setSelected(this.auto_save);
            }
            if (jMenuItem.getText().equals("Auto Archive")) {
                this.item[n].setSelected(this.auto_arch);
            }
            if (jMenuItem.getText().equals("Word Wrap")) {
                this.item[n].setSelected(this.word_wrap);
            }
            if (jMenuItem.getText().equals("About")) break;
            ++n;
        }
    }

    public void stop_bgsave() {
        if (this.bgsave.isAlive()) {
            System.out.println("Thread Running");
            while (this.bgsave.isAlive()) {
                this.bgsave.stopsave();
            }
            System.out.println("Thread Stopped");
        } else {
            System.out.println("Thread NOT Running");
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        System.out.println("closed Main window");
        System.exit(0);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("closing Main window");
        if (this.exammode) {
            if (!this.saved) {
                this.save(this.loaded_file);
            }
            if (this.versions != null) {
                this.history_add();
                System.out.println("Adding to end of TAR file...");
                this.versions.addend();
                this.stop_bgsave();
            }
        } else if (!this.saved) {
            int n = JOptionPane.showConfirmDialog(this.frame, "Changes will be lost! Do you really want to exit?", "Exit Confirmation : ", 0);
            if (n == 0) {
                this.frame.setDefaultCloseOperation(2);
            } else if (n == 1) {
                this.frame.setDefaultCloseOperation(0);
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        this.saved = false;
        this.update_title();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        this.saved = false;
        this.update_title();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        this.saved = false;
        this.update_title();
    }
}

