/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Match
extends JFrame
implements ActionListener,
WindowListener {
    public static final String prog_name = "Match Maker";
    static final String prog_desc = "Word pairing game";
    static final String prog_author = "ssjx";
    public static final String prog_version = "v0.4b (06/10/2024)";
    public static final String prog_url = "https://ssjx.co.uk";
    Font myfont = new Font("Verdana", 0, 20);
    Font infofont = new Font("Verdana", 0, 12);
    JButton[] txt_label = new JButton[16];
    String[] reveal = new String[16];
    String loaded_file;
    String full_filename;
    boolean saved = true;
    int[] pair = new int[2];
    boolean[] correct = new boolean[16];
    String[] default_txt = new String[]{"Mercury", "Venus", "Earth", "Mars", "Jupiter", "Neptune", "Uranus", "Saturn", "Pluto"};
    ArrayList<String> loaded_txt = new ArrayList();
    String[] word = new String[8];
    String[] answer = new String[8];
    int[] tile = new int[16];
    JLabel info_label;
    int pairs = 0;

    public Match() {
        super(prog_name);
        this.setSize(640, 480);
        this.setDefaultCloseOperation(3);
        this.setResizable(true);
        this.match_gui();
        boolean bl = false;
        for (String string : this.default_txt) {
            this.loaded_txt.add(string);
        }
        this.import_words();
    }

    public void jumble() {
        for (int i = 0; i < 50; ++i) {
            int n = (int)Math.floor(Math.random() * (double)this.reveal.length);
            int n2 = (int)Math.floor(Math.random() * (double)this.reveal.length);
            String string = this.reveal[n];
            this.reveal[n] = this.reveal[n2];
            this.reveal[n2] = string;
            int n3 = this.tile[n];
            this.tile[n] = this.tile[n2];
            this.tile[n2] = n3;
        }
    }

    public void jumble_loaded() {
        for (int i = 0; i < 50; ++i) {
            int n = (int)Math.floor(Math.random() * (double)this.loaded_txt.size());
            int n2 = (int)Math.floor(Math.random() * (double)this.loaded_txt.size());
            String string = this.loaded_txt.get(n);
            this.loaded_txt.set(n, this.loaded_txt.get(n2));
            this.loaded_txt.set(n2, string);
        }
    }

    public void match_gui() {
        JMenuItem[] jMenuItemArray = new JMenuItem[15];
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        String[] stringArray = new String[]{"Open...", "Save", "Save As...", "", "Export As CSV", "Export As HTML", "", "Reset Game", "", "Exit"};
        int n = 0;
        for (String string : stringArray) {
            if (string.equals("")) {
                jMenu.addSeparator();
            } else {
                jMenuItemArray[n] = new JMenuItem(string);
                jMenuItemArray[n].addActionListener(this);
                jMenuItemArray[n].setActionCommand(string);
                if (string.equals("Open...")) {
                    jMenuItemArray[n].setMnemonic(79);
                    jMenuItemArray[n].setAccelerator(KeyStroke.getKeyStroke(79, 2));
                }
                if (string.equals("Save")) {
                    jMenuItemArray[n].setMnemonic(83);
                    jMenuItemArray[n].setAccelerator(KeyStroke.getKeyStroke(83, 2));
                }
                if (string.equals("Save As...")) {
                    jMenuItemArray[n].setMnemonic(65);
                }
                if (string.equals("Exit")) {
                    jMenuItemArray[n].setMnemonic(88);
                    jMenuItemArray[n].setAccelerator(KeyStroke.getKeyStroke(115, 8));
                }
                jMenu.add(jMenuItemArray[n]);
            }
            ++n;
        }
        JMenu jMenu2 = new JMenu("Create");
        String[] stringArray2 = new String[]{"Editor", "Show All"};
        for (String string : stringArray2) {
            jMenuItemArray[n] = new JMenuItem(string);
            jMenuItemArray[n].addActionListener(this);
            jMenuItemArray[n].setActionCommand(string);
            jMenu2.add(jMenuItemArray[n]);
            ++n;
        }
        JMenu jMenu3 = new JMenu("Help");
        String[] stringArray3 = new String[]{"About"};
        for (String object2 : stringArray3) {
            jMenuItemArray[n] = new JMenuItem(object2);
            jMenuItemArray[n].addActionListener(this);
            jMenuItemArray[n].setActionCommand(object2);
            if (object2.equals("About")) {
                jMenuItemArray[n].setAccelerator(KeyStroke.getKeyStroke(112, 0));
            }
            jMenu3.add(jMenuItemArray[n]);
            ++n;
        }
        JButton jButton = new JButton();
        jButton.setBorderPainted(false);
        jButton.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        String string = "pound";
        jButton.setToolTipText("Save money shopping online with TopCashback!");
        String string2 = "\u00c2\u00a3";
        jButton.setFocusable(false);
        jButton.addActionListener(this);
        jButton.setActionCommand(string);
        try {
            BufferedImage exception = ImageIO.read(this.getClass().getResource("gifs/" + string + ".gif"));
            jButton.setIcon(new ImageIcon(exception));
        }
        catch (Exception exception) {
            jButton.setText(string2);
        }
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(jButton);
        this.setJMenuBar(jMenuBar);
        GridLayout gridLayout = new GridLayout(4, 4);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridLayout);
        this.setBackground(Color.cyan);
        for (int i = 0; i < this.txt_label.length; ++i) {
            this.txt_label[i] = new JButton();
            this.txt_label[i].setOpaque(true);
            this.txt_label[i].setBackground(Color.white);
            this.txt_label[i].setFont(this.myfont);
            this.txt_label[i].setText("?");
            this.txt_label[i].setBorderPainted(true);
            this.txt_label[i].addActionListener(this);
            this.txt_label[i].setActionCommand("show_" + i);
            jPanel.add(this.txt_label[i]);
        }
        FlowLayout flowLayout = new FlowLayout(3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(flowLayout);
        this.info_label = new JLabel("Started...                  ");
        this.info_label.setFont(this.infofont);
        jPanel2.add(this.info_label);
        JPanel jPanel3 = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        jPanel3.setLayout(borderLayout);
        jPanel3.add((Component)jPanel, "Center");
        jPanel3.add((Component)jPanel2, "Last");
        this.add(jPanel3);
        this.update_title();
        this.setLocationRelativeTo(null);
        this.addWindowListener(this);
        this.setVisible(true);
    }

    public void update_title() {
        String string = "";
        if (!this.saved) {
            string = "*";
        }
        if (this.loaded_file != null) {
            this.setTitle(string + this.loaded_file + " - Match Maker");
        } else {
            this.setTitle(string + "Match Maker v0.4b (06/10/2024)");
        }
    }

    public static void openWebpage(String string) {
        try {
            Desktop.getDesktop().browse(new URL(string).toURI());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = "";
        int n = -1;
        if (string.contains("_")) {
            Object object = string.split("_");
            string2 = object[0];
            n = Integer.parseInt((String)object[1]);
        } else {
            string2 = string;
        }
        switch (string2) {
            case "ssjx": {
                Match.openWebpage(prog_url);
                break;
            }
            case "coin": {
                Match.openWebpage("http://cointiply.com/r/KegY7o");
                break;
            }
            case "pound": {
                Match.openWebpage("https://www.topcashback.co.uk/ref/ssjx");
                break;
            }
            case "test": {
                Match.openWebpage("https://www.testerup.com/start/?promotion=&cid=xLB8d48XQM");
                break;
            }
            case "Editor": {
                Editor editor = new Editor(this);
                if (!editor.refresh) break;
                if (editor.loaded_file != null) {
                    this.loaded_file = editor.loaded_file;
                    this.full_filename = editor.full_filename;
                }
                this.saved = editor.saved;
                this.update_title();
                this.import_words();
                break;
            }
            case "About": {
                Intro intro = new Intro();
                break;
            }
            case "Show All": {
                this.show_all();
                break;
            }
            case "show": {
                if (this.correct[n]) {
                    return;
                }
                this.txt_label[n].setText(this.reveal[n]);
                if (this.pair[0] == -1) {
                    this.pair[0] = n;
                    this.txt_label[n].setBackground(Color.yellow);
                    break;
                }
                if (this.pair[1] == -1 && this.pair[0] != n) {
                    this.pair[1] = n;
                    if (this.check_pair(this.tile[this.pair[0]], this.tile[this.pair[1]])) {
                        this.txt_label[this.pair[0]].setBackground(Color.green);
                        this.txt_label[this.pair[1]].setBackground(Color.green);
                        this.correct[this.pair[0]] = true;
                        this.correct[this.pair[1]] = true;
                        if (!this.completed()) break;
                        JOptionPane.showMessageDialog(null, "You have completed this grid!\nWell Done!", "Well Done", 1);
                        break;
                    }
                    Color color = new Color(255, 96, 96);
                    this.txt_label[this.pair[0]].setBackground(color);
                    this.txt_label[this.pair[1]].setBackground(color);
                    break;
                }
                for (int i = 0; i < this.txt_label.length; ++i) {
                    if (this.correct[i]) continue;
                    this.txt_label[i].setBackground(Color.white);
                    this.txt_label[i].setText("?");
                }
                this.pair[0] = n;
                this.txt_label[n].setText(this.reveal[n]);
                this.txt_label[n].setBackground(Color.yellow);
                this.pair[1] = -1;
                break;
            }
            case "Reset Game": {
                this.import_words();
                break;
            }
            case "Open...": {
                int n2;
                boolean bl = true;
                if (!this.saved && (n2 = JOptionPane.showConfirmDialog(this, "Changes will be lost! Do you really want to continue?", "Exit Confirmation : ", 0)) == 1) {
                    bl = false;
                }
                if (!bl) break;
                FileDialog fileDialog = new FileDialog((Frame)this, "Open File", 0);
                fileDialog.setFile("*.txt");
                fileDialog.setVisible(true);
                if (fileDialog.getFile() == null) break;
                this.loaded_file = fileDialog.getFile();
                this.full_filename = fileDialog.getDirectory() + fileDialog.getFile();
                try {
                    String string3;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.full_filename));
                    this.loaded_txt.clear();
                    while ((string3 = bufferedReader.readLine()) != null) {
                        String string4 = string3.trim();
                        if (string4.length() <= 0) continue;
                        this.loaded_txt.add(string4);
                    }
                    bufferedReader.close();
                    this.saved = true;
                    this.update_title();
                    this.import_words();
                }
                catch (IOException iOException) {
                    System.out.println("Problem loading file!");
                }
                break;
            }
            case "Save": {
                if (this.full_filename != null) {
                    this.save(this.full_filename);
                    break;
                }
                this.save_as();
                break;
            }
            case "Save As...": {
                this.save_as();
                break;
            }
            case "Export As CSV": {
                this.export_csv();
                break;
            }
            case "Export As HTML": {
                this.export_html();
                break;
            }
            case "Exit": {
                if (!this.saved) {
                    int n3 = JOptionPane.showConfirmDialog(this, "Changes will be lost! Do you really want to exit?", "Exit Confirmation : ", 0);
                    if (n3 == 0) {
                        this.setDefaultCloseOperation(2);
                        this.dispose();
                        break;
                    }
                    if (n3 != 1) break;
                    this.setDefaultCloseOperation(0);
                    break;
                }
                this.dispose();
            }
        }
    }

    void save_as() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save As", 1);
        fileDialog.setFile("*.txt");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            this.save(string);
        }
    }

    boolean save(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            for (int i = 0; i < this.loaded_txt.size() - 1; ++i) {
                String string2 = this.loaded_txt.get(i);
                fileWriter.write(string2 + "\n");
            }
            fileWriter.close();
            this.saved = true;
            this.update_title();
        }
        catch (IOException iOException) {
            System.out.println("An error occurred doing a SAVE");
            return false;
        }
        return true;
    }

    void import_words() {
        int n;
        this.jumble_loaded();
        for (n = 0; n < this.word.length; ++n) {
            String string = this.loaded_txt.get(n);
            if (string.contains("#")) {
                String[] stringArray = string.split("#");
                this.word[n] = stringArray[0];
                this.answer[n] = stringArray[1];
                continue;
            }
            this.word[n] = string;
            this.answer[n] = string;
        }
        n = 0;
        int n2 = 0;
        while (n2 < this.word.length) {
            this.reveal[n] = this.word[n2];
            this.tile[n] = n2;
            this.reveal[++n] = this.answer[n2];
            this.tile[n] = n2++;
            ++n;
        }
        n = 0;
        String[] stringArray = this.reveal;
        int n3 = stringArray.length;
        for (int i = 0; i < n3; ++i) {
            String string;
            String string2 = string = stringArray[i];
            string2 = string2.replaceAll("\\\\n", "<br>");
            string2 = string2.replaceAll("\\\\h", "#");
            this.reveal[n] = "<html><center><font color='black'>" + string2 + "</font></center></html>";
            ++n;
        }
        this.jumble();
        this.reset_grid();
    }

    void reset_grid() {
        this.pair[0] = -1;
        this.pair[1] = -1;
        for (int i = 0; i < this.txt_label.length; ++i) {
            this.txt_label[i].setBackground(Color.white);
            this.txt_label[i].setText("?");
            this.txt_label[i].setEnabled(true);
        }
        Arrays.fill(this.correct, false);
        this.pairs = 0;
        this.info_label.setText("Pairs: " + this.pairs);
    }

    boolean completed() {
        for (boolean bl : this.correct) {
            if (bl) continue;
            return false;
        }
        return true;
    }

    void show_all() {
        for (int i = 0; i < this.txt_label.length; ++i) {
            this.correct[i] = true;
            this.txt_label[i].setBackground(Color.cyan);
            this.txt_label[i].setText(this.reveal[i]);
        }
    }

    boolean check_pair(int n, int n2) {
        ++this.pairs;
        this.info_label.setText("Pairs: " + this.pairs);
        return n == n2;
    }

    public static void main(String[] stringArray) {
        Match match = new Match();
    }

    public void export_csv() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Export as CSV", 1);
        fileDialog.setFile("*.csv");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            try {
                FileWriter fileWriter = new FileWriter(string);
                for (String string2 : this.loaded_txt) {
                    String string3;
                    String string4;
                    if (string2.contains("#")) {
                        String[] stringArray = string2.split("#");
                        string4 = stringArray[0];
                        string3 = stringArray[1];
                    } else {
                        string4 = string2;
                        string3 = string2;
                    }
                    string4 = string4.replaceAll("\\\\n", " ");
                    string4 = string4.replaceAll("\\\\h", "#");
                    string3 = string3.replaceAll("\\\\n", " ");
                    string3 = string3.replaceAll("\\\\h", "#");
                    fileWriter.write("\"" + string4 + "\",\"" + string3 + "\"\n");
                }
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("An error occurred doing an EXPORT (csv)");
            }
        }
    }

    public void export_html() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Export as HTML", 1);
        fileDialog.setFile("*.html");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            try {
                FileWriter fileWriter = new FileWriter(string);
                fileWriter.write("<!DOCTYPE html>\n");
                fileWriter.write("<html>\n");
                fileWriter.write("<head>\n");
                fileWriter.write("<meta charset=\"utf-8\">\n");
                fileWriter.write("<style>\n");
                fileWriter.write("p,h1 {text-align:center;}\n");
                fileWriter.write("p{font-size: 20px;}\n");
                fileWriter.write(".grid{width:100%;border-spacing: 20px;}\n");
                fileWriter.write(".grid td{width:50%;text-align:center;font-size: 20px;border: 1px solid black;}\n");
                fileWriter.write(".grid tr{height:200px}\n");
                fileWriter.write(".credit{color:gray;font-style: italic;}\n");
                fileWriter.write("</style>\n");
                fileWriter.write("</head>\n");
                fileWriter.write("<body>\n");
                int n = 0;
                for (String string2 : this.loaded_txt) {
                    String string3;
                    String string4;
                    if (string2.contains("#")) {
                        String[] stringArray = string2.split("#");
                        string4 = stringArray[0];
                        string3 = stringArray[1];
                    } else {
                        string4 = string2;
                        string3 = string2;
                    }
                    string4 = string4.replaceAll("\\\\n", " ");
                    string4 = string4.replaceAll("\\\\h", "#");
                    string3 = string3.replaceAll("\\\\n", " ");
                    string3 = string3.replaceAll("\\\\h", "#");
                    fileWriter.write("<table class=\"grid\">\n");
                    fileWriter.write("<tr>\n");
                    fileWriter.write("<td>" + string4 + "</td>\n");
                    fileWriter.write("<td>" + string3 + "</td></tr>\n");
                    fileWriter.write("</table>\n");
                    if (++n <= 3) continue;
                    n = 0;
                    fileWriter.write("<p style=\"page-break-after:always;\"></p>\n");
                }
                fileWriter.write("<p class=\"credit\">\n");
                fileWriter.write("This page was created using the Match Maker application\n");
                fileWriter.write("which can be found at <a href=\"http://ssjx.co.uk\">http://ssjx.co.uk</a>\n");
                fileWriter.write("</p>\n");
                fileWriter.close();
            }
            catch (IOException iOException) {
                System.out.println("An error occurred doing an EXPORT (csv)");
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (!this.saved) {
            int n = JOptionPane.showConfirmDialog(this, "Changes will be lost! Do you really want to exit?", "Exit Confirmation : ", 0);
            if (n == 0) {
                this.setDefaultCloseOperation(2);
            } else if (n == 1) {
                this.setDefaultCloseOperation(0);
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

