/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Editor
extends JDialog
implements ActionListener,
ListSelectionListener,
WindowListener {
    public boolean refresh = false;
    public boolean saved = true;
    public boolean localsaved = true;
    DefaultListModel<String> words = new DefaultListModel();
    private JTextArea word;
    private JTextArea answer;
    private JList<String> wordlist;
    private JButton[] btn = new JButton[4];
    Match parent;
    private int items;
    public String loaded_file;
    public String full_filename;

    /*
     * WARNING - void declaration
     */
    public Editor(Match match) {
        super((Frame)match, "Editor");
        void var18_25;
        this.parent = match;
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        JMenuItem[] jMenuItemArray = new JMenuItem[15];
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        String[] stringArray = new String[]{"New", "", "Open", "Save", "Save As..."};
        int n = 0;
        for (String object22 : stringArray) {
            if (object22.equals("")) {
                jMenu.addSeparator();
            } else {
                jMenuItemArray[n] = new JMenuItem(object22);
                jMenuItemArray[n].addActionListener(this);
                jMenuItemArray[n].setActionCommand(object22);
                jMenu.add(jMenuItemArray[n]);
            }
            ++n;
        }
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel();
        jLabel.setText("Add your words or word pairs below:");
        jPanel2.add(jLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 1));
        for (String string : match.loaded_txt) {
            this.words.addElement(string);
        }
        this.words.addElement("<<Add Word>>");
        this.wordlist = new JList<String>(this.words);
        this.wordlist.setSelectionMode(0);
        this.wordlist.addListSelectionListener(this);
        JScrollPane jScrollPane = new JScrollPane(this.wordlist);
        jPanel3.add(jScrollPane);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        this.word = new JTextArea("", 5, 10);
        this.word.setLineWrap(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.word);
        this.answer = new JTextArea("", 5, 10);
        this.answer.setLineWrap(true);
        JScrollPane jScrollPane3 = new JScrollPane(this.answer);
        jPanel4.add(jScrollPane2);
        jPanel4.add(jScrollPane3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 4));
        String[] stringArray2 = new String[]{"Add", "Delete", "Apply", "Cancel"};
        int n2 = 0;
        for (String string : stringArray2) {
            this.btn[n2] = new JButton();
            this.btn[n2].setText(string);
            this.btn[n2].addActionListener(this);
            this.btn[n2].setActionCommand(string);
            jPanel5.add(this.btn[n2]);
            ++n2;
        }
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        jPanel.add(jPanel5);
        this.add(jPanel);
        this.pack();
        this.setLocationRelativeTo(match);
        if (this.parent.full_filename != null) {
            this.full_filename = this.parent.full_filename;
            this.loaded_file = this.parent.loaded_file;
        }
        this.items = this.words.size() - 1;
        String string = "";
        this.saved = this.parent.saved;
        if (!this.localsaved) {
            String string2 = "*";
        }
        if (this.loaded_file == null) {
            this.setTitle((String)var18_25 + "Editor (Items: " + this.items + ")");
        } else {
            this.setTitle((String)var18_25 + this.loaded_file + " - Items: " + this.items);
        }
        this.addWindowListener(this);
        this.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.wordlist.getSelectedIndex() != -1) {
            String string = this.wordlist.getSelectedValue().replaceAll("\\\\n", "\n");
            if (string.contains("#")) {
                String[] stringArray = string.split("#");
                this.word.setText(stringArray[0]);
                this.answer.setText(stringArray[1]);
                this.btn[0].setText("Modify");
                this.btn[1].setEnabled(true);
            } else if (string.equals("<<Add Word>>")) {
                this.btn[0].setText("Add");
                this.btn[1].setEnabled(false);
                this.word.setText("");
                this.answer.setText("");
            } else {
                this.word.setText(string);
                this.answer.setText("");
                this.btn[0].setText("Modify");
                this.btn[1].setEnabled(true);
            }
        }
    }

    private void update_title_buttons() {
        int n = this.words.size() - 1;
        String string = "";
        if (!this.localsaved) {
            string = "*";
        }
        if (this.loaded_file == null) {
            this.setTitle(string + "Editor (Items: " + n + ")");
        } else {
            this.setTitle(string + this.loaded_file + " - Items: " + n);
        }
        if (n < 8) {
            this.btn[2].setEnabled(false);
        }
        if (n >= 8) {
            this.btn[2].setEnabled(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = "";
        int n = -1;
        if (string.contains("_")) {
            Object object = string.split("_");
            string2 = object[0];
            n = Integer.parseInt((String)object[1]);
        } else {
            string2 = string;
        }
        switch (string2) {
            case "New": {
                this.words.clear();
                this.words.addElement("<<Add Word>>");
                this.update_title_buttons();
                break;
            }
            case "Open": {
                FileDialog fileDialog = new FileDialog((Dialog)this, "Open File", 0);
                fileDialog.setFile("*.txt");
                fileDialog.setVisible(true);
                if (fileDialog.getFile() == null) break;
                this.loaded_file = fileDialog.getFile();
                this.full_filename = fileDialog.getDirectory() + fileDialog.getFile();
                try {
                    String string3;
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(this.full_filename));
                    this.words.clear();
                    while ((string3 = bufferedReader.readLine()) != null) {
                        String string4 = string3.trim();
                        if (string4.length() <= 0) continue;
                        this.words.addElement(string4);
                    }
                    bufferedReader.close();
                    this.words.addElement("<<Add Word>>");
                    this.update_title_buttons();
                }
                catch (IOException iOException) {
                    System.out.println("Problem loading file!");
                }
                break;
            }
            case "Save As...": {
                this.save_as();
                break;
            }
            case "Save": {
                if (this.full_filename != null) {
                    this.save(this.full_filename);
                    break;
                }
                this.save_as();
                break;
            }
            case "Add": {
                int n2;
                String string5 = this.word.getText().trim();
                String string6 = this.answer.getText().trim();
                string5 = string5.replaceAll("\n", "\\\\n");
                string6 = string6.replaceAll("\n", "\\\\n");
                string5 = string5.replaceAll("#", "\\\\h");
                string6 = string6.replaceAll("#", "\\\\h");
                if (this.btn[0].getText().equals("Add")) {
                    int n3 = this.words.size() - 1;
                    if (!string5.equals("")) {
                        if (string6.equals("")) {
                            this.words.setElementAt(string5, n3);
                            this.words.addElement("<<Add Word>>");
                        } else {
                            this.words.setElementAt(string5 + "#" + string6, n3);
                            this.words.addElement("<<Add Word>>");
                        }
                        this.wordlist.setSelectedIndex(n3);
                        this.btn[0].setText("Modify");
                        this.btn[1].setEnabled(true);
                        this.localsaved = false;
                    }
                } else if (this.btn[0].getText().equals("Modify") && (n2 = this.wordlist.getSelectedIndex()) != -1 && !string5.equals("")) {
                    if (string6.equals("")) {
                        this.words.setElementAt(string5, n2);
                    } else {
                        this.words.setElementAt(string5 + "#" + string6, n2);
                    }
                    this.localsaved = false;
                }
                this.update_title_buttons();
                break;
            }
            case "Delete": {
                int n4 = this.wordlist.getSelectedIndex();
                if (n4 <= -1) break;
                this.words.removeElementAt(n4);
                this.word.setText("");
                this.answer.setText("");
                this.update_title_buttons();
                this.btn[0].setText("Add");
                this.localsaved = false;
                break;
            }
            case "Apply": {
                this.parent.loaded_txt.clear();
                for (int i = 0; i < this.words.size() - 1; ++i) {
                    String string7 = this.words.getElementAt(i);
                    this.parent.loaded_txt.add(string7);
                }
                this.refresh = true;
                if (!this.localsaved) {
                    this.saved = false;
                }
                this.dispose();
                break;
            }
            case "Cancel": {
                if (!this.localsaved) {
                    int n5 = JOptionPane.showConfirmDialog(this, "Changes will be lost! Do you really want to exit?", "Exit Confirmation : ", 0);
                    if (n5 == 0) {
                        this.setDefaultCloseOperation(2);
                        this.dispose();
                        break;
                    }
                    if (n5 != 1) break;
                    this.setDefaultCloseOperation(0);
                    break;
                }
                this.dispose();
            }
        }
    }

    private void save_as() {
        FileDialog fileDialog = new FileDialog((Dialog)this, "Save As", 1);
        fileDialog.setFile("*.txt");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            this.save(string);
        }
    }

    private boolean save(String string) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            for (int i = 0; i < this.words.size() - 1; ++i) {
                String string2 = this.words.getElementAt(i);
                fileWriter.write(string2 + "\n");
            }
            fileWriter.close();
            this.saved = true;
            this.localsaved = true;
            this.full_filename = string;
            this.update_title_buttons();
        }
        catch (IOException iOException) {
            System.out.println("An error occurred.");
            return false;
        }
        return true;
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (!this.localsaved) {
            int n = JOptionPane.showConfirmDialog(this, "Changes will be lost! Do you really want to exit?", "Exit Confirmation : ", 0);
            if (n == 0) {
                this.setDefaultCloseOperation(2);
                this.refresh = true;
            } else if (n == 1) {
                this.setDefaultCloseOperation(0);
            }
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

