/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Objects;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class View
extends JFrame
implements ActionListener,
ClipboardOwner {
    public static final String prog_name = "Cybiko Viewer";
    final String prog_desc = "File Viewer";
    final String prog_author = "by ssjx";
    static final String prog_version = "0.6b (23/12/2024)";
    final String prog_url = "https://ssjx.co.uk";
    JFrame frame;
    BufferedImage bimage;
    JButton mybutton;
    JLabel guardian;
    ImageIcon will;
    JMenuItem[] item = new JMenuItem[15];
    JButton[] bar_button = new JButton[20];
    boolean stop_playback = false;
    boolean pause_playback = false;
    boolean playing_playback = false;
    int info_w;
    int info_h;
    int info_d;
    String info_comp = "";
    String info_type = "";
    int info_frames;
    int info_fps;
    String current_file;

    public View() {
        super(prog_name);
        this.setSize(350, 320);
        this.setDefaultCloseOperation(3);
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        String[] stringArray = new String[]{"Open...", "Information", "Exit"};
        int n = 0;
        for (String string : stringArray) {
            this.item[n] = new JMenuItem(string);
            this.item[n].addActionListener(this);
            this.item[n].setActionCommand(string);
            jMenu.add(this.item[n]);
            if (string.equals("Open...")) {
                this.item[n].setMnemonic(79);
                this.item[n].setAccelerator(KeyStroke.getKeyStroke(79, 0));
            }
            if (string.equals("Information")) {
                this.item[n].setMnemonic(73);
                this.item[n].setAccelerator(KeyStroke.getKeyStroke(73, 0));
            }
            if (string.equals("Exit")) {
                this.item[n].setMnemonic(88);
                this.item[n].setAccelerator(KeyStroke.getKeyStroke(27, 0));
            }
            ++n;
        }
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic(69);
        String[] stringArray2 = new String[]{"Copy"};
        for (String string : stringArray2) {
            this.item[n] = new JMenuItem(string);
            this.item[n].addActionListener(this);
            this.item[n].setActionCommand(string);
            jMenu2.add(this.item[n]);
            ++n;
        }
        JMenu jMenu3 = new JMenu("Controls");
        jMenu3.setMnemonic(67);
        String[] stringArray3 = new String[]{"Replay", "Pause", "Stop"};
        for (String string : stringArray3) {
            this.item[n] = new JMenuItem(string);
            this.item[n].addActionListener(this);
            this.item[n].setActionCommand(string);
            jMenu3.add(this.item[n]);
            ++n;
        }
        JMenu jMenu4 = new JMenu("Help");
        jMenu4.setMnemonic(72);
        String[] stringArray4 = new String[]{"About"};
        for (String object2 : stringArray4) {
            this.item[n] = new JMenuItem(object2);
            this.item[n].addActionListener(this);
            this.item[n].setActionCommand(object2);
            if (object2.equals("About")) {
                this.item[n].setAccelerator(KeyStroke.getKeyStroke(112, 0));
            }
            jMenu4.add(this.item[n]);
            ++n;
        }
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
        JToolBar jToolBar = new JToolBar("Main Toolbar");
        jToolBar.setFloatable(false);
        String[] stringArray5 = new String[]{"open", "|", "play", "stop", "#", "coin"};
        int n2 = 0;
        for (String string : stringArray5) {
            if (string.equals("#")) {
                jToolBar.add(Box.createGlue());
                continue;
            }
            if (string.equals("coin")) {
                int exception = (int)Math.floor(Math.random() * 2.0);
                this.bar_button[n2] = new JButton();
                String string2 = "";
                if (exception == 0) {
                    string2 = "coin";
                    this.bar_button[n2].setToolTipText("Earn Free Bitcoin at Cointiply!");
                }
                if (exception == 1) {
                    string2 = "pound";
                    this.bar_button[n2].setToolTipText("Save money shopping online with TopCashback!");
                }
                this.bar_button[n2].addActionListener(this);
                this.bar_button[n2].setActionCommand(string2);
                this.bar_button[n2].setFocusable(false);
                jToolBar.add(this.bar_button[n2]);
                try {
                    BufferedImage bufferedImage = ImageIO.read(this.getClass().getResource("gifs/" + string2 + ".gif"));
                    this.bar_button[n2].setIcon(new ImageIcon(bufferedImage));
                }
                catch (Exception exception2) {
                    this.bar_button[n2].setText(string);
                }
                continue;
            }
            if (!string.equals("|")) {
                this.bar_button[n2] = new JButton();
                try {
                    Object object = ImageIO.read(this.getClass().getResource("gifs/" + string + ".gif"));
                    this.bar_button[n2].setIcon(new ImageIcon((Image)object));
                }
                catch (Exception exception) {
                    this.bar_button[n2].setText(string);
                }
                switch (string) {
                    case "open": {
                        this.bar_button[n2].setToolTipText("Open");
                        break;
                    }
                    case "play": {
                        this.bar_button[n2].setToolTipText("Play");
                        break;
                    }
                    case "stop": {
                        this.bar_button[n2].setToolTipText("Stop");
                        break;
                    }
                    case "coin": {
                        this.bar_button[n2].setToolTipText("Earn Free Bitcoin at Cointiply!");
                    }
                }
                this.bar_button[n2].addActionListener(this);
                this.bar_button[n2].setActionCommand(string);
                jToolBar.add(this.bar_button[n2]);
                ++n2;
                continue;
            }
            jToolBar.addSeparator();
        }
        this.add((Component)jToolBar, "First");
        this.bimage = new BufferedImage(320, 200, 1);
        Random random = new Random();
        int n3 = 0;
        for (int i = 0; i < this.bimage.getHeight(); ++i) {
            for (n = 0; n < this.bimage.getWidth(); ++n) {
                if (random.nextInt(10) > 5) {
                    this.bimage.setRGB(n, i, 0);
                } else {
                    this.bimage.setRGB(n, i, 0xFFFFFF);
                }
                ++n3;
            }
        }
        this.will = new ImageIcon(this.bimage);
        this.guardian = new JLabel(this.will);
        this.add((Component)this.guardian, "Center");
        this.setVisible(true);
        this.setTitle("Cybiko Viewer 0.6b (23/12/2024) by ssjx [https://ssjx.co.uk]");
    }

    public void open_media(String string) {
        int n;
        int n2;
        int n3;
        Object object;
        this.setTitle(string + " - Cybiko Viewer");
        boolean bl = false;
        String string2 = string.substring(string.lastIndexOf(".") + 1).toLowerCase();
        System.out.println("Ext:" + string2);
        if (string2.equals("pic") && ((Cypic)(object = new Cypic())).load(string)) {
            this.bimage = new BufferedImage(((Cypic)object).bmhd_w, ((Cypic)object).bmhd_h, 1);
            n3 = 0;
            for (n2 = 0; n2 < ((Cypic)object).bmhd_h; ++n2) {
                for (n = 0; n < ((Cypic)object).bmhd_w; ++n) {
                    this.bimage.setRGB(n, n2, ((Cypic)object).rgb[n3]);
                    ++n3;
                }
            }
            bl = true;
            this.info_w = ((Cypic)object).bmhd_w;
            this.info_h = ((Cypic)object).bmhd_h;
            Objects.requireNonNull(object);
            this.info_d = 2;
            Objects.requireNonNull(object);
            this.info_type = "Cybiko PIC";
            Objects.requireNonNull(object);
            this.info_comp = "Uncompressed 2bpp";
            this.info_frames = 0;
            this.info_fps = 0;
        }
        if (string2.equals("cvi") && ((Cvd1)(object = new Cvd1())).load(string)) {
            this.bimage = new BufferedImage(((Cvd1)object).bmhd_w, ((Cvd1)object).bmhd_h, 1);
            n3 = 0;
            for (n2 = 0; n2 < ((Cvd1)object).bmhd_h; ++n2) {
                for (n = 0; n < ((Cvd1)object).bmhd_w; ++n) {
                    this.bimage.setRGB(n, n2, ((Cvd1)object).rgb[n3]);
                    ++n3;
                }
            }
            bl = true;
            this.info_w = ((Cvd1)object).bmhd_w;
            this.info_h = ((Cvd1)object).bmhd_h;
            Objects.requireNonNull(object);
            this.info_d = 2;
            Objects.requireNonNull(object);
            this.info_type = "Cybiko Video Image";
            this.info_comp = ((Cvd1)object).bmhd_comp;
            this.info_frames = 0;
            this.info_fps = 0;
        }
        if (string2.equals("iff") && ((Iff)(object = new Iff())).load(string)) {
            this.bimage = new BufferedImage(((Iff)object).bmhd_w, ((Iff)object).bmhd_h, 1);
            n3 = 0;
            for (n2 = 0; n2 < ((Iff)object).bmhd_h; ++n2) {
                for (n = 0; n < ((Iff)object).bmhd_w; ++n) {
                    this.bimage.setRGB(n, n2, ((Iff)object).rgb[n3]);
                    ++n3;
                }
            }
            bl = true;
            this.info_w = ((Iff)object).bmhd_w;
            this.info_h = ((Iff)object).bmhd_h;
            this.info_d = ((Iff)object).bmhd_d;
            Objects.requireNonNull(object);
            this.info_type = "Amiga ILBM";
            this.info_comp = ((Iff)object).bmhd_comp_txt;
            this.info_frames = 0;
            this.info_fps = 0;
        }
        if (string2.equals("qoi") && ((Qoi)(object = new Qoi())).load(string)) {
            this.bimage = new BufferedImage(((Qoi)object).bmhd_w, ((Qoi)object).bmhd_h, 1);
            n3 = 0;
            for (n2 = 0; n2 < ((Qoi)object).bmhd_h; ++n2) {
                for (n = 0; n < ((Qoi)object).bmhd_w; ++n) {
                    this.bimage.setRGB(n, n2, ((Qoi)object).rgb[n3]);
                    ++n3;
                }
            }
            bl = true;
            this.info_w = ((Qoi)object).bmhd_w;
            this.info_h = ((Qoi)object).bmhd_h;
            this.info_d = ((Qoi)object).bmhd_d;
            Objects.requireNonNull(object);
            this.info_type = "Quite Okay Image (QOI)";
            this.info_comp = ((Qoi)object).bmhd_comp_txt;
            this.info_frames = 0;
            this.info_fps = 0;
        }
        if (bl) {
            this.stop_playback = true;
            do {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(interruptedException);
                    break;
                }
            } while (this.playing_playback);
            this.setSize(this.info_w + 30, this.info_h + 100);
            this.guardian.setIcon(new ImageIcon(this.bimage));
            this.guardian.repaint();
        }
        boolean bl2 = false;
        if (string2.equals("avi")) {
            this.graceful_stop();
            this.stop_playback = false;
            Avi avi = new Avi();
            avi.init(string, this);
            avi.start();
            bl2 = true;
        }
        if (string2.equals("cvc")) {
            this.graceful_stop();
            this.stop_playback = false;
            Cvc cvc = new Cvc();
            cvc.init(string, this);
            cvc.start();
            bl2 = true;
        }
        if (string2.equals("fli") || string2.equals("flc")) {
            this.graceful_stop();
            this.stop_playback = false;
            Flick flick = new Flick();
            flick.init(string, this);
            flick.start();
            bl2 = true;
        }
        if (string2.equals("anim")) {
            this.graceful_stop();
            this.stop_playback = false;
            Anim anim = new Anim();
            anim.init(string, this);
            anim.start();
            bl2 = true;
        }
        if (bl2) {
            this.item[4].setEnabled(false);
        }
    }

    public void graceful_stop() {
        this.stop_playback = true;
        System.out.println("Gracefully stopping any playing video...");
        do {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
                break;
            }
        } while (this.playing_playback);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        switch (string = actionEvent.getActionCommand()) {
            case "Copy": {
                if (this.bimage == null) break;
                TransferableImage transferableImage = new TransferableImage(this.bimage);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferableImage, null);
                break;
            }
            case "Information": {
                if (this.current_file != null) {
                    String[] stringArray = new String[]{this.info_w + " x " + this.info_h + " x " + this.info_d, this.info_type, this.info_comp};
                    String string2 = stringArray[0] + "\n" + stringArray[1] + "\n" + stringArray[2];
                    if (this.info_frames > 0) {
                        string2 = string2 + "\n" + this.info_frames + " frames @ " + this.info_fps + " fps";
                    }
                    JOptionPane.showMessageDialog(null, string2, "File Info", 1);
                    break;
                }
                JOptionPane.showMessageDialog(null, "No file loaded!", "File Info", 1);
                break;
            }
            case "Exit": {
                this.graceful_stop();
                System.exit(0);
                break;
            }
            case "About": {
                Intro intro = new Intro();
                break;
            }
            case "Pause": {
                if (!this.playing_playback) break;
                if (!this.pause_playback) {
                    this.pause_playback = true;
                    break;
                }
                this.pause_playback = false;
                break;
            }
            case "stop": 
            case "Stop": {
                this.stop_playback = true;
                this.item[0].setEnabled(true);
                break;
            }
            case "play": 
            case "Replay": {
                if (this.current_file == null) break;
                this.open_media(this.current_file);
                break;
            }
            case "open": 
            case "Open...": {
                String string3;
                FileDialog fileDialog = new FileDialog((Frame)this, "Open", 0);
                fileDialog.setFile("*.cvi;*.iff;*.cvc;*.flc;*.fli;*.avi;*.pic;*.anim;*qoi");
                fileDialog.setVisible(true);
                if (fileDialog.getFile() == null) break;
                this.current_file = string3 = new String(fileDialog.getDirectory() + fileDialog.getFile());
                this.open_media(string3);
                break;
            }
            case "coin": {
                View.openWebpage("https://cointiply.com/r/KegY7o");
                break;
            }
            case "pound": {
                View.openWebpage("https://www.topcashback.co.uk/ref/ssjx");
            }
        }
    }

    public static void openWebpage(String string) {
        try {
            Desktop.getDesktop().browse(new URL(string).toURI());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        System.out.println("Lost Clipboard Ownership");
    }

    public static void main(String[] stringArray) {
        View view = new View();
    }
}

