/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Contact
extends JFrame
implements ActionListener,
WindowListener,
ListSelectionListener,
Printable {
    static final String prog_name = "Contact Sheet Maker";
    static final String prog_desc = "Image Application";
    static final String prog_author = "ssjx";
    static final String prog_version = "v0.2 (27/11/2025)";
    static final String prog_url = "https://ssjx.co.uk";
    static final boolean demo = false;
    JLabel info_label;
    JLabel print_label;
    JList<PicInfo> mylist;
    JMenuBar menuBar = new JMenuBar();
    JMenuItem[] item = new JMenuItem[40];
    ArrayList<String> fn = new ArrayList();
    DefaultListModel<PicInfo> listm = new DefaultListModel();
    ArrayList<Integer> image_start = new ArrayList();
    final int width = 160;
    final int height = 120;
    int image_gap = 5;
    int images_per_row = 5;
    JScrollPane scrolly;
    private final Font smlFont = new Font("Arial", 0, 12);
    String footer = "Created with Contact Sheet Maker https://ssjx.co.uk";
    int image_index = 0;
    int alt = 1;

    public Contact() {
        super("Contact");
        this.setSize(680, 520);
        this.setFocusable(true);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.contact_gui();
        this.setTitle("Contact Sheet Maker v0.2 (27/11/2025) by ssjx (https://ssjx.co.uk)");
        this.set_status();
    }

    public void add_thumb() {
        boolean bl = false;
        ImportPic importPic = new ImportPic();
        importPic.init(this.fn, this);
        importPic.start();
        this.refresh_thumbs();
    }

    public void refresh_thumbs() {
        int[] nArray = this.mylist.getSelectedIndices();
        int n = nArray.length;
        int n2 = this.listm.size();
        if (n2 > 0) {
            String string = n2 + " images";
            if (n > 0) {
                string = n + " of " + n2 + " images selected.";
            }
            this.info_label.setText(string);
            this.item[4].setEnabled(true);
        } else {
            this.set_status();
            this.item[4].setEnabled(false);
        }
        this.print_label.setText(this.images_per_row + " image per row / " + this.image_gap + "px padding");
    }

    /*
     * WARNING - void declaration
     */
    public void contact_gui() {
        String[] stringArray;
        void object3;
        this.addWindowListener(this);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        String[] stringArray2 = new String[]{"New", "", "Open...", "", "Print...", "Exit"};
        int n = 0;
        for (String string : stringArray2) {
            if (string.equals("")) {
                jMenu.addSeparator();
            } else {
                this.item[n] = new JMenuItem(string);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                if (string.equals("New")) {
                    this.item[n].setMnemonic(78);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(78, 2));
                }
                if (string.equals("Open...")) {
                    this.item[n].setMnemonic(79);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(79, 2));
                }
                if (string.equals("Print...")) {
                    this.item[n].setMnemonic(80);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(80, 2));
                    this.item[n].setEnabled(false);
                }
                if (string.equals("Exit")) {
                    this.item[n].setMnemonic(88);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(115, 8));
                }
                jMenu.add(this.item[n]);
            }
            ++n;
        }
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic(69);
        String[] stringArray3 = new String[]{"Select All", "Select None", "", "Remove Selected", "", "Settings"};
        for (String string : stringArray3) {
            if (string.equals("")) {
                jMenu2.addSeparator();
            } else {
                this.item[n] = new JMenuItem(string);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                if (string.equals("Select All")) {
                    this.item[n].setMnemonic(65);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(65, 2));
                }
                if (string.equals("Remove Selected")) {
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(127, 0));
                }
                jMenu2.add(this.item[n]);
            }
            ++n;
        }
        JMenu jMenu3 = new JMenu("Help");
        jMenu3.setMnemonic(72);
        String[] stringArray4 = new String[]{"About", "Debug"};
        Object jPanel = stringArray4;
        int n2 = ((String[])jPanel).length;
        boolean bl = false;
        while (object3 < n2) {
            String jPanel2 = jPanel[object3];
            this.item[n] = new JMenuItem(jPanel2);
            this.item[n].addActionListener(this);
            this.item[n].setActionCommand(jPanel2);
            if (jPanel2.equals("About")) {
                this.item[n].setAccelerator(KeyStroke.getKeyStroke(112, 0));
            }
            if (jPanel2.equals("Debug")) {
                this.item[n].setEnabled(false);
            }
            jMenu3.add(this.item[n]);
            ++n;
            ++object3;
        }
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
        this.menuBar.add(jMenu3);
        this.setJMenuBar(this.menuBar);
        this.mylist = new JList<PicInfo>(this.listm);
        this.mylist.setLayoutOrientation(2);
        this.mylist.setCellRenderer(new ThumbRenderer());
        this.mylist.setVisibleRowCount(-1);
        this.mylist.addListSelectionListener(this);
        this.scrolly = new JScrollPane(this.mylist);
        this.setDropTarget(new DropTarget(this, new DropTargetListener(){

            @Override
            public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
                if (dropTargetDragEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    dropTargetDragEvent.acceptDrag(1);
                } else {
                    dropTargetDragEvent.rejectDrag();
                }
            }

            @Override
            public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            }

            @Override
            public void dragExit(DropTargetEvent dropTargetEvent) {
            }

            @Override
            public void drop(DropTargetDropEvent dropTargetDropEvent) {
                try {
                    dropTargetDropEvent.acceptDrop(1);
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        for (File file : list) {
                            Contact.this.fn.add(file.getAbsolutePath());
                        }
                        Contact.this.add_thumb();
                        dropTargetDropEvent.dropComplete(true);
                    } else {
                        dropTargetDropEvent.rejectDrop();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    dropTargetDropEvent.dropComplete(false);
                }
            }
        }));
        jPanel = new JPanel();
        ((Container)jPanel).setLayout(new FlowLayout(3));
        for (String string : stringArray = new String[]{"1", "5", "10", "#"}) {
            JButton jButton;
            if (!string.equals("#")) {
                String string2 = string + " Images Per Row";
                jButton = new JButton(string2);
                jButton.setToolTipText(string2);
                jButton.setActionCommand(string + "pic");
            } else {
                jButton = new JButton("Custom");
                jButton.setToolTipText("Settings");
                jButton.setActionCommand("Settings");
            }
            jButton.addActionListener(this);
            ((Container)jPanel).add(jButton);
        }
        GridLayout gridLayout = new GridLayout(0, 3);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridLayout);
        jPanel2.setBackground(Color.WHITE);
        this.info_label = new JLabel("");
        this.info_label.setBorder(new EmptyBorder(3, 5, 3, 5));
        jPanel2.add(this.info_label);
        this.print_label = new JLabel("");
        this.print_label.setText(this.images_per_row + " image per row / " + this.image_gap + "px padding");
        this.print_label.setHorizontalAlignment(0);
        this.print_label.setBorder(new EmptyBorder(3, 0, 3, 0));
        jPanel2.add(this.print_label);
        Serializable serializable = new JButton("");
        serializable.setText("<html>&#10084;&#65039; <u>Save money shopping online!</u></html>");
        serializable.setHorizontalAlignment(4);
        serializable.setBorderPainted(false);
        serializable.setBackground(Color.WHITE);
        serializable.setToolTipText("Click to visit TopCashback!");
        serializable.setOpaque(false);
        serializable.setActionCommand("advert");
        serializable.addActionListener(this);
        jPanel2.add((Component)serializable);
        serializable = new BorderLayout();
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)((Object)serializable));
        this.mylist.setBackground(jPanel3.getBackground());
        jPanel3.add((Component)jPanel, "First");
        jPanel3.add((Component)this.scrolly, "Center");
        jPanel3.add((Component)jPanel2, "Last");
        this.add(jPanel3);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private static void openWebpage(String string) {
        try {
            Desktop.getDesktop().browse(new URL(string).toURI());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean add_image(String string) {
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n - 1).toLowerCase();
        if (string2.endsWith(".jpg") || string2.endsWith(".jpeg") || string2.endsWith(".png")) {
            try {
                PicInfo picInfo = new PicInfo(string);
                this.listm.addElement(picInfo);
                return true;
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
        return false;
    }

    boolean import_images() {
        int n = 0;
        FileDialog fileDialog = new FileDialog((Frame)this, "Import Image", 0);
        fileDialog.setFile("*.jpg;*.jpeg;*.png;");
        fileDialog.setMultipleMode(true);
        fileDialog.setVisible(true);
        if (fileDialog.getFiles() != null) {
            File[] fileArray;
            for (File file : fileArray = fileDialog.getFiles()) {
                String string = file.getAbsolutePath();
                this.fn.add(string);
                ++n;
            }
        }
        if (n > 0) {
            this.add_thumb();
        }
        return true;
    }

    void set_status() {
        this.info_label.setText("Welcome to Contact Sheet Maker!");
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.refresh_thumbs();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        switch (string = actionEvent.getActionCommand()) {
            case "1pic": {
                this.images_per_row = 1;
                this.refresh_thumbs();
                break;
            }
            case "5pic": {
                this.images_per_row = 5;
                this.refresh_thumbs();
                break;
            }
            case "10pic": {
                this.images_per_row = 10;
                this.refresh_thumbs();
                break;
            }
            case "New": {
                this.listm.clear();
                this.fn.clear();
                this.refresh_thumbs();
                break;
            }
            case "Select All": {
                this.selectAll();
                break;
            }
            case "Select None": {
                this.selectNone();
                break;
            }
            case "Remove Selected": {
                this.remove_selected();
                break;
            }
            case "Print...": {
                this.image_start.clear();
                this.print_page();
                break;
            }
            case "Settings": {
                Settings settings = new Settings(this);
                if (settings.option == 0) break;
                this.images_per_row = settings.images;
                this.image_gap = settings.gap;
                this.refresh_thumbs();
                break;
            }
            case "About": {
                Intro intro = new Intro();
                break;
            }
            case "Exit": {
                this.dispose();
                break;
            }
            case "open": 
            case "Open...": {
                this.import_images();
                break;
            }
            case "advert": {
                Contact.openWebpage("https://www.topcashback.co.uk/ref/ssjx");
            }
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        block12: {
            int n2;
            int n3;
            this.alt = 1 - this.alt;
            if (this.alt == 0) {
                this.info_label.setText("/");
            } else {
                this.info_label.setText("\\");
            }
            if (this.image_start.size() > 0 && n >= this.image_start.size()) {
                System.out.println("Done - No more images! " + this.image_index + " >= " + this.listm.size());
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            System.out.println("-- Page " + n + " --");
            System.out.println("Page Width:\t" + pageFormat.getImageableWidth());
            System.out.println("Page Height:\t" + pageFormat.getImageableHeight());
            int n4 = (int)pageFormat.getImageableWidth();
            int n5 = (int)pageFormat.getImageableHeight();
            int n6 = this.image_gap;
            int n7 = (n4 - (this.images_per_row + 1) * this.image_gap) / this.images_per_row;
            int n8 = n6;
            int n9 = n6;
            int n10 = 0;
            int n11 = 0;
            if (this.image_start.size() == 0) {
                n3 = 0;
                this.image_start.add(0);
                do {
                    this.listm.get(n3).resize_print(n7);
                    int n12 = this.listm.get((int)n3).print_width;
                    n2 = this.listm.get((int)n3).print_height;
                    if (n9 + n2 + 40 < n5) {
                        System.out.println("\tImage " + n3 + " ypos:" + n9);
                        n8 += n12 + n6;
                        ++n10;
                        if (n2 > n11) {
                            n11 = n2;
                        }
                        if (n10 >= this.images_per_row) {
                            n10 = 0;
                            n8 = n6;
                            n9 += n11 + n6;
                            n11 = 0;
                        }
                        ++n3;
                        continue;
                    }
                    n8 = n6;
                    n9 = n6;
                    n10 = 0;
                    n11 = 0;
                    this.image_start.add(n3);
                    System.out.println("New page needed");
                } while (n3 < this.listm.size());
                System.out.println("No more images!");
            }
            System.out.println("Image Width:\t" + n7);
            FontMetrics fontMetrics = graphics.getFontMetrics(this.smlFont);
            n2 = fontMetrics.stringWidth(this.footer);
            int n13 = (n4 - n2) / 2;
            graphics.setFont(this.smlFont);
            graphics.setColor(Color.gray);
            graphics.drawString(this.footer, n13, n5 - 20);
            n8 = n6;
            n9 = n6;
            n10 = 0;
            n11 = 0;
            n3 = this.image_start.get(n);
            do {
                this.listm.get(n3).resize_print(n7);
                int n14 = this.listm.get((int)n3).print_width;
                n2 = this.listm.get((int)n3).print_height;
                if (n9 + n2 + 40 >= n5) {
                    System.out.println("New page needed");
                    break block12;
                }
                System.out.println("\tImage " + n3 + " ypos:" + n9);
                graphics.drawImage(this.listm.get((int)n3).mybmp, n8, n9, n14, n2, null);
                n8 += n14 + n6;
                ++n10;
                if (n2 > n11) {
                    n11 = n2;
                }
                if (n10 >= this.images_per_row) {
                    n10 = 0;
                    n8 = n6;
                    n9 += n11 + n6;
                    n11 = 0;
                }
            } while (++n3 < this.listm.size());
            System.out.println("No more images!");
        }
        System.out.println("Return - Page Exists");
        return 0;
    }

    private void print_page() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        printerJob.setPrintable(this);
        this.info_label.setText("Please wait, printing...");
        boolean bl = printerJob.printDialog();
        if (bl) {
            try {
                System.out.println("=== Printing ===");
                printerJob.print();
                this.refresh_thumbs();
            }
            catch (PrinterException printerException) {
                System.out.println(printerException);
            }
        }
    }

    private void selectAll() {
        this.mylist.setSelectionInterval(0, this.listm.size());
        this.refresh_thumbs();
    }

    private void selectNone() {
        this.mylist.clearSelection();
        this.refresh_thumbs();
    }

    private void remove_selected() {
        boolean bl;
        int[] nArray;
        int n = 0;
        int[] nArray2 = nArray = this.mylist.getSelectedIndices();
        int n2 = nArray2.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray2[i];
            if (n3 < this.listm.size()) {
                this.listm.get((int)n3).selected = true;
                continue;
            }
            System.out.println("Cannot remove item #" + n3);
        }
        block1: do {
            bl = true;
            for (n2 = 0; n2 < this.listm.size(); ++n2) {
                if (!this.listm.get((int)n2).selected) continue;
                this.listm.remove(n2);
                ++n;
                bl = false;
                continue block1;
            }
        } while (!bl);
        System.out.println(n + " items removed");
        if (n > 0) {
            this.refresh_thumbs();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        System.out.println("closed Main window");
        System.exit(0);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("closing Main window");
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    public static void main(String[] stringArray) {
        Contact contact = new Contact();
    }
}

