/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.time.LocalTime;
import java.util.Scanner;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Clock
implements ActionListener,
KeyListener,
WindowListener {
    private final boolean debug = false;
    JFrame frame;
    public static final String prog_name = "Clock";
    static final String prog_desc = "Large Digital Clock";
    static final String prog_author = "ssjx";
    public static final String prog_version = "v0.3b (06/10/2024)";
    public static final String prog_url = "https://ssjx.co.uk";
    final String settings_file = "settings.txt";
    private Color dim_color = new Color(250, 250, 250);
    private Color led_color = Color.red;
    private Color bg_color = null;
    private Color saved_dim_color = null;
    private int[] active = new int[]{0, 2359};
    private boolean showtext = true;
    private boolean showintro = true;
    private int xdir = 2;
    private int ydir = 2;
    private int bx = 30;
    private int by = 30;
    int blink = 1;
    JPanel mypanel = new JPanel();
    ImageIcon myicon;
    JLabel mylabel;
    BufferedImage bimage;
    int prev_width;
    int prev_height;
    final Font fs = new Font("Arial", 1, 16);
    String start_str;
    String end_str;
    FontMetrics fmetric;
    int counter = 15;
    String[] txt = new String[3];
    boolean full = false;
    Dimension framesize = new Dimension(800, 480);
    Point framepos;
    static GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
    private int size = 16;
    private int half = this.size / 2;
    private int width = 4 * this.size;
    private int height = this.size;

    public Clock() {
        Object object;
        this.createUI(false);
        this.load_settings();
        this.start_str = "" + this.active[0];
        this.end_str = "" + this.active[1];
        if (this.start_str.length() != 4) {
            object = "0".repeat(4 - this.start_str.length());
            this.start_str = (String)object + this.start_str;
        }
        if (this.end_str.length() != 4) {
            object = "0".repeat(4 - this.end_str.length());
            this.end_str = (String)object + this.end_str;
        }
        this.txt[0] = "Time displaying from " + this.start_str + " until " + this.end_str;
        this.txt[1] = "Visit http://ssjx.co.uk for more great applications!";
        this.update();
        object = new Thread(){

            @Override
            public void run() {
                while (true) {
                    Clock.this.update();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        ((Thread)object).start();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 122: {
                if (!this.full) break;
                this.full = false;
                this.frame.dispose();
                this.createUI(this.full);
                device.setFullScreenWindow(null);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void createUI(boolean bl) {
        JMenuBar jMenuBar = new JMenuBar();
        JMenuItem[] jMenuItemArray = new JMenuItem[35];
        this.frame = new JFrame();
        this.frame.addWindowListener(this);
        this.frame.setSize(this.framesize.width, this.framesize.height);
        this.frame.setDefaultCloseOperation(3);
        if (this.bg_color == null) {
            this.bg_color = this.frame.getBackground();
        }
        this.frame.setTitle("Clock v0.3b (06/10/2024) by ssjx (https://ssjx.co.uk)");
        if (!bl) {
            String string4;
            String[] stringArray;
            JMenu jMenu = new JMenu("File");
            jMenu.setMnemonic(70);
            String[] stringArray2 = new String[]{"Open...", "Save", "Save As...", "", "Exit"};
            int n = 0;
            for (String string2 : stringArray2) {
                if (string2.equals("")) {
                    jMenu.addSeparator();
                } else {
                    jMenuItemArray[n] = new JMenuItem(string2);
                    jMenuItemArray[n].addActionListener(this);
                    jMenuItemArray[n].setActionCommand(string2);
                    if (!string2.equals("Exit")) {
                        jMenuItemArray[n].setEnabled(false);
                    }
                    if (string2.equals("Exit")) {
                        jMenuItemArray[n].setMnemonic(88);
                        jMenuItemArray[n].setAccelerator(KeyStroke.getKeyStroke(115, 8));
                    }
                    jMenu.add(jMenuItemArray[n]);
                }
                ++n;
            }
            JMenu jMenu2 = new JMenu("Settings");
            jMenu2.setMnemonic(83);
            String[] stringArray3 = new String[]{"Colour", "Dim Colour", "Background", "Show/Hide Dim", "Active Range"};
            for (String string3 : stringArray3) {
                jMenuItemArray[n] = new JMenuItem(string3);
                jMenuItemArray[n].addActionListener(this);
                jMenuItemArray[n].setActionCommand(string3);
                jMenu2.add(jMenuItemArray[n]);
                ++n;
            }
            JMenu jMenu3 = new JMenu("Help");
            jMenu3.setMnemonic(72);
            for (String string4 : stringArray = new String[]{"About", "Fullscreen"}) {
                jMenuItemArray[n] = new JMenuItem(string4);
                jMenuItemArray[n].addActionListener(this);
                jMenuItemArray[n].setActionCommand(string4);
                if (string4.equals("About")) {
                    jMenuItemArray[n].setMnemonic(65);
                    jMenuItemArray[n].setAccelerator(KeyStroke.getKeyStroke(112, 0));
                }
                if (string4.equals("Fullscreen")) {
                    jMenuItemArray[n].setMnemonic(70);
                    jMenuItemArray[n].setAccelerator(KeyStroke.getKeyStroke(122, 0));
                }
                jMenu3.add(jMenuItemArray[n]);
                ++n;
            }
            JButton jButton = new JButton();
            jButton.setBorderPainted(false);
            jButton.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
            String string5 = "";
            string4 = "$";
            switch (1) {
                case 0: {
                    string5 = "coin";
                    jButton.setToolTipText("Earn Free Bitcoin at Cointiply!");
                    string4 = "$";
                    break;
                }
                case 1: {
                    string5 = "pound";
                    jButton.setToolTipText("Save money shopping online with TopCashback!");
                    string4 = "\u00c2\u00a3";
                    break;
                }
                case 2: {
                    string5 = "test";
                    jButton.setToolTipText("Earn money as a games tester at Testerup!");
                    string4 = "T";
                }
            }
            jButton.setFocusable(false);
            jButton.addActionListener(this);
            jButton.setActionCommand(string5);
            try {
                BufferedImage bufferedImage = ImageIO.read(this.getClass().getResource("gifs/" + string5 + ".gif"));
                jButton.setIcon(new ImageIcon(bufferedImage));
            }
            catch (Exception exception) {
                jButton.setText(string4);
            }
            jMenuBar.add(jMenu);
            jMenuBar.add(jMenu2);
            jMenuBar.add(jMenu3);
            jMenuBar.add(Box.createHorizontalGlue());
            jMenuBar.add(jButton);
            this.frame.setJMenuBar(jMenuBar);
        } else {
            this.frame.setUndecorated(true);
            this.frame.addKeyListener(this);
        }
        this.myicon = new ImageIcon();
        this.mylabel = new JLabel(this.myicon);
        this.prev_height = this.mylabel.getHeight();
        this.prev_width = this.mylabel.getWidth();
        this.frame.add(this.mylabel);
        if (this.framepos == null) {
            this.frame.setLocationRelativeTo(null);
        } else {
            this.frame.setLocation(this.framepos.x, this.framepos.y);
        }
        this.frame.setVisible(true);
    }

    boolean save_settings() {
        int n;
        Color color;
        int n2;
        int n3;
        String[] stringArray = new String[10];
        int n4 = 0;
        if (!this.led_color.equals(Color.red)) {
            int n5 = this.led_color.getRed();
            n3 = this.led_color.getGreen();
            n2 = this.led_color.getBlue();
            stringArray[n4++] = "color:" + n5 + "," + n3 + "," + n2;
        }
        if (!this.dim_color.equals(color = new Color(250, 250, 250))) {
            n3 = this.dim_color.getRed();
            n2 = this.dim_color.getGreen();
            n = this.dim_color.getBlue();
            stringArray[n4++] = "dim:" + n3 + "," + n2 + "," + n;
        }
        if (!this.bg_color.equals(this.frame.getBackground())) {
            n3 = this.bg_color.getRed();
            n2 = this.bg_color.getGreen();
            n = this.bg_color.getBlue();
            stringArray[n4++] = "background:" + n3 + "," + n2 + "," + n;
        }
        n3 = 0;
        if (this.active[0] != 0) {
            n3 = 1;
        }
        if (this.active[1] != 2359) {
            n3 = 1;
        }
        if (n3 == 1) {
            String string = "" + this.active[0];
            String string2 = "" + this.active[1];
            stringArray[n4++] = "active:" + string + "," + string2;
        }
        if (!this.showtext) {
            stringArray[n4++] = "showtext:false\r\n";
        }
        if (n4 > 0) {
            try {
                FileWriter fileWriter = new FileWriter("settings.txt");
                for (String string : stringArray) {
                    if (string == null) continue;
                    fileWriter.write(string + "\r\n");
                }
                fileWriter.close();
                return true;
            }
            catch (IOException iOException) {
                System.out.println("An error occurred.");
            }
        } else {
            File file = new File("settings.txt");
            if (file.exists()) {
                file.delete();
            }
        }
        return false;
    }

    private Color string_to_color(String string) {
        Color color = null;
        try {
            String[] stringArray = string.split(",");
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            int n3 = Integer.parseInt(stringArray[2]);
            color = new Color(n, n2, n3);
        }
        catch (Exception exception) {
            System.out.println("Error converting colour...");
        }
        return color;
    }

    private boolean load_settings() {
        try {
            File file = new File("settings.txt");
            if (file.exists()) {
                Scanner scanner = new Scanner(file);
                block20: while (scanner.hasNextLine()) {
                    String string = scanner.nextLine();
                    if (string.charAt(0) == '#') continue;
                    String[] stringArray = string.split(":");
                    switch (stringArray[0]) {
                        case "color": {
                            Color color = this.string_to_color(stringArray[1]);
                            if (color == null) break;
                            this.led_color = color;
                            break;
                        }
                        case "dim": {
                            Color color = this.string_to_color(stringArray[1]);
                            if (color == null) break;
                            this.dim_color = color;
                            break;
                        }
                        case "background": {
                            Color color = this.string_to_color(stringArray[1]);
                            if (color == null) break;
                            this.bg_color = color;
                            break;
                        }
                        case "active": {
                            try {
                                String[] stringArray2 = stringArray[1].split(",");
                                int n = Integer.parseInt(stringArray2[0]);
                                int n2 = Integer.parseInt(stringArray2[1]);
                                this.active[0] = n;
                                this.active[1] = n2;
                                for (int i = 0; i < 2; ++i) {
                                    if (this.active[i] >= 2400) {
                                        this.active[i] = 2359;
                                    }
                                    if (this.active[i] >= 0) continue;
                                    this.active[i] = 0;
                                }
                                continue block20;
                            }
                            catch (Exception exception) {
                                System.out.println("Error loading clock active times...");
                                this.active[0] = 0;
                                this.active[1] = 2400;
                                break;
                            }
                        }
                        case "showtext": {
                            if (!stringArray[1].equals("false")) break;
                            this.showtext = false;
                            break;
                        }
                        case "showintro": {
                            if (!stringArray[1].equals("false")) break;
                            this.showintro = false;
                        }
                    }
                }
                scanner.close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private void update() {
        if (this.frame == null) {
            return;
        }
        int n = this.mylabel.getWidth();
        int n2 = this.mylabel.getHeight();
        if (this.prev_width != n || this.prev_height != n2) {
            this.bimage = new BufferedImage(n, n2, 1);
            this.prev_height = n2;
            this.prev_width = n;
            this.bx = n / 2;
            this.by = n2 / 2;
        }
        Graphics graphics = this.bimage.getGraphics();
        this.drawClock(graphics);
        if (this.counter > 0) {
            --this.counter;
            this.txt[2] = "This message will vanish in " + this.counter + " seconds...";
            graphics.setColor(this.led_color);
            graphics.setFont(this.fs);
            this.fmetric = graphics.getFontMetrics(this.fs);
            int n3 = n2 - 50;
            for (String string : this.txt) {
                if (string == null) continue;
                int n4 = (n - this.fmetric.stringWidth(string)) / 2;
                graphics.drawString(string, n4, n3);
                n3 += 18;
            }
        }
        this.mylabel.setIcon(new ImageIcon(this.bimage));
        this.mylabel.repaint();
    }

    public static void main(String[] stringArray) {
        Clock clock = new Clock();
    }

    private void diamond(Graphics graphics, int n, int n2) {
        Polygon polygon = new Polygon();
        polygon.addPoint(n, n2);
        polygon.addPoint(n - this.half, n2 + this.half);
        polygon.addPoint(n, n2 + this.size);
        polygon.addPoint(n + this.half, n2 + this.half);
        graphics.fillPolygon(polygon);
    }

    private void block_number(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        if (n == 0) {
            n4 = 119;
        }
        if (n == 1) {
            n4 = 36;
        }
        if (n == 2) {
            n4 = 93;
        }
        if (n == 3) {
            n4 = 109;
        }
        if (n == 4) {
            n4 = 46;
        }
        if (n == 5) {
            n4 = 107;
        }
        if (n == 6) {
            n4 = 123;
        }
        if (n == 7) {
            n4 = 37;
        }
        if (n == 8) {
            n4 = 127;
        }
        if (n == 9) {
            n4 = 111;
        }
        graphics.setColor(this.dim_color);
        if ((n4 & 1) == 1) {
            graphics.setColor(this.led_color);
        }
        graphics.fillRect(n2, n3, this.width, this.height);
        this.diamond(graphics, n2, n3);
        this.diamond(graphics, n2 + this.width, n3);
        graphics.setColor(this.dim_color);
        if ((n4 & 2) == 2) {
            graphics.setColor(this.led_color);
        }
        graphics.fillRect(n2 - this.size, n3 + this.size, this.height, this.width);
        this.diamond(graphics, n2 - this.half, n3 + this.half);
        this.diamond(graphics, n2 - this.half, n3 + 4 * this.size + this.half);
        graphics.setColor(this.dim_color);
        if ((n4 & 4) == 4) {
            graphics.setColor(this.led_color);
        }
        graphics.fillRect(n2 + 4 * this.size, n3 + this.height, this.height, this.width);
        this.diamond(graphics, n2 + 5 * this.size - this.half, n3 + this.half);
        this.diamond(graphics, n2 + 5 * this.size - this.half, n3 + 4 * this.size + this.half);
        graphics.setColor(this.dim_color);
        if ((n4 & 8) == 8) {
            graphics.setColor(this.led_color);
        }
        graphics.fillRect(n2, n3 + 5 * this.size, this.width, this.height);
        this.diamond(graphics, n2, n3 + 5 * this.size);
        this.diamond(graphics, n2 + this.width, n3 + 5 * this.size);
        graphics.setColor(this.dim_color);
        if ((n4 & 0x10) == 16) {
            graphics.setColor(this.led_color);
        }
        graphics.fillRect(n2 - this.size, n3 + 6 * this.size, this.size, this.size * 4);
        this.diamond(graphics, n2 - this.half, n3 + 5 * this.size + this.half);
        this.diamond(graphics, n2 - this.half, n3 + 5 * this.size + 4 * this.size + this.half);
        graphics.setColor(this.dim_color);
        if ((n4 & 0x20) == 32) {
            graphics.setColor(this.led_color);
        }
        graphics.fillRect(n2 + 4 * this.size, n3 + 6 * this.size, this.size, this.size * 4);
        this.diamond(graphics, n2 + 5 * this.size - this.half, n3 + 5 * this.size + this.half);
        this.diamond(graphics, n2 + 5 * this.size - this.half, n3 + 5 * this.size + 4 * this.size + this.half);
        graphics.setColor(this.dim_color);
        if ((n4 & 0x40) == 64) {
            graphics.setColor(this.led_color);
        }
        graphics.fillRect(n2, n3 + 10 * this.size, this.width, this.height);
        this.diamond(graphics, n2, n3 + 10 * this.size);
        this.diamond(graphics, n2 + this.width, n3 + 10 * this.size);
    }

    private int block_dot(Graphics graphics, int n, int n2) {
        graphics.setColor(this.dim_color);
        if (this.blink == 1) {
            graphics.setColor(this.led_color);
        }
        this.blink = 1 - this.blink;
        this.diamond(graphics, n + this.half, n2 + 4 * this.size);
        this.diamond(graphics, n + this.half, n2 + 6 * this.size);
        return 3 * this.size;
    }

    private void drawClock(Graphics graphics) {
        int n;
        String string;
        int n2 = this.bimage.getWidth();
        int n3 = this.bimage.getHeight();
        LocalTime localTime = LocalTime.now();
        String string2 = "" + localTime.getHour();
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = "" + localTime.getMinute()).length() == 1) {
            string = "0" + string;
        }
        if ((n = localTime.getHour() * 100 + localTime.getMinute()) >= this.active[0] && n <= this.active[1]) {
            graphics.setColor(this.bg_color);
            graphics.fillRect(0, 0, n2, n3);
            this.size = n2 / 31;
            if (this.size * 10 > n3) {
                this.size = n3 / 12;
            }
            this.half = this.size / 2;
            this.width = 4 * this.size;
            this.height = this.size;
            int n4 = 6 * this.size;
            int n5 = 11 * this.size;
            int n6 = (n2 - 4 * n4 - 2 * this.size - 3 * this.size) / 2;
            int n7 = (n3 - n5) / 2;
            n6 += this.size;
            char c = string2.charAt(0);
            if (c == '0') {
                this.block_number(graphics, -1, n6, n7);
            } else {
                this.block_number(graphics, c - 48, n6, n7);
            }
            c = string2.charAt(1);
            this.block_number(graphics, c - 48, n6 += n4 + this.size, n7);
            this.block_dot(graphics, n6 += n4, n7);
            c = string.charAt(0);
            this.block_number(graphics, c - 48, n6 += 3 * this.size, n7);
            c = string.charAt(1);
            this.block_number(graphics, c - 48, n6 += n4 + this.size, n7);
        } else {
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, n2, n3);
            if (this.showtext) {
                graphics.setColor(Color.gray);
                graphics.drawString("Sleeping...", this.bx, this.by);
                this.bx += this.xdir;
                this.by += this.ydir;
                if (this.bx < 0 || this.bx + 40 > n2) {
                    this.xdir *= -1;
                }
                if (this.by < 0 || this.by + 20 > n3) {
                    this.ydir *= -1;
                }
            }
        }
    }

    public static void openWebpage(String string) {
        try {
            Desktop.getDesktop().browse(new URL(string).toURI());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        switch (string = actionEvent.getActionCommand()) {
            case "coin": {
                Clock.openWebpage("http://cointiply.com/r/KegY7o");
                break;
            }
            case "pound": {
                Clock.openWebpage("https://www.topcashback.co.uk/ref/ssjx");
                break;
            }
            case "test": {
                Clock.openWebpage("https://www.testerup.com/start/?promotion=&cid=xLB8d48XQM");
                break;
            }
            case "Colour": {
                Color color = JColorChooser.showDialog(this.frame, "Choose Segment Colour", this.led_color);
                if (color == null) break;
                this.led_color = color;
                break;
            }
            case "Dim Colour": {
                Color color = JColorChooser.showDialog(this.frame, "Choose Dim Segment Colour", this.dim_color);
                if (color == null) break;
                this.dim_color = color;
                break;
            }
            case "Background": {
                Color color = JColorChooser.showDialog(this.frame, "Choose Background Colour", this.bg_color);
                if (color == null) break;
                this.bg_color = color;
                break;
            }
            case "Show/Hide Dim": {
                if (this.dim_color != this.bg_color) {
                    this.saved_dim_color = this.dim_color;
                    this.dim_color = this.bg_color;
                    break;
                }
                this.dim_color = this.saved_dim_color;
                break;
            }
            case "Active Range": {
                String string2 = JOptionPane.showInputDialog(this.frame, "Please enter a time range in the format 0000-0000.\nE.g. 0800-1800", this.start_str + "-" + this.end_str);
                if (string2 == null || string2.length() <= 0) break;
                try {
                    String[] stringArray = string2.split("-");
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    this.active[0] = n;
                    this.active[1] = n2;
                    for (int i = 0; i < 2; ++i) {
                        if (this.active[i] >= 2400) {
                            this.active[i] = 2359;
                        }
                        if (this.active[i] >= 0) continue;
                        this.active[i] = 0;
                    }
                    this.start_str = "" + this.active[0];
                    this.end_str = "" + this.active[1];
                    if (this.start_str.length() != 4) {
                        String string3 = "0".repeat(4 - this.start_str.length());
                        this.start_str = string3 + this.start_str;
                    }
                    if (this.end_str.length() != 4) {
                        String string4 = "0".repeat(4 - this.end_str.length());
                        this.end_str = string4 + this.end_str;
                    }
                    JOptionPane.showMessageDialog(null, "Time will be displayed between:\n" + this.start_str + " and " + this.end_str);
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(null, "Sorry, that time does not seem correct...");
                }
                break;
            }
            case "About": {
                Intro intro = new Intro();
                break;
            }
            case "Fullscreen": {
                if (this.full) break;
                this.full = true;
                this.framesize = this.frame.getSize();
                this.framepos = this.frame.getLocation();
                this.frame.dispose();
                this.createUI(this.full);
                device.setFullScreenWindow(this.frame);
                break;
            }
            case "Exit": {
                System.exit(0);
            }
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        System.out.println("closed Main window");
        System.exit(0);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("closing Main window");
        this.save_settings();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

