/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

class SaveFli
extends Thread {
    private Animator parent;
    private String outname;
    byte[] header = new byte[128];
    byte[] chunkhdr = new byte[6];
    byte[] framehdr = new byte[16];
    byte[] pal = new byte[772];
    private short width;
    private short height;
    private short depth = (short)8;
    private short frames;
    private int fps = 7;
    private int speed;

    SaveFli(Animator animator, String string) {
        this.parent = animator;
        this.width = (short)this.parent.width;
        this.height = (short)this.parent.height;
        this.outname = string;
        this.fps = this.parent.fps;
        this.speed = 1000 / this.fps;
    }

    @Override
    public void run() {
        int n = 128;
        System.out.println("Speed: " + this.speed);
        try {
            File file = new File(this.outname);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            this.frames = (short)this.parent.frames.size();
            System.out.println("Saving");
            System.out.println("======");
            System.out.println("Frames: " + this.frames + " @ " + this.fps + " fps");
            System.out.println("Res: " + this.width + " x " + this.height);
            PleaseWait pleaseWait = new PleaseWait(this.parent, this.frames, "Saving FLI file");
            pleaseWait.start();
            this.setheader();
            fileOutputStream.write(this.header, 0, 128);
            int n2 = this.setpal256();
            byte[] byArray = new byte[this.width * this.height];
            int n3 = 0;
            for (int i = 0; i < this.frames + 1; ++i) {
                if (i == this.frames) {
                    n3 = 0;
                    System.out.println("Ring / Loop Frame (First Frame)");
                }
                this.parent.frames.get(n3).make_eight();
                int n4 = -1;
                if (n3 != 0) {
                    this.parent.frames.get(n3);
                    n4 = this.encode_rle(AnimFrame.eight_bit, byArray, this.width, this.height);
                }
                int n5 = n4;
                if (n4 == -1) {
                    n5 = this.width * this.height;
                }
                this.setframechunk(22 + n5 + 6 + n2);
                fileOutputStream.write(this.framehdr, 0, 16);
                this.setchunk(6 + n2, 4);
                fileOutputStream.write(this.chunkhdr, 0, 6);
                fileOutputStream.write(this.pal, 0, n2);
                if (n3 == 0 || n4 == -1) {
                    System.out.println("Encode CPY : " + this.width * this.height + " bytes");
                    this.setchunk(this.width * this.height + 6, 16);
                    fileOutputStream.write(this.chunkhdr, 0, 6);
                    this.parent.frames.get(n3);
                    fileOutputStream.write(AnimFrame.eight_bit, 0, n5);
                } else {
                    System.out.println("Encode RLE : " + this.width * this.height + " to " + n4);
                    this.setchunk(n4 + 6, 15);
                    fileOutputStream.write(this.chunkhdr, 0, 6);
                    fileOutputStream.write(byArray, 0, n4);
                }
                n += 22 + n4 + 6 + n2;
                if (pleaseWait.isCanceled()) break;
                pleaseWait.setProgress(n3);
                ++n3;
            }
            fileOutputStream.close();
            this.writefilesize(n, this.frames);
            System.out.println("Done " + this.frames + " frames");
            System.out.println("Filesize " + n);
            pleaseWait.done();
        }
        catch (IOException iOException) {
            System.out.println("Savefli file not found error...");
        }
    }

    private int encode_rle(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            int n6 = n3++;
            byte by = byArray[n4++];
            int n7 = 1;
            for (int j = 1; j < n; ++j) {
                if (byArray[n4] == by && n7 < 126) {
                    n7 = (byte)(n7 + 1);
                } else {
                    byArray2[n3] = n7;
                    byArray2[n3 + 1] = by;
                    n3 += 2;
                    ++n5;
                    by = byArray[n4];
                    n7 = 1;
                }
                if (n3 > n * n2 - 100) {
                    return -1;
                }
                ++n4;
            }
            if (n7 > 0) {
                byArray2[n3++] = n7;
                byArray2[n3++] = by;
                ++n5;
            }
            if (n5 > 255) {
                n5 = 0;
            }
            byArray2[n6] = (byte)n5;
        }
        return n3;
    }

    public void setheader() {
        Arrays.fill(this.header, (byte)0);
        this.header[0] = 0;
        this.header[1] = 0;
        this.header[2] = 0;
        this.header[3] = 0;
        this.header[4] = 18;
        this.header[5] = -81;
        this.header[6] = (byte)(this.frames & 0xFF);
        this.header[7] = (byte)(this.frames >> 8 & 0xFF);
        this.header[8] = (byte)(this.width & 0xFF);
        this.header[9] = (byte)(this.width >> 8 & 0xFF);
        this.header[10] = (byte)(this.height & 0xFF);
        this.header[11] = (byte)(this.height >> 8 & 0xFF);
        this.header[12] = 8;
        this.header[13] = 0;
        this.header[14] = 0;
        this.header[15] = 0;
        this.header[16] = (byte)(this.speed & 0xFF);
        this.header[17] = (byte)(this.speed >> 8 & 0xFF);
        this.header[18] = (byte)(this.speed >> 16 & 0xFF);
        this.header[19] = (byte)(this.speed >> 24 & 0xFF);
    }

    public void setchunk(int n, int n2) {
        this.chunkhdr[0] = (byte)(n & 0xFF);
        this.chunkhdr[1] = (byte)(n >> 8 & 0xFF);
        this.chunkhdr[2] = (byte)(n >> 16 & 0xFF);
        this.chunkhdr[3] = (byte)(n >> 24 & 0xFF);
        this.chunkhdr[4] = (byte)n2;
        this.chunkhdr[5] = 0;
    }

    public void setframechunk(int n) {
        Arrays.fill(this.framehdr, (byte)0);
        this.framehdr[3] = (byte)(n >> 24 & 0xFF);
        this.framehdr[2] = (byte)(n >> 16 & 0xFF);
        this.framehdr[1] = (byte)(n >> 8 & 0xFF);
        this.framehdr[0] = (byte)(n & 0xFF);
        this.framehdr[4] = -6;
        this.framehdr[5] = -15;
        this.framehdr[6] = 2;
        this.framehdr[7] = 0;
    }

    public int setpal256() {
        int n = 0;
        this.pal[n++] = 1;
        this.pal[n++] = 0;
        this.pal[n++] = 0;
        this.pal[n++] = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 4; ++k) {
                    this.pal[n++] = (byte)(i * 36);
                    this.pal[n++] = (byte)(j * 36);
                    this.pal[n++] = (byte)(k * 85);
                }
            }
        }
        return n;
    }

    public void writefilesize(int n, int n2) {
        System.out.println("Filesize: " + n);
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.outname, "rw");
            byte[] byArray = new byte[4];
            byArray[3] = (byte)(n >> 24 & 0xFF);
            byArray[2] = (byte)(n >> 16 & 0xFF);
            byArray[1] = (byte)(n >> 8 & 0xFF);
            byArray[0] = (byte)(n & 0xFF);
            randomAccessFile.seek(0L);
            randomAccessFile.write(byArray, 0, 4);
            short s = (short)n2;
            this.header[0] = (byte)(s & 0xFF);
            this.header[1] = (byte)(s >> 8 & 0xFF);
            randomAccessFile.seek(0L);
            randomAccessFile.write(this.header, 0, 2);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            System.out.println("Savefli could not write file size...");
        }
    }
}

