/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class ImportQoi {
    public int bmhd_w;
    public int bmhd_h;
    public int bmhd_d;
    public final String bmhd_type = "Quite Okay Image (QOI)";
    public String bmhd_comp_txt = "Compressed";
    public int[] rgb;
    private int[] cache_r = new int[64];
    private int[] cache_g = new int[64];
    private int[] cache_b = new int[64];
    private int[] cache_a = new int[64];

    private int swp(byte by, byte by2, byte by3, byte by4) {
        int n = Byte.toUnsignedInt(by);
        int n2 = Byte.toUnsignedInt(by2);
        int n3 = Byte.toUnsignedInt(by3);
        int n4 = Byte.toUnsignedInt(by4);
        return n + (n2 << 8) + (n3 << 16) + (n4 << 24);
    }

    private void cache_add(int n, int n2, int n3, int n4) {
        int n5 = (n * 3 + n2 * 5 + n3 * 7 + n4 * 11) % 64;
        this.cache_r[n5] = n;
        this.cache_g[n5] = n2;
        this.cache_b[n5] = n3;
        this.cache_a[n5] = n4;
    }

    public boolean load(String string) {
        boolean bl = false;
        try {
            File file = new File(string);
            if (file.exists()) {
                int n;
                int n2;
                FileInputStream fileInputStream = new FileInputStream(string);
                byte[] byArray = ((InputStream)fileInputStream).readAllBytes();
                ((InputStream)fileInputStream).close();
                int n3 = this.swp(byArray[7], byArray[6], byArray[5], byArray[4]);
                int n4 = this.swp(byArray[11], byArray[10], byArray[9], byArray[8]);
                byte by = byArray[12];
                System.out.println("--> File Size " + byArray.length);
                System.out.println("--> Dimensions  : " + n3 + " x " + n4);
                System.out.println("--> Depth : " + by * 8);
                String string2 = "" + (char)byArray[0] + (char)byArray[1] + (char)byArray[2] + (char)byArray[3];
                if (!string2.equals("qoif")) {
                    System.out.println("This does not look like a valid QOI file...");
                    System.out.println("Magic: [" + string2 + "]");
                    this.bmhd_comp_txt = "Invalid QOI header";
                    return false;
                }
                if (n3 <= 0 || n4 <= 0) {
                    System.out.println("These dimensions do not seem right...");
                    this.bmhd_comp_txt = "Invalid QOI dimensions";
                    return false;
                }
                this.bmhd_w = n3;
                this.bmhd_h = n4;
                this.bmhd_d = by * 8;
                this.rgb = new int[this.bmhd_w * this.bmhd_h];
                int[] nArray = new int[n3 * n4];
                int[] nArray2 = new int[n3 * n4];
                int[] nArray3 = new int[n3 * n4];
                int[] nArray4 = new int[n3 * n4];
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 255;
                int n9 = 0;
                int n10 = 14;
                do {
                    int n11;
                    n2 = 0;
                    n = 0;
                    int n12 = Byte.toUnsignedInt(byArray[n10++]);
                    switch (n12) {
                        case 254: {
                            n5 = Byte.toUnsignedInt(byArray[n10++]);
                            n6 = Byte.toUnsignedInt(byArray[n10++]);
                            n7 = Byte.toUnsignedInt(byArray[n10++]);
                            n = 1;
                            break;
                        }
                        case 255: {
                            n5 = Byte.toUnsignedInt(byArray[n10++]);
                            n6 = Byte.toUnsignedInt(byArray[n10++]);
                            n7 = Byte.toUnsignedInt(byArray[n10++]);
                            n8 = Byte.toUnsignedInt(byArray[n10++]);
                            n = 1;
                        }
                    }
                    if (n == 0) {
                        n11 = n12;
                        n12 = (n12 & 0xC0) >> 6;
                        switch (n12) {
                            case 0: {
                                int n13 = n11 & 0x3F;
                                if (n13 < 0 || n13 > 63) break;
                                n5 = this.cache_r[n13];
                                n6 = this.cache_g[n13];
                                n7 = this.cache_b[n13];
                                n8 = this.cache_a[n13];
                                break;
                            }
                            case 1: {
                                int n14 = (n11 & 0x30) >> 4;
                                int n15 = (n11 & 0xC) >> 2;
                                int n16 = n11 & 3;
                                n5 += (n14 -= 2);
                                n6 += (n15 -= 2);
                                n7 += (n16 -= 2);
                                break;
                            }
                            case 2: {
                                int n17 = Byte.toUnsignedInt(byArray[n10++]);
                                int n18 = (n11 & 0x3F) - 32;
                                int n19 = ((n17 & 0xF0) >> 4) + n18 - 8;
                                int n20 = (n17 & 0xF) + n18 - 8;
                                n5 += n19;
                                n6 += n18;
                                n7 += n20;
                                break;
                            }
                            case 3: {
                                n2 = n11 & 0x3F;
                                if (n2 >= 0) break;
                                n2 += 256;
                                break;
                            }
                            default: {
                                System.out.println("Unknown tag! " + n12);
                            }
                        }
                    }
                    if (n2 > 0) {
                        for (n11 = 0; n11 < n2 + 1; ++n11) {
                            nArray[n9] = n5;
                            nArray2[n9] = n6;
                            nArray3[n9] = n7;
                            nArray4[n9] = n8;
                            ++n9;
                        }
                    } else {
                        this.cache_add(n5, n6, n7, n8);
                        nArray[n9] = n5;
                        nArray2[n9] = n6;
                        nArray3[n9] = n7;
                        nArray4[n9] = n8;
                        ++n9;
                    }
                } while (n9 < n3 * n4 && n10 < byArray.length);
                n9 = 0;
                for (n2 = 0; n2 < n4; ++n2) {
                    for (n = 0; n < n3; ++n) {
                        this.rgb[n9] = -16777216 + (nArray[n9] << 16) + (nArray2[n9] << 8) + nArray3[n9];
                        ++n9;
                    }
                }
                bl = true;
            }
        }
        catch (Exception exception) {
            System.out.println("Exception " + exception);
        }
        return bl;
    }
}

