/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;

class ExportCvc
extends Thread {
    private Animator parent;
    private String outname;
    private final short width = (short)160;
    private final short height = (short)100;
    private short frames;
    private int fps = 7;
    short size;
    short type;
    byte[] frame = new byte[4000];
    byte[] comp = new byte[16000];
    byte[] prev = new byte[4000];
    private byte[] header = new byte[]{99, 118, 105, 109, 48, 48, 48, 48, 99, 118, 100, 49, 48, 48, 48, 48, 48, 48, 48, 48};
    byte[] cvc_header = new byte[]{99, 121, 118, 100, 48, 48, 48, 48, 49, 49, 48, 48};
    byte[] cvc_video = new byte[]{118, 105, 100, 111, 48, 48, 48, 48, 49, 49, 49, 49, 48, 48, 99, 121, 118, 49};
    byte[] cvc_frame = new byte[6];

    ExportCvc(Animator animator, String string) {
        this.parent = animator;
        this.outname = string;
        this.fps = this.parent.fps;
    }

    @Override
    public void run() {
        this.frames = (short)this.parent.frames.size();
        System.out.println("Exporting as Cvc");
        System.out.println("================");
        System.out.println("Frames:\t" + this.frames + " @ " + this.fps + " fps");
        System.out.println("Res:\t160 x 100");
        PleaseWait pleaseWait = new PleaseWait(this.parent, this.frames, "Saving CVC file");
        pleaseWait.start();
        this.set_cvc_hdr();
        this.set_cvc_vdr();
        try {
            File file = new File(this.outname);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.cvc_header);
            fileOutputStream.write(this.cvc_video);
            this.clrframe();
            int n = 30;
            for (int i = 0; i < this.frames; ++i) {
                int n2 = 0;
                this.parent.frames.get(i).make_two();
                this.parent.frames.get(n2);
                byte[] byArray = AnimFrame.two_bit;
                int n3 = byArray.length;
                for (int j = 0; j < n3; ++j) {
                    byte by;
                    this.frame[n2] = by = byArray[j];
                    ++n2;
                }
                this.encbest();
                this.set_cvc_fdr();
                fileOutputStream.write(this.cvc_frame);
                n += 6 + this.size;
                fileOutputStream.write(this.comp, 0, this.size);
                this.setprevious();
                pleaseWait.setProgress(i);
            }
            fileOutputStream.close();
            System.out.println("Done " + this.frames + " frames");
            System.out.println("Filesize " + n);
            pleaseWait.done();
        }
        catch (IOException iOException) {
            System.out.println("ExportCvc Exception:");
            System.out.println(iOException);
        }
    }

    public void set_cvc_hdr() {
        this.cvc_header[4] = 0;
        this.cvc_header[5] = 0;
        this.cvc_header[6] = 0;
        this.cvc_header[7] = 0;
        this.cvc_header[8] = 0;
        this.cvc_header[9] = 0;
        this.cvc_header[11] = 1;
        this.cvc_header[10] = 0;
    }

    public void set_cvc_vdr() {
        int n = 160;
        int n2 = 100;
        this.cvc_video[5] = (byte)(n & 0xFF);
        this.cvc_video[4] = (byte)((n & 0xFF00) >> 8);
        this.cvc_video[7] = (byte)(n2 & 0xFF);
        this.cvc_video[6] = (byte)((n2 & 0xFF00) >> 8);
        this.cvc_video[11] = (byte)(this.frames & 0xFF);
        this.cvc_video[10] = (byte)((this.frames & 0xFF00) >> 8);
        this.cvc_video[9] = (byte)((this.frames & 0xFF0000) >> 16);
        this.cvc_video[8] = (byte)((this.frames & 0xFF000000) >> 24);
        this.cvc_video[12] = (byte)((this.fps & 0xFF00) >> 8);
        this.cvc_video[13] = (byte)(this.fps & 0xFF);
    }

    public void set_cvc_fdr() {
        this.cvc_frame[0] = 0;
        this.cvc_frame[1] = 0;
        this.cvc_frame[3] = (byte)(this.size & 0xFF);
        this.cvc_frame[2] = (byte)((this.size & 0xFF00) >> 8);
        this.cvc_frame[5] = (byte)(this.type & 0xFF);
        this.cvc_frame[4] = (byte)((this.type & 0xFF00) >> 8);
    }

    public void setheader() {
        int n = 160;
        int n2 = 100;
        this.header[5] = (byte)(n & 0xFF);
        this.header[4] = (byte)((n & 0xFF00) >> 8);
        this.header[7] = 100;
        this.header[6] = 0;
        this.header[13] = (byte)(this.type & 0xFF);
        this.header[12] = (byte)((this.type & 0xFF00) >> 8);
        this.header[14] = 0;
        this.header[15] = 0;
        this.header[17] = 0;
        this.header[16] = 0;
        this.header[19] = (byte)(this.size & 0xFF);
        this.header[18] = (byte)((this.size & 0xFF00) >> 8);
    }

    public void setprevious() {
        for (int i = 0; i < this.prev.length; ++i) {
            this.prev[i] = this.frame[i];
        }
    }

    public void clrframe() {
        Arrays.fill(this.frame, (byte)0);
    }

    public int rawframe() {
        int n = 4000;
        this.type = 0;
        for (int i = 0; i < n; ++i) {
            this.comp[i] = this.frame[i];
        }
        this.size = (short)n;
        return n;
    }

    public int enc() {
        int n = 0;
        int n2 = 1;
        this.type = 1;
        int n3 = 4000;
        byte by = this.frame[0];
        for (int i = 1; i < n3; ++i) {
            byte by2 = this.frame[i];
            if (by2 == by && n2 < 126) {
                ++n2;
            } else {
                this.comp[n++] = (byte)n2;
                this.comp[n++] = by;
                n2 = 1;
            }
            by = by2;
        }
        if (n2 != 0) {
            this.comp[n++] = (byte)n2;
            this.comp[n++] = by;
        }
        this.size = (short)n;
        return n;
    }

    public int delta_cv1() {
        int n = 0;
        int n2 = 1;
        this.type = (short)2;
        int n3 = 4000;
        int n4 = Byte.toUnsignedInt(this.frame[0]);
        if (this.frame[0] == this.prev[0]) {
            n4 = -1;
        }
        for (int i = 1; i < n3; ++i) {
            int n5 = Byte.toUnsignedInt(this.frame[i]);
            if (this.frame[i] == this.prev[i]) {
                n5 = -1;
            }
            if (n5 == n4 && n2 < 126) {
                ++n2;
            } else {
                if (n4 < 0) {
                    this.comp[n++] = (byte)(-n2);
                } else {
                    this.comp[n++] = (byte)n2;
                    this.comp[n++] = this.frame[i - 1];
                }
                n2 = 1;
            }
            n4 = n5;
        }
        if (n2 != 0) {
            if (n4 < 0) {
                this.comp[n++] = (byte)(-n2);
            } else {
                this.comp[n++] = (byte)n2;
                this.comp[n++] = this.frame[n3 - 1];
            }
        }
        this.size = (short)n;
        return n;
    }

    public int delta2_cv1() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.type = (short)3;
        int n5 = 4000;
        for (n = 0; n < n5; ++n) {
            int n6;
            if (this.frame[n] == this.prev[n]) {
                if (n4 > 0) {
                    this.comp[n2++] = n4;
                    for (n6 = 0; n6 < n4; ++n6) {
                        this.comp[n2++] = this.frame[n - n4 + n6];
                    }
                    n4 = 0;
                }
                if ((n3 = (int)((byte)(n3 + 1))) <= 126) continue;
                this.comp[n2++] = (byte)(-n3);
                n3 = 0;
                continue;
            }
            n4 = (byte)(n4 + 1);
            if (n3 > 0) {
                this.comp[n2++] = (byte)(-n3);
                n3 = 0;
            }
            if (n4 < 126) continue;
            this.comp[n2++] = n4;
            for (n6 = 0; n6 < n4; ++n6) {
                this.comp[n2++] = this.frame[n - n4 + n6 + 1];
            }
            n4 = 0;
        }
        if (n3 > 0) {
            this.comp[n2++] = (byte)(-n3);
        }
        if (n4 > 0) {
            this.comp[n2++] = n4;
            for (n = 0; n < n4; ++n) {
                this.comp[n2++] = this.frame[n5 - n4 + n];
            }
        }
        this.size = (short)n2;
        return n2;
    }

    public void encbest() {
        int n = 0;
        short s = 4000;
        this.enc();
        System.out.print(" EN: [" + this.size + "]");
        if (this.size < s) {
            s = this.size;
            n = 1;
        }
        this.delta_cv1();
        System.out.print(" D1: [" + this.size + "]");
        if (this.size < s) {
            s = this.size;
            n = 2;
        }
        this.delta2_cv1();
        System.out.print(" D2: [" + this.size + "]");
        if (this.size < s) {
            s = this.size;
            n = 3;
        }
        switch (n) {
            case 0: {
                System.out.print(" - Raw Frame");
                this.rawframe();
                break;
            }
            case 1: {
                System.out.print(" - RLE");
                this.enc();
                break;
            }
            case 2: {
                System.out.print(" - Delta 1");
                this.delta_cv1();
                break;
            }
            case 3: {
                System.out.print(" - Delta 2");
                this.delta2_cv1();
                break;
            }
            default: {
                System.out.print(" - Unknown!?");
            }
        }
        System.out.println("");
    }
}

