/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class Animator
extends JFrame
implements ActionListener,
MouseListener,
MouseMotionListener,
WindowListener,
KeyListener {
    public static final String prog_name = "Animator";
    static final String prog_desc = "Animation Application";
    static final String prog_author = "ssjx";
    static final String prog_version = "v0.4 (18/11/2024)";
    static final String prog_url = "https://ssjx.co.uk";
    Font myfont = new Font("Verdana", 0, 16);
    Font infofont = new Font("Verdana", 0, 12);
    JLabel info_label;
    JLabel display_label;
    JLabel[] label;
    JMenuBar menuBar = new JMenuBar();
    JMenuItem[] item = new JMenuItem[40];
    JPanel gridpanel = new JPanel();
    JPanel thumbpanel = new JPanel();
    JPanel outerpanel = new JPanel();
    JButton nxt_button;
    JButton[] bar_button = new JButton[20];
    JButton[] side_button = new JButton[5];
    JComboBox<String> cb;
    boolean mousedown = false;
    boolean stop_playback = true;
    boolean hide = false;
    int startx = -1;
    int starty = -1;
    int thickness = 1;
    Random r = new Random();
    BufferedImage display_img;
    ArrayList<JLabel> thumb_label = new ArrayList();
    int currentMouseButton = -1;
    public int current_frame = 0;
    ArrayList<AnimFrame> frames = new ArrayList();
    private int shift_x;
    private int shift_y;
    private boolean shift_rotate;
    int fps = 5;
    int width = 320;
    int height = 200;
    int depth = 8;
    Color leftColour = Color.BLACK;
    Color rightColour = Color.WHITE;
    JScrollPane scrolly;
    boolean onion = false;
    Tools current_tool = Tools.SPRAY;
    String loaded_file;
    boolean saved = true;
    Stack<Point> fillStack = new Stack();

    public Animator() {
        super(prog_name);
        this.setSize(680, 520);
        this.addKeyListener(this);
        this.setFocusable(true);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.frames.add(new AnimFrame(this.width, this.height));
        this.animator_gui();
        this.setTitle("Animator v0.4 (18/11/2024) by ssjx (https://ssjx.co.uk)");
    }

    public void add_thumb(int n) {
        ImageIcon imageIcon = new ImageIcon(this.frames.get((int)n).thumb);
        this.thumb_label.add(new JLabel(imageIcon));
        this.thumb_label.get(n).addMouseListener(this);
        this.thumbpanel.add(this.thumb_label.get(n));
    }

    public void add_frame(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        this.frames.add(new AnimFrame(n, n2));
        int n3 = this.frames.size() - 1;
        this.copy_bmp(bufferedImage, this.frames.get((int)n3).data);
        this.add_thumb(n3);
        this.frames.get(n3).make_thumb();
        this.thumb_label.get(n3).repaint();
    }

    public void update_screen() {
        this.gridpanel.remove(this.display_label);
        int n = this.frames.get(0).getWidth();
        int n2 = this.frames.get(0).getHeight();
        this.width = n;
        this.height = n2;
        this.display_img = new BufferedImage(n, n2, 1);
        this.clear_display();
        ImageIcon imageIcon = new ImageIcon(this.display_img);
        this.display_label = new JLabel(imageIcon);
        this.display_label.addMouseListener(this);
        this.display_label.addMouseMotionListener(this);
        this.gridpanel.add(this.display_label);
        this.current_frame = 0;
        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
        this.display_label.repaint();
    }

    public void new_frame() {
        if (this.frames.size() > 0) {
            this.frames.get(this.current_frame).make_thumb();
            this.thumb_label.get(this.current_frame).repaint();
        }
        this.frames.add(new AnimFrame(this.width, this.height));
        int n = this.frames.size() - 1;
        this.add_thumb(n);
        this.frames.get(n).make_thumb();
        this.frames.get(n).thumb_border();
        this.thumb_label.get(n).repaint();
    }

    public void clear_color(BufferedImage bufferedImage, int n) {
        int n2 = this.display_img.getWidth();
        int n3 = this.display_img.getHeight();
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n2; ++j) {
                bufferedImage.setRGB(j, i, n);
            }
        }
    }

    public void clear_display() {
        int n = this.display_img.getWidth();
        int n2 = this.display_img.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.display_img.setRGB(j, i, 0xFFFFFF);
            }
        }
    }

    private void copy_from_previous() {
        if (this.current_frame - 1 >= 0) {
            this.copy_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data);
            this.frames.get(this.current_frame).make_thumb();
            this.thumb_label.get(this.current_frame).repaint();
            this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
            this.display_label.repaint();
        }
    }

    private void copy_to_all(int n) {
        System.out.println("Copying to all...");
        for (int i = 0; i < this.frames.size(); ++i) {
            if (i == n) continue;
            this.copy_bmp(this.frames.get((int)n).data, this.frames.get((int)i).data);
            this.frames.get(i).make_thumb();
            this.thumb_label.get(i).repaint();
        }
    }

    private void copy_to_following(int n, int n2) {
        if (n != this.frames.size()) {
            int n3 = -1;
            if (n2 == 0) {
                n3 = this.frames.size();
                System.out.println("Copying to ALL following...");
            } else {
                n3 = n2;
                if (n3 > this.frames.size()) {
                    n3 = this.frames.size();
                }
                System.out.println("Copying to " + n3 + " following...");
            }
            for (int i = n + 1; i < n + 1 + n3; ++i) {
                this.copy_bmp(this.frames.get((int)n).data, this.frames.get((int)i).data);
                this.frames.get(i).make_thumb();
                this.thumb_label.get(i).repaint();
            }
        }
    }

    public void animator_gui() {
        Object object;
        this.addWindowListener(this);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        String[] stringArray2 = new String[]{"New", "", "Open...", "Save", "Save As...", "", "Import Image", "", "Export FLI", "Export Cybiko", "", "Exit"};
        int n = 0;
        for (String string : stringArray2) {
            if (string.equals("")) {
                jMenu.addSeparator();
            } else {
                this.item[n] = new JMenuItem(string);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                if (string.equals("New")) {
                    this.item[n].setMnemonic(78);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(78, 2));
                }
                if (string.equals("Open...")) {
                    this.item[n].setMnemonic(79);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(79, 2));
                }
                if (string.equals("Save")) {
                    this.item[n].setMnemonic(83);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(83, 2));
                }
                if (string.equals("Save As...")) {
                    this.item[n].setMnemonic(65);
                }
                if (string.equals("Exit")) {
                    this.item[n].setMnemonic(88);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(115, 8));
                }
                if (string.contains("Project")) {
                    this.item[n].setEnabled(false);
                }
                jMenu.add(this.item[n]);
            }
            ++n;
        }
        JMenu jMenu2 = new JMenu("Edit");
        jMenu2.setMnemonic(69);
        String[] stringArray3 = new String[]{"Undo"};
        for (String string : stringArray3) {
            if (string.equals("")) {
                jMenu2.addSeparator();
            } else {
                this.item[n] = new JMenuItem(string);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                if (string.equals("Undo")) {
                    this.item[n].setMnemonic(85);
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(90, 2));
                }
                jMenu2.add(this.item[n]);
            }
            ++n;
        }
        JMenu jMenu3 = new JMenu("Frame");
        jMenu3.setMnemonic(82);
        String[] stringArray4 = new String[]{"Add (End)", "Insert (Before)", "Insert (After)", "Delete", "", "Move (Left)", "Move (Right)", "", "Set Rate"};
        for (String string : stringArray4) {
            if (string.equals("")) {
                jMenu3.addSeparator();
            } else {
                this.item[n] = new JMenuItem(string);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                jMenu3.add(this.item[n]);
            }
            ++n;
        }
        JMenu jMenu4 = new JMenu("Image");
        jMenu4.setMnemonic(73);
        String[] stringArray5 = new String[]{"Flip", "Mirror", "", "Shift ...", "Shift Again", "", "Copy Previous", "Copy To Many...", "", "Blend", "Clear"};
        for (String string : stringArray5) {
            if (string.equals("")) {
                jMenu4.addSeparator();
            } else {
                this.item[n] = new JMenuItem(string);
                this.item[n].addActionListener(this);
                this.item[n].setActionCommand(string);
                if (string.equals("Flip")) {
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(73, 2));
                }
                if (string.equals("Mirror")) {
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(77, 2));
                }
                if (string.equals("Clear")) {
                    this.item[n].setAccelerator(KeyStroke.getKeyStroke(127, 0));
                }
                jMenu4.add(this.item[n]);
            }
            ++n;
        }
        JMenu jMenu5 = new JMenu("Help");
        jMenu5.setMnemonic(72);
        String[] stringArray6 = new String[]{"About", "Debug"};
        for (String object32 : stringArray6) {
            this.item[n] = new JMenuItem(object32);
            this.item[n].addActionListener(this);
            this.item[n].setActionCommand(object32);
            if (object32.equals("About")) {
                this.item[n].setAccelerator(KeyStroke.getKeyStroke(112, 0));
            }
            jMenu5.add(this.item[n]);
            ++n;
        }
        this.menuBar.add(jMenu);
        this.menuBar.add(jMenu2);
        this.menuBar.add(jMenu3);
        this.menuBar.add(jMenu4);
        this.menuBar.add(jMenu5);
        this.setJMenuBar(this.menuBar);
        JToolBar jToolBar = new JToolBar("Main Toolbar");
        jToolBar.setFloatable(false);
        String[] stringArray7 = new String[]{"new", "open", "save", "undo", "onion", "|", "add", "delete", "|", "pen", "spray", "fill", "|", "copy", "shift", "|", "play", "stop", "#", "coin"};
        int n2 = 0;
        for (String string : stringArray7) {
            if (string.equals("#")) {
                jToolBar.add(Box.createGlue());
                continue;
            }
            if (string.equals("coin")) {
                if (this.hide) continue;
                int n4 = (int)Math.floor(Math.random() * 2.0);
                this.bar_button[n2] = new JButton();
                String string2 = "";
                if (n4 == 0) {
                    string2 = "coin";
                    this.bar_button[n2].setToolTipText("Join Cointiply to Earn Free Bitcoin!");
                }
                if (n4 == 1) {
                    string2 = "pound";
                    this.bar_button[n2].setToolTipText("Save money shopping online with TopCashback!");
                }
                if (n4 == 2) {
                    string2 = "test";
                    this.bar_button[n2].setToolTipText("Earn money as a games tester at Testerup!");
                }
                this.bar_button[n2].addActionListener(this);
                this.bar_button[n2].setActionCommand(string2);
                this.bar_button[n2].setFocusable(false);
                jToolBar.add(this.bar_button[n2]);
                try {
                    BufferedImage bufferedImage = ImageIO.read(this.getClass().getResource("gifs/" + string2 + ".gif"));
                    this.bar_button[n2].setIcon(new ImageIcon(bufferedImage));
                }
                catch (Exception exception) {
                    this.bar_button[n2].setText(string);
                }
                continue;
            }
            if (!string.equals("|")) {
                this.bar_button[n2] = new JButton();
                this.bar_button[n2].setFont(this.infofont);
                try {
                    Object object2 = ImageIO.read(this.getClass().getResource("gifs/" + string + ".gif"));
                    this.bar_button[n2].setIcon(new ImageIcon((Image)object2));
                }
                catch (Exception exception) {
                    this.bar_button[n2].setText(string);
                }
                switch (string) {
                    case "new": {
                        this.bar_button[n2].setToolTipText("New Project");
                        break;
                    }
                    case "open": {
                        this.bar_button[n2].setToolTipText("Open");
                        break;
                    }
                    case "save": {
                        this.bar_button[n2].setToolTipText("Save");
                        break;
                    }
                    case "undo": {
                        this.bar_button[n2].setToolTipText("Undo");
                        break;
                    }
                    case "onion": {
                        this.bar_button[n2].setToolTipText("Onion");
                        break;
                    }
                    case "add": {
                        this.bar_button[n2].setToolTipText("Add Frame (End)");
                        break;
                    }
                    case "delete": {
                        this.bar_button[n2].setToolTipText("Delete Frame");
                        break;
                    }
                    case "pen": {
                        this.bar_button[n2].setToolTipText("Pen");
                        break;
                    }
                    case "spray": {
                        this.bar_button[n2].setToolTipText("Spray");
                        break;
                    }
                    case "fill": {
                        this.bar_button[n2].setToolTipText("Fill Area");
                        break;
                    }
                    case "copy": {
                        this.bar_button[n2].setToolTipText("Copy Previous Frame");
                        break;
                    }
                    case "shift": {
                        this.bar_button[n2].setToolTipText("Shift Frame");
                        break;
                    }
                    case "play": {
                        this.bar_button[n2].setToolTipText("Play");
                        break;
                    }
                    case "stop": {
                        this.bar_button[n2].setToolTipText("Stop");
                    }
                }
                this.bar_button[n2].addActionListener(this);
                this.bar_button[n2].setActionCommand(string);
                jToolBar.add(this.bar_button[n2]);
                ++n2;
                continue;
            }
            jToolBar.addSeparator();
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(new TitledBorder("Colours"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        String[] stringArray = new String[]{"L", "R", "P"};
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (String string : stringArray) {
            if (string.equals("L") || string.equals("R")) {
                this.side_button[n3] = new JButton();
                this.side_button[n3].setFont(this.infofont);
                this.side_button[n3].setText(string);
                this.side_button[n3].addActionListener(this);
                this.side_button[n3].setActionCommand(string);
                if (string == "L") {
                    this.side_button[n3].setBackground(this.leftColour);
                }
                if (string == "R") {
                    this.side_button[n3].setBackground(this.rightColour);
                }
                gridBagConstraints.gridx = n4;
                gridBagConstraints.gridy = n5;
                jPanel2.add((Component)this.side_button[n3], gridBagConstraints);
                ++n3;
            }
            if (string.equals("P")) {
                object = new String[]{"PEN 1", "PEN 2", "PEN 3", "PEN 4", "PEN 5"};
                this.cb = new JComboBox<String>((E[])object);
                this.cb.addActionListener(this);
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridx = n4;
                gridBagConstraints.gridy = n5;
                gridBagConstraints.gridwidth = 2;
                jPanel2.add(this.cb, gridBagConstraints);
            }
            if (++n4 != 2) continue;
            n4 = 0;
            ++n5;
        }
        jPanel.add(jPanel2);
        this.gridpanel = new JPanel();
        this.display_img = new BufferedImage(320, 200, 1);
        this.clear_display();
        ImageIcon imageIcon = new ImageIcon(this.display_img);
        this.display_label = new JLabel(imageIcon);
        this.display_label.addMouseListener(this);
        this.display_label.addMouseMotionListener(this);
        this.gridpanel.add(this.display_label);
        FlowLayout flowLayout = new FlowLayout(3);
        this.thumbpanel.setLayout(flowLayout);
        this.thumbpanel.setFocusable(true);
        this.add_thumb(0);
        this.scrolly = new JScrollPane(this.thumbpanel);
        this.scrolly.setHorizontalScrollBarPolicy(32);
        FlowLayout flowLayout2 = new FlowLayout(3);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(flowLayout2);
        jPanel3.setBackground(Color.WHITE);
        this.info_label = new JLabel("Frame 1 / 1 @ " + this.fps + " fps");
        this.info_label.setFont(this.infofont);
        jPanel3.add(this.info_label);
        object = new JPanel();
        ((Container)object).setLayout(new BoxLayout((Container)object, 3));
        BorderLayout borderLayout = new BorderLayout();
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(borderLayout);
        jPanel4.add((Component)jToolBar, "First");
        jPanel4.add((Component)jPanel, "Before");
        jPanel4.add((Component)this.gridpanel, "Center");
        jPanel4.add((Component)jPanel3, "Last");
        ((Container)object).add(jPanel4);
        ((Container)object).add(this.scrolly);
        this.add((Component)object);
        this.update_title();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public void update_title() {
        String string = "";
        if (!this.saved) {
            string = "*";
        }
        if (this.loaded_file != null) {
            this.setTitle(string + this.loaded_file + " - Animator");
        } else {
            this.setTitle(string + "Animator v0.4 (18/11/2024)");
        }
    }

    public void copy_bmp(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage2.getWidth();
        int n4 = bufferedImage2.getHeight();
        int n5 = 0;
        int n6 = 0;
        n6 = n > n3 ? n3 : n;
        n5 = n2 > n4 ? n4 : n2;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n6; ++j) {
                int n7 = bufferedImage.getRGB(j, i);
                bufferedImage2.setRGB(j, i, n7);
            }
        }
    }

    public void onion_bmp(BufferedImage bufferedImage, BufferedImage bufferedImage2, BufferedImage bufferedImage3) {
        int n;
        int n2;
        int n3;
        System.out.println("Onion copy!");
        int n4 = bufferedImage2.getWidth();
        int n5 = bufferedImage2.getHeight();
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                bufferedImage3.setRGB(n2, n3, 0xFFFFFF);
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = bufferedImage2.getRGB(n2, n3);
                if (n != -1) continue;
                int n6 = bufferedImage.getRGB(n2, n3);
                if (n6 == -16777216) {
                    n6 = -14540254;
                }
                if (n6 == -1) continue;
                int n7 = n6 >> 16 & 0xFF;
                int n8 = n6 >> 8 & 0xFF;
                int n9 = n6 & 0xFF;
                n8 <<= 2;
                n9 <<= 2;
                if ((n7 <<= 2) > 255) {
                    n7 = 255;
                }
                if (n8 > 255) {
                    n8 = 255;
                }
                if (n9 > 255) {
                    n9 = 255;
                }
                int n10 = (n7 + n8 + n9) / 3;
                int n11 = n10 << 16 | n10 << 8 | n10;
                bufferedImage3.setRGB(n2, n3, n11);
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = bufferedImage2.getRGB(n2, n3);
                if (n == -1) continue;
                bufferedImage3.setRGB(n2, n3, n);
            }
        }
    }

    void save_as() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save As", 1);
        fileDialog.setFile("*.avi");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            this.save(string);
        }
    }

    boolean save(String string) {
        SaveAvi saveAvi = new SaveAvi(this, string);
        saveAvi.start();
        this.loaded_file = string;
        this.saved = true;
        this.update_title();
        return true;
    }

    boolean export_fli() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Export Fli", 1);
        fileDialog.setFile("*.fli");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            SaveFli saveFli = new SaveFli(this, string);
            saveFli.start();
            return true;
        }
        return false;
    }

    boolean export_cvc() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Export Cybiko", 1);
        fileDialog.setFile("*.cvc");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            ExportCvc exportCvc = new ExportCvc(this, string);
            exportCvc.start();
            return true;
        }
        return false;
    }

    boolean import_image() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Import Image", 0);
        fileDialog.setFile("*.jpg;*.jpeg;*.png;*.qoi");
        fileDialog.setVisible(true);
        if (fileDialog.getFile() != null) {
            String string = fileDialog.getDirectory() + fileDialog.getFile();
            this.import_direct(string);
            this.saved = false;
        }
        return true;
    }

    boolean import_direct(String string) {
        BufferedImage bufferedImage = null;
        boolean bl = false;
        System.out.println("Importing: \t" + string);
        if (string.endsWith(".qoi")) {
            bl = this.loadQoi(string);
        } else {
            try {
                bufferedImage = ImageIO.read(new File(string));
                this.resize_img(bufferedImage);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return true;
    }

    boolean loadQoi(String string) {
        BufferedImage bufferedImage;
        ImportQoi importQoi = new ImportQoi();
        if (importQoi.load(string)) {
            bufferedImage = new BufferedImage(importQoi.bmhd_w, importQoi.bmhd_h, 1);
            int n = 0;
            for (int i = 0; i < importQoi.bmhd_h; ++i) {
                for (int j = 0; j < importQoi.bmhd_w; ++j) {
                    bufferedImage.setRGB(j, i, importQoi.rgb[n]);
                    ++n;
                }
            }
        } else {
            return false;
        }
        this.resize_img(bufferedImage);
        return true;
    }

    void resize_img(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        boolean bl = false;
        if (bufferedImage.getWidth() > this.width) {
            bl = true;
        }
        if (bufferedImage.getHeight() > this.height) {
            bl = true;
        }
        if (bl) {
            System.out.println(" -- " + bufferedImage.getWidth() + " x " + bufferedImage.getHeight());
            float f = (float)bufferedImage.getWidth() / (float)this.width;
            float f2 = (float)bufferedImage.getHeight() / (float)this.height;
            if (bufferedImage.getWidth() > bufferedImage.getHeight()) {
                f2 = f;
            }
            if (bufferedImage.getHeight() > bufferedImage.getWidth()) {
                f = f2;
            }
            System.out.println(" -- " + f + " x " + f2);
            int n3 = (int)((float)bufferedImage.getWidth() / f);
            int n4 = (int)((float)bufferedImage.getHeight() / f2);
            float f3 = 0.0f;
            float f4 = 0.0f;
            int n5 = 0;
            int n6 = 0;
            if (n4 < this.height) {
                n6 = this.height - n4 >> 1;
            }
            if (n3 < this.width) {
                n5 = this.width - n3 >> 1;
            }
            for (int i = 0; i < n4; ++i) {
                f3 = 0.0f;
                for (int j = 0; j < n3; ++j) {
                    if (f3 < (float)bufferedImage.getWidth() && f4 < (float)bufferedImage.getHeight()) {
                        int n7 = bufferedImage.getRGB((int)f3, (int)f4);
                        if (n5 + j < this.width && n6 + i < this.height) {
                            this.frames.get((int)this.current_frame).data.setRGB(n5 + j, n6 + i, n7);
                        }
                    }
                    f3 += f;
                }
                f4 += f2;
            }
        } else {
            boolean bl2 = false;
            if (n < this.width) {
                bl2 = true;
            }
            if (n2 < this.height) {
                bl2 = true;
            }
            if (bl2) {
                int n8 = 0;
                int n9 = 0;
                if (n2 < this.height) {
                    n9 = this.height - n2 >> 1;
                }
                if (n < this.width) {
                    n8 = this.width - n >> 1;
                }
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n; ++j) {
                        int n10 = bufferedImage.getRGB(j, i);
                        if (n8 + j >= this.width || n9 + i >= this.height) continue;
                        this.frames.get((int)this.current_frame).data.setRGB(n8 + j, n9 + i, n10);
                    }
                }
            } else {
                this.copy_bmp(bufferedImage, this.frames.get((int)this.current_frame).data);
            }
        }
        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
        this.frames.get(this.current_frame).make_thumb();
        this.display_label.repaint();
        this.thumb_label.get(this.current_frame).repaint();
    }

    void set_status() {
        this.info_label.setText("Frames " + (this.current_frame + 1) + " / " + this.frames.size() + " @ " + this.fps + " fps");
    }

    void interfaceEnabled(boolean bl) {
        if (bl) {
            int n;
            for (n = 0; n < 12; ++n) {
                this.bar_button[n].setEnabled(true);
            }
            for (n = 0; n < this.item.length; ++n) {
                if (this.item[n] == null) continue;
                this.item[n].setEnabled(true);
            }
            for (n = 0; n < this.side_button.length; ++n) {
                if (this.side_button[n] == null) continue;
                this.side_button[n].setEnabled(true);
            }
            this.current_tool = Tools.PEN;
        } else {
            int n;
            for (n = 0; n < 12; ++n) {
                this.bar_button[n].setEnabled(false);
            }
            for (n = 0; n < this.item.length; ++n) {
                if (this.item[n] == null) continue;
                this.item[n].setEnabled(false);
            }
            for (n = 0; n < this.side_button.length; ++n) {
                if (this.side_button[n] == null) continue;
                this.side_button[n].setEnabled(false);
            }
            this.current_tool = Tools.NONE;
        }
    }

    void gotoFrame(int n) {
        this.current_frame = n;
        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
        this.display_label.repaint();
        this.frames.get(this.current_frame).thumb_border();
        this.thumb_label.get(this.current_frame).repaint();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.cb) {
            if (this.cb.getSelectedIndex() == 0) {
                this.thickness = 1;
            }
            if (this.cb.getSelectedIndex() == 1) {
                this.thickness = 2;
            }
            if (this.cb.getSelectedIndex() == 2) {
                this.thickness = 4;
            }
            if (this.cb.getSelectedIndex() == 3) {
                this.thickness = 8;
            }
            if (this.cb.getSelectedIndex() == 4) {
                this.thickness = 10;
            }
        }
        switch (string) {
            case "About": {
                Intro intro = new Intro();
                break;
            }
            case "Debug": {
                int n = this.frames.get(this.current_frame).coloursUsed();
                String string2 = "Width:" + this.width + "\nHeight:" + this.height + "\nFrames:" + this.frames.size() + "\nFPS:" + this.fps + "\nDepth:" + this.depth + "\nColours:" + n;
                JOptionPane.showMessageDialog(this, string2, "Current Project", 1);
                break;
            }
            case "ssjx": {
                break;
            }
            case "playasia": {
                break;
            }
            case "Import Image": {
                this.import_image();
                break;
            }
            case "Exit": {
                if (!this.saved) {
                    int n = JOptionPane.showConfirmDialog(this, "Changes will be lost! Do you really want to exit?", "Exit Confirmation : ", 0);
                    if (n != 0) break;
                    this.dispose();
                    break;
                }
                this.dispose();
                break;
            }
            case "Flip": {
                this.frames.get(this.current_frame).flip();
                this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                this.display_label.repaint();
                this.thumb_label.get(this.current_frame).repaint();
                break;
            }
            case "Mirror": {
                this.frames.get(this.current_frame).mirror();
                this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                this.display_label.repaint();
                this.thumb_label.get(this.current_frame).repaint();
                break;
            }
            case "undo": {
                this.frames.get(this.current_frame).from_undo();
                if (this.onion) {
                    if (this.current_frame > 0) {
                        this.onion_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data, this.display_img);
                    } else {
                        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    }
                } else {
                    this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                }
                this.display_label.repaint();
                this.thumb_label.get(this.current_frame).repaint();
                break;
            }
            case "play": {
                if (this.stop_playback) {
                    this.frames.get(this.current_frame).make_thumb();
                    this.thumb_label.get(this.current_frame).repaint();
                    this.interfaceEnabled(false);
                    this.stop_playback = false;
                    Player player = new Player();
                    player.init(this);
                    player.start();
                    break;
                }
                this.interfaceEnabled(true);
                this.stop_playback = true;
                break;
            }
            case "stop": {
                if (this.stop_playback) break;
                this.stop_playback = true;
                this.interfaceEnabled(true);
                break;
            }
            case "Copy Previous": 
            case "copy": {
                this.copy_from_previous();
                break;
            }
            case "Set Rate": {
                SetFrameRate setFrameRate = new SetFrameRate(this);
                if (setFrameRate.rate != -1) {
                    System.out.println("Frame rate:" + setFrameRate.rate);
                    this.fps = setFrameRate.rate;
                    this.set_status();
                    this.saved = false;
                    break;
                }
                System.out.println("FPS not changed");
                break;
            }
            case "new": 
            case "New": {
                Object object;
                int n;
                boolean bl = true;
                if (!this.saved && (n = JOptionPane.showConfirmDialog(this, "Changes will be lost! Do you really want to continue?", "Unsaved Changes", 0)) == 1) {
                    bl = false;
                }
                if (!bl) break;
                Newproject newproject = new Newproject(this);
                if (newproject.option == 1 || newproject.option == 2) {
                    this.loaded_file = null;
                    this.update_title();
                    int n2 = this.frames.size();
                    this.frames.clear();
                    this.thumb_label.clear();
                    for (int i = 0; i < n2; ++i) {
                        this.thumbpanel.remove(0);
                    }
                    this.thumbpanel.revalidate();
                    this.thumbpanel.repaint();
                    this.width = newproject.width;
                    this.height = newproject.height;
                    this.fps = newproject.fps;
                    System.out.println("New: " + this.width + " x " + this.height);
                    this.gridpanel.remove(this.display_label);
                    this.display_img = new BufferedImage(this.width, this.height, 1);
                    this.clear_display();
                    object = new ImageIcon(this.display_img);
                    this.display_label = new JLabel((Icon)object);
                    this.display_label.addMouseListener(this);
                    this.display_label.addMouseMotionListener(this);
                    this.gridpanel.add(this.display_label);
                    this.current_frame = 0;
                    for (int i = 0; i < newproject.frames; ++i) {
                        this.frames.add(new AnimFrame(this.width, this.height, newproject.bgColour.getRGB()));
                        this.add_thumb(this.current_frame);
                        ++this.current_frame;
                    }
                    this.gridpanel.revalidate();
                    this.gridpanel.repaint();
                }
                if (newproject.option == 1) {
                    this.saved = true;
                }
                if (newproject.option == 2) {
                    this.saved = false;
                    this.current_frame = 0;
                    object = new PleaseWait(this, newproject.frames, "Loading...");
                    ((Thread)object).start();
                    for (String string3 : newproject.filelist) {
                        if (this.import_direct(string3)) {
                            ++this.current_frame;
                        }
                        ((PleaseWait)object).setProgress(this.current_frame);
                        if (!((PleaseWait)object).isCanceled()) continue;
                        System.out.println("AVI - Break!");
                        break;
                    }
                    ((PleaseWait)object).done();
                    Object var10_25 = null;
                }
                if (newproject.option != 1 && newproject.option != 2) break;
                this.current_frame = 0;
                this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                this.display_label.repaint();
                this.frames.get(this.current_frame).thumb_border();
                this.thumb_label.get(this.current_frame).repaint();
                this.set_status();
                break;
            }
            case "save": 
            case "Save": {
                if (this.loaded_file == null) {
                    this.save_as();
                    break;
                }
                this.save(this.loaded_file);
                break;
            }
            case "Save As...": {
                this.save_as();
                break;
            }
            case "Export FLI": {
                this.export_fli();
                break;
            }
            case "Export Cybiko": {
                this.export_cvc();
                break;
            }
            case "Open Project...": {
                FileDialog fileDialog = new FileDialog((Frame)this, "Open Project", 0);
                fileDialog.setFile("*.txt");
                fileDialog.setVisible(true);
                if (fileDialog.getFile() == null) break;
                String string4 = fileDialog.getDirectory() + fileDialog.getFile();
                if (string4.endsWith(".txt")) {
                    LoadProject loadProject = new LoadProject(this, string4);
                    this.update_screen();
                    this.copy_bmp(this.frames.get((int)0).data, this.display_img);
                    this.display_label.repaint();
                    this.thumbpanel.revalidate();
                    this.thumbpanel.repaint();
                    this.set_status();
                    this.frames.get(0).thumb_border();
                    this.thumb_label.get(0).repaint();
                }
                this.loaded_file = string4;
                this.saved = true;
                this.update_title();
                break;
            }
            case "open": 
            case "Open...": {
                Thread thread;
                int n;
                boolean bl = true;
                if (!this.saved && (n = JOptionPane.showConfirmDialog(this, "Changes will be lost! Do you really want to continue?", "Unsaved Changes", 0)) == 1) {
                    bl = false;
                }
                if (!bl) break;
                FileDialog fileDialog = new FileDialog((Frame)this, "Open File", 0);
                fileDialog.setFile("*.fli;*.flc;*.avi");
                fileDialog.setVisible(true);
                if (fileDialog.getFile() == null) break;
                String string5 = fileDialog.getDirectory() + fileDialog.getFile();
                if (string5.endsWith(".fli") || string5.endsWith(".flc")) {
                    thread = new LoadFli();
                    ((LoadFli)thread).init(string5, this);
                    thread.start();
                }
                if (string5.endsWith(".avi")) {
                    thread = new LoadAvi();
                    ((LoadAvi)thread).init(string5, this);
                    thread.start();
                }
                this.loaded_file = string5;
                this.saved = true;
                this.update_title();
                break;
            }
            case "onion": {
                if (!this.onion) {
                    this.onion = true;
                    System.out.println("Onion! -On");
                } else {
                    this.onion = false;
                    System.out.println("Onion! -Off");
                }
                if (this.onion) {
                    if (this.current_frame > 0) {
                        this.onion_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data, this.display_img);
                    } else {
                        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    }
                } else {
                    this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                }
                this.display_label.repaint();
                break;
            }
            case "Clear": {
                this.clear_color(this.frames.get((int)this.current_frame).data, this.rightColour.getRGB());
                this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                this.display_label.repaint();
                this.frames.get(this.current_frame).make_thumb();
                this.thumb_label.get(this.current_frame).repaint();
                break;
            }
            case "shift": 
            case "Shift ...": {
                ShiftFrame shiftFrame = new ShiftFrame(this, this.shift_x, this.shift_y, this.shift_rotate);
                if (shiftFrame.cancel) break;
                this.shift_x = shiftFrame.xdir;
                this.shift_y = shiftFrame.ydir;
                this.shift_rotate = shiftFrame.rotate;
                this.frames.get(this.current_frame).shift(shiftFrame.xdir, shiftFrame.ydir, shiftFrame.rotate, this.rightColour.getRGB());
                this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                this.frames.get(this.current_frame).make_thumb();
                this.display_label.repaint();
                this.thumb_label.get(this.current_frame).repaint();
                break;
            }
            case "Shift Again": {
                this.frames.get(this.current_frame).shift(this.shift_x, this.shift_y, this.shift_rotate, this.rightColour.getRGB());
                this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                this.frames.get(this.current_frame).make_thumb();
                this.display_label.repaint();
                this.thumb_label.get(this.current_frame).repaint();
                break;
            }
            case "Copy To Many...": {
                CopyToMany copyToMany = new CopyToMany(this);
                if (copyToMany.cancel) break;
                if (copyToMany.option == 0) {
                    this.copy_to_all(this.current_frame);
                }
                if (copyToMany.option == 1) {
                    this.copy_to_following(this.current_frame, 0);
                }
                if (copyToMany.option != 2) break;
                this.copy_to_following(this.current_frame, copyToMany.count);
                break;
            }
            case "Blend": {
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        int n = this.frames.get((int)(this.current_frame + 1)).data.getRGB(j, i);
                        int n3 = n >> 16 & 0xFF;
                        int n4 = n >> 8 & 0xFF;
                        int n5 = n & 0xFF;
                        n = this.frames.get((int)(this.current_frame - 1)).data.getRGB(j, i);
                        int n6 = n >> 16 & 0xFF;
                        int n7 = n >> 8 & 0xFF;
                        int n8 = n & 0xFF;
                        int n9 = n3 + n6 >> 1;
                        int n10 = n4 + n7 >> 1;
                        int n11 = n5 + n8 >> 1;
                        int n12 = (n9 << 16) + (n10 << 8) + n11;
                        this.frames.get((int)this.current_frame).data.setRGB(j, i, n12);
                    }
                }
                this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                this.frames.get(this.current_frame).make_thumb();
                this.display_label.repaint();
                this.thumb_label.get(this.current_frame).repaint();
                break;
            }
            case "fill": {
                this.current_tool = Tools.FILL;
                break;
            }
            case "pen": {
                this.current_tool = Tools.PEN;
                break;
            }
            case "spray": {
                this.current_tool = Tools.SPRAY;
                break;
            }
            case "L": {
                Color color = JColorChooser.showDialog(this, "Choose Left Button Colour", this.leftColour);
                if (color == null) break;
                this.leftColour = color;
                this.side_button[0].setBackground(this.leftColour);
                break;
            }
            case "R": {
                Color color = JColorChooser.showDialog(this, "Choose Right Button Colour", this.rightColour);
                if (color == null) break;
                this.rightColour = color;
                this.side_button[1].setBackground(this.rightColour);
                break;
            }
            case "add": 
            case "Add (End)": {
                this.frames.get(this.current_frame).make_thumb();
                this.thumb_label.get(this.current_frame).repaint();
                this.current_frame = this.frames.size();
                this.frames.add(new AnimFrame(this.width, this.height));
                this.add_thumb(this.current_frame);
                this.frames.get(this.current_frame).thumb_border();
                this.thumb_label.get(this.current_frame).repaint();
                if (this.onion) {
                    if (this.current_frame > 0) {
                        this.onion_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data, this.display_img);
                    } else {
                        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    }
                } else {
                    this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                }
                this.display_label.repaint();
                this.set_status();
                this.outerpanel.repaint();
                this.thumbpanel.revalidate();
                this.thumbpanel.repaint();
                break;
            }
            case "Insert (Before)": {
                int n;
                int n13 = this.frames.size();
                this.thumb_label.clear();
                for (n = 0; n < n13; ++n) {
                    this.thumbpanel.remove(0);
                }
                this.frames.add(this.current_frame, new AnimFrame(this.width, this.height));
                n13 = this.frames.size();
                for (n = 0; n < n13; ++n) {
                    this.add_thumb(n);
                    this.frames.get(n).make_thumb();
                    this.thumb_label.get(n).repaint();
                }
                if (this.onion) {
                    if (this.current_frame > 0) {
                        this.onion_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data, this.display_img);
                    } else {
                        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    }
                } else {
                    this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                }
                this.frames.get(this.current_frame).thumb_border();
                this.thumb_label.get(this.current_frame).repaint();
                this.display_label.repaint();
                this.set_status();
                this.outerpanel.repaint();
                this.thumbpanel.revalidate();
                this.thumbpanel.repaint();
                break;
            }
            case "Insert (After)": {
                int n;
                int n14 = this.frames.size();
                this.thumb_label.clear();
                for (n = 0; n < n14; ++n) {
                    this.thumbpanel.remove(0);
                }
                ++this.current_frame;
                this.frames.add(this.current_frame, new AnimFrame(this.width, this.height));
                n14 = this.frames.size();
                for (n = 0; n < n14; ++n) {
                    this.add_thumb(n);
                    this.frames.get(n).make_thumb();
                    this.thumb_label.get(n).repaint();
                }
                if (this.onion) {
                    if (this.current_frame > 0) {
                        this.onion_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data, this.display_img);
                    } else {
                        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    }
                } else {
                    this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                }
                this.frames.get(this.current_frame).thumb_border();
                this.thumb_label.get(this.current_frame).repaint();
                this.display_label.repaint();
                this.set_status();
                this.outerpanel.repaint();
                this.thumbpanel.revalidate();
                this.thumbpanel.repaint();
                break;
            }
            case "delete": 
            case "Delete": {
                int n = JOptionPane.showConfirmDialog(this, "Do you really want to delete this frame?", "Delete Confirmation : ", 0);
                if (n != 0) break;
                System.out.println("Delete:" + this.current_frame);
                this.frames.remove(this.current_frame);
                this.thumb_label.remove(this.current_frame);
                this.thumbpanel.remove(this.current_frame);
                if (this.current_frame > 0) {
                    --this.current_frame;
                    this.frames.get(this.current_frame).thumb_border();
                    if (this.onion) {
                        if (this.current_frame > 0) {
                            this.onion_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data, this.display_img);
                        } else {
                            this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                        }
                    } else {
                        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    }
                } else {
                    this.new_frame();
                    this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    this.frames.get(this.current_frame).thumb_border();
                }
                this.thumb_label.get(this.current_frame).repaint();
                this.display_label.repaint();
                this.set_status();
                this.outerpanel.repaint();
                this.thumbpanel.revalidate();
                this.thumbpanel.repaint();
                break;
            }
            case "Move (Right)": {
                this.move_frame(1);
                break;
            }
            case "Move (Left)": {
                this.move_frame(-1);
                break;
            }
            case "coin": {
                Animator.openWebpage("http://cointiply.com/r/KegY7o");
                break;
            }
            case "pound": {
                Animator.openWebpage("https://www.topcashback.co.uk/ref/ssjx");
                break;
            }
            case "test": {
                Animator.openWebpage("https://www.testerup.com/start/?promotion=&cid=xLB8d48XQM");
            }
        }
    }

    public static void openWebpage(String string) {
        System.out.println("Going to " + string);
    }

    private boolean move_frame(int n) {
        boolean bl = false;
        int n2 = this.current_frame + n;
        if (n2 >= 0 && n2 < this.frames.size()) {
            this.copy_bmp(this.frames.get((int)n2).data, this.display_img);
            this.copy_bmp(this.frames.get((int)this.current_frame).data, this.frames.get((int)n2).data);
            this.copy_bmp(this.display_img, this.frames.get((int)this.current_frame).data);
            this.frames.get(this.current_frame).make_thumb();
            this.frames.get(n2).make_thumb();
            this.frames.get(this.current_frame).make_thumb();
            this.thumb_label.get(this.current_frame).repaint();
            this.current_frame = n2;
            this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
            this.frames.get(this.current_frame).thumb_border();
            this.thumb_label.get(this.current_frame).repaint();
            this.thumbpanel.revalidate();
            this.thumbpanel.repaint();
            bl = true;
        } else {
            System.out.println("Cannot move frame");
            bl = false;
        }
        return bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.display_label) {
            this.startx = mouseEvent.getX();
            this.starty = mouseEvent.getY();
            this.mousedown = true;
            this.currentMouseButton = mouseEvent.getButton();
            this.frames.get(this.current_frame).to_undo();
            switch (this.current_tool) {
                case PEN: {
                    int n = this.startx;
                    int n2 = this.starty;
                    Graphics2D graphics2D = this.frames.get((int)this.current_frame).data.createGraphics();
                    if (this.currentMouseButton == 1) {
                        graphics2D.setColor(this.leftColour);
                    }
                    if (this.currentMouseButton == 3) {
                        graphics2D.setColor(this.rightColour);
                    }
                    BasicStroke basicStroke = new BasicStroke(this.thickness);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.drawLine(this.startx, this.starty, n, n2);
                    graphics2D.dispose();
                    n = this.startx;
                    n2 = this.starty;
                    graphics2D = this.display_img.createGraphics();
                    if (this.currentMouseButton == 1) {
                        graphics2D.setColor(this.leftColour);
                    }
                    if (this.currentMouseButton == 3) {
                        graphics2D.setColor(this.rightColour);
                    }
                    basicStroke = new BasicStroke(this.thickness);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.drawLine(this.startx, this.starty, n, n2);
                    graphics2D.dispose();
                    this.display_label.repaint();
                    this.saved = false;
                    this.update_title();
                    break;
                }
                case SPRAY: {
                    int n = 10 * this.thickness / 2;
                    for (int i = 0; i < 20 * this.thickness / 2; ++i) {
                        int n3 = this.r.nextInt(10 * this.thickness) - n;
                        int n4 = this.r.nextInt(10 * this.thickness) - n;
                        Graphics2D graphics2D = this.frames.get((int)this.current_frame).data.createGraphics();
                        if (this.currentMouseButton == 1) {
                            graphics2D.setColor(this.leftColour);
                        }
                        if (this.currentMouseButton == 3) {
                            graphics2D.setColor(this.rightColour);
                        }
                        graphics2D.drawLine(this.startx + n3, this.starty + n4, this.startx + n3, this.starty + n4);
                        graphics2D.dispose();
                        graphics2D = this.display_img.createGraphics();
                        if (this.currentMouseButton == 1) {
                            graphics2D.setColor(this.leftColour);
                        }
                        if (this.currentMouseButton == 3) {
                            graphics2D.setColor(this.rightColour);
                        }
                        graphics2D.drawLine(this.startx + n3, this.starty + n4, this.startx + n3, this.starty + n4);
                        graphics2D.dispose();
                        this.display_label.repaint();
                    }
                    this.saved = false;
                    this.update_title();
                }
            }
        }
    }

    public boolean validCoordinates(int n, int n2) {
        boolean bl = true;
        if (n >= this.frames.get((int)this.current_frame).data.getWidth()) {
            bl = false;
        }
        if (n < 0) {
            bl = false;
        }
        if (n2 >= this.frames.get((int)this.current_frame).data.getHeight()) {
            bl = false;
        }
        if (n2 < 0) {
            bl = false;
        }
        return bl;
    }

    public void fill_area(int n, int n2, int n3, int n4) {
        this.fillStack.push(new Point(n, n2));
        while (!this.fillStack.empty()) {
            Point point = this.fillStack.pop();
            int n5 = point.x;
            int n6 = point.y;
            if (!this.validCoordinates(n5, n6) || this.frames.get((int)this.current_frame).data.getRGB(n5, n6) != n3) continue;
            this.frames.get((int)this.current_frame).data.setRGB(n5, n6, n4);
            this.fillStack.push(new Point(n5 + 1, n6));
            this.fillStack.push(new Point(n5 - 1, n6));
            this.fillStack.push(new Point(n5, n6 + 1));
            this.fillStack.push(new Point(n5, n6 - 1));
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        int n = this.currentMouseButton;
        this.currentMouseButton = -1;
        if (mouseEvent.getSource() == this.display_label) {
            this.startx = -1;
            this.starty = -1;
            this.mousedown = false;
            if (this.current_tool == Tools.FILL) {
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                int n4 = this.frames.get((int)this.current_frame).data.getRGB(n2, n3);
                int n5 = -1;
                if (n == 1) {
                    n5 = this.leftColour.getRGB();
                }
                if (n == 3) {
                    n5 = this.rightColour.getRGB();
                }
                this.fill_area(n2, n3, n4, n5);
                if (this.onion) {
                    if (this.current_frame > 0) {
                        this.onion_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data, this.display_img);
                    } else {
                        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    }
                } else {
                    this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                }
                this.display_label.repaint();
                this.saved = false;
                this.update_title();
            }
            this.frames.get(this.current_frame).make_thumb();
            this.frames.get(this.current_frame).thumb_border();
            this.thumb_label.get(this.current_frame).repaint();
        } else {
            int n6 = 0;
            boolean bl = false;
            for (JLabel jLabel : this.thumb_label) {
                if (mouseEvent.getSource() == jLabel) {
                    System.out.println("Frame:" + n6);
                    bl = true;
                    break;
                }
                ++n6;
            }
            if (bl) {
                this.requestFocusInWindow();
                if (this.current_frame != n6) {
                    this.frames.get(this.current_frame).make_thumb();
                    this.thumb_label.get(this.current_frame).repaint();
                    this.current_frame = n6;
                    this.frames.get(this.current_frame).thumb_border();
                    this.thumb_label.get(this.current_frame).repaint();
                    if (this.onion) {
                        if (this.current_frame > 0) {
                            this.onion_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data, this.display_img);
                        } else {
                            this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                        }
                    } else {
                        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    }
                    this.display_label.repaint();
                    this.set_status();
                    this.outerpanel.repaint();
                    this.thumbpanel.repaint();
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.display_label) {
            this.display_label.setCursor(new Cursor(1));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.display_label) {
            this.display_label.setCursor(new Cursor(0));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this.display_label) {
            // empty if block
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        switch (this.current_tool) {
            case PEN: {
                Graphics2D graphics2D = this.frames.get((int)this.current_frame).data.createGraphics();
                if (this.currentMouseButton == 1) {
                    graphics2D.setColor(this.leftColour);
                }
                if (this.currentMouseButton == 3) {
                    graphics2D.setColor(this.rightColour);
                }
                BasicStroke basicStroke = new BasicStroke(this.thickness);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawLine(this.startx, this.starty, n, n2);
                graphics2D.dispose();
                graphics2D = this.display_img.createGraphics();
                if (this.currentMouseButton == 1) {
                    graphics2D.setColor(this.leftColour);
                }
                if (this.currentMouseButton == 3) {
                    graphics2D.setColor(this.rightColour);
                }
                basicStroke = new BasicStroke(this.thickness);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawLine(this.startx, this.starty, n, n2);
                graphics2D.dispose();
                this.display_label.repaint();
                break;
            }
            case SPRAY: {
                int n3 = 10 * this.thickness / 2;
                for (int i = 0; i < 20 * this.thickness / 2; ++i) {
                    int n4 = this.r.nextInt(10 * this.thickness) - n3;
                    int n5 = this.r.nextInt(10 * this.thickness) - n3;
                    Graphics2D graphics2D = this.frames.get((int)this.current_frame).data.createGraphics();
                    if (this.currentMouseButton == 1) {
                        graphics2D.setColor(this.leftColour);
                    }
                    if (this.currentMouseButton == 3) {
                        graphics2D.setColor(this.rightColour);
                    }
                    graphics2D.drawLine(this.startx + n4, this.starty + n5, this.startx + n4, this.starty + n5);
                    graphics2D.dispose();
                    graphics2D = this.display_img.createGraphics();
                    if (this.currentMouseButton == 1) {
                        graphics2D.setColor(this.leftColour);
                    }
                    if (this.currentMouseButton == 3) {
                        graphics2D.setColor(this.rightColour);
                    }
                    graphics2D.drawLine(this.startx + n4, this.starty + n5, this.startx + n4, this.starty + n5);
                    graphics2D.dispose();
                    this.display_label.repaint();
                }
                break;
            }
        }
        this.startx = n;
        this.starty = n2;
        this.saved = false;
        this.update_title();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        System.out.println("closed Main window");
        System.exit(0);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        System.out.println("closing Main window");
        if (!this.saved) {
            int n = JOptionPane.showConfirmDialog(this, "Changes will be lost! Do you really want to exit?", "Exit Confirmation : ", 0);
            if (n == 0) {
                this.setDefaultCloseOperation(2);
            } else if (n == 1) {
                this.setDefaultCloseOperation(0);
            }
        } else {
            this.dispose();
        }
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                if (this.current_frame + 1 >= this.frames.size()) break;
                int n = this.thumbpanel.getWidth() / this.frames.size() * (this.current_frame + 1);
                JScrollBar jScrollBar = this.scrolly.getHorizontalScrollBar();
                if (jScrollBar.getValue() + this.scrolly.getViewport().getWidth() < jScrollBar.getMaximum()) {
                    this.scrolly.getViewport().setViewPosition(new Point(n, 0));
                }
                this.frames.get(this.current_frame).make_thumb();
                this.thumb_label.get(this.current_frame).repaint();
                ++this.current_frame;
                this.frames.get(this.current_frame).thumb_border();
                this.thumb_label.get(this.current_frame).repaint();
                if (this.onion) {
                    if (this.current_frame > 0) {
                        this.onion_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data, this.display_img);
                    } else {
                        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    }
                } else {
                    this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                }
                this.display_label.repaint();
                this.set_status();
                this.outerpanel.repaint();
                this.thumbpanel.repaint();
                break;
            }
            case 37: {
                if (this.current_frame - 1 < 0) break;
                int n = this.thumbpanel.getWidth() / this.frames.size() * (this.current_frame - 1);
                JScrollBar jScrollBar = this.scrolly.getHorizontalScrollBar();
                if (jScrollBar.getValue() > 0 && n < jScrollBar.getValue()) {
                    this.scrolly.getViewport().setViewPosition(new Point(n, 0));
                }
                this.frames.get(this.current_frame).make_thumb();
                this.thumb_label.get(this.current_frame).repaint();
                --this.current_frame;
                this.frames.get(this.current_frame).thumb_border();
                this.thumb_label.get(this.current_frame).repaint();
                if (this.onion) {
                    if (this.current_frame > 0) {
                        this.onion_bmp(this.frames.get((int)(this.current_frame - 1)).data, this.frames.get((int)this.current_frame).data, this.display_img);
                    } else {
                        this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                    }
                } else {
                    this.copy_bmp(this.frames.get((int)this.current_frame).data, this.display_img);
                }
                this.display_label.repaint();
                this.set_status();
                this.outerpanel.repaint();
                this.thumbpanel.repaint();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        Animator animator = new Animator();
    }

    public static enum Tools {
        NONE,
        PEN,
        SPRAY,
        FILL;

    }
}

