/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.util.HashSet;

public class AnimFrame {
    static byte[] two_bit;
    static byte[] eight_bit;
    static byte[] true_bit;
    BufferedImage data;
    BufferedImage undo;
    BufferedImage thumb;
    private boolean can_undo = false;
    private static int width;
    private static int height;
    public static int colour;
    private static int thumb_width;
    private static int thumb_height;
    private final int[][] pattern = new int[][]{{0, 32, 8, 40, 2, 34, 10, 42}, {48, 16, 56, 24, 50, 18, 58, 26}, {12, 44, 4, 36, 14, 46, 6, 38}, {60, 28, 52, 20, 62, 30, 54, 22}, {3, 35, 11, 43, 1, 33, 9, 41}, {51, 19, 59, 27, 49, 17, 57, 25}, {15, 47, 7, 39, 13, 45, 5, 37}, {63, 31, 55, 23, 61, 29, 53, 21}};
    int[] cycol = new int[]{0, 85, 171, 255};
    public int[] fli_rgb_r = new int[256];
    public int[] fli_rgb_g = new int[256];
    public int[] fli_rgb_b = new int[256];
    private int totalcol;
    private int nextcol;

    public AnimFrame(int n, int n2) {
        width = n;
        height = n2;
        thumb_width = n / 2;
        thumb_height = n2 / 2;
        two_bit = new byte[4000];
        eight_bit = new byte[width * height];
        true_bit = new byte[width * height * 3];
        this.undo = new BufferedImage(width, height, 1);
        this.data = new BufferedImage(width, height, 1);
        this.thumb = new BufferedImage(thumb_width, thumb_height, 1);
        this.clear_bitmap(this.data);
        this.clear_bitmap(this.thumb);
    }

    public AnimFrame(int n, int n2, int n3) {
        width = n;
        height = n2;
        thumb_width = n / 2;
        thumb_height = n2 / 2;
        two_bit = new byte[4000];
        eight_bit = new byte[width * height];
        true_bit = new byte[width * height * 3];
        this.undo = new BufferedImage(width, height, 1);
        this.data = new BufferedImage(width, height, 1);
        this.thumb = new BufferedImage(thumb_width, thumb_height, 1);
        colour = n3;
        this.clear_bitmap(this.data);
        this.clear_bitmap(this.thumb);
    }

    public int getWidth() {
        return width;
    }

    public int getHeight() {
        return height;
    }

    public void flip() {
        int n;
        int n2;
        int n3;
        int n4 = this.data.getWidth();
        int n5 = this.data.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.data.getRGB(n2, n3);
                bufferedImage.setRGB(n2, n5 - n3 - 1, n);
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = bufferedImage.getRGB(n2, n3);
                this.data.setRGB(n2, n3, n);
            }
        }
        this.make_thumb();
    }

    public void mirror() {
        int n;
        int n2;
        int n3;
        int n4 = this.data.getWidth();
        int n5 = this.data.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = this.data.getRGB(n2, n3);
                bufferedImage.setRGB(n4 - n2 - 1, n3, n);
            }
        }
        for (n3 = 0; n3 < n5; ++n3) {
            for (n2 = 0; n2 < n4; ++n2) {
                n = bufferedImage.getRGB(n2, n3);
                this.data.setRGB(n2, n3, n);
            }
        }
        this.make_thumb();
    }

    public void shift(int n, int n2, boolean bl, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = this.data.getWidth();
        int n8 = this.data.getHeight();
        System.out.println("Shift:" + n + "," + n2 + " Wrap:" + bl);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        for (n6 = 0; n6 < n8; ++n6) {
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = this.data.getRGB(n5, n6);
                bufferedImage.setRGB(n5, n6, n4);
            }
        }
        for (n6 = 0; n6 < n8; ++n6) {
            if (n > 0) {
                for (n5 = 0; n5 < n7 - n; ++n5) {
                    n4 = bufferedImage.getRGB(n5, n6);
                    this.data.setRGB(n5 + n, n6, n4);
                }
                if (bl) {
                    for (n5 = 0; n5 < n; ++n5) {
                        n4 = bufferedImage.getRGB(n7 - n + n5, n6);
                        this.data.setRGB(n5, n6, n4);
                    }
                } else {
                    for (n5 = 0; n5 < n; ++n5) {
                        this.data.setRGB(n5, n6, n3);
                    }
                }
            }
            if (n >= 0) continue;
            for (n5 = 0; n5 < n7 + n; ++n5) {
                n4 = bufferedImage.getRGB(n5 - n, n6);
                this.data.setRGB(n5, n6, n4);
            }
            if (bl) {
                for (n5 = 0; n5 < -n; ++n5) {
                    n4 = bufferedImage.getRGB(n5, n6);
                    this.data.setRGB(n7 + n + n5, n6, n4);
                }
                continue;
            }
            for (n5 = 0; n5 < -n; ++n5) {
                this.data.setRGB(n7 + n + n5, n6, n3);
            }
        }
        for (n6 = 0; n6 < n8; ++n6) {
            for (n5 = 0; n5 < n7; ++n5) {
                n4 = this.data.getRGB(n5, n6);
                bufferedImage.setRGB(n5, n6, n4);
            }
        }
        for (n6 = 0; n6 < n7; ++n6) {
            if (n2 > 0) {
                for (n5 = 0; n5 < n8 - n2; ++n5) {
                    n4 = bufferedImage.getRGB(n6, n5 + n2);
                    this.data.setRGB(n6, n5, n4);
                }
                if (bl) {
                    for (n5 = 0; n5 < n2; ++n5) {
                        n4 = bufferedImage.getRGB(n6, n5);
                        this.data.setRGB(n6, n8 - n2 + n5, n4);
                    }
                } else {
                    for (n5 = 0; n5 < n2; ++n5) {
                        this.data.setRGB(n6, n8 - n2 + n5, n3);
                    }
                }
            }
            if (n2 >= 0) continue;
            for (n5 = 0; n5 < n8 + n2; ++n5) {
                n4 = bufferedImage.getRGB(n6, n5);
                this.data.setRGB(n6, n5 - n2, n4);
            }
            if (bl) {
                for (n5 = 0; n5 < -n2; ++n5) {
                    n4 = bufferedImage.getRGB(n6, n5 + n8 + n2);
                    this.data.setRGB(n6, n5, n4);
                }
                continue;
            }
            for (n5 = 0; n5 < -n2; ++n5) {
                this.data.setRGB(n6, n5, n3);
            }
        }
    }

    private void clear_bitmap(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                bufferedImage.setRGB(j, i, colour);
            }
        }
    }

    public void to_undo() {
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int n = this.data.getRGB(j, i);
                this.undo.setRGB(j, i, n);
            }
        }
        this.can_undo = true;
    }

    public void from_undo() {
        if (this.can_undo) {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int n = this.undo.getRGB(j, i);
                    this.data.setRGB(j, i, n);
                }
            }
        }
        this.make_thumb();
    }

    public void make_thumb() {
        for (int i = 0; i < thumb_height; ++i) {
            for (int j = 0; j < thumb_width; ++j) {
                int n = this.data.getRGB(j * 2, i * 2);
                this.thumb.setRGB(j, i, n);
            }
        }
    }

    public void make_true() {
        for (int i = 0; i < height; ++i) {
            int n = (height - 1 - i) * (width * 3);
            for (int j = 0; j < width; ++j) {
                int n2 = this.data.getRGB(j, i);
                int n3 = n2 >> 16 & 0xFF;
                int n4 = n2 >> 8 & 0xFF;
                int n5 = n2 & 0xFF;
                AnimFrame.true_bit[n] = (byte)n5;
                AnimFrame.true_bit[n + 1] = (byte)n4;
                AnimFrame.true_bit[n + 2] = (byte)n3;
                n += 3;
            }
        }
    }

    public void make_eight() {
        int n = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int n2 = this.data.getRGB(j, i);
                int n3 = n2 >> 16 & 0xFF;
                int n4 = n2 >> 8 & 0xFF;
                int n5 = n2 & 0xFF;
                AnimFrame.eight_bit[n] = (byte)(((n3 >>= 5) << 5) + ((n4 >>= 5) << 2) + (n5 >>= 6));
                ++n;
            }
        }
    }

    public void make_two() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        int[] nArray = new int[16000];
        if (width > 160 || height > 100) {
            float f = (float)width / 160.0f;
            float f2 = (float)height / 100.0f;
            if (width > height) {
                f2 = f;
            }
            if (height > width) {
                f = f2;
            }
            System.out.println(" -- " + f + " x " + f2);
            float f3 = 0.0f;
            float f4 = 0.0f;
            n5 = 0;
            n4 = 0;
            n6 = 0;
            for (n3 = 0; n3 < height; ++n3) {
                f3 = 0.0f;
                for (n2 = 0; n2 < width; ++n2) {
                    if (n2 < 160 && n3 < 100) {
                        int n7 = this.data.getRGB((int)f3, (int)f4);
                        if (n5 + n2 < width && n4 + n3 < height) {
                            int n8;
                            int n9 = n7 >> 16 & 0xFF;
                            int n10 = n7 >> 8 & 0xFF;
                            int n11 = n7 & 0xFF;
                            nArray[n6] = n8 = (n9 + n10 + n11) / 3;
                            ++n6;
                        }
                    }
                    f3 += f;
                }
                f4 += f2;
            }
        } else {
            for (int i = 0; i < height; ++i) {
                for (int j = 0; j < width; ++j) {
                    int n12 = this.data.getRGB(j, i);
                    int n13 = n12 >> 16 & 0xFF;
                    n5 = n12 >> 8 & 0xFF;
                    n4 = n12 & 0xFF;
                    nArray[n6] = n3 = (n13 + n5 + n4) / 3;
                    ++n6;
                }
            }
        }
        n6 = 0;
        for (n = 0; n < 100; ++n) {
            int n14 = 0;
            for (int i = 0; i < 160; ++i) {
                int n15 = 999;
                n5 = 0;
                n4 = nArray[n6] + n14;
                for (n3 = 0; n3 < 4; ++n3) {
                    n2 = this.abs(this.cycol[n3] - n4);
                    if (n2 >= n15) continue;
                    n15 = n2;
                    n5 = n3;
                    n14 = n4 - this.cycol[n3];
                }
                nArray[n6] = n5;
                ++n6;
            }
        }
        n6 = 0;
        n = 0;
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 160; j += 4) {
                byte by = (byte)(3 - nArray[n++]);
                n5 = (byte)(3 - nArray[n++]);
                n4 = (byte)(3 - nArray[n++]);
                n3 = (byte)(3 - nArray[n++]);
                AnimFrame.two_bit[n6++] = (byte)((by & 0xFF) << 6 | (n5 & 0xFF) << 4 | (n4 & 0xFF) << 2 | n3 & 0xFF);
            }
        }
    }

    public void thumb_border() {
        int n;
        for (n = 0; n < thumb_height; ++n) {
            this.thumb.setRGB(0, n, 0xFF0000);
            this.thumb.setRGB(thumb_width - 1, n, 0xFF0000);
        }
        for (n = 0; n < thumb_width; ++n) {
            this.thumb.setRGB(n, 0, 0xFF0000);
            this.thumb.setRGB(n, thumb_height - 1, 0xFF0000);
        }
    }

    public int coloursUsed() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int n = this.data.getRGB(j, i);
                hashSet.add(n);
            }
        }
        return hashSet.size();
    }

    private void resetpal() {
        this.totalcol = 0;
        this.nextcol = 1;
        for (int i = 0; i < 256; ++i) {
            this.fli_rgb_r[i] = 0;
            this.fli_rgb_g[i] = 0;
            this.fli_rgb_b[i] = 0;
        }
    }

    private int abs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    private int getcol(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 999;
        for (int i = 0; i < 256; ++i) {
            int n6 = this.abs(this.fli_rgb_r[i] - n);
            n6 += this.abs(this.fli_rgb_g[i] - n2);
            if ((n6 += this.abs(this.fli_rgb_b[i] - n3)) >= n5) continue;
            n5 = n6;
            n4 = i;
        }
        return n4;
    }

    void convert2() {
        int n = 0;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int n2 = this.data.getRGB(j, i);
                int n3 = n2 >> 16 & 0xFF;
                int n4 = n2 >> 8 & 0xFF;
                int n5 = n2 & 0xFF;
                AnimFrame.eight_bit[n] = (byte)this.getcol(n3, n4, n5);
                ++n;
            }
        }
    }

    private boolean inpal(int n, int n2, int n3, int n4) {
        for (int i = 0; i < 256; ++i) {
            int n5 = this.abs(this.fli_rgb_r[i] - n);
            n5 += this.abs(this.fli_rgb_g[i] - n2);
            if ((n5 += this.abs(this.fli_rgb_b[i] - n3)) > n4) continue;
            return true;
        }
        if (this.nextcol <= 255) {
            this.fli_rgb_r[this.nextcol] = n;
            this.fli_rgb_g[this.nextcol] = n2;
            this.fli_rgb_b[this.nextcol] = n3;
            ++this.nextcol;
            return true;
        }
        return false;
    }

    void optpalette() {
        boolean bl;
        int n = 0;
        do {
            bl = true;
            this.resetpal();
            boolean bl2 = false;
            for (int i = 0; i < height; ++i) {
                int n2;
                int n3;
                int n4;
                int n5;
                for (int j = 0; j < width && (bl = this.inpal(n5 = (n4 = this.data.getRGB(j, i)) >> 16 & 0xFF, n3 = n4 >> 8 & 0xFF, n2 = n4 & 0xFF, n)); ++j) {
                }
                if (!bl) break;
            }
            if (bl) continue;
            ++n;
        } while (!bl);
    }

    static {
        colour = -1;
    }
}

